/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement.binder;

import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.file.Path;
import java.sql.Blob;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.AbstractEnumParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.statement.binder.LambdaParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.NameEnumParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.NullAwareParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.OrdinalEnumParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.bean.ClassIterator;
import org.codefilarete.tool.bean.InterfaceIterator;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;

public class ParameterBinderRegistry {
    private final WeakHashMap<Class<?>, ParameterBinder<?>> binderPerType = new WeakHashMap();

    public ParameterBinderRegistry() {
        this.registerParameterBinders();
    }

    public Map<Class<?>, ParameterBinder<?>> getBinderPerType() {
        return this.binderPerType;
    }

    public <T> void register(Class<T> clazz, ParameterBinder<T> parameterBinder) {
        this.binderPerType.put(clazz, parameterBinder);
    }

    protected void registerParameterBinders() {
        this.register(String.class, DefaultParameterBinders.STRING_BINDER);
        this.register(Double.class, DefaultParameterBinders.DOUBLE_BINDER);
        this.register(Double.TYPE, DefaultParameterBinders.DOUBLE_PRIMITIVE_BINDER);
        this.register(Number.class, DefaultParameterBinders.NUMBER_BINDER);
        this.register(Float.class, DefaultParameterBinders.FLOAT_BINDER);
        this.register(Float.TYPE, DefaultParameterBinders.FLOAT_PRIMITIVE_BINDER);
        this.register(BigDecimal.class, DefaultParameterBinders.BIGDECIMAL_BINDER);
        this.register(BigInteger.class, new NullAwareParameterBinder(new LambdaParameterBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER, BigInteger::valueOf, BigInteger::longValue)));
        this.register(Long.class, DefaultParameterBinders.LONG_BINDER);
        this.register(Long.TYPE, DefaultParameterBinders.LONG_PRIMITIVE_BINDER);
        this.register(Integer.class, DefaultParameterBinders.INTEGER_BINDER);
        this.register(Integer.TYPE, DefaultParameterBinders.INTEGER_PRIMITIVE_BINDER);
        this.register(Byte.class, DefaultParameterBinders.BYTE_BINDER);
        this.register(Byte.TYPE, DefaultParameterBinders.BYTE_PRIMITIVE_BINDER);
        this.register(byte[].class, DefaultParameterBinders.BYTES_BINDER);
        this.register(java.util.Date.class, DefaultParameterBinders.DATE_BINDER);
        this.register(Date.class, DefaultParameterBinders.DATE_SQL_BINDER);
        this.register(LocalDate.class, DefaultParameterBinders.LOCALDATE_BINDER);
        this.register(LocalDateTime.class, DefaultParameterBinders.LOCALDATETIME_BINDER);
        this.register(LocalTime.class, DefaultParameterBinders.LOCALTIME_BINDER);
        this.register(Instant.class, new LambdaParameterBinder(DefaultParameterBinders.LONG_BINDER, Instant::ofEpochMilli, Instant::toEpochMilli));
        this.register(Timestamp.class, DefaultParameterBinders.TIMESTAMP_BINDER);
        this.register(Boolean.class, DefaultParameterBinders.BOOLEAN_BINDER);
        this.register(Boolean.TYPE, DefaultParameterBinders.BOOLEAN_PRIMITIVE_BINDER);
        this.register(InputStream.class, DefaultParameterBinders.BINARYSTREAM_BINDER);
        this.register(Blob.class, DefaultParameterBinders.BLOB_BINDER);
        this.register(ZoneId.class, DefaultParameterBinders.ZONEID_BINDER);
        this.register(UUID.class, DefaultParameterBinders.UUID_BINDER);
        this.register(Path.class, DefaultParameterBinders.PATH_BINDER);
        this.register(File.class, DefaultParameterBinders.FILE_BINDER);
    }

    public <T> ParameterBinder<T> getBinder(Class<T> clazz) {
        ParameterBinder<Object> parameterBinder = this.binderPerType.get(clazz);
        if (parameterBinder == null) {
            parameterBinder = this.lookupForBinder(clazz);
        }
        return parameterBinder;
    }

    private <T> Set<Duo<Class<?>, ParameterBinder<?>>> lookupForCompatibleBinder(Class<T> clazz) {
        if (clazz.isEnum()) {
            return Arrays.asSet((Object[])new Duo[]{new Duo(clazz, (Object)this.binderPerType.computeIfAbsent(clazz, k -> new NullAwareParameterBinder(new OrdinalEnumParameterBinder(k))))});
        }
        ClassIterator classHierarchy = new ClassIterator(clazz);
        return Iterables.stream((Iterator)classHierarchy).map(classAncestor -> {
            ParameterBinder<?> parameterBinder = this.binderPerType.get(classAncestor);
            Duo classParameterBinderDuo = new Duo((Object)clazz, parameterBinder);
            return parameterBinder == null ? null : Arrays.asSet((Object[])new Duo[]{classParameterBinderDuo});
        }).filter(Objects::nonNull).findFirst().orElseGet(() -> {
            Set result = Iterables.stream((Iterator)new InterfaceIterator(clazz)).map(pawn -> new Duo(pawn, this.binderPerType.get(pawn))).filter(duo -> duo.getRight() != null).collect(Collectors.toSet());
            return result;
        });
    }

    private <T> ParameterBinder<T> lookupForBinder(Class<T> clazz) {
        Set<Duo<Class<?>, ParameterBinder<?>>> binderPerInterface = this.lookupForCompatibleBinder(clazz);
        if (binderPerInterface.size() > 1) {
            throw new SQLStatement.BindingException("Multiple binders found for " + Reflections.toString(clazz) + ", please register one for any of : " + Iterables.stream(binderPerInterface).map(Duo::getLeft).map(Reflections::toString).collect(Collectors.toSet()));
        }
        if (binderPerInterface.isEmpty()) {
            throw new SQLStatement.BindingException("No binder found for type " + Reflections.toString(clazz));
        }
        ParameterBinder foundBinder = (ParameterBinder)((Duo)Iterables.first(binderPerInterface)).getRight();
        this.binderPerType.put(clazz, foundBinder);
        return foundBinder;
    }

    public static enum EnumBindType {
        NAME(NameEnumParameterBinder::new),
        ORDINAL(OrdinalEnumParameterBinder::new);

        private final Function<Class<? extends Enum>, AbstractEnumParameterBinder> factory;

        private EnumBindType(Function<Class<? extends Enum>, AbstractEnumParameterBinder> factory) {
            this.factory = factory;
        }

        public <E extends Enum<E>> ParameterBinder<E> newParameterBinder(Class<E> enumType) {
            return new NullAwareParameterBinder(this.factory.apply(enumType));
        }
    }
}

