/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.test;

import java.sql.SQLException;
import javax.sql.DataSource;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.SimpleConnectionProvider;
import org.codefilarete.stalactite.sql.test.DatabaseHelper;
import org.codefilarete.tool.exception.Exceptions;
import org.junit.jupiter.api.BeforeEach;

public abstract class DatabaseIntegrationTest {
    protected ConnectionProvider connectionProvider;

    @BeforeEach
    protected void init() {
        this.setConnectionProvider();
        this.clearDatabaseSchema();
    }

    protected void setConnectionProvider() {
        DataSource dataSource = this.giveDataSource();
        try {
            this.connectionProvider = new SimpleConnectionProvider(dataSource.getConnection());
        }
        catch (SQLException e) {
            throw Exceptions.asRuntimeException((Throwable)e);
        }
    }

    protected void clearDatabaseSchema() {
        this.giveDatabaseHelper().clearDatabaseSchema(this.connectionProvider.giveConnection());
    }

    protected abstract DataSource giveDataSource();

    protected DatabaseHelper giveDatabaseHelper() {
        return new DatabaseHelper();
    }
}

