/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement.binder;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderIndex;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriter;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriterRegistry;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReaderRegistry;

public class ColumnBinderRegistry
implements ParameterBinderIndex<Column, ParameterBinder>,
ResultSetReaderRegistry,
PreparedStatementWriterRegistry {
    private final Map<Column, ParameterBinder> bindersPerColumn = new HashMap<Column, ParameterBinder>();
    private final ParameterBinderRegistry parameterBinderRegistry;

    public ColumnBinderRegistry() {
        this(new ParameterBinderRegistry());
    }

    public ColumnBinderRegistry(ParameterBinderRegistry parameterBinderRegistry) {
        this.parameterBinderRegistry = parameterBinderRegistry;
    }

    public <T> void register(Class<T> clazz, ParameterBinder<T> parameterBinder) {
        this.parameterBinderRegistry.register(clazz, parameterBinder);
    }

    public <T> void register(Column column, ParameterBinder<T> parameterBinder) {
        ParameterBinder existingBinder = this.bindersPerColumn.get(column);
        if (existingBinder != null && !existingBinder.equals(parameterBinder)) {
            throw new SQLStatement.BindingException("Binder for column " + column + " already exists");
        }
        this.bindersPerColumn.put(column, parameterBinder);
    }

    public <T> ParameterBinder<T> getBinder(Class<T> clazz) {
        return this.parameterBinderRegistry.getBinder(clazz);
    }

    public ParameterBinder doGetBinder(Column column) {
        ParameterBinder columnBinder = this.bindersPerColumn.get(column);
        return columnBinder != null ? columnBinder : this.getBinder(column.getJavaType());
    }

    public Set<Column> keys() {
        return this.bindersPerColumn.keySet();
    }

    public Set<Map.Entry<Column, ParameterBinder>> all() {
        return this.bindersPerColumn.entrySet();
    }

    @Override
    public <T> ResultSetReader<T> doGetReader(Class<T> key) {
        return this.getBinder(key);
    }

    @Override
    public <T> PreparedStatementWriter<T> doGetWriter(Class<T> key) {
        return this.getBinder(key);
    }
}

