/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.dsl.MappingEase;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfiguration;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.idpolicy.IdentifierPolicy;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.model.Timestamp;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialectBuilder;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.Strings;
import org.codefilarete.tool.collection.Arrays;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FluentEntityMappingConfigurationSupportAlreadyAssignedIdentifierTest {
    private Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
    private DataSource dataSource = new HSQLDBInMemoryDataSource();
    private PersistenceContext persistenceContext;

    @BeforeEach
    public void initTest() {
        this.persistenceContext = new PersistenceContext(this.dataSource, this.dialect);
    }

    @Test
    void insert_basic() {
        EntityPersister carPersister = MappingEase.entityBuilder(Car.class, Long.TYPE).mapKey(AbstractVehicle::getId, (IdentifierPolicy)IdentifierPolicy.alreadyAssigned(AbstractVehicle::markAsPersisted, AbstractVehicle::isPersisted)).map(Car::getModel).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Car dummyCar = new Car(42L);
        dummyCar.setModel("Renault");
        carPersister.insert((Object)dummyCar);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)dummyCar.isPersisted()).as("car is persisted", new Object[0])).isTrue();
        Set allCars = (Set)this.persistenceContext.newQuery((CharSequence)"select id, model from Car", Car.class).mapKey(Car::new, "id", Long.TYPE).map("model", Car::setModel).execute(Accumulators.toSet());
        Assertions.assertThat((Collection)allCars).containsExactlyInAnyOrder((Object[])new Car[]{dummyCar});
        Car loadedCar = (Car)carPersister.select((Object)42L);
        Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)loadedCar.isPersisted()).as("loaded car is mark as persisted", new Object[0])).isTrue();
    }

    @Test
    void insert_oneToOne() {
        EntityPersister carPersister = MappingEase.entityBuilder(Car.class, Long.TYPE).mapKey(AbstractVehicle::getId, (IdentifierPolicy)IdentifierPolicy.alreadyAssigned(AbstractVehicle::markAsPersisted, AbstractVehicle::isPersisted)).map(Car::getModel).mapOneToOne(Vehicle::getEngine, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Engine.class, String.class).mapKey(Engine::getModel, (IdentifierPolicy)IdentifierPolicy.alreadyAssigned(Engine::markAsPersisted, Engine::isPersisted))).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Car dummyCar = new Car(42L);
        dummyCar.setModel("Renault");
        dummyCar.setEngine(new Engine("XFE45K-TRE"));
        carPersister.insert((Object)dummyCar);
        Set allCars = (Set)this.persistenceContext.newQuery((CharSequence)"select id, model from Car", Car.class).mapKey(Car::new, "id", Long.TYPE).map("model", Car::setModel).execute(Accumulators.toSet());
        Assertions.assertThat((Collection)allCars).containsExactlyInAnyOrder((Object[])new Car[]{dummyCar});
        Car loadedCar = (Car)carPersister.select((Object)42L);
        Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
        Assertions.assertThat((Object)loadedCar.getEngine()).isEqualTo((Object)dummyCar.getEngine());
    }

    @Test
    void insert_oneToOne_ownedByReverseSide() {
        EntityPersister carPersister = MappingEase.entityBuilder(Car.class, Long.TYPE).mapKey(AbstractVehicle::getId, (IdentifierPolicy)IdentifierPolicy.alreadyAssigned(AbstractVehicle::markAsPersisted, AbstractVehicle::isPersisted)).map(Car::getModel).mapOneToOne(Vehicle::getEngine, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Engine.class, String.class).mapKey(Engine::getModel, (IdentifierPolicy)IdentifierPolicy.alreadyAssigned(Engine::markAsPersisted, Engine::isPersisted))).mappedBy(Engine::getCar).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Car dummyCar = new Car(42L);
        dummyCar.setModel("Renault");
        Engine engine = new Engine("XFE45K-TRE");
        dummyCar.setEngine(engine);
        engine.setCar(dummyCar);
        carPersister.insert((Object)dummyCar);
        Set allCars = (Set)this.persistenceContext.newQuery((CharSequence)"select id, model from Car", Car.class).mapKey(Car::new, "id", Long.TYPE).map("model", Car::setModel).execute(Accumulators.toSet());
        Assertions.assertThat((Collection)allCars).containsExactlyInAnyOrder((Object[])new Car[]{dummyCar});
        Car loadedCar = (Car)carPersister.select((Object)42L);
        Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
        Assertions.assertThat((Object)loadedCar.getEngine()).isEqualTo((Object)dummyCar.getEngine());
    }

    @Test
    void multipleInheritance() {
        EntityMappingConfiguration inheritanceConfiguration = MappingEase.entityBuilder(AbstractVehicle.class, Long.TYPE).mapKey(AbstractVehicle::getId, (IdentifierPolicy)IdentifierPolicy.alreadyAssigned(AbstractVehicle::markAsPersisted, AbstractVehicle::isPersisted)).getConfiguration();
        EntityMappingConfiguration inheritanceConfiguration2 = MappingEase.entityBuilder(Vehicle.class, Long.TYPE).mapSuperClass(inheritanceConfiguration).getConfiguration();
        EntityPersister carPersister = MappingEase.entityBuilder(Car.class, Long.TYPE).map(Car::getModel).mapSuperClass(inheritanceConfiguration2).build(this.persistenceContext);
        Assertions.assertThat((String)((ConfiguredPersister)this.persistenceContext.findPersister(Car.class)).getMapping().getTargetTable().getName()).isEqualTo("Car");
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Car dummyCar = new Car(42L);
        dummyCar.setModel("Renault");
        carPersister.insert((Object)dummyCar);
        Set allCars = (Set)this.persistenceContext.newQuery((CharSequence)"select id, model from Car", Car.class).mapKey(Car::new, "id", Long.TYPE).map("model", Car::setModel).execute(Accumulators.toSet());
        Assertions.assertThat((Collection)allCars).containsExactlyInAnyOrder((Object[])new Car[]{dummyCar});
        Car loadedCar = (Car)carPersister.select((Object)42L);
        Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
    }

    @Test
    void multipleInheritance_joinedTables() {
        EntityMappingConfiguration inheritanceConfiguration = MappingEase.entityBuilder(AbstractVehicle.class, Long.TYPE).mapKey(AbstractVehicle::getId, (IdentifierPolicy)IdentifierPolicy.alreadyAssigned(AbstractVehicle::markAsPersisted, AbstractVehicle::isPersisted)).getConfiguration();
        EntityMappingConfiguration inheritanceConfiguration2 = MappingEase.entityBuilder(Vehicle.class, Long.TYPE).mapSuperClass(inheritanceConfiguration).withJoinedTable().getConfiguration();
        EntityPersister carPersister = MappingEase.entityBuilder(Car.class, Long.TYPE).map(Car::getModel).mapSuperClass(inheritanceConfiguration2).withJoinedTable().build(this.persistenceContext);
        Assertions.assertThat((Collection)DDLDeployer.collectTables((PersistenceContext)this.persistenceContext).stream().map(Table::getName).collect(Collectors.toSet())).isEqualTo((Object)Arrays.asHashSet((Object[])new String[]{"Car", "Vehicle", "AbstractVehicle"}));
        Assertions.assertThat((String)((ConfiguredPersister)this.persistenceContext.findPersister(Car.class)).getMapping().getTargetTable().getName()).isEqualTo("Car");
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Car dummyCar = new Car(42L);
        dummyCar.setModel("Renault");
        carPersister.insert((Object)dummyCar);
        Set allCars = (Set)this.persistenceContext.newQuery((CharSequence)"select id, model from Car", Car.class).mapKey(Car::new, "id", Long.TYPE).map("model", Car::setModel).execute(Accumulators.toSet());
        Assertions.assertThat((Collection)allCars).containsExactlyInAnyOrder((Object[])new Car[]{dummyCar});
        Car loadedCar = (Car)carPersister.select((Object)42L);
        Assertions.assertThat((Object)loadedCar).isEqualTo((Object)dummyCar);
    }

    static class Engine {
        private boolean persisted = false;
        private String model;
        private Car car;

        public Engine() {
        }

        public Engine(String model) {
            this.model = model;
        }

        public boolean isPersisted() {
            return this.persisted;
        }

        public void markAsPersisted() {
            this.persisted = true;
        }

        public String getModel() {
            return this.model;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Engine engine = (Engine)o;
            return Objects.equals(this.model, engine.model);
        }

        public int hashCode() {
            return this.model != null ? this.model.hashCode() : 0;
        }

        public String toString() {
            return "Engine(" + Strings.footPrint((Object)this, (Function[])new Function[]{Engine::getModel}) + ")";
        }

        public Car getCar() {
            return this.car;
        }

        public void setCar(Car car) {
            this.car = car;
        }
    }

    static class Car
    extends Vehicle {
        private String model;

        public Car() {
        }

        public Car(Long id) {
            super(id);
        }

        public Car(Long id, String model) {
            super(id);
            this.setModel(model);
        }

        public String getModel() {
            return this.model;
        }

        public void setModel(String model) {
            this.model = model;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Car car = (Car)o;
            return Objects.equals(this.model, car.model);
        }

        public String toString() {
            return "Car{id=" + this.getId() + ", color=" + Nullable.nullable((Object)this.getColor()).map(Color::getRgb).get() + ", model='" + this.model + "'}";
        }
    }

    static class Color {
        private int rgb;

        public Color() {
        }

        public Color(int rgb) {
            this.rgb = rgb;
        }

        public int getRgb() {
            return this.rgb;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Color color = (Color)o;
            return this.rgb == color.rgb;
        }

        public int hashCode() {
            return Objects.hash(this.rgb);
        }
    }

    static class Vehicle
    extends AbstractVehicle {
        private Color color;
        private Engine engine;

        public Vehicle(Long id) {
            super(id);
        }

        public Vehicle() {
        }

        public Color getColor() {
            return this.color;
        }

        public void setColor(Color color) {
            this.color = color;
        }

        public Engine getEngine() {
            return this.engine;
        }

        public void setEngine(Engine engine) {
            this.engine = engine;
        }
    }

    static abstract class AbstractVehicle {
        private Long id;
        private Timestamp timestamp;
        private boolean persisted = false;

        public AbstractVehicle() {
        }

        private AbstractVehicle(Long id) {
            this.id = id;
        }

        public Long getId() {
            return this.id;
        }

        public Timestamp getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Timestamp timestamp) {
            this.timestamp = timestamp;
        }

        public boolean isPersisted() {
            return this.persisted;
        }

        public void markAsPersisted() {
            this.persisted = true;
        }
    }
}

