/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.oracle.test;

import java.sql.SQLException;
import java.util.Map;
import javax.sql.DataSource;
import oracle.jdbc.datasource.impl.OracleDataSource;
import org.codefilarete.stalactite.sql.oracle.test.OracleEmbeddableDataSource;
import org.codefilarete.stalactite.sql.test.TestDataSourceSelector;
import org.codefilarete.tool.Nullable;

public class OracleTestDataSourceSelector
extends TestDataSourceSelector {
    protected boolean isExternalServiceConfigured(Map<String, String> properties) {
        return properties.get("oracle.url") != null;
    }

    protected DataSource buildDataSource(Map<String, String> properties) {
        String url = properties.get("oracle.url");
        try {
            OracleDataSource oracleDataSource = new OracleDataSource();
            oracleDataSource.setURL(url);
            Nullable.nullable((Object)properties.get("oracle.user")).invoke(arg_0 -> ((OracleDataSource)oracleDataSource).setUser(arg_0));
            Nullable.nullable((Object)properties.get("oracle.password")).invoke(arg_0 -> ((OracleDataSource)oracleDataSource).setPassword(arg_0));
            return oracleDataSource;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    protected DataSource buildEmbeddedDataSource() {
        return new OracleEmbeddableDataSource();
    }
}

