/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import java.util.function.Consumer;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.ValuedVariable;
import org.codefilarete.stalactite.query.model.Variable;
import org.codefilarete.stalactite.query.model.operator.Cast;
import org.codefilarete.stalactite.query.model.operator.Count;
import org.codefilarete.stalactite.query.model.operator.SQLFunction;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;

public class FunctionSQLBuilderFactory {
    private final JavaTypeToSqlTypeMapping javaTypeToSqlTypeMapping;

    public FunctionSQLBuilderFactory(JavaTypeToSqlTypeMapping javaTypeToSqlTypeMapping) {
        this.javaTypeToSqlTypeMapping = javaTypeToSqlTypeMapping;
    }

    public FunctionSQLBuilder functionSQLBuilder(DMLNameProvider dmlNameProvider) {
        return new FunctionSQLBuilder(dmlNameProvider, this.javaTypeToSqlTypeMapping);
    }

    public static class FunctionSQLBuilder {
        private final DMLNameProvider dmlNameProvider;
        private final JavaTypeToSqlTypeMapping javaTypeToSqlTypeMapping;

        public FunctionSQLBuilder(DMLNameProvider dmlNameProvider, JavaTypeToSqlTypeMapping javaTypeToSqlTypeMapping) {
            this.dmlNameProvider = dmlNameProvider;
            this.javaTypeToSqlTypeMapping = javaTypeToSqlTypeMapping;
        }

        public <N> void cat(SQLFunction<N, ?> operator, SQLAppender sql) {
            if (operator instanceof Cast) {
                this.catCast((Cast)operator, sql);
            } else {
                Variable<N> functionValue;
                sql.cat(operator.getExpression(), "(");
                if (operator instanceof Count && ((Count)operator).isDistinct()) {
                    sql.cat("distinct ", new String[0]);
                }
                if ((functionValue = operator.getValue()) instanceof ValuedVariable) {
                    Object functionArguments = ((ValuedVariable)functionValue).getValue();
                    if (functionArguments instanceof Iterable) {
                        for (Object argument : (Iterable)functionArguments) {
                            this.catArgument(sql, argument, sql::catValue);
                            sql.cat(", ", new String[0]);
                        }
                        sql.removeLastChars(2);
                    } else {
                        this.catArgument(sql, functionArguments, sql::catValue);
                    }
                    sql.cat(")", new String[0]);
                }
            }
        }

        private void catArgument(SQLAppender sql, Object argument, Consumer<Object> fallbackHandler) {
            if (argument instanceof ValuedVariable) {
                argument = ((ValuedVariable)argument).getValue();
            }
            if (argument instanceof SQLFunction) {
                this.cat((SQLFunction)argument, sql);
            } else if (argument instanceof Selectable) {
                sql.cat(this.dmlNameProvider.getName((Selectable)argument), new String[0]);
            } else {
                fallbackHandler.accept(argument);
            }
        }

        public void catCast(Cast<?, ?> cast, SQLAppender sqlAppender) {
            sqlAppender.cat(cast.getExpression(), "(");
            this.catArgument(sqlAppender, cast.getValue(), value -> sqlAppender.cat(String.valueOf(value), new String[0]));
            sqlAppender.cat(" as ", this.javaTypeToSqlTypeMapping.getTypeName(cast.getJavaType(), cast.getTypeSize()), ")");
        }
    }
}

