/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.result;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Map;
import org.codefilarete.stalactite.sql.result.NoopResultSet;

public class InMemoryResultSet
extends NoopResultSet {
    private final Iterator<Map<String, Object>> data;
    private Map<String, Object> currentRow;

    public InMemoryResultSet(Iterable<? extends Map<? extends String, ? extends Object>> data) {
        this(data.iterator());
    }

    public InMemoryResultSet(Iterator<? extends Map<? extends String, ? extends Object>> data) {
        this.data = data;
    }

    @Override
    public boolean next() throws SQLException {
        boolean hasNext = this.data.hasNext();
        if (hasNext) {
            this.currentRow = this.data.next();
        }
        return hasNext;
    }

    @Override
    public boolean wasNull() throws SQLException {
        throw new UnsupportedOperationException();
    }

    private void assertExists(String columnName) throws SQLException {
        if (!this.currentRow.containsKey(columnName)) {
            throw new SQLException("Column doesn't exist : " + columnName);
        }
    }

    @Override
    public String getString(String columnName) throws SQLException {
        this.assertExists(columnName);
        return (String)this.currentRow.get(columnName);
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        this.assertExists(columnName);
        return (Boolean)this.currentRow.get(columnName);
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        this.assertExists(columnName);
        return (Byte)this.currentRow.get(columnName);
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        this.assertExists(columnName);
        return (Short)this.currentRow.get(columnName);
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        this.assertExists(columnName);
        return (Integer)this.currentRow.get(columnName);
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        this.assertExists(columnName);
        return (Long)this.currentRow.get(columnName);
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        this.assertExists(columnName);
        return ((Float)this.currentRow.get(columnName)).floatValue();
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        this.assertExists(columnName);
        return (Double)this.currentRow.get(columnName);
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        this.assertExists(columnName);
        return (byte[])this.currentRow.get(columnName);
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        this.assertExists(columnName);
        return (Date)this.currentRow.get(columnName);
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        this.assertExists(columnName);
        return (Time)this.currentRow.get(columnName);
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        this.assertExists(columnName);
        return (Timestamp)this.currentRow.get(columnName);
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        this.assertExists(columnName);
        return (InputStream)this.currentRow.get(columnName);
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        this.assertExists(columnName);
        return (InputStream)this.currentRow.get(columnName);
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        this.assertExists(columnName);
        return (InputStream)this.currentRow.get(columnName);
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        this.assertExists(columnName);
        return this.currentRow.get(columnName);
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        this.assertExists(columnName);
        return (Reader)this.currentRow.get(columnName);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        this.assertExists(columnName);
        return (BigDecimal)this.currentRow.get(columnName);
    }
}

