/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.time.Duration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.tool.Retryer;

public class ClosedConnectionRetryerProvider
implements ConnectionProvider {
    private final ConnectionProvider dataSource;
    private final ClosedConnectionRetryer closedConnectionRetryer;

    public ClosedConnectionRetryerProvider(ConnectionProvider dataSource) {
        this(dataSource, 3);
    }

    public ClosedConnectionRetryerProvider(ConnectionProvider dataSource, int connectionOpeningRetryMaxCount) {
        this.dataSource = dataSource;
        this.closedConnectionRetryer = new ClosedConnectionRetryer(connectionOpeningRetryMaxCount, Duration.ofMillis(10L));
    }

    public ClosedConnectionRetryerProvider(ConnectionProvider dataSource, int connectionOpeningRetryMaxCount, Duration connectionOpeningRetryInterval) {
        this.dataSource = dataSource;
        this.closedConnectionRetryer = new ClosedConnectionRetryer(connectionOpeningRetryMaxCount, connectionOpeningRetryInterval);
    }

    @Override
    public Connection giveConnection() {
        return this.lookupForConnection();
    }

    private Connection lookupForConnection() {
        Connection connection;
        try {
            connection = (Connection)this.closedConnectionRetryer.execute(this.dataSource::giveConnection, "getting a connection");
        }
        catch (Retryer.RetryException e) {
            throw new Retryer.RetryException("Maximum attempt to open a connection reached : all are closed", (Throwable)e);
        }
        return connection;
    }

    private static class ClosedConnectionRetryer
    extends Retryer {
        public ClosedConnectionRetryer(int retryCount, Duration connectionOpeningRetryInterval) {
            super(retryCount, connectionOpeningRetryInterval);
        }

        protected boolean shouldRetry(Retryer.Result result) {
            if (result instanceof Retryer.Failure) {
                return false;
            }
            try {
                return ((Connection)((Retryer.Success)result).getValue()).isClosed();
            }
            catch (SQLException e) {
                throw new IllegalStateException("Impossible to know if connection is closed or not", e);
            }
        }
    }
}

