/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.postgresql.test;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.sql.DataSource;
import org.codefilarete.stalactite.sql.UrlAwareDataSource;
import org.postgresql.ds.PGSimpleDataSource;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.utility.DockerImageName;

public class PostgreSQLEmbeddedDataSource
extends UrlAwareDataSource
implements Closeable {
    public static final int DEFAULT_PORT = 5432;
    private static final Map<Integer, PostgreSQLContainer> USED_PORTS = new HashMap<Integer, PostgreSQLContainer>();
    private PostgreSQLContainer container;
    private final int port;
    private final String databaseName;

    public PostgreSQLEmbeddedDataSource() {
        this(5432);
    }

    public PostgreSQLEmbeddedDataSource(int port) {
        this(port, "test" + Integer.toHexString(new Random().nextInt()));
    }

    private PostgreSQLEmbeddedDataSource(int port, String databaseName) {
        super("jdbc:postgresql://localhost:" + port + "/" + databaseName);
        this.port = port;
        this.databaseName = databaseName;
        this.start(databaseName);
        PGSimpleDataSource delegate = new PGSimpleDataSource();
        delegate.setDatabaseName(this.container.getDatabaseName());
        delegate.setServerNames(new String[]{"localhost"});
        delegate.setPortNumbers(new int[]{port});
        delegate.setUser(this.container.getUsername());
        delegate.setPassword(this.container.getPassword());
        delegate.setCurrentSchema(databaseName);
        this.setDelegate((DataSource)delegate);
    }

    public Connection getConnection() throws SQLException {
        Connection conn = super.getConnection();
        conn.createStatement().execute("SET search_path TO " + this.databaseName + ";");
        return conn;
    }

    private void start(String databaseName) {
        this.container = USED_PORTS.get(this.port);
        if (this.container == null) {
            PostgreSQLContainer mariaDBContainer = new PostgreSQLContainer(DockerImageName.parse((String)"postgres:14.11"));
            ((PostgreSQLContainer)mariaDBContainer.withReuse(true)).withDatabaseName("test").withUsername("test").withPassword("test").setPortBindings(Arrays.asList(this.port + ":" + 5432));
            mariaDBContainer.start();
            USED_PORTS.put(this.port, mariaDBContainer);
            this.container = mariaDBContainer;
        }
        try {
            this.container.createConnection("").prepareStatement("create schema " + databaseName).execute();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() {
        this.container.stop();
    }
}

