/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.ddl;

import java.util.HashMap;
import java.util.Map;
import org.codefilarete.stalactite.sql.ddl.JavaTypeToSqlTypeMapping;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.statement.SQLStatement;

public class SqlTypeRegistry {
    private final JavaTypeToSqlTypeMapping javaTypeToSqlType;
    private final Map<Column, String> columnToSQLType = new HashMap<Column, String>();

    public SqlTypeRegistry() {
        this(new JavaTypeToSqlTypeMapping());
    }

    public SqlTypeRegistry(JavaTypeToSqlTypeMapping javaTypeToSqlTypeMapping) {
        this.javaTypeToSqlType = javaTypeToSqlTypeMapping;
    }

    public JavaTypeToSqlTypeMapping getJavaTypeToSqlTypeMapping() {
        return this.javaTypeToSqlType;
    }

    public void put(Class clazz, String sqlType) {
        this.javaTypeToSqlType.put(clazz, sqlType);
    }

    public void put(Class clazz, String sqlType, int size) {
        this.javaTypeToSqlType.put(clazz, sqlType, size);
    }

    public void put(Column column, String sqlType) {
        this.columnToSQLType.put(column, sqlType);
    }

    public String getTypeName(Column column) {
        String typeName = this.columnToSQLType.get(column);
        if (typeName != null) {
            return typeName;
        }
        Class javaType = column.getJavaType();
        Integer size = column.getSize();
        if (size != null) {
            return this.javaTypeToSqlType.getTypeName(javaType, size);
        }
        try {
            return this.javaTypeToSqlType.getTypeName(javaType);
        }
        catch (SQLStatement.BindingException e) {
            throw new SQLStatement.BindingException("No sql type defined for column " + column.getAbsoluteName(), (Throwable)e);
        }
    }
}

