/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.builder;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.codefilarete.stalactite.query.builder.DMLNameProvider;
import org.codefilarete.stalactite.query.builder.SQLAppender;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.tool.trace.ModifiableInt;

public class PreparedSQLWrapper
implements SQLAppender {
    private final SQLAppender surrogate;
    private final ColumnBinderRegistry parameterBinderRegistry;
    private final Map<Integer, ParameterBinder> parameterBinders;
    private final Map<Integer, Object> values;
    private final ModifiableInt paramCounter = new ModifiableInt(1);
    private final DMLNameProvider dmlNameProvider;

    public PreparedSQLWrapper(SQLAppender sqlAppender, ColumnBinderRegistry parameterBinderRegistry, DMLNameProvider dmlNameProvider) {
        this.surrogate = sqlAppender;
        this.parameterBinderRegistry = parameterBinderRegistry;
        this.dmlNameProvider = dmlNameProvider;
        this.parameterBinders = new HashMap<Integer, ParameterBinder>();
        this.values = new HashMap<Integer, Object>();
    }

    public Map<Integer, Object> getValues() {
        return this.values;
    }

    public Map<Integer, ParameterBinder> getParameterBinders() {
        return this.parameterBinders;
    }

    @Override
    public PreparedSQLWrapper cat(String s, String ... ss) {
        this.surrogate.cat(s, ss);
        return this;
    }

    @Override
    public <V> PreparedSQLWrapper catValue(@Nullable Selectable<V> column, V value) {
        return this.catValue(value, () -> {
            if (column == null) {
                return this.getParameterBinderFromRegistry(value);
            }
            if (column instanceof Column) {
                return this.parameterBinderRegistry.getBinder((Column)column);
            }
            return this.parameterBinderRegistry.getBinder(column.getJavaType());
        });
    }

    @Override
    public PreparedSQLWrapper catValue(Object value) {
        return this.catValue(value, () -> this.getParameterBinderFromRegistry(value));
    }

    private ParameterBinder<?> getParameterBinderFromRegistry(Object value) {
        Class<?> binderType = value.getClass().isArray() ? value.getClass().getComponentType() : value.getClass();
        return this.parameterBinderRegistry.getBinder(binderType);
    }

    private PreparedSQLWrapper catValue(Object value, Supplier<ParameterBinder<?>> binderSupplier) {
        if (value instanceof Selectable) {
            this.surrogate.cat(this.dmlNameProvider.getName((Selectable)value), new String[0]);
        } else {
            this.surrogate.cat("?", new String[0]);
            this.values.put(this.paramCounter.getValue(), value);
            this.parameterBinders.put(this.paramCounter.getValue(), binderSupplier.get());
            this.paramCounter.increment();
        }
        return this;
    }

    @Override
    public PreparedSQLWrapper catColumn(Column column) {
        this.surrogate.cat(this.dmlNameProvider.getName(column), new String[0]);
        return this;
    }

    @Override
    public SQLAppender removeLastChars(int length) {
        this.surrogate.removeLastChars(length);
        return this;
    }

    @Override
    public String getSQL() {
        return this.surrogate.getSQL();
    }
}

