/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.codefilarete.reflection.MethodReferenceDispatcher;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.ExecutableProjection;
import org.codefilarete.stalactite.engine.ExecutableQuery;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.PolymorphicPersister;
import org.codefilarete.stalactite.engine.runtime.RelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.SimpleRelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.query.EntityCriteriaSupport;
import org.codefilarete.stalactite.query.EntitySelector;
import org.codefilarete.stalactite.query.RelationalEntityCriteria;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.tool.Nullable;

public abstract class AbstractPolymorphismPersister<C, I>
implements ConfiguredRelationalPersister<C, I>,
PolymorphicPersister<C> {
    protected final Map<Class<C>, ConfiguredRelationalPersister<C, I>> subEntitiesPersisters;
    protected final ConfiguredRelationalPersister<C, I> mainPersister;
    protected final EntityCriteriaSupport<C> criteriaSupport;
    protected final EntitySelector<C, I> entitySelectExecutor;

    protected AbstractPolymorphismPersister(ConfiguredRelationalPersister<C, I> mainPersister, Map<? extends Class<C>, ? extends ConfiguredRelationalPersister<C, I>> subEntitiesPersisters, EntitySelector<C, I> entitySelectExecutor) {
        this.mainPersister = mainPersister;
        this.subEntitiesPersisters = subEntitiesPersisters;
        this.criteriaSupport = new EntityCriteriaSupport(mainPersister.getMapping());
        this.entitySelectExecutor = entitySelectExecutor;
    }

    @Override
    public RelationalEntityPersister.RelationalExecutableEntityQuery<C> selectWhere() {
        EntityCriteriaSupport<C> localCriteriaSupport = this.newWhere();
        return this.wrapIntoExecutable(localCriteriaSupport);
    }

    private RelationalEntityPersister.RelationalExecutableEntityQuery<C> wrapIntoExecutable(EntityCriteriaSupport<C> localCriteriaSupport) {
        MethodReferenceDispatcher methodDispatcher = new MethodReferenceDispatcher();
        return (RelationalEntityPersister.RelationalExecutableEntityQuery)methodDispatcher.redirect(ExecutableQuery::execute, this.wrapGraphLoad(localCriteriaSupport)).redirect(SimpleRelationalEntityPersister.CriteriaProvider::getCriteria, localCriteriaSupport::getCriteria).redirect(RelationalEntityCriteria.class, localCriteriaSupport, true).build(RelationalEntityPersister.RelationalExecutableEntityQuery.class);
    }

    private <R> Function<Accumulator<C, Set<C>, R>, R> wrapGraphLoad(EntityCriteriaSupport<C> localCriteriaSupport) {
        return accumulator -> {
            Set result = this.getPersisterListener().doWithSelectListener(Collections.emptySet(), () -> this.entitySelectExecutor.select(localCriteriaSupport.getCriteria()));
            return accumulator.collect((Iterable)result);
        };
    }

    private EntityCriteriaSupport<C> newWhere() {
        return new EntityCriteriaSupport<C>(this.criteriaSupport);
    }

    public EntityPersister.ExecutableProjectionQuery<C> selectProjectionWhere(Consumer<Select> selectAdapter) {
        return this.wrapIntoExecutable(selectAdapter, this.newWhere());
    }

    private EntityPersister.ExecutableProjectionQuery<C> wrapIntoExecutable(Consumer<Select> selectAdapter, EntityCriteriaSupport<C> localCriteriaSupport) {
        MethodReferenceDispatcher methodDispatcher = new MethodReferenceDispatcher();
        ExecutableProjectionQuerySupport querySugarSupport = new ExecutableProjectionQuerySupport();
        return (EntityPersister.ExecutableProjectionQuery)methodDispatcher.redirect(ExecutableProjection::execute, this.wrapProjectionLoad(selectAdapter, localCriteriaSupport, querySugarSupport)).redirect(ExecutableProjection::distinct, querySugarSupport::distinct).redirect(ExecutableProjection::limit, querySugarSupport::limit).redirect(EntityPersister.EntityCriteria.class, localCriteriaSupport, true).build(EntityPersister.ExecutableProjectionQuery.class);
    }

    private <R> Function<Accumulator<? super Function<? extends Selectable, Object>, Object, R>, R> wrapProjectionLoad(Consumer<Select> selectAdapter, EntityCriteriaSupport<C> localCriteriaSupport, ExecutableProjectionQuerySupport querySugarSupport) {
        return accumulator -> this.entitySelectExecutor.selectProjection(selectAdapter, accumulator, localCriteriaSupport.getCriteria(), querySugarSupport.isDistinct(), fluentOrderByClause -> Nullable.nullable((Object)querySugarSupport.getLimit()).invoke(arg_0 -> ((Query.FluentOrderByClause)fluentOrderByClause).limit(arg_0)));
    }

    public Set<C> selectAll() {
        return this.entitySelectExecutor.select(this.newWhere().getCriteria());
    }

    public boolean isNew(C entity) {
        return this.mainPersister.isNew(entity);
    }

    public Class<C> getClassToPersist() {
        return this.mainPersister.getClassToPersist();
    }

    @Override
    public EntityJoinTree<C, I> getEntityJoinTree() {
        return this.mainPersister.getEntityJoinTree();
    }

    private static class ExecutableProjectionQuerySupport {
        private boolean distinct;
        private Integer limit;

        private ExecutableProjectionQuerySupport() {
        }

        public boolean isDistinct() {
            return this.distinct;
        }

        void distinct() {
            this.distinct = true;
        }

        public Integer getLimit() {
            return this.limit;
        }

        void limit(int count) {
            this.limit = count;
        }
    }
}

