/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.stalactite.engine.MappingConfigurationException;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.Strings;

public interface AssociationTableNamingStrategy {
    public static final AssociationTableNamingStrategy DEFAULT = new DefaultAssociationTableNamingStrategy();

    public <LEFTTABLE extends Table<LEFTTABLE>, RIGHTTABLE extends Table<RIGHTTABLE>> String giveName(AccessorDefinition var1, PrimaryKey<LEFTTABLE, ?> var2, PrimaryKey<RIGHTTABLE, ?> var3);

    public <LEFTTABLE extends Table<LEFTTABLE>, RIGHTTABLE extends Table<RIGHTTABLE>, LEFTID, RIGHTID> ReferencedColumnNames<LEFTTABLE, RIGHTTABLE> giveColumnNames(AccessorDefinition var1, PrimaryKey<LEFTTABLE, LEFTID> var2, PrimaryKey<RIGHTTABLE, RIGHTID> var3);

    public static class DefaultAssociationTableNamingStrategy
    implements AssociationTableNamingStrategy {
        @Override
        public <LEFTTABLE extends Table<LEFTTABLE>, RIGHTTABLE extends Table<RIGHTTABLE>> String giveName(AccessorDefinition accessor, PrimaryKey<LEFTTABLE, ?> source, PrimaryKey<RIGHTTABLE, ?> target) {
            return accessor.getDeclaringClass().getSimpleName() + "_" + accessor.getName();
        }

        @Override
        public <LEFTTABLE extends Table<LEFTTABLE>, RIGHTTABLE extends Table<RIGHTTABLE>, LEFTID, RIGHTID> ReferencedColumnNames<LEFTTABLE, RIGHTTABLE> giveColumnNames(AccessorDefinition accessorDefinition, PrimaryKey<LEFTTABLE, LEFTID> leftPrimaryKey, PrimaryKey<RIGHTTABLE, RIGHTID> rightPrimaryKey) {
            ReferencedColumnNames result = new ReferencedColumnNames();
            leftPrimaryKey.getColumns().forEach(column -> {
                String leftColumnName = Strings.uncapitalize((CharSequence)leftPrimaryKey.getTable().getName()) + "_" + column.getName();
                result.setLeftColumnName(column, leftColumnName);
            });
            TreeSet existingColumns = new TreeSet(String.CASE_INSENSITIVE_ORDER);
            existingColumns.addAll(result.leftColumnNames.values());
            String rightSideColumnNamePrefix = accessorDefinition.getName();
            rightPrimaryKey.getColumns().forEach(column -> {
                String rightColumnName = Strings.uncapitalize((CharSequence)(rightSideColumnNamePrefix + "_" + column.getName()));
                if (existingColumns.contains(rightColumnName)) {
                    throw new MappingConfigurationException("Identical column names in association table of collection " + accessorDefinition + " : " + rightColumnName);
                }
                result.setRightColumnName(column, rightColumnName);
            });
            return result;
        }
    }

    public static class ReferencedColumnNames<LEFTTABLE extends Table<LEFTTABLE>, RIGHTTABLE extends Table<RIGHTTABLE>> {
        private final Map<Column<LEFTTABLE, Object>, String> leftColumnNames = new HashMap<Column<LEFTTABLE, Object>, String>();
        private final Map<Column<RIGHTTABLE, Object>, String> rightColumnNames = new HashMap<Column<RIGHTTABLE, Object>, String>();

        public void setLeftColumnName(Column<LEFTTABLE, ?> column, String name) {
            this.leftColumnNames.put(column, name);
        }

        public String getLeftColumnName(Column<LEFTTABLE, ?> column) {
            return this.leftColumnNames.get(column);
        }

        public void setRightColumnName(Column<RIGHTTABLE, ?> column, String name) {
            this.rightColumnNames.put(column, name);
        }

        public String getRightColumnName(Column<RIGHTTABLE, ?> column) {
            return this.rightColumnNames.get(column);
        }
    }
}

