/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import org.assertj.core.api.Assertions;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.dsl.naming.ColumnNamingStrategy;
import org.junit.jupiter.api.Test;

public class ColumnNamingStrategyTest {
    @Test
    void defaultGiveName() {
        Assertions.assertThat((String)ColumnNamingStrategy.DEFAULT.giveName(new AccessorDefinition(Toto.class, "name", Integer.TYPE))).isEqualTo("name");
        Assertions.assertThat((String)ColumnNamingStrategy.DEFAULT.giveName(new AccessorDefinition(Toto.class, "isbn", String.class))).isEqualTo("isbn");
        AccessorChain accessor = AccessorChain.fromMethodReferences(Toto::getTata, Tata::getWonderfulProperty);
        Assertions.assertThat((String)ColumnNamingStrategy.DEFAULT.giveName(AccessorDefinition.giveDefinition((ValueAccessPoint)accessor))).isEqualTo("tata_wonderfulProperty");
    }

    private static class Tata {
        private String wonderfulProperty;

        private Tata() {
        }

        public String getWonderfulProperty() {
            return this.wonderfulProperty;
        }

        public void setName(String name) {
            this.wonderfulProperty = name;
        }
    }

    private static class Toto {
        private int name;
        private String isbn;
        private Tata tata;

        private Toto() {
        }

        public int getName() {
            return this.name;
        }

        public void setName(int name) {
            this.name = name;
        }

        public String getIsbn() {
            return this.isbn;
        }

        public void setIsbn(String isbn) {
            this.isbn = isbn;
        }

        public Tata getTata() {
            return this.tata;
        }

        public void setTata(Tata tata) {
            this.tata = tata;
        }
    }
}

