/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.onetoone;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.dsl.naming.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.IndexNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.JoinColumnNamingStrategy;
import org.codefilarete.stalactite.dsl.property.CascadeOptions;
import org.codefilarete.stalactite.engine.configurer.onetoone.FirstPhaseCycleLoadListener;
import org.codefilarete.stalactite.engine.configurer.onetoone.OneToOneConfigurerTemplate;
import org.codefilarete.stalactite.engine.configurer.onetoone.OneToOneRelation;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.load.PassiveJoinNode;
import org.codefilarete.stalactite.engine.runtime.load.RelationJoinNode;
import org.codefilarete.stalactite.engine.runtime.onetoone.OneToOneOwnedBySourceEngine;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.collection.KeepOrderSet;

public class OneToOneOwnedBySourceConfigurer<SRC, TRGT, SRCID, TRGTID, LEFTTABLE extends Table<LEFTTABLE>, RIGHTTABLE extends Table<RIGHTTABLE>, JOINID>
extends OneToOneConfigurerTemplate<SRC, TRGT, SRCID, TRGTID, LEFTTABLE, RIGHTTABLE, JOINID> {
    private final JoinColumnNamingStrategy joinColumnNamingStrategy;
    private final ForeignKeyNamingStrategy foreignKeyNamingStrategy;
    private final Map<Column<LEFTTABLE, ?>, Column<RIGHTTABLE, ?>> keyColumnsMapping = new HashMap();
    private OneToOneOwnedBySourceEngine<SRC, TRGT, SRCID, TRGTID, LEFTTABLE, RIGHTTABLE> engine;

    public OneToOneOwnedBySourceConfigurer(ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, OneToOneRelation<SRC, TRGT, TRGTID> oneToOneRelation, JoinColumnNamingStrategy joinColumnNamingStrategy, ForeignKeyNamingStrategy foreignKeyNamingStrategy, IndexNamingStrategy indexNamingStrategy) {
        super(sourcePersister, oneToOneRelation, indexNamingStrategy);
        this.joinColumnNamingStrategy = joinColumnNamingStrategy;
        this.foreignKeyNamingStrategy = foreignKeyNamingStrategy;
    }

    @Override
    protected BeanRelationFixer<SRC, TRGT> determineRelationFixer() {
        Mutator targetSetter = this.oneToOneRelation.getTargetProvider().toMutator();
        return BeanRelationFixer.of((arg_0, arg_1) -> ((Mutator)targetSetter).set(arg_0, arg_1));
    }

    @Override
    protected Duo<Key<LEFTTABLE, JOINID>, Key<RIGHTTABLE, JOINID>> determineForeignKeyColumns(EntityMapping<SRC, SRCID, LEFTTABLE> mappingStrategy, EntityMapping<TRGT, TRGTID, RIGHTTABLE> targetMappingStrategy) {
        boolean createForeignKey;
        PrimaryKey rightKey = targetMappingStrategy.getTargetTable().getPrimaryKey();
        Key.KeyBuilder leftKeyBuilder = Key.from((Fromable)mappingStrategy.getTargetTable());
        AccessorDefinition accessorDefinition = AccessorDefinition.giveDefinition(this.oneToOneRelation.getTargetProvider());
        targetMappingStrategy.getTargetTable().getPrimaryKey().getColumns().forEach(column -> {
            String effectiveLeftColumnName = (String)Nullable.nullable((Object)this.oneToOneRelation.getColumnName()).elseSet(() -> this.joinColumnNamingStrategy.giveName(accessorDefinition, (Column<?, ?>)column)).get();
            Column foreignKeyColumn = mappingStrategy.getTargetTable().addColumn(effectiveLeftColumnName, column.getJavaType());
            leftKeyBuilder.addColumn((JoinLink)foreignKeyColumn);
            this.keyColumnsMapping.put((Column<LEFTTABLE, ?>)foreignKeyColumn, (Column<RIGHTTABLE, ?>)column);
        });
        Key leftKey = leftKeyBuilder.build();
        leftKey.getColumns().forEach(c -> ((Column)c).nullable(this.oneToOneRelation.isNullable()));
        boolean bl = createForeignKey = !this.oneToOneRelation.isTargetTablePerClassPolymorphic();
        if (createForeignKey) {
            String foreignKeyName = this.foreignKeyNamingStrategy.giveName(leftKey, rightKey);
            this.sourcePersister.getMapping().getTargetTable().addForeignKey(foreignKeyName, leftKey, (Key)rightKey);
        }
        return new Duo((Object)leftKey, (Object)rightKey);
    }

    @Override
    protected void addIndex(Column<?, ?> column) {
        String indexName = this.indexNamingStrategy.giveName((ValueAccessPoint<?>)this.oneToOneRelation.getTargetProvider(), column.getExpression());
        column.getTable().addIndex(indexName, column, new Column[0]).setUnique();
    }

    @Override
    protected void addSelectIn2Phases(String tableAlias, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister, Key<LEFTTABLE, JOINID> leftKey, Key<RIGHTTABLE, JOINID> rightKey, FirstPhaseCycleLoadListener<SRC, TRGTID> firstPhaseCycleLoadListener) {
        Table targetTableClone = new Table(targetPersister.getMapping().getTargetTable().getName());
        KeepOrderSet columns = rightKey.getColumns();
        columns.forEach(column -> targetTableClone.addColumn(column.getExpression(), column.getJavaType()).primaryKey());
        String joinName = this.sourcePersister.getEntityJoinTree().addPassiveJoin("ROOT", leftKey, targetTableClone.getPrimaryKey(), tableAlias, this.oneToOneRelation.isNullable() ? EntityJoinTree.JoinType.OUTER : EntityJoinTree.JoinType.INNER, (Set<? extends Selectable<?>>)targetTableClone.getPrimaryKey().getColumns(), (src, columnValueProvider) -> firstPhaseCycleLoadListener.onFirstPhaseRowRead(src, targetPersister.getMapping().getIdMapping().getIdentifierAssembler().assemble(columnValueProvider)), true);
        PassiveJoinNode passiveJoin = (PassiveJoinNode)this.sourcePersister.getEntityJoinTree().getJoin(joinName);
        targetPersister.getEntityJoinTree().foreachJoin(joinNode -> {
            if (joinNode instanceof RelationJoinNode && ((RelationJoinNode)joinNode).getEntityInflater().getEntityType() == this.sourcePersister.getClassToPersist()) {
                EntityJoinTree.cloneNodeForParent(passiveJoin, joinNode, leftKey);
            }
        });
    }

    @Override
    protected void addWriteCascades(ConfiguredPersister<TRGT, TRGTID> targetPersister) {
        boolean writeAuthorized;
        this.engine = new OneToOneOwnedBySourceEngine(this.sourcePersister, targetPersister, this.oneToOneRelation.getTargetProvider(), this.keyColumnsMapping);
        boolean bl = writeAuthorized = this.oneToOneRelation.getRelationMode() != CascadeOptions.RelationMode.READ_ONLY;
        if (writeAuthorized) {
            super.addWriteCascades(targetPersister);
        } else {
            this.engine.addForeignKeyMaintainer();
        }
    }

    @Override
    protected void addInsertCascade(ConfiguredPersister<TRGT, TRGTID> targetPersister) {
        super.addInsertCascade(targetPersister);
        this.engine.addInsertCascade();
    }

    @Override
    protected void addUpdateCascade(ConfiguredPersister<TRGT, TRGTID> targetPersister, boolean orphanRemoval) {
        super.addUpdateCascade(targetPersister, orphanRemoval);
        this.engine.addUpdateCascade(orphanRemoval);
    }

    @Override
    protected void addDeleteCascade(ConfiguredPersister<TRGT, TRGTID> targetPersister, boolean orphanRemoval) {
        this.engine.addDeleteCascade(orphanRemoval);
    }
}

