/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.sql.DataSource;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.dsl.MappingConfigurationException;
import org.codefilarete.stalactite.dsl.MappingEase;
import org.codefilarete.stalactite.dsl.embeddable.EmbeddableMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.embeddable.FluentEmbeddableMappingBuilder;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.entity.FluentEntityMappingBuilder;
import org.codefilarete.stalactite.dsl.idpolicy.IdentifierPolicy;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.configurer.FluentEmbeddableMappingConfigurationSupport;
import org.codefilarete.stalactite.engine.configurer.ToStringBuilder;
import org.codefilarete.stalactite.engine.model.AbstractCountry;
import org.codefilarete.stalactite.engine.model.City;
import org.codefilarete.stalactite.engine.model.Country;
import org.codefilarete.stalactite.engine.model.Gender;
import org.codefilarete.stalactite.engine.model.Person;
import org.codefilarete.stalactite.engine.model.PersonWithGender;
import org.codefilarete.stalactite.engine.model.Timestamp;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.PersisterWrapper;
import org.codefilarete.stalactite.engine.runtime.SimpleRelationalEntityPersister;
import org.codefilarete.stalactite.id.Identified;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.PersistableIdentifier;
import org.codefilarete.stalactite.id.PersistedIdentifier;
import org.codefilarete.stalactite.id.StatefulIdentifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Operators;
import org.codefilarete.stalactite.query.model.QueryEase;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialectBuilder;
import org.codefilarete.stalactite.sql.SimpleConnectionProvider;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.Length;
import org.codefilarete.stalactite.sql.ddl.Size;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.ForeignKey;
import org.codefilarete.stalactite.sql.ddl.structure.Index;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.statement.SQLOperation;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.statement.binder.LambdaParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.NullAwareParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriter;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.stalactite.test.DefaultDialect;
import org.codefilarete.tool.Dates;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.InvocationHandlerSupport;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.function.Functions;
import org.codefilarete.tool.function.SerializableThrowingFunction;
import org.danekja.java.util.function.serializable.SerializableFunction;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class FluentEntityMappingConfigurationSupportTest {
    private static final Class<Identifier<UUID>> UUID_TYPE = Identifier.class;
    private final Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
    private final DataSource dataSource = new HSQLDBInMemoryDataSource();
    private PersistenceContext persistenceContext;

    FluentEntityMappingConfigurationSupportTest() {
    }

    @BeforeEach
    void initTest() {
        this.dialect.getDmlGenerator().sortColumnsAlphabetically();
        this.dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        this.dialect.getSqlTypeRegistry().put(Identifier.class, "int");
        this.persistenceContext = new PersistenceContext(this.dataSource, this.dialect);
    }

    @Test
    void build_identifierIsNotDefined_throwsException() {
        FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions mappingStrategy = MappingEase.entityBuilder(Toto.class, Identifier.class).map(Toto::getId).map(Toto::getName);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$build_identifierIsNotDefined_throwsException$0((FluentEntityMappingBuilder)mappingStrategy)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("Identifier is not defined for o.c.s.e.FluentEntityMappingConfigurationSupportTest$Toto, please add one through o.c.s.d.e.FluentEntityMappingBuilder.mapKey(o.d.j.u.f.s.SerializableBiConsumer, o.c.s.d.i.IdentifierPolicy)");
    }

    @Test
    void map_withoutName_targetedPropertyNameIsTaken() {
        ConfiguredRelationalPersister persister = (ConfiguredRelationalPersister)MappingEase.entityBuilder(Toto.class, UUID_TYPE).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).build(this.persistenceContext);
        Assertions.assertThat((String)persister.getMapping().getTargetTable().getName()).isEqualTo("Toto");
        Column columnForProperty = (Column)persister.getMapping().getTargetTable().mapColumnsOnName().get("name");
        Assertions.assertThat((Object)columnForProperty).isNotNull();
        Assertions.assertThat((Class)columnForProperty.getJavaType()).isEqualTo(String.class);
    }

    @Test
    void map_withColumnName_targetedPropertyNameIsTaken() {
        ConfiguredRelationalPersister persister = (ConfiguredRelationalPersister)MappingEase.entityBuilder(Toto.class, UUID_TYPE).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).columnName("dummyName").build(this.persistenceContext);
        Assertions.assertThat((String)persister.getMapping().getTargetTable().getName()).isEqualTo("Toto");
        Column columnForProperty = (Column)persister.getMapping().getTargetTable().mapColumnsOnName().get("dummyName");
        Assertions.assertThat((Object)columnForProperty).isNotNull();
        Assertions.assertThat((Class)columnForProperty.getJavaType()).isEqualTo(String.class);
    }

    @Test
    void map_withFieldName_targetedPropertyNameIsTaken() {
        ConfiguredRelationalPersister persister = (ConfiguredRelationalPersister)MappingEase.entityBuilder(Toto.class, UUID_TYPE).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).fieldName("firstName").build(this.persistenceContext);
        Assertions.assertThat((String)persister.getMapping().getTargetTable().getName()).isEqualTo("Toto");
        Column columnForProperty = (Column)persister.getMapping().getTargetTable().mapColumnsOnName().get("firstName");
        Assertions.assertThat((Object)columnForProperty).isNotNull();
        Assertions.assertThat((Class)columnForProperty.getJavaType()).isEqualTo(String.class);
    }

    @Test
    void map_mandatory_onMissingValue_throwsException() {
        Table totoTable = new Table("Toto");
        Column idColumn = totoTable.addColumn("id", UUID_TYPE);
        this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
        this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
        EntityPersister persister = MappingEase.entityBuilder(Toto.class, UUID_TYPE).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).mandatory().map(Toto::getFirstName).mandatory().build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Toto toto = new Toto();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> persister.insert((Object)toto)).isInstanceOf(RuntimeException.class)).hasMessage("Error while inserting values for " + toto + " in statement \"insert into Toto(firstName, id, name) values (?, ?, ?)\"").hasCause((Throwable)new SQLStatement.BindingException("Expected non null value for : Toto.firstName, Toto.name"));
    }

    @Test
    void map_mandatory_columnConstraintIsAdded() {
        ConfiguredRelationalPersister totoPersister = (ConfiguredRelationalPersister)MappingEase.entityBuilder(Toto.class, UUID_TYPE).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).mandatory().build(this.persistenceContext);
        Assertions.assertThat((boolean)totoPersister.getMapping().getTargetTable().getColumn("name").isNullable()).isFalse();
    }

    @Test
    void map_readonly_columnIsNotWrittenToDatabase() {
        Table totoTable = new Table("Toto");
        Column idColumn = totoTable.addColumn("id", Identifier.class);
        Column nameColumn = totoTable.addColumn("name", String.class);
        this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
        this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
        ConfiguredRelationalPersister persister = (ConfiguredRelationalPersister)MappingEase.entityBuilder(Toto.class, UUID_TYPE).onTable(totoTable).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).readonly().map(Toto::getFirstName).build(this.persistenceContext);
        Assertions.assertThat((Collection)persister.getMapping().getSelectableColumns().stream().map(Column::getName).collect(Collectors.toSet())).isEqualTo((Object)Arrays.asSet((Object[])new String[]{"id", "name", "firstName"}));
        Assertions.assertThat((Collection)persister.getMapping().getInsertableColumns().stream().map(Column::getName).collect(Collectors.toSet())).isEqualTo((Object)Arrays.asSet((Object[])new String[]{"id", "firstName"}));
        Assertions.assertThat((Collection)persister.getMapping().getUpdatableColumns().stream().map(Column::getName).collect(Collectors.toSet())).isEqualTo((Object)Arrays.asSet((Object[])new String[]{"firstName"}));
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        UUID uuid = UUID.randomUUID();
        Toto toto = new Toto(new PersistedIdentifier<UUID>(uuid));
        toto.setName("dummyName");
        persister.insert((Object)toto);
        List totoNames = this.persistenceContext.select(Duo::new, idColumn, nameColumn);
        Assertions.assertThat((List)totoNames).containsExactly((Object[])new Duo[]{new Duo(toto.getId(), null)});
        this.persistenceContext.update(totoTable, QueryEase.where((Selectable)idColumn, (ConditionalOperator)Operators.eq(toto.getId()))).set(nameColumn, (Object)"dummyName").execute();
        totoNames = this.persistenceContext.select(Duo::new, idColumn, nameColumn);
        Assertions.assertThat((List)totoNames).containsExactly((Object[])new Duo[]{new Duo(toto.getId(), (Object)"dummyName")});
    }

    @Test
    void map_readonly_columnIsNotWrittenToDatabase_CRUD() {
        Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
        dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
        dialect.getSqlTypeRegistry().put(Identifier.class, "varchar(36)");
        PersistenceContext persistenceContext = new PersistenceContext(this.dataSource, dialect);
        EntityPersister persister = MappingEase.entityBuilder(Toto.class, UUID_TYPE).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).readonly().map(Toto::getFirstName).build(persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
        ddlDeployer.deployDDL();
        Toto toto = new Toto(new PersistedIdentifier<UUID>(UUID.randomUUID()));
        toto.setName("dummy value");
        persister.insert((Object)toto);
        String firstName = (String)persistenceContext.newQuery((CharSequence)"select firstName from Toto", String.class).mapKey("firstName", String.class).execute(Accumulators.getFirst());
        Assertions.assertThat((String)firstName).isNull();
        toto.setName("updated dummy value");
        persister.update((Object)toto);
        firstName = (String)persistenceContext.newQuery((CharSequence)"select firstName from Toto", String.class).mapKey("firstName", String.class).execute(Accumulators.getFirst());
        Assertions.assertThat((String)firstName).isNull();
    }

    @Test
    void map_withColumn_columnIsUsed() {
        Table toto = new Table("Toto");
        Column titleColumn = toto.addColumn("title", String.class);
        ConfiguredPersister persister = (ConfiguredPersister)MappingEase.entityBuilder(Toto.class, UUID_TYPE).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).column(titleColumn).build(this.persistenceContext);
        Column columnForProperty = (Column)persister.getMapping().getTargetTable().mapColumnsOnName().get("name");
        Assertions.assertThat((Object)columnForProperty).isNull();
        Assertions.assertThat((Collection)persister.getMapping().getInsertableColumns().stream().map(Column::getName).collect(Collectors.toSet())).isEqualTo((Object)Arrays.asSet((Object[])new String[]{"id", "title"}));
        Assertions.assertThat((Collection)persister.getMapping().getUpdatableColumns().stream().map(Column::getName).collect(Collectors.toSet())).isEqualTo((Object)Arrays.asSet((Object[])new String[]{"title"}));
    }

    @Test
    void map_withReadConverter_converterIsUsed() {
        Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
        PersistenceContext persistenceContext = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), dialect);
        Table totoTable = new Table("Toto");
        Column id = totoTable.addColumn("id", UUID_TYPE).primaryKey();
        Column name = totoTable.addColumn("name", String.class);
        dialect.getColumnBinderRegistry().register(id, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
        dialect.getSqlTypeRegistry().put(id, "varchar(255)");
        ConfiguredPersister persister = (ConfiguredPersister)MappingEase.entityBuilder(Toto.class, UUID_TYPE).onTable(totoTable).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).readConverter(String::toUpperCase).build(persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
        ddlDeployer.deployDDL();
        Toto toto = new Toto();
        toto.setName("toto");
        persister.persist((Object)toto);
        Toto select = (Toto)persister.select(toto.getId());
        Assertions.assertThat((String)select.getName()).isEqualTo("TOTO");
        Assertions.assertThat((List)persistenceContext.select(SerializableFunction.identity(), name)).containsExactly((Object[])new String[]{"toto"});
    }

    @Test
    void map_withReadConverter_converterIsUsed_readOnlyProperty() {
        Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
        PersistenceContext persistenceContext = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), dialect);
        Table totoTable = new Table("Toto");
        Column id = totoTable.addColumn("id", UUID_TYPE).primaryKey();
        Column name = totoTable.addColumn("name", String.class);
        dialect.getColumnBinderRegistry().register(id, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
        dialect.getSqlTypeRegistry().put(id, "varchar(255)");
        ConfiguredPersister persister = (ConfiguredPersister)MappingEase.entityBuilder(Toto.class, UUID_TYPE).onTable(totoTable).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).readonly().readConverter(String::toUpperCase).build(persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
        ddlDeployer.deployDDL();
        PersistedIdentifier<UUID> identifier = new PersistedIdentifier<UUID>(UUID.randomUUID());
        persistenceContext.insert(totoTable).set(name, (Object)"toto").set(id, identifier).execute();
        Toto select = (Toto)persister.select(identifier);
        Assertions.assertThat((String)select.getName()).isEqualTo("TOTO");
        Assertions.assertThat((List)persistenceContext.select(SerializableFunction.identity(), name)).containsExactly((Object[])new String[]{"toto"});
    }

    @Test
    void map_withWriteConverter_converterIsUsed() {
        Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
        PersistenceContext persistenceContext = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), dialect);
        Table totoTable = new Table("Toto");
        Column id = totoTable.addColumn("id", UUID_TYPE).primaryKey();
        Column name = totoTable.addColumn("name", String.class);
        dialect.getColumnBinderRegistry().register(id, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
        dialect.getSqlTypeRegistry().put(id, "varchar(255)");
        ConfiguredPersister persister = (ConfiguredPersister)MappingEase.entityBuilder(Toto.class, UUID_TYPE).onTable(totoTable).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).usingConstructor(uuidIdentifier -> new Toto((PersistedIdentifier)uuidIdentifier)).map(Toto::getName).writeConverter(String::toUpperCase).build(persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
        ddlDeployer.deployDDL();
        Toto toto = new Toto();
        toto.setName("toto");
        persister.persist((Object)toto);
        Toto select = (Toto)persister.select(toto.getId());
        Assertions.assertThat((String)select.getName()).isEqualTo("TOTO");
        toto.setName("titi");
        persister.update((Object)toto, (Object)select, true);
        select = (Toto)persister.select(toto.getId());
        Assertions.assertThat((String)select.getName()).isEqualTo("TITI");
        Assertions.assertThat((List)persistenceContext.select(SerializableFunction.identity(), name)).containsExactly(new Object[]{"TITI"});
    }

    @Test
    void map_withSqlBinder_binderIsUsed_readCase() {
        Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
        PersistenceContext persistenceContext = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), dialect);
        Table totoTable = new Table("Toto");
        Column id = totoTable.addColumn("id", UUID_TYPE).primaryKey();
        Column name = totoTable.addColumn("name", String.class);
        dialect.getColumnBinderRegistry().register(id, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
        dialect.getSqlTypeRegistry().put(id, "varchar(255)");
        ConfiguredPersister persister = (ConfiguredPersister)MappingEase.entityBuilder(Toto.class, UUID_TYPE).onTable(totoTable).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).sqlBinder((ParameterBinder)new NullAwareParameterBinder((ResultSetReader)new ResultSetReader.LambdaResultSetReader((resultSet, columnName) -> resultSet.getString((String)columnName).toUpperCase(), String.class), (PreparedStatementWriter)DefaultParameterBinders.STRING_BINDER)).build(persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
        ddlDeployer.deployDDL();
        Toto toto = new Toto();
        toto.setName("toto");
        persister.persist((Object)toto);
        Toto select = (Toto)persister.select(toto.getId());
        Assertions.assertThat((String)select.getName()).isEqualTo("TOTO");
    }

    @Test
    void map_withSqlBinder_binderIsUsed_writeCase() {
        Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
        PersistenceContext persistenceContext = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), dialect);
        dialect.getSqlTypeRegistry().getJavaTypeToSqlTypeMapping().put(Set.class, "varchar(255)");
        Table totoTable = new Table("Toto");
        Column id = totoTable.addColumn("id", UUID_TYPE).primaryKey();
        dialect.getColumnBinderRegistry().register(id, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
        dialect.getSqlTypeRegistry().put(id, "varchar(255)");
        ConfiguredPersister persister = (ConfiguredPersister)MappingEase.entityBuilder(Toto.class, UUID_TYPE).onTable(totoTable).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getPossibleStates).sqlBinder((ParameterBinder)new NullAwareParameterBinder(DefaultParameterBinders.STRING_BINDER.thenApply((SerializableThrowingFunction & Serializable)setAsString -> {
            String[] databaseValue = setAsString.substring(1, setAsString.length() - 1).split(", ");
            return EnumSet.copyOf(Stream.of(databaseValue).map(State::valueOf).collect(Collectors.toSet()));
        }), DefaultParameterBinders.STRING_BINDER.preApply(Object::toString))).build(persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
        ddlDeployer.deployDDL();
        Toto toto = new Toto();
        toto.setPossibleStates(EnumSet.of(State.DONE, State.IN_PROGRESS));
        persister.insert((Object)toto);
        Toto select = (Toto)persister.select(toto.getId());
        Assertions.assertThat(select.getPossibleStates()).isEqualTo((Object)Arrays.asSet((Object[])new State[]{State.DONE, State.IN_PROGRESS}));
    }

    @Test
    void map_withSqlBinderOnEmbeddedProperty_binderIsUsed_writeCase() {
        Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
        PersistenceContext persistenceContext = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), dialect);
        dialect.getSqlTypeRegistry().getJavaTypeToSqlTypeMapping().put(Set.class, "varchar(255)");
        Table totoTable = new Table("Toto");
        Column id = totoTable.addColumn("id", UUID_TYPE).primaryKey();
        Column creationDate = totoTable.addColumn("creationDate", String.class);
        dialect.getColumnBinderRegistry().register(id, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
        dialect.getSqlTypeRegistry().put(id, "varchar(255)");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ConfiguredPersister persister = (ConfiguredPersister)MappingEase.entityBuilder(Toto.class, UUID_TYPE).onTable(totoTable).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).embed(Toto::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).sqlBinder((ParameterBinder)new NullAwareParameterBinder(DefaultParameterBinders.STRING_BINDER.thenApply(sdf::parse), DefaultParameterBinders.STRING_BINDER.preApply(sdf::format))).map(Timestamp::getModificationDate)).build(persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
        ddlDeployer.deployDDL();
        Toto toto = new Toto();
        toto.setPossibleStates(EnumSet.of(State.DONE, State.IN_PROGRESS));
        Timestamp timestamp = new Timestamp();
        toto.setTimestamp(timestamp);
        persister.insert((Object)toto);
        Toto select = (Toto)persister.select(toto.getId());
        Date toDayAsDate = Date.from(Dates.today().atStartOfDay(ZoneId.systemDefault()).toInstant());
        Timestamp expected = new Timestamp(toDayAsDate, timestamp.getModificationDate());
        Assertions.assertThat((Object)select.getTimestamp()).isEqualTo((Object)expected);
    }

    @Test
    void map_definedAsIdentifier_identifierIsStoredAsString() {
        Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
        PersistenceContext persistenceContext = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), dialect);
        Table totoTable = new Table("Toto");
        Column id = totoTable.addColumn("id", UUID_TYPE).primaryKey();
        Column name = totoTable.addColumn("name", String.class);
        dialect.getColumnBinderRegistry().register(id, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
        dialect.getSqlTypeRegistry().put(id, "varchar(255)");
        EntityPersister persister = MappingEase.entityBuilder(Toto.class, UUID_TYPE).onTable(totoTable).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).build(persistenceContext);
        Assertions.assertThat((boolean)totoTable.getColumn("id").isPrimaryKey()).isTrue();
        DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
        ddlDeployer.deployDDL();
        Toto toto = new Toto();
        toto.setName("toto");
        persister.persist((Object)toto);
        List select = persistenceContext.select(Duo::new, id, name);
        Assertions.assertThat((int)select.size()).isEqualTo(1);
        Assertions.assertThat((String)((Identifier)((Duo)Iterables.first((List)select)).getLeft()).getDelegate().toString()).isEqualTo(((UUID)toto.getId().getDelegate()).toString());
    }

    @Test
    void map_mappingDefinedTwiceByMethod_throwsException() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MappingEase.entityBuilder(Toto.class, UUID_TYPE).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).map(Toto::setName).build(this.persistenceContext)).isInstanceOf(MappingConfigurationException.class)).hasMessage("Mapping is already defined by method Toto::getName");
    }

    @Test
    void map_mappingDefinedTwiceByColumn_throwsException() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MappingEase.entityBuilder(Toto.class, UUID_TYPE).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).columnName("xyz").map(Toto::getFirstName).columnName("xyz").build(this.persistenceContext)).isInstanceOf(MappingConfigurationException.class)).hasMessage("Column 'xyz' of mapping 'Toto::getName' is already targeted by 'Toto::getFirstName'");
    }

    @Test
    void map_methodHasNoMatchingField_configurationIsStillValid() {
        Table toto = new Table("Toto");
        MappingEase.entityBuilder(Toto.class, UUID_TYPE).onTable(toto).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getNoMatchingField).build(this.persistenceContext);
        Column columnForProperty = (Column)toto.mapColumnsOnName().get("noMatchingField");
        Assertions.assertThat((Object)columnForProperty).isNotNull();
        Assertions.assertThat((Class)columnForProperty.getJavaType()).isEqualTo(Long.class);
    }

    @Test
    void map_methodIsASetter_configurationIsStillValid() {
        Table toto = new Table("Toto");
        MappingEase.entityBuilder(Toto.class, UUID_TYPE).onTable(toto).mapKey(Toto::setId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).build(this.persistenceContext);
        Column columnForProperty = (Column)toto.mapColumnsOnName().get("id");
        Assertions.assertThat((Object)columnForProperty).isNotNull();
        Assertions.assertThat((Class)columnForProperty.getJavaType()).isEqualTo(UUID_TYPE);
    }

    @Test
    void withTableNaming() {
        EntityPersister persister = MappingEase.entityBuilder(Toto.class, UUID_TYPE).mapKey(Toto::setId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).withTableNaming(persistedClass -> "tata").build(this.persistenceContext);
        Assertions.assertThat(((ConfiguredPersister)persister).giveImpliedTables().stream().map(Table::getName).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"tata"});
    }

    @Test
    void withIndexNaming() {
        EntityPersister persister = MappingEase.entityBuilder(Toto.class, UUID_TYPE).mapKey(Toto::setId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).unique().withIndexNaming((accessor, columnName) -> "myIndex").build(this.persistenceContext);
        Assertions.assertThat(((ConfiguredPersister)persister).giveImpliedTables().stream().flatMap(table -> table.getIndexes().stream()).map(Index::getName).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"myIndex"});
    }

    @Test
    void withIndexNaming_isAppliedToEmbedded() {
        EntityPersister persister = MappingEase.entityBuilder(Toto.class, UUID_TYPE).mapKey(Toto::setId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).embed(Toto::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate).unique()).withIndexNaming((accessor, columnName) -> "myIndex").build(this.persistenceContext);
        Assertions.assertThat(((ConfiguredPersister)persister).giveImpliedTables().stream().flatMap(table -> table.getIndexes().stream()).map(Index::getName).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"myIndex"});
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        Assertions.assertThat((List)ddlDeployer.getCreationScripts()).contains((Object[])new String[]{"create unique index myIndex on Toto(modificationDate)"});
    }

    @Test
    void withIndexNaming_onEmbedded() {
        EntityPersister persister = MappingEase.entityBuilder(Toto.class, UUID_TYPE).mapKey(Toto::setId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).embed(Toto::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).withIndexNaming((accessor, columnName) -> "myIndex").map(Timestamp::getCreationDate).map(Timestamp::getModificationDate).unique()).build(this.persistenceContext);
        Assertions.assertThat(((ConfiguredPersister)persister).giveImpliedTables().stream().flatMap(table -> table.getIndexes().stream()).map(Index::getName).collect(Collectors.toList())).containsExactlyInAnyOrder((Object[])new String[]{"myIndex"});
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        Assertions.assertThat((List)ddlDeployer.getCreationScripts()).contains((Object[])new String[]{"create unique index myIndex on Toto(modificationDate)"});
    }

    @Test
    void embed_definedByGetter() {
        Table toto = new Table("Toto");
        MappingEase.entityBuilder(Toto.class, UUID_TYPE).onTable(toto).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).embed(Toto::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)).build(new PersistenceContext((ConnectionProvider)Mockito.mock(ConnectionProvider.class), this.dialect));
        Column columnForProperty = (Column)toto.mapColumnsOnName().get("creationDate");
        Assertions.assertThat((Object)columnForProperty).isNotNull();
        Assertions.assertThat((Class)columnForProperty.getJavaType()).isEqualTo(Date.class);
    }

    @Test
    void embed_definedBySetter() {
        Table toto = new Table("Toto");
        MappingEase.entityBuilder(Toto.class, UUID_TYPE).onTable(toto).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).embed(Toto::setTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)).build(new PersistenceContext((ConnectionProvider)Mockito.mock(ConnectionProvider.class), this.dialect));
        Column columnForProperty = (Column)toto.mapColumnsOnName().get("creationDate");
        Assertions.assertThat((Object)columnForProperty).isNotNull();
        Assertions.assertThat((Class)columnForProperty.getJavaType()).isEqualTo(Date.class);
    }

    @Test
    void embed_withReadonlyProperty() {
        Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
        dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
        dialect.getSqlTypeRegistry().put(Identifier.class, "varchar(36)");
        PersistenceContext persistenceContext = new PersistenceContext(this.dataSource, dialect);
        EntityPersister persister = MappingEase.entityBuilder(Toto.class, UUID_TYPE).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).embed(Toto::setTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate).map(Timestamp::getReadonlyProperty).readonly()).build(persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
        ddlDeployer.deployDDL();
        Toto toto = new Toto(new PersistedIdentifier<UUID>(UUID.randomUUID()));
        Timestamp timestamp = new Timestamp();
        timestamp.setReadonlyProperty("dummy value");
        toto.setTimestamp(timestamp);
        persister.insert((Object)toto);
        String readonlyProperty = (String)persistenceContext.newQuery((CharSequence)"select readonlyProperty from Toto", String.class).mapKey("readonlyProperty", String.class).execute(Accumulators.getFirst());
        Assertions.assertThat((String)readonlyProperty).isNull();
    }

    @Test
    void embed_withOverriddenColumnName() {
        Table toto = new Table("Toto");
        MappingEase.entityBuilder(Toto.class, UUID_TYPE).onTable(toto).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).embed(Toto::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)).overrideName(Timestamp::getCreationDate, "createdAt").overrideName(Timestamp::getModificationDate, "modifiedAt").overrideSize(Timestamp::getCreationDate, (Size)Size.length((int)42)).overrideSize(Timestamp::getModificationDate, (Size)Size.length((int)42)).build(new PersistenceContext((ConnectionProvider)Mockito.mock(ConnectionProvider.class), this.dialect));
        Map columnsByName = toto.mapColumnsOnName();
        Assertions.assertThat(columnsByName.get("creationDate")).isNull();
        Assertions.assertThat(columnsByName.get("modificationDate")).isNull();
        Column overriddenColumn = (Column)columnsByName.get("modifiedAt");
        Assertions.assertThat((Object)overriddenColumn).isNotNull();
        Assertions.assertThat((Class)overriddenColumn.getJavaType()).isEqualTo(Date.class);
        overriddenColumn = (Column)columnsByName.get("createdAt");
        Assertions.assertThat((Object)overriddenColumn).isNotNull();
        Assertions.assertThat((Class)overriddenColumn.getJavaType()).isEqualTo(Date.class);
    }

    @Test
    void embed_withOverriddenColumnName_nameAlreadyExists_throwsException() {
        Table totoTable = new Table("Toto");
        Column idColumn = totoTable.addColumn("id", UUID_TYPE);
        this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
        this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> MappingEase.entityBuilder(Toto.class, UUID_TYPE).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).embed(Toto::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)).overrideName(Timestamp::getCreationDate, "modificationDate").build(this.persistenceContext)).isInstanceOf(MappingConfigurationException.class)).hasMessage("Column 'modificationDate' of mapping 'Timestamp::getCreationDate' is already targeted by 'Timestamp::getModificationDate'");
    }

    @Test
    void embed_withOverriddenColumn() {
        Table targetTable = new Table("Toto");
        Column createdAt = targetTable.addColumn("createdAt", Date.class);
        Column modifiedAt = targetTable.addColumn("modifiedAt", Date.class);
        Connection connectionMock = (Connection)InvocationHandlerSupport.mock(Connection.class, (Class[])new Class[0]);
        ConfiguredPersister persister = (ConfiguredPersister)MappingEase.entityBuilder(Toto.class, UUID_TYPE).onTable(targetTable).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).embed(Toto::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)).override(Timestamp::getCreationDate, createdAt).override(Timestamp::getModificationDate, modifiedAt).build(new PersistenceContext((ConnectionProvider)new SimpleConnectionProvider(connectionMock), this.dialect));
        Map columnsByName = targetTable.mapColumnsOnName();
        Assertions.assertThat(columnsByName.get("creationDate")).isNull();
        Assertions.assertThat(columnsByName.get("modificationDate")).isNull();
        Assertions.assertThat((Collection)persister.getMapping().getInsertableColumns()).isEqualTo((Object)targetTable.getColumns());
        Assertions.assertThat((Collection)persister.getMapping().getUpdatableColumns()).isEqualTo((Object)targetTable.getColumnsNoPrimaryKey());
        Assertions.assertThat((Collection)persister.getMapping().getSelectableColumns()).isEqualTo((Object)targetTable.getColumns());
    }

    @Test
    void embed_withSomeExcludedProperty() {
        Table targetTable = new Table("Toto");
        Column modifiedAt = targetTable.addColumn("modifiedAt", Date.class);
        Connection connectionMock = (Connection)InvocationHandlerSupport.mock(Connection.class, (Class[])new Class[0]);
        ConfiguredPersister persister = (ConfiguredPersister)MappingEase.entityBuilder(Toto.class, UUID_TYPE).onTable(targetTable).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).embed(Toto::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)).exclude(Timestamp::getCreationDate).override(Timestamp::getModificationDate, modifiedAt).build(new PersistenceContext((ConnectionProvider)new SimpleConnectionProvider(connectionMock), this.dialect));
        Map columnsByName = targetTable.mapColumnsOnName();
        Assertions.assertThat(columnsByName.get("creationDate")).isNull();
        Assertions.assertThat(columnsByName.get("modificationDate")).isNull();
        Assertions.assertThat((Collection)persister.getMapping().getInsertableColumns()).isEqualTo((Object)targetTable.getColumns());
        Assertions.assertThat((Collection)persister.getMapping().getUpdatableColumns()).isEqualTo((Object)targetTable.getColumnsNoPrimaryKey());
        Assertions.assertThat((Collection)persister.getMapping().getSelectableColumns()).isEqualTo((Object)targetTable.getColumns());
    }

    @Test
    void innerEmbed_withConflictingEmbeddable() throws SQLException {
        Table countryTable = new Table("countryTable");
        FluentEntityMappingBuilder.FluentMappingBuilderEmbeddableMappingConfigurationImportedEmbedOptions mappingBuilder = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).onTable(countryTable).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).embed(Country::getPresident, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Person.class).map(Person::getName).map(Person::getVersion).embed(Person::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)).exclude(Timestamp::getCreationDate).overrideName(Timestamp::getModificationDate, "presidentElectedAt")).exclude(Person::getVersion).overrideName(Person::getName, "presidentName").embed(Country::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)).exclude(Timestamp::getModificationDate).overrideName(Timestamp::getCreationDate, "countryCreatedAt");
        mappingBuilder.build(this.persistenceContext);
        Assertions.assertThat((Collection)countryTable.getColumns()).extracting(Column::getName).containsExactlyInAnyOrder((Object[])new String[]{"id", "name", "presidentName", "presidentElectedAt", "countryCreatedAt"});
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        DefaultDialect dialect = new DefaultDialect();
        dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        dialect.getDmlGenerator().sortColumnsAlphabetically();
        ConfiguredPersister persister = (ConfiguredPersister)mappingBuilder.build(new PersistenceContext((ConnectionProvider)new SimpleConnectionProvider(connectionMock), (Dialect)dialect));
        Map columnsByName = countryTable.mapColumnsOnName();
        Assertions.assertThat(columnsByName.get("creationDate")).isNull();
        Assertions.assertThat(columnsByName.get("modificationDate")).isNull();
        Assertions.assertThat((Collection)persister.getMapping().getInsertableColumns()).isEqualTo((Object)countryTable.getColumns());
        Assertions.assertThat((Collection)persister.getMapping().getUpdatableColumns()).isEqualTo((Object)countryTable.getColumnsNoPrimaryKey());
        Assertions.assertThat((Collection)persister.getMapping().getSelectableColumns()).isEqualTo((Object)countryTable.getColumns());
        Country country = new Country(new PersistableIdentifier<Long>(1L));
        country.setName("France");
        Timestamp countryTimestamp = new Timestamp();
        LocalDateTime localDateTime = LocalDate.of(2018, 1, 1).atStartOfDay();
        Date countryCreationDate = Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
        countryTimestamp.setCreationDate(countryCreationDate);
        country.setTimestamp(countryTimestamp);
        Person president = new Person();
        president.setName("Fran\u00e7ois");
        Timestamp presidentTimestamp = new Timestamp();
        Date presidentElection = Date.from(LocalDate.of(2019, 1, 1).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        presidentTimestamp.setModificationDate(presidentElection);
        president.setTimestamp(presidentTimestamp);
        country.setPresident(president);
        PreparedStatement statementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)statementMock.executeLargeBatch()).thenReturn((Object)new long[]{1L});
        final HashMap capturedValues = new HashMap();
        Mockito.when((Object)connectionMock.prepareStatement(ArgumentMatchers.anyString(), ArgumentMatchers.eq((int)1))).thenReturn((Object)statementMock);
        final StringBuilder capturedSQL = new StringBuilder();
        ((SimpleRelationalEntityPersister)((PersisterWrapper)persister).getDeepestDelegate()).getInsertExecutor().setOperationListener((SQLOperation.SQLOperationListener)new SQLOperation.SQLOperationListener<Column<Table, Object>>(){

            public void onValuesSet(Map<Column<Table, Object>, ?> values) {
                capturedValues.putAll(values);
            }

            public void onExecute(SQLStatement<Column<Table, Object>> sqlStatement) {
                capturedSQL.append(sqlStatement.getSQL());
            }
        });
        persister.insert((Object)country);
        Assertions.assertThat((String)capturedSQL.toString()).isEqualTo("insert into countryTable(countryCreatedAt, id, name, presidentElectedAt, presidentName) values (?, ?, ?, ?, ?)");
        Assertions.assertThat(capturedValues).isEqualTo((Object)Maps.forHashMap(Column.class, Object.class).add(columnsByName.get("presidentName"), (Object)country.getPresident().getName()).add(columnsByName.get("presidentElectedAt"), (Object)country.getPresident().getTimestamp().getModificationDate()).add(columnsByName.get("name"), (Object)country.getName()).add(columnsByName.get("countryCreatedAt"), (Object)country.getTimestamp().getCreationDate()).add(columnsByName.get("id"), country.getId()));
    }

    @Test
    void innerEmbed_withSomeExcludedProperties() throws SQLException {
        Table countryTable = new Table("countryTable");
        FluentEntityMappingBuilder.FluentMappingBuilderEmbeddableMappingConfigurationImportedEmbedOptions mappingBuilder = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).onTable(countryTable).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).embed(Country::getPresident, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Person.class).map(Person::getName).map(Person::getVersion).embed(Person::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)).exclude(Timestamp::getCreationDate).overrideName(Timestamp::getModificationDate, "presidentElectedAt")).exclude(Person::getVersion).overrideName(Person::getName, "presidentName");
        mappingBuilder.build(this.persistenceContext);
        Assertions.assertThat((Collection)countryTable.getColumns()).extracting(Column::getName).containsExactlyInAnyOrder((Object[])new String[]{"id", "name", "presidentName", "presidentElectedAt"});
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        DefaultDialect dialect = new DefaultDialect();
        dialect.getColumnBinderRegistry().register(UUID_TYPE, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        dialect.getDmlGenerator().sortColumnsAlphabetically();
        ConfiguredPersister persister = (ConfiguredPersister)mappingBuilder.build(new PersistenceContext((ConnectionProvider)new SimpleConnectionProvider(connectionMock), (Dialect)dialect));
        Map columnsByName = countryTable.mapColumnsOnName();
        Assertions.assertThat(columnsByName.get("creationDate")).isNull();
        Assertions.assertThat(columnsByName.get("modificationDate")).isNull();
        Assertions.assertThat((Collection)persister.getMapping().getInsertableColumns()).isEqualTo((Object)countryTable.getColumns());
        Assertions.assertThat((Collection)persister.getMapping().getUpdatableColumns()).isEqualTo((Object)countryTable.getColumnsNoPrimaryKey());
        Assertions.assertThat((Collection)persister.getMapping().getSelectableColumns()).isEqualTo((Object)countryTable.getColumns());
        Country country = new Country(new PersistableIdentifier<Long>(1L));
        country.setName("France");
        Person president = new Person();
        president.setName("Fran\u00e7ois");
        Timestamp presidentTimestamp = new Timestamp();
        Date presidentElection = Date.from(LocalDate.of(2019, 1, 1).atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        presidentTimestamp.setModificationDate(presidentElection);
        president.setTimestamp(presidentTimestamp);
        country.setPresident(president);
        PreparedStatement statementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)statementMock.executeLargeBatch()).thenReturn((Object)new long[]{1L});
        final HashMap capturedValues = new HashMap();
        Mockito.when((Object)connectionMock.prepareStatement(ArgumentMatchers.anyString(), ArgumentMatchers.eq((int)1))).thenReturn((Object)statementMock);
        final StringBuilder capturedSQL = new StringBuilder();
        ((SimpleRelationalEntityPersister)((PersisterWrapper)persister).getDeepestDelegate()).getInsertExecutor().setOperationListener((SQLOperation.SQLOperationListener)new SQLOperation.SQLOperationListener<Column<Table, Object>>(){

            public void onValuesSet(Map<Column<Table, Object>, ?> values) {
                capturedValues.putAll(values);
            }

            public void onExecute(SQLStatement<Column<Table, Object>> sqlStatement) {
                capturedSQL.append(sqlStatement.getSQL());
            }
        });
        persister.insert((Object)country);
        Assertions.assertThat((String)capturedSQL.toString()).isEqualTo("insert into countryTable(id, name, presidentElectedAt, presidentName) values (?, ?, ?, ?)");
        Assertions.assertThat(capturedValues).isEqualTo((Object)Maps.forHashMap(Column.class, Object.class).add(columnsByName.get("presidentName"), (Object)country.getPresident().getName()).add(columnsByName.get("presidentElectedAt"), (Object)country.getPresident().getTimestamp().getModificationDate()).add(columnsByName.get("name"), (Object)country.getName()).add(columnsByName.get("id"), country.getId()));
    }

    @Test
    void innerEmbed_withTwiceSameInnerEmbeddableName() {
        Table countryTable = new Table("countryTable");
        FluentEntityMappingBuilder.FluentMappingBuilderEmbeddableMappingConfigurationImportedEmbedOptions mappingBuilder = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).onTable(countryTable).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).embed(Country::getPresident, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Person.class).map(Person::getId).map(Person::getName).map(Person::getVersion).embed(Person::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate))).overrideName(Person::getId, "presidentId").overrideName(Person::getName, "presidentName").embed(Country::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> mappingBuilder.build(this.persistenceContext)).isInstanceOf(MappingConfigurationException.class)).hasMessage("Person::getTimestamp conflicts with Country::getTimestamp while embedding a o.c.s.e.m.Timestamp, column names should be overridden : Timestamp::getModificationDate, Timestamp::getCreationDate");
        mappingBuilder.overrideName(Timestamp::getModificationDate, "modifiedAt");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> mappingBuilder.build(this.persistenceContext)).isInstanceOf(MappingConfigurationException.class)).hasMessage("Person::getTimestamp conflicts with Country::getTimestamp while embedding a o.c.s.e.m.Timestamp, column names should be overridden : Timestamp::getCreationDate");
        mappingBuilder.overrideName(Timestamp::getCreationDate, "createdAt");
        mappingBuilder.build(this.persistenceContext);
        Assertions.assertThat((Collection)countryTable.getColumns()).extracting(Column::getName).containsExactlyInAnyOrder((Object[])new String[]{"id", "name", "presidentId", "version", "presidentName", "creationDate", "modificationDate", "createdAt", "modifiedAt"});
    }

    @Test
    void insert() {
        ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(PersonWithGender.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapEnum(PersonWithGender::getGender).build(this.persistenceContext);
        Column gender = (Column)personPersister.getMapping().getTargetTable().mapColumnsOnName().get("gender");
        this.dialect.getSqlTypeRegistry().put(gender, "VARCHAR(255)");
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        PersonWithGender person = new PersonWithGender(new PersistableIdentifier<Long>(1L));
        person.setName(null);
        person.setGender(Gender.FEMALE);
        personPersister.insert((Object)person);
        PersonWithGender loadedPerson = (PersonWithGender)personPersister.select(person.getId());
        Assertions.assertThat((Comparable)((Object)loadedPerson.getGender())).isEqualTo((Object)Gender.FEMALE);
    }

    @Test
    void insert_nullValues() {
        ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(PersonWithGender.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapEnum(PersonWithGender::getGender).build(this.persistenceContext);
        Column gender = (Column)personPersister.getMapping().getTargetTable().mapColumnsOnName().get("gender");
        this.dialect.getSqlTypeRegistry().put(gender, "VARCHAR(255)");
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        PersonWithGender person = new PersonWithGender(new PersistableIdentifier<Long>(1L));
        person.setName(null);
        person.setGender(null);
        personPersister.insert((Object)person);
        PersonWithGender loadedPerson = (PersonWithGender)personPersister.select(person.getId());
        Assertions.assertThat((Comparable)((Object)loadedPerson.getGender())).isEqualTo(null);
    }

    @Test
    void update_nullValues() {
        ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(PersonWithGender.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapEnum(PersonWithGender::getGender).build(this.persistenceContext);
        Column gender = (Column)personPersister.getMapping().getTargetTable().mapColumnsOnName().get("gender");
        this.dialect.getSqlTypeRegistry().put(gender, "VARCHAR(255)");
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        PersonWithGender person = new PersonWithGender(new PersistableIdentifier<Long>(1L));
        person.setName("toto");
        person.setGender(Gender.MALE);
        personPersister.insert((Object)person);
        PersonWithGender updatedPerson = new PersonWithGender(person.getId());
        personPersister.update((Object)updatedPerson, (Object)person, true);
        PersonWithGender loadedPerson = (PersonWithGender)personPersister.select(person.getId());
        Assertions.assertThat((Comparable)((Object)loadedPerson.getGender())).isEqualTo(null);
    }

    @Test
    void apiUsage() {
        FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderPropertyOptions personMappingBuilder2;
        try {
            MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).embed(Country::getPresident, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Person.class).map(Person::getName)).overrideName(Person::getId, "personId").overrideName(Person::getName, "personName").embed(Country::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)).map(Country::getId).map(Country::setDescription).columnName("zxx").fieldName("tutu").mapSuperClass(() -> new FluentEmbeddableMappingConfigurationSupport(Country.class)).build(this.persistenceContext);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).embed(Country::getPresident, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Person.class).map(Person::getName)).embed(Country::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)).map(Country::getId).columnName("zz").mapOneToOne(Country::getPresident, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Person.class, Long.TYPE)).mapSuperClass(() -> new FluentEmbeddableMappingConfigurationSupport(Country.class)).map(Country::getDescription).columnName("xx").build(this.persistenceContext);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            MappingEase.entityBuilder(Country.class, Long.TYPE).map(Country::getName).map(Country::getId).columnName("zz").mapSuperClass(() -> new FluentEmbeddableMappingConfigurationSupport(Country.class)).embed(Country::setPresident, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Person.class).map(Person::getName)).embed(Country::setTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Long.TYPE)).mappedBy(City::getAbstractCountry).map(Country::getDescription).columnName("xx").map(AbstractCountry::getDummyProperty).columnName("dd").build(this.persistenceContext);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        try {
            personMappingBuilder2 = MappingEase.embeddableBuilder(Person.class).map(Person::getName);
            MappingEase.entityBuilder(Country.class, Long.TYPE).map(Country::getName).map(Country::getId).columnName("zz").mapOneToOne(Country::setPresident, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Person.class, Long.TYPE)).mapSuperClass((EmbeddableMappingConfigurationProvider)new FluentEmbeddableMappingConfigurationSupport(Country.class)).embed(Country::getPresident, (EmbeddableMappingConfigurationProvider)personMappingBuilder2).build(this.persistenceContext);
        }
        catch (RuntimeException personMappingBuilder2) {
            // empty catch block
        }
        try {
            personMappingBuilder2 = MappingEase.embeddableBuilder(Person.class).map(Person::getName);
            MappingEase.entityBuilder(Country.class, Long.TYPE).map(Country::getName).map(Country::getId).columnName("zz").embed(Country::getPresident, (EmbeddableMappingConfigurationProvider)personMappingBuilder2).mapSuperClass(() -> new FluentEmbeddableMappingConfigurationSupport(Country.class)).mapOneToOne(Country::setPresident, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Person.class, Long.TYPE)).embed(Country::getPresident, (EmbeddableMappingConfigurationProvider)personMappingBuilder2).overrideName(Person::getName, "toto").overrideName(Person::setName, "tata").build(this.persistenceContext);
        }
        catch (RuntimeException personMappingBuilder3) {
            // empty catch block
        }
        class PersonTable
        extends Table<PersonTable> {
            Column<PersonTable, Gender> gender;
            Column<PersonTable, String> name;

            PersonTable() {
                super("Person");
                this.gender = this.addColumn("gender", Gender.class);
                this.name = this.addColumn("name", String.class);
            }
        }
        PersonTable personTable = new PersonTable();
        try {
            MappingEase.entityBuilder(PersonWithGender.class, Long.TYPE).onTable(new Table("person")).map(Person::getName).map(Person::getName).column(personTable.name).mapEnum(PersonWithGender::getGender).byOrdinal().embed(Person::setTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)).overrideName(Timestamp::getCreationDate, "myDate").mapEnum(PersonWithGender::getGender).columnName("MM").byOrdinal().mapEnum(PersonWithGender::getGender).column(personTable.gender).byOrdinal().map(Person::getId).columnName("zz").mapEnum(PersonWithGender::setGender).byName().embed(Person::getTimestamp, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate)).mapEnum(PersonWithGender::setGender).columnName("MM").byName().build(this.persistenceContext);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private /* synthetic */ void lambda$build_identifierIsNotDefined_throwsException$0(FluentEntityMappingBuilder mappingStrategy) throws Throwable {
        mappingStrategy.build(this.persistenceContext);
    }

    static class TimestampWithLocale
    extends Timestamp {
        private Locale locale;

        TimestampWithLocale() {
            this(null, null, null);
        }

        public TimestampWithLocale(Date creationDate, Date modificationDate, Locale locale) {
            super(creationDate, modificationDate);
            this.locale = locale;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public TimestampWithLocale setLocale(Locale locale) {
            this.locale = locale;
            return this;
        }
    }

    static enum State {
        TODO,
        IN_PROGRESS,
        DONE;

    }

    protected static class Toto
    extends AbstractToto {
        private Identifier<UUID> identifier;
        private String name;
        private String firstName;
        private Timestamp timestamp;
        private Set<State> possibleStates = new HashSet<State>();
        private Set<Timestamp> times = new HashSet<Timestamp>();
        private boolean setIdWasCalled;
        private boolean constructorWithIdWasCalled;
        private boolean constructorWith2ArgsWasCalled;

        public static Toto newInstance() {
            Toto newInstance = new Toto();
            newInstance.firstName = "set by static factory";
            return newInstance;
        }

        public Toto() {
        }

        public Toto(PersistedIdentifier<UUID> id) {
            super(id);
            this.constructorWithIdWasCalled = true;
        }

        public Toto(PersistedIdentifier<UUID> id, String name) {
            super(id);
            this.name = name + " by constructor";
            this.constructorWith2ArgsWasCalled = true;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        public Identifier<UUID> getIdentifier() {
            return this.identifier;
        }

        public void setIdentifier(Identifier<UUID> id) {
            this.identifier = id;
        }

        public Long getNoMatchingField() {
            return null;
        }

        public void setNoMatchingField(Long s) {
        }

        public long getNoMatchingFieldPrimitive() {
            return 0L;
        }

        public void setNoMatchingFieldPrimitive(long s) {
        }

        @Override
        public Identifier<UUID> getId() {
            return this.id;
        }

        public void setId(Identifier<UUID> id) {
            this.setIdWasCalled = true;
        }

        public boolean isSetIdWasCalled() {
            return this.setIdWasCalled;
        }

        public boolean isConstructorWithIdWasCalled() {
            return this.constructorWithIdWasCalled;
        }

        public boolean isConstructorWith2ArgsWasCalled() {
            return this.constructorWith2ArgsWasCalled;
        }

        public Timestamp getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(Timestamp timestamp) {
            this.timestamp = timestamp;
        }

        public Set<State> getPossibleStates() {
            return this.possibleStates;
        }

        public void setPossibleStates(Set<State> possibleStates) {
            this.possibleStates = possibleStates;
        }

        public Set<Timestamp> getTimes() {
            return this.times;
        }

        public void setTimes(Set<Timestamp> times) {
            this.times = times;
        }
    }

    protected static abstract class AbstractToto
    implements Identified<UUID> {
        protected final Identifier<UUID> id;
        private String prop1;

        public AbstractToto() {
            this.id = new PersistableIdentifier<UUID>(UUID.randomUUID());
        }

        public AbstractToto(PersistedIdentifier<UUID> id) {
            this.id = id;
        }

        @Override
        public Identifier<UUID> getId() {
            return this.id;
        }

        public String getProp1() {
            return this.prop1;
        }

        public void setProp1(String prop1) {
            this.prop1 = prop1;
        }
    }

    @Nested
    class MapEnum {
        MapEnum() {
        }

        @Test
        void byDefault_ordinalIsUsed() {
            ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(PersonWithGender.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapEnum(PersonWithGender::getGender).build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            Column gender = (Column)personPersister.getMapping().getTargetTable().mapColumnsOnName().get("gender");
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(gender, "VARCHAR(255)");
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            PersonWithGender person = new PersonWithGender(new PersistableIdentifier<Long>(1L));
            person.setName("toto");
            person.setGender(Gender.FEMALE);
            personPersister.insert((Object)person);
            PersistenceContext.ExecutableBeanPropertyQueryMapper integerExecutableQuery = FluentEntityMappingConfigurationSupportTest.this.persistenceContext.newQuery((CharSequence)"select * from PersonWithGender", Integer.class).mapKey(Integer::new, "gender", Integer.class);
            Set result = (Set)integerExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)result).containsExactly((Object[])new Integer[]{1});
        }

        @Test
        void mandatory_onMissingValue_throwsException() {
            ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(PersonWithGender.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapEnum(PersonWithGender::getGender).mandatory().build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            Column gender = (Column)personPersister.getMapping().getTargetTable().mapColumnsOnName().get("gender");
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(gender, "VARCHAR(255)");
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            PersonWithGender person = new PersonWithGender(new PersistableIdentifier<Long>(1L));
            person.setName("toto");
            person.setGender(null);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> personPersister.insert((Object)person)).isInstanceOf(RuntimeException.class)).hasMessage("Error while inserting values for " + person + " in statement \"insert into PersonWithGender(gender, id, name) values (?, ?, ?)\"").hasCause((Throwable)new SQLStatement.BindingException("Expected non null value for : PersonWithGender.gender"));
        }

        @Test
        void mandatory_columnConstraintIsAdded() {
            ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(PersonWithGender.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapEnum(PersonWithGender::getGender).mandatory().build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            Assertions.assertThat((boolean)personPersister.getMapping().getTargetTable().getColumn("gender").isNullable()).isFalse();
        }

        @Test
        void mappedByOrdinal() {
            ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(PersonWithGender.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapEnum(PersonWithGender::getGender).byOrdinal().build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            Column gender = (Column)personPersister.getMapping().getTargetTable().mapColumnsOnName().get("gender");
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(gender, "INT");
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            PersonWithGender person = new PersonWithGender(new PersistableIdentifier<Long>(1L));
            person.setName("toto");
            person.setGender(Gender.FEMALE);
            personPersister.insert((Object)person);
            PersistenceContext.ExecutableBeanPropertyQueryMapper integerExecutableQuery = FluentEntityMappingConfigurationSupportTest.this.persistenceContext.newQuery((CharSequence)"select * from PersonWithGender", Integer.class).mapKey(Integer::valueOf, "gender", String.class);
            Set result = (Set)integerExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)result).containsExactly((Object[])new Integer[]{person.getGender().ordinal()});
        }

        @Test
        void mappedByName() {
            ConfiguredPersister personPersister = (ConfiguredPersister)MappingEase.entityBuilder(PersonWithGender.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapEnum(PersonWithGender::getGender).byName().build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            PersonWithGender person = new PersonWithGender(new PersistableIdentifier<Long>(1L));
            person.setName("toto");
            person.setGender(Gender.FEMALE);
            personPersister.insert((Object)person);
            PersistenceContext.ExecutableBeanPropertyQueryMapper integerExecutableQuery = FluentEntityMappingConfigurationSupportTest.this.persistenceContext.newQuery((CharSequence)"select * from PersonWithGender", String.class).mapKey("gender", String.class);
            Set result = (Set)integerExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)result).containsExactly((Object[])new String[]{person.getGender().name()});
        }

        @Test
        void columnMappedByOrdinal() {
            Table personTable = new Table("PersonWithGender");
            Column genderColumn = personTable.addColumn("gender", Gender.class);
            EntityPersister personPersister = MappingEase.entityBuilder(PersonWithGender.class, Identifier.LONG_TYPE).mapKey(Person::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Person::getName).mapEnum(PersonWithGender::getGender).column(genderColumn).byOrdinal().build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(genderColumn, "INT");
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            PersonWithGender person = new PersonWithGender(new PersistableIdentifier<Long>(1L));
            person.setName("toto");
            person.setGender(Gender.FEMALE);
            personPersister.insert((Object)person);
            PersistenceContext.ExecutableBeanPropertyQueryMapper integerExecutableQuery = FluentEntityMappingConfigurationSupportTest.this.persistenceContext.newQuery((CharSequence)"select * from PersonWithGender", Integer.class).mapKey(Integer::valueOf, "gender", String.class);
            Set result = (Set)integerExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)result).containsExactly((Object[])new Integer[]{person.getGender().ordinal()});
        }
    }

    @Nested
    class EmbedWithExternalEmbeddedBean {
        EmbedWithExternalEmbeddedBean() {
        }

        @Test
        void simpleCase() {
            Table totoTable = new Table("Toto");
            Column idColumn = totoTable.addColumn("id", UUID_TYPE);
            Column creationDate = totoTable.addColumn("creationDate", Date.class);
            Column modificationDate = totoTable.addColumn("modificationDate", Date.class);
            FluentEntityMappingConfigurationSupportTest.this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
            FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderPropertyOptions timestampMapping = MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate);
            EntityPersister persister = MappingEase.entityBuilder(Toto.class, (Class)UUID_TYPE).onTable(totoTable).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).embed(Toto::getTimestamp, (EmbeddableMappingConfigurationProvider)timestampMapping).build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Toto toto = new Toto();
            toto.setTimestamp(new Timestamp(Dates.nowAsDate(), null));
            persister.insert((Object)toto);
            List select = FluentEntityMappingConfigurationSupportTest.this.persistenceContext.select(Timestamp::new, creationDate, modificationDate);
            Assertions.assertThat((Object)Iterables.first((List)select)).isEqualTo((Object)toto.getTimestamp());
            Toto loadedToto = (Toto)persister.select(toto.getId());
            Assertions.assertThat((Object)loadedToto.getTimestamp()).isEqualTo((Object)toto.getTimestamp());
        }

        @Test
        void embed_withMappedSuperClass() {
            Table totoTable = new Table("Toto");
            Column idColumn = totoTable.addColumn("id", UUID_TYPE);
            Column creationDate = totoTable.addColumn("creationDate", Date.class);
            Column modificationDate = totoTable.addColumn("modificationDate", Date.class);
            Column localeColumn = totoTable.addColumn("locale", Locale.class);
            FluentEntityMappingConfigurationSupportTest.this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
            FluentEntityMappingConfigurationSupportTest.this.dialect.getColumnBinderRegistry().register(Locale.class, (ParameterBinder)new NullAwareParameterBinder((ParameterBinder)new LambdaParameterBinder((ResultSetReader)new ResultSetReader.LambdaResultSetReader((resultSet, columnName) -> Locale.forLanguageTag(resultSet.getString((String)columnName)), Locale.class), (PreparedStatementWriter)new PreparedStatementWriter.LambdaPreparedStatementWriter((preparedStatement, valueIndex, value) -> preparedStatement.setString((int)valueIndex, value.toLanguageTag()), Locale.class))));
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(Locale.class, "VARCHAR(20)");
            FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderPropertyOptions timestampMapping = MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate);
            FluentEmbeddableMappingBuilder timestampWithLocaleMapping = MappingEase.embeddableBuilder(TimestampWithLocale.class).map(TimestampWithLocale::getLocale).mapSuperClass((EmbeddableMappingConfigurationProvider)timestampMapping);
            EntityPersister persister = MappingEase.entityBuilder(Toto.class, (Class)UUID_TYPE).onTable(totoTable).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).embed(Toto::getTimestamp, (EmbeddableMappingConfigurationProvider)timestampWithLocaleMapping).build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Toto toto = new Toto();
            toto.setTimestamp(new TimestampWithLocale(Dates.nowAsDate(), null, Locale.US));
            persister.insert((Object)toto);
            List select = FluentEntityMappingConfigurationSupportTest.this.persistenceContext.select(TimestampWithLocale::new, creationDate, modificationDate, localeColumn);
            Assertions.assertThat((Object)Iterables.first((List)select)).isEqualTo((Object)toto.getTimestamp());
            Toto loadedToto = (Toto)persister.select(toto.getId());
            Assertions.assertThat((Object)loadedToto.getTimestamp()).isEqualTo((Object)toto.getTimestamp());
        }

        @Test
        void embed_withMappedSuperClassAndOverride() {
            Table totoTable = new Table("Toto");
            Column idColumn = totoTable.addColumn("id", UUID_TYPE);
            Column creationDate = totoTable.addColumn("creationDate", Date.class);
            Column modificationDate = totoTable.addColumn("modificationTime", Date.class);
            Column localeColumn = totoTable.addColumn("locale", Locale.class);
            FluentEntityMappingConfigurationSupportTest.this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
            FluentEntityMappingConfigurationSupportTest.this.dialect.getColumnBinderRegistry().register(Locale.class, (ParameterBinder)new NullAwareParameterBinder((ParameterBinder)new LambdaParameterBinder((ResultSetReader)new ResultSetReader.LambdaResultSetReader((resultSet, columnName) -> Locale.forLanguageTag(resultSet.getString((String)columnName)), Locale.class), (PreparedStatementWriter)new PreparedStatementWriter.LambdaPreparedStatementWriter((preparedStatement, valueIndex, value) -> preparedStatement.setString((int)valueIndex, value.toLanguageTag()), Locale.class))));
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(Locale.class, "VARCHAR(20)");
            FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderPropertyOptions timestampMapping = MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate);
            FluentEmbeddableMappingBuilder timestampWithLocaleMapping = MappingEase.embeddableBuilder(TimestampWithLocale.class).map(TimestampWithLocale::getLocale).mapSuperClass((EmbeddableMappingConfigurationProvider)timestampMapping);
            EntityPersister persister = MappingEase.entityBuilder(Toto.class, (Class)UUID_TYPE).onTable(totoTable).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).embed(Toto::getTimestamp, (EmbeddableMappingConfigurationProvider)timestampWithLocaleMapping).override(Timestamp::getModificationDate, modificationDate).build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Toto toto = new Toto();
            toto.setTimestamp(new TimestampWithLocale(Dates.nowAsDate(), null, Locale.US));
            persister.insert((Object)toto);
            List select = FluentEntityMappingConfigurationSupportTest.this.persistenceContext.select(TimestampWithLocale::new, creationDate, modificationDate, localeColumn);
            Assertions.assertThat((Object)Iterables.first((List)select)).isEqualTo((Object)toto.getTimestamp());
            Toto loadedToto = (Toto)persister.select(toto.getId());
            Assertions.assertThat((Object)loadedToto.getTimestamp()).isEqualTo((Object)toto.getTimestamp());
        }

        @Test
        void overrideName() {
            Table totoTable = new Table("Toto");
            Column idColumn = totoTable.addColumn("id", UUID_TYPE);
            Column creationDate = totoTable.addColumn("createdAt", Date.class);
            Column modificationDate = totoTable.addColumn("modificationDate", Date.class);
            FluentEntityMappingConfigurationSupportTest.this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
            FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderPropertyOptions timestampMapping = MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate);
            EntityPersister persister = MappingEase.entityBuilder(Toto.class, (Class)UUID_TYPE).onTable(totoTable).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).embed(Toto::getTimestamp, (EmbeddableMappingConfigurationProvider)timestampMapping).overrideName(Timestamp::getCreationDate, "createdAt").build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            Map columnsByName = totoTable.mapColumnsOnName();
            Assertions.assertThat(columnsByName.get("creationDate")).isNull();
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Toto toto = new Toto();
            toto.setTimestamp(new Timestamp(Dates.nowAsDate(), null));
            persister.insert((Object)toto);
            List select = FluentEntityMappingConfigurationSupportTest.this.persistenceContext.select(Timestamp::new, creationDate, modificationDate);
            Assertions.assertThat((Object)Iterables.first((List)select)).isEqualTo((Object)toto.getTimestamp());
            Toto loadedToto = (Toto)persister.select(toto.getId());
            Assertions.assertThat((Object)loadedToto.getTimestamp()).isEqualTo((Object)toto.getTimestamp());
        }

        @Test
        void overrideName_nameAlreadyExists_throwsException() {
            Table totoTable = new Table("Toto");
            Column idColumn = totoTable.addColumn("id", UUID_TYPE);
            FluentEntityMappingConfigurationSupportTest.this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
            FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderPropertyOptions timestampMapping = MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$overrideName_nameAlreadyExists_throwsException$4((EmbeddableMappingConfigurationProvider)timestampMapping)).isInstanceOf(MappingConfigurationException.class)).hasMessage("Column 'modificationDate' of mapping 'Timestamp::getCreationDate' is already targeted by 'Timestamp::getModificationDate'");
        }

        @Test
        void overrideName_nameIsAlreadyOverridden_nameIsOverwritten() {
            Table totoTable = new Table("Toto");
            Column idColumn = totoTable.addColumn("id", UUID_TYPE);
            Column creationDate = totoTable.addColumn("createdAt", Date.class);
            Column modificationDate = totoTable.addColumn("modificationDate", Date.class);
            FluentEntityMappingConfigurationSupportTest.this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
            FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderPropertyOptions timestampMapping = MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).columnName("creation").map(Timestamp::getModificationDate);
            EntityPersister persister = MappingEase.entityBuilder(Toto.class, (Class)UUID_TYPE).onTable(totoTable).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).embed(Toto::getTimestamp, (EmbeddableMappingConfigurationProvider)timestampMapping).overrideName(Timestamp::getCreationDate, "createdAt").build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Toto toto = new Toto();
            toto.setTimestamp(new Timestamp(Dates.nowAsDate(), null));
            persister.insert((Object)toto);
            List select = FluentEntityMappingConfigurationSupportTest.this.persistenceContext.select(Timestamp::new, creationDate, modificationDate);
            Assertions.assertThat((Object)Iterables.first((List)select)).isEqualTo((Object)toto.getTimestamp());
            Toto loadedToto = (Toto)persister.select(toto.getId());
            Assertions.assertThat((Object)loadedToto.getTimestamp()).isEqualTo((Object)toto.getTimestamp());
        }

        @Test
        void mappingDefinedTwice_throwsException() {
            Table totoTable = new Table("Toto");
            Column idColumn = totoTable.addColumn("id", UUID_TYPE);
            FluentEntityMappingConfigurationSupportTest.this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
            FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderPropertyOptions timestampMapping = MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).map(Timestamp::getModificationDate).map(Timestamp::setModificationDate);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$mappingDefinedTwice_throwsException$5((EmbeddableMappingConfigurationProvider)timestampMapping)).isInstanceOf(MappingConfigurationException.class)).hasMessage("Mapping is already defined by method Timestamp::getModificationDate");
        }

        @Test
        void exclude() {
            Table totoTable = new Table("Toto");
            Column idColumn = totoTable.addColumn("id", UUID_TYPE);
            FluentEntityMappingConfigurationSupportTest.this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
            FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderPropertyOptions timestampMapping = MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).columnName("creation").map(Timestamp::getModificationDate);
            EntityPersister persister = MappingEase.entityBuilder(Toto.class, (Class)UUID_TYPE).onTable(totoTable).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).embed(Toto::getTimestamp, (EmbeddableMappingConfigurationProvider)timestampMapping).exclude(Timestamp::getCreationDate).build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            Map map = totoTable.mapColumnsOnName();
            Assertions.assertThat(map.get("creationDate")).isNull();
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Toto toto = new Toto();
            toto.setTimestamp(new Timestamp(Dates.nowAsDate(), null));
            persister.insert((Object)toto);
            Toto loadedToto = (Toto)persister.select(toto.getId());
            Assertions.assertThat((Object)loadedToto.getTimestamp()).isNull();
        }

        @Test
        void overrideColumn() {
            Table totoTable = new Table("Toto");
            Column idColumn = totoTable.addColumn("id", UUID_TYPE);
            Column creationDate = totoTable.addColumn("createdAt", Date.class);
            Column modificationDate = totoTable.addColumn("modificationDate", Date.class);
            FluentEntityMappingConfigurationSupportTest.this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
            FluentEmbeddableMappingBuilder.FluentEmbeddableMappingBuilderPropertyOptions timestampMapping = MappingEase.embeddableBuilder(Timestamp.class).map(Timestamp::getCreationDate).columnName("creation").map(Timestamp::getModificationDate);
            EntityPersister persister = MappingEase.entityBuilder(Toto.class, (Class)UUID_TYPE).onTable(totoTable).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).embed(Toto::getTimestamp, (EmbeddableMappingConfigurationProvider)timestampMapping).override(Timestamp::getCreationDate, creationDate).build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            Map map = totoTable.mapColumnsOnName();
            Assertions.assertThat(map.get("creationDate")).isNull();
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Toto toto = new Toto();
            toto.setTimestamp(new Timestamp(Dates.nowAsDate(), null));
            persister.insert((Object)toto);
            List select = FluentEntityMappingConfigurationSupportTest.this.persistenceContext.select(Timestamp::new, creationDate, modificationDate);
            Assertions.assertThat((Object)Iterables.first((List)select)).isEqualTo((Object)toto.getTimestamp());
            Toto loadedToto = (Toto)persister.select(toto.getId());
            Assertions.assertThat((Object)loadedToto.getTimestamp()).isEqualTo((Object)toto.getTimestamp());
        }

        private /* synthetic */ void lambda$mappingDefinedTwice_throwsException$5(EmbeddableMappingConfigurationProvider timestampMapping) throws Throwable {
            MappingEase.entityBuilder(Toto.class, (Class)UUID_TYPE).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).embed(Toto::getTimestamp, timestampMapping).build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
        }

        private /* synthetic */ void lambda$overrideName_nameAlreadyExists_throwsException$4(EmbeddableMappingConfigurationProvider timestampMapping) throws Throwable {
            MappingEase.entityBuilder(Toto.class, (Class)UUID_TYPE).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).embed(Toto::getTimestamp, timestampMapping).overrideName(Timestamp::getCreationDate, "modificationDate").build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
        }
    }

    @Nested
    class ExtraTable {
        ExtraTable() {
        }

        @Test
        void tableStructure() {
            FluentEntityMappingConfigurationSupportTest.this.dialect.getColumnBinderRegistry().register(Identifier.class, (ParameterBinder)new NullAwareParameterBinder((ParameterBinder)new LambdaParameterBinder(DefaultParameterBinders.UUID_BINDER, PersistedIdentifier::new, StatefulIdentifier::getDelegate)));
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(Identifier.class, "VARCHAR(255)");
            ConfiguredRelationalPersister persister = (ConfiguredRelationalPersister)MappingEase.entityBuilder(Toto.class, (Class)UUID_TYPE).mapKey(Toto::getIdentifier, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).extraTableName("Tata").build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Map tablePerName = Iterables.map((Iterable)persister.getEntityJoinTree().giveTables(), Table::getName);
            Assertions.assertThat(tablePerName.keySet()).containsExactlyInAnyOrder((Object[])new String[]{"Toto", "Tata"});
            Table totoTable = (Table)tablePerName.get("Toto");
            Table tataTable = (Table)tablePerName.get("Tata");
            Column columnForProperty = (Column)tataTable.mapColumnsOnName().get("name");
            Assertions.assertThat((Object)columnForProperty).isNotNull();
            Assertions.assertThat((Class)columnForProperty.getJavaType()).isEqualTo(String.class);
            Function columnPrinter = ToStringBuilder.of(", ", Column::getAbsoluteName, Functions.chain(Column::getJavaType, Reflections::toString));
            Function fkPrinter = ToStringBuilder.of(", ", ForeignKey::getName, Functions.link(ForeignKey::getColumns, ToStringBuilder.asSeveral(columnPrinter)), Functions.link(ForeignKey::getTargetColumns, ToStringBuilder.asSeveral(columnPrinter)));
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)tataTable.getForeignKeys()).usingElementComparator(Comparator.comparing(fkPrinter))).containsExactly((Object[])new ForeignKey[]{new ForeignKey("FK_Tata_identifier_Toto_identifier", tataTable.getColumn("identifier"), totoTable.getColumn("identifier"))});
        }

        @Test
        void tableStructure_columnNameGiven_columnNameIsUsed() {
            FluentEntityMappingConfigurationSupportTest.this.dialect.getColumnBinderRegistry().register(Identifier.class, (ParameterBinder)new NullAwareParameterBinder((ParameterBinder)new LambdaParameterBinder(DefaultParameterBinders.UUID_BINDER, PersistedIdentifier::new, StatefulIdentifier::getDelegate)));
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(Identifier.class, "VARCHAR(255)");
            ConfiguredRelationalPersister persister = (ConfiguredRelationalPersister)MappingEase.entityBuilder(Toto.class, (Class)UUID_TYPE).mapKey(Toto::getIdentifier, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).columnName("dummyName").extraTableName("Tata").build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Assertions.assertThat((Collection)persister.getEntityJoinTree().giveTables()).extracting(Table::getName).containsExactlyInAnyOrder((Object[])new String[]{"Toto", "Tata"});
            Table tataTable = (Table)Iterables.find((Iterable)persister.getEntityJoinTree().giveTables(), table -> table.getName().equals("Tata"));
            Column columnForProperty = (Column)tataTable.mapColumnsOnName().get("dummyName");
            Assertions.assertThat((Object)columnForProperty).isNotNull();
            Assertions.assertThat((Class)columnForProperty.getJavaType()).isEqualTo(String.class);
        }

        @Test
        void tableStructure_columnSizeGiven_columnSizeIsUsed() {
            FluentEntityMappingConfigurationSupportTest.this.dialect.getColumnBinderRegistry().register(Identifier.class, (ParameterBinder)new NullAwareParameterBinder((ParameterBinder)new LambdaParameterBinder(DefaultParameterBinders.UUID_BINDER, PersistedIdentifier::new, StatefulIdentifier::getDelegate)));
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(Identifier.class, "VARCHAR(255)");
            ConfiguredRelationalPersister persister = (ConfiguredRelationalPersister)MappingEase.entityBuilder(Toto.class, (Class)UUID_TYPE).mapKey(Toto::getIdentifier, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).columnSize((Size)Size.length((int)123)).extraTableName("Tata").build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Assertions.assertThat((Collection)persister.getEntityJoinTree().giveTables()).extracting(Table::getName).containsExactlyInAnyOrder((Object[])new String[]{"Toto", "Tata"});
            Table tataTable = (Table)Iterables.find((Iterable)persister.getEntityJoinTree().giveTables(), table -> table.getName().equals("Tata"));
            Column columnForProperty = (Column)tataTable.mapColumnsOnName().get("name");
            Assertions.assertThat((Object)columnForProperty).isNotNull();
            Assertions.assertThat((int)((Length)columnForProperty.getSize()).getValue()).isEqualTo(123);
        }

        @Test
        void crud() {
            FluentEntityMappingConfigurationSupportTest.this.dialect.getColumnBinderRegistry().register(Identifier.class, (ParameterBinder)new NullAwareParameterBinder((ParameterBinder)new LambdaParameterBinder(DefaultParameterBinders.UUID_BINDER, PersistedIdentifier::new, StatefulIdentifier::getDelegate)));
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(Identifier.class, "VARCHAR(255)");
            ConfiguredRelationalPersister persister = (ConfiguredRelationalPersister)MappingEase.entityBuilder(Toto.class, (Class)UUID_TYPE).mapKey(Toto::getIdentifier, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).extraTableName("Tata").build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Toto toto = new Toto();
            toto.setIdentifier(new PersistableIdentifier<UUID>(UUID.randomUUID()));
            toto.setName("dummy value");
            persister.insert((Object)toto);
            Toto selectedToto = (Toto)persister.select(toto.getIdentifier());
            Assertions.assertThat((String)selectedToto.getName()).isEqualTo("dummy value");
            toto.setName("another dummy value");
            persister.update((Object)toto, (Object)selectedToto, true);
            selectedToto = (Toto)persister.select(toto.getIdentifier());
            Assertions.assertThat((String)selectedToto.getName()).isEqualTo("another dummy value");
            persister.delete((Object)selectedToto);
            PersistenceContext.ExecutableBeanPropertyQueryMapper stringExecutableQuery = FluentEntityMappingConfigurationSupportTest.this.persistenceContext.newQuery((CharSequence)"select identifier from Toto union all select identifier from Tata", String.class).mapKey("identifier", String.class);
            Set identifiers = (Set)stringExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)identifiers).isEmpty();
        }

        @Test
        void crud_severalTables() {
            FluentEntityMappingConfigurationSupportTest.this.dialect.getColumnBinderRegistry().register(Identifier.class, (ParameterBinder)new NullAwareParameterBinder((ParameterBinder)new LambdaParameterBinder(DefaultParameterBinders.UUID_BINDER, PersistedIdentifier::new, StatefulIdentifier::getDelegate)));
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(Identifier.class, "VARCHAR(255)");
            ConfiguredRelationalPersister persister = (ConfiguredRelationalPersister)MappingEase.entityBuilder(Toto.class, (Class)UUID_TYPE).mapKey(Toto::getIdentifier, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).extraTableName("Tata").map(Toto::getFirstName).extraTableName("Tutu").build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Toto toto = new Toto();
            toto.setIdentifier(new PersistableIdentifier<UUID>(UUID.randomUUID()));
            toto.setName("dummy name");
            toto.setFirstName("dummy firstName");
            persister.insert((Object)toto);
            Toto selectedToto = (Toto)persister.select(toto.getIdentifier());
            Assertions.assertThat((String)selectedToto.getName()).isEqualTo("dummy name");
            Assertions.assertThat((String)selectedToto.getFirstName()).isEqualTo("dummy firstName");
            toto.setName("another dummy name");
            toto.setFirstName("another dummy firstName");
            persister.update((Object)toto, (Object)selectedToto, true);
            selectedToto = (Toto)persister.select(toto.getIdentifier());
            Assertions.assertThat((String)selectedToto.getName()).isEqualTo("another dummy name");
            Assertions.assertThat((String)selectedToto.getFirstName()).isEqualTo("another dummy firstName");
            persister.delete((Object)selectedToto);
            PersistenceContext.ExecutableBeanPropertyQueryMapper stringExecutableQuery = FluentEntityMappingConfigurationSupportTest.this.persistenceContext.newQuery((CharSequence)"select identifier from Toto union all select identifier from Tata", String.class).mapKey("identifier", String.class);
            Set identifiers = (Set)stringExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)identifiers).isEmpty();
        }

        @Test
        void crud_withConfigurationFromInheritance() {
            FluentEntityMappingConfigurationSupportTest.this.dialect.getColumnBinderRegistry().register(Identifier.class, (ParameterBinder)new NullAwareParameterBinder((ParameterBinder)new LambdaParameterBinder(DefaultParameterBinders.UUID_BINDER, PersistedIdentifier::new, StatefulIdentifier::getDelegate)));
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(Identifier.class, "VARCHAR(255)");
            ConfiguredRelationalPersister persister = (ConfiguredRelationalPersister)MappingEase.entityBuilder(Toto.class, (Class)UUID_TYPE).map(Toto::getName).extraTableName("Tata").map(Toto::getFirstName).extraTableName("Tutu").mapSuperClass((EntityMappingConfigurationProvider)MappingEase.entityBuilder(AbstractToto.class, (Class)UUID_TYPE).mapKey(AbstractToto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(AbstractToto::getProp1).extraTableName("Titi")).build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Toto toto = new Toto();
            toto.setIdentifier(new PersistableIdentifier<UUID>(UUID.randomUUID()));
            toto.setName("dummy name");
            toto.setProp1("dummy firstName");
            persister.insert((Object)toto);
            Toto selectedToto = (Toto)persister.select(toto.getId());
            Assertions.assertThat((String)selectedToto.getName()).isEqualTo("dummy name");
            Assertions.assertThat((String)selectedToto.getProp1()).isEqualTo("dummy firstName");
            toto.setName("another dummy name");
            toto.setProp1("another dummy firstName");
            persister.update((Object)toto, (Object)selectedToto, true);
            selectedToto = (Toto)persister.select(toto.getId());
            Assertions.assertThat((String)selectedToto.getName()).isEqualTo("another dummy name");
            Assertions.assertThat((String)selectedToto.getProp1()).isEqualTo("another dummy firstName");
            persister.delete((Object)selectedToto);
            PersistenceContext.ExecutableBeanPropertyQueryMapper stringExecutableQuery = FluentEntityMappingConfigurationSupportTest.this.persistenceContext.newQuery((CharSequence)"select id from Toto union all select id from Tata", String.class).mapKey("identifier", String.class);
            Set identifiers = (Set)stringExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)identifiers).isEmpty();
        }
    }

    @Nested
    class UseConstructor {
        UseConstructor() {
        }

        @Test
        void byDefault_defaultConstructorIsInvoked_setterIsCalled() {
            Table totoTable = new Table("Toto");
            Column idColumn = totoTable.addColumn("id", UUID_TYPE);
            FluentEntityMappingConfigurationSupportTest.this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
            EntityPersister persister = MappingEase.entityBuilder(Toto.class, (Class)UUID_TYPE).onTable(totoTable).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).map(Toto::getName).build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Toto entity = new Toto();
            entity.setName("Tutu");
            persister.insert((Object)entity);
            Toto loadedInstance = (Toto)persister.select(entity.getId());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)loadedInstance.isSetIdWasCalled()).as("setId was called", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)loadedInstance.isConstructorWithIdWasCalled()).as("constructor with Id was called", new Object[0])).isFalse();
        }

        @Test
        <T extends Table<T>> void withConstructorSpecified_constructorIsInvoked_setterIsNotCalled() {
            Table totoTable = new Table("Toto");
            Column idColumn = totoTable.addColumn("id", UUID_TYPE);
            FluentEntityMappingConfigurationSupportTest.this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
            Function<PersistedIdentifier, Toto> constructor = Toto::new;
            EntityPersister persister = MappingEase.entityBuilder(Toto.class, (Class)UUID_TYPE).onTable(totoTable).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).usingConstructor(constructor, idColumn).map(Toto::getName).build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Toto entity = new Toto();
            entity.setName("Tutu");
            persister.insert((Object)entity);
            Toto loadedInstance = (Toto)persister.select(entity.getId());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)loadedInstance.isSetIdWasCalled()).as("setId was called", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)loadedInstance.isConstructorWithIdWasCalled()).as("constructor with Id was called", new Object[0])).isTrue();
        }

        @Test
        void withConstructorSpecified_byColumnName_constructorIsInvoked() {
            Table totoTable = new Table("Toto");
            ParameterBinder statefulIdentifierParameterBinder = Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER);
            FluentEntityMappingConfigurationSupportTest.this.dialect.getColumnBinderRegistry().register(UUID_TYPE, statefulIdentifierParameterBinder);
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(UUID_TYPE, "VARCHAR(255)");
            Function<PersistedIdentifier, Toto> constructor = Toto::new;
            EntityPersister persister = MappingEase.entityBuilder(Toto.class, (Class)UUID_TYPE).onTable(totoTable).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED, "identifier").usingConstructor(constructor, "identifier").map(Toto::getName).columnName("label").build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Toto entity = new Toto();
            persister.insert((Object)entity);
            Toto loadedInstance = (Toto)persister.select(entity.getId());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)loadedInstance.isSetIdWasCalled()).as("setId was called", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)loadedInstance.isConstructorWithIdWasCalled()).as("constructor with Id was called", new Object[0])).isTrue();
        }

        @Test
        <T extends Table<T>> void setByConstructor_constructorIsInvoked_setterIsCalled() {
            Table totoTable = new Table("Toto");
            Column idColumn = totoTable.addColumn("id", UUID_TYPE);
            FluentEntityMappingConfigurationSupportTest.this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
            Function<PersistedIdentifier, Toto> constructor = Toto::new;
            EntityPersister persister = MappingEase.entityBuilder(Toto.class, (Class)UUID_TYPE).onTable(totoTable).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).usingConstructor(constructor, idColumn).map(Toto::getName).build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Toto entity = new Toto();
            entity.setName("Tutu");
            persister.insert((Object)entity);
            Toto loadedInstance = (Toto)persister.select(entity.getId());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)loadedInstance.isSetIdWasCalled()).as("setId was called", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)loadedInstance.isConstructorWithIdWasCalled()).as("constructor with Id was called", new Object[0])).isTrue();
        }

        @Test
        <T extends Table<T>> void setByConstructor_withSeveralArguments() {
            Table totoTable = new Table("Toto");
            Column idColumn = totoTable.addColumn("id", UUID_TYPE);
            Column nameColumn = totoTable.addColumn("name", String.class);
            FluentEntityMappingConfigurationSupportTest.this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
            BiFunction<PersistedIdentifier, String, Toto> constructor = Toto::new;
            EntityPersister persister = MappingEase.entityBuilder(Toto.class, (Class)UUID_TYPE).onTable(totoTable).mapKey(Toto::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.UUID_ALREADY_ASSIGNED).usingConstructor(constructor, idColumn, nameColumn).map(Toto::getName).setByConstructor().build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Toto entity = new Toto();
            entity.setName("Hello");
            persister.insert((Object)entity);
            Toto loadedInstance = (Toto)persister.select(entity.getId());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)loadedInstance.isSetIdWasCalled()).as("setId was called", new Object[0])).isFalse();
            Assertions.assertThat((String)loadedInstance.getName()).isEqualTo("Hello by constructor");
        }
    }

    @Nested
    class MapKey {
        MapKey() {
        }

        @Test
        void calledTwice_throwsException() {
            Assertions.assertThatThrownBy(() -> MappingEase.entityBuilder(Toto.class, (Class)UUID_TYPE).mapKey(Toto::getIdentifier, (IdentifierPolicy)IdentifierPolicy.alreadyAssigned(c -> c.getId().setPersisted(), c -> c.getId().isPersisted())).mapKey(Toto::getId, (IdentifierPolicy)IdentifierPolicy.alreadyAssigned(c -> c.getId().setPersisted(), c -> c.getId().isPersisted())).map(Toto::getName).build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext)).hasMessage("Identifier is already defined by Toto::getIdentifier");
        }

        @Test
        void byDefault_defaultConstructorIsInvoked_setterIsCalled() {
            Table totoTable = new Table("Toto");
            Column idColumn = totoTable.addColumn("id", UUID_TYPE);
            FluentEntityMappingConfigurationSupportTest.this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
            EntityPersister persister = MappingEase.entityBuilder(Toto.class, (Class)UUID_TYPE).onTable(totoTable).mapKey(Toto::getId, (IdentifierPolicy)IdentifierPolicy.alreadyAssigned(c -> c.getId().setPersisted(), c -> c.getId().isPersisted())).map(Toto::getName).build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Toto entity = new Toto();
            entity.setName("Tutu");
            persister.insert((Object)entity);
            Toto loadedInstance = (Toto)persister.select(entity.getId());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)loadedInstance.isSetIdWasCalled()).as("setId was called", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)loadedInstance.isConstructorWithIdWasCalled()).as("constructor with Id was called", new Object[0])).isFalse();
        }

        @Test
        void usingConstructor_supplier_supplierIsCalled() {
            Table totoTable = new Table("Toto");
            Column idColumn = totoTable.addColumn("id", UUID_TYPE);
            FluentEntityMappingConfigurationSupportTest.this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
            Supplier<Toto> constructor = Toto::newInstance;
            EntityPersister persister = MappingEase.entityBuilder(Toto.class, (Class)UUID_TYPE).onTable(totoTable).mapKey(Toto::getId, (IdentifierPolicy)IdentifierPolicy.alreadyAssigned(c -> c.getId().setPersisted(), c -> c.getId().isPersisted())).usingConstructor(constructor).map(Toto::getName).build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Toto entity = new Toto();
            entity.setName("Tutu");
            persister.insert((Object)entity);
            Toto loadedInstance = (Toto)persister.select(entity.getId());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)loadedInstance.isSetIdWasCalled()).as("setId was called", new Object[0])).isTrue();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)loadedInstance.isConstructorWithIdWasCalled()).as("constructor with Id was called", new Object[0])).isFalse();
            Assertions.assertThat((String)loadedInstance.getFirstName()).isEqualTo("set by static factory");
        }

        @Test
        void usingConstructor_constructorIsInvoked_setterIsNotCalled() {
            Table totoTable = new Table("Toto");
            FluentEntityMappingConfigurationSupportTest.this.dialect.getColumnBinderRegistry().register(UUID_TYPE, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(UUID_TYPE, "VARCHAR(255)");
            Function<PersistedIdentifier, Toto> constructor = Toto::new;
            EntityPersister persister = MappingEase.entityBuilder(Toto.class, (Class)UUID_TYPE).onTable(totoTable).mapKey(Toto::getId, (IdentifierPolicy)IdentifierPolicy.alreadyAssigned(c -> c.getId().setPersisted(), c -> c.getId().isPersisted())).usingConstructor(constructor).map(Toto::getName).build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Toto entity = new Toto();
            entity.setName("Tutu");
            persister.insert((Object)entity);
            Toto loadedInstance = (Toto)persister.select(entity.getId());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)loadedInstance.isSetIdWasCalled()).as("setId was called", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)loadedInstance.isConstructorWithIdWasCalled()).as("constructor with Id was called", new Object[0])).isTrue();
        }

        @Test
        <T extends Table<T>> void usingConstructor_1Arg_constructorIsInvoked_setterIsNotCalled() {
            Table totoTable = new Table("Toto");
            Column idColumn = totoTable.addColumn("id", UUID_TYPE).primaryKey();
            FluentEntityMappingConfigurationSupportTest.this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
            Function<PersistedIdentifier, Toto> constructor = Toto::new;
            EntityPersister persister = MappingEase.entityBuilder(Toto.class, (Class)UUID_TYPE).onTable(totoTable).mapKey(Toto::getId, (IdentifierPolicy)IdentifierPolicy.alreadyAssigned(c -> c.getId().setPersisted(), c -> c.getId().isPersisted())).usingConstructor(constructor, idColumn).map(Toto::getName).build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Toto entity = new Toto();
            entity.setName("Tutu");
            persister.insert((Object)entity);
            Toto loadedInstance = (Toto)persister.select(entity.getId());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)loadedInstance.isSetIdWasCalled()).as("setId was called", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)loadedInstance.isConstructorWithIdWasCalled()).as("constructor with Id was called", new Object[0])).isTrue();
        }

        @Test
        void usingConstructor_1ArgColumnName_constructorIsInvoked_setterIsNotCalled() {
            Table totoTable = new Table("Toto");
            FluentEntityMappingConfigurationSupportTest.this.dialect.getColumnBinderRegistry().register(UUID_TYPE, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(UUID_TYPE, "VARCHAR(255)");
            Function<PersistedIdentifier, Toto> constructor = Toto::new;
            EntityPersister persister = MappingEase.entityBuilder(Toto.class, (Class)UUID_TYPE).onTable(totoTable).mapKey(Toto::getId, (IdentifierPolicy)IdentifierPolicy.alreadyAssigned(c -> c.getId().setPersisted(), c -> c.getId().isPersisted())).usingConstructor(constructor, "myId").map(Toto::getName).build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Toto entity = new Toto();
            entity.setName("Tutu");
            persister.insert((Object)entity);
            Toto loadedInstance = (Toto)persister.select(entity.getId());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)loadedInstance.isSetIdWasCalled()).as("setId was called", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)loadedInstance.isConstructorWithIdWasCalled()).as("constructor with Id was called", new Object[0])).isTrue();
        }

        @Test
        <T extends Table<T>> void usingConstructor_2Args_constructorIsInvoked_setterIsNotCalled() {
            Table totoTable = new Table("Toto");
            Column idColumn = totoTable.addColumn("id", UUID_TYPE).primaryKey();
            Column nameColumn = totoTable.addColumn("name", String.class);
            FluentEntityMappingConfigurationSupportTest.this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
            BiFunction<PersistedIdentifier, String, Toto> constructor = Toto::new;
            EntityPersister persister = MappingEase.entityBuilder(Toto.class, (Class)UUID_TYPE).onTable(totoTable).mapKey(Toto::getId, (IdentifierPolicy)IdentifierPolicy.alreadyAssigned(c -> c.getId().setPersisted(), c -> c.getId().isPersisted())).usingConstructor(constructor, idColumn, nameColumn).map(Toto::getName).setByConstructor().build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Toto entity = new Toto();
            entity.setName("Tutu");
            persister.insert((Object)entity);
            Toto loadedInstance = (Toto)persister.select(entity.getId());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)loadedInstance.isSetIdWasCalled()).as("setId was called", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)loadedInstance.isConstructorWith2ArgsWasCalled()).as("constructor with Id was called", new Object[0])).isTrue();
            Assertions.assertThat((String)loadedInstance.getName()).isEqualTo("Tutu by constructor");
        }

        @Test
        void usingFactory_constructorIsInvoked_setterIsNotCalled() {
            Table totoTable = new Table("Toto");
            Column idColumn = totoTable.addColumn("id", UUID_TYPE).primaryKey();
            Column nameColumn = totoTable.addColumn("name", String.class);
            FluentEntityMappingConfigurationSupportTest.this.dialect.getColumnBinderRegistry().register(idColumn, Identifier.identifierBinder(DefaultParameterBinders.UUID_BINDER));
            FluentEntityMappingConfigurationSupportTest.this.dialect.getSqlTypeRegistry().put(idColumn, "VARCHAR(255)");
            EntityPersister persister = MappingEase.entityBuilder(Toto.class, (Class)UUID_TYPE).onTable(totoTable).mapKey(Toto::getId, (IdentifierPolicy)IdentifierPolicy.alreadyAssigned(c -> c.getId().setPersisted(), c -> c.getId().isPersisted())).usingFactory(row -> new Toto((PersistedIdentifier)row.apply(idColumn), (String)row.apply(nameColumn))).map(Toto::getName).setByConstructor().build(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Toto entity = new Toto();
            entity.setName("Tutu");
            persister.insert((Object)entity);
            Toto loadedInstance = (Toto)persister.select(entity.getId());
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)loadedInstance.isSetIdWasCalled()).as("setId was called", new Object[0])).isFalse();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)loadedInstance.isConstructorWith2ArgsWasCalled()).as("constructor with Id was called", new Object[0])).isTrue();
            Assertions.assertThat((String)loadedInstance.getName()).isEqualTo("Tutu by constructor");
        }
    }
}

