/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query.projection;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.LongSupplier;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.engine.runtime.ProjectionQueryCriteriaSupport;
import org.codefilarete.stalactite.engine.runtime.query.EntityCriteriaSupport;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.spring.repository.query.StalactiteQueryMethod;
import org.codefilarete.stalactite.spring.repository.query.derivation.ToCriteriaPartTreeTransformer;
import org.codefilarete.stalactite.spring.repository.query.domain.DomainEntityQueryExecutor;
import org.codefilarete.stalactite.spring.repository.query.execution.AbstractQueryExecutor;
import org.codefilarete.stalactite.spring.repository.query.execution.AbstractRepositoryQuery;
import org.codefilarete.stalactite.spring.repository.query.execution.StalactiteQueryMethodInvocationParameters;
import org.codefilarete.stalactite.spring.repository.query.projection.PartTreeStalactiteCountProjection;
import org.codefilarete.stalactite.spring.repository.query.projection.ProjectionMappingFinder;
import org.codefilarete.stalactite.spring.repository.query.projection.ProjectionQueryExecutor;
import org.codefilarete.tool.VisibleForTesting;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.query.parser.PartTree;

public class PartTreeStalactiteProjection<C, R>
extends AbstractRepositoryQuery<C, R> {
    private final ToCriteriaPartTreeTransformer<C> projectionCriteriaAppender;
    private final ProjectionMappingFinder<C> projectionMappingFinder;
    private final AdvancedEntityPersister<C, ?> entityPersister;
    private final PartTree partTree;
    private final ProjectionFactory factory;
    private final PartTreeStalactiteCountProjection<C> countQuery;
    private final ProjectionQueryCriteriaSupport<C, ?> defaultProjectionQueryCriteriaSupport;

    @VisibleForTesting
    public static void buildHierarchicMap(AccessorChain<?, ?> dottedProperty, Object value, Map<String, Object> root) {
        Map current = root;
        int lengthMinus1 = dottedProperty.getAccessors().size() - 1;
        for (int i = 0; i < lengthMinus1; ++i) {
            Accessor accessor = (Accessor)dottedProperty.getAccessors().get(i);
            String propertyName = AccessorDefinition.giveDefinition((ValueAccessPoint)accessor).getName();
            current = (Map)current.computeIfAbsent((String)propertyName, k -> new HashMap());
        }
        Accessor lastAccessor = (Accessor)dottedProperty.getAccessors().get(lengthMinus1);
        String propertyName = AccessorDefinition.giveDefinition((ValueAccessPoint)lastAccessor).getName();
        current.putIfAbsent((String)propertyName, (Object)value);
    }

    public PartTreeStalactiteProjection(StalactiteQueryMethod method, AdvancedEntityPersister<C, ?> entityPersister, PartTree partTree, ProjectionFactory factory) {
        super(method);
        this.entityPersister = entityPersister;
        this.partTree = partTree;
        this.factory = factory;
        this.countQuery = new PartTreeStalactiteCountProjection<C>(method, entityPersister, partTree);
        this.projectionMappingFinder = new ProjectionMappingFinder<C>(factory, entityPersister);
        this.projectionMappingFinder.lookup(method.getDomainClass());
        this.defaultProjectionQueryCriteriaSupport = entityPersister.newProjectionCriteriaSupport(selectables -> {});
        this.projectionCriteriaAppender = new ToCriteriaPartTreeTransformer(partTree, entityPersister.getClassToPersist());
        this.projectionCriteriaAppender.applyTo((EntityCriteriaSupport<C>)this.defaultProjectionQueryCriteriaSupport.getEntityCriteriaSupport(), (EntityPersister.OrderByChain<C, ?>)this.defaultProjectionQueryCriteriaSupport.getQueryPageSupport(), (EntityPersister.LimitAware<?>)this.defaultProjectionQueryCriteriaSupport.getQueryPageSupport());
    }

    @Override
    protected AbstractQueryExecutor<List<Object>, Object> buildQueryExecutor(StalactiteQueryMethodInvocationParameters invocationParameters) {
        boolean runProjectionQuery;
        IdentityHashMap<JoinLink<?, ?>, AccessorChain<C, ?>> propertiesColumns;
        if (this.method.getParameters().hasDynamicProjection()) {
            propertiesColumns = this.projectionMappingFinder.lookup(invocationParameters.getDynamicProjectionType());
            runProjectionQuery = this.factory.getProjectionInformation(invocationParameters.getDynamicProjectionType()).isClosed() && !invocationParameters.getDynamicProjectionType().isAssignableFrom(this.entityPersister.getClassToPersist());
        } else {
            propertiesColumns = this.projectionMappingFinder.lookup(this.method.getReturnedObjectType());
            runProjectionQuery = this.factory.getProjectionInformation(this.method.getReturnedObjectType()).isClosed();
        }
        if (runProjectionQuery) {
            return new ProjectionQueryExecutor<C>(this.method, this.defaultProjectionQueryCriteriaSupport, propertiesColumns);
        }
        return new DomainEntityQueryExecutor<Object>(this.method, this.entityPersister, this.partTree);
    }

    @Override
    protected LongSupplier buildCountSupplier(StalactiteQueryMethodInvocationParameters accessor) {
        return () -> this.countQuery.execute(accessor.getValues());
    }
}

