/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;
import org.codefilarete.stalactite.sql.CommitListener;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.RollbackListener;
import org.codefilarete.stalactite.sql.SimpleConnectionProvider;
import org.codefilarete.stalactite.sql.TransactionAwareConnectionProvider;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class TransactionAwareConnectionProviderTest {
    TransactionAwareConnectionProviderTest() {
    }

    @Test
    void commitIsCalled_commitMethodsAreInvoked() throws SQLException {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        TransactionAwareConnectionProvider testInstance = new TransactionAwareConnectionProvider((ConnectionProvider)new SimpleConnectionProvider(connection));
        CommitListener commitListenerMock = (CommitListener)Mockito.mock(CommitListener.class);
        testInstance.addCommitListener(commitListenerMock);
        testInstance.giveConnection().commit();
        ((CommitListener)Mockito.verify((Object)commitListenerMock)).beforeCommit();
        ((CommitListener)Mockito.verify((Object)commitListenerMock)).afterCommit();
    }

    @Test
    void rollbackIsCalled_rollbackMethodsAreInvoked() throws SQLException {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        TransactionAwareConnectionProvider testInstance = new TransactionAwareConnectionProvider((ConnectionProvider)new SimpleConnectionProvider(connection));
        RollbackListener rollbackListenerMock = (RollbackListener)Mockito.mock(RollbackListener.class);
        testInstance.addRollbackListener(rollbackListenerMock);
        testInstance.giveConnection().rollback();
        ((RollbackListener)Mockito.verify((Object)rollbackListenerMock)).beforeRollback();
        ((RollbackListener)Mockito.verify((Object)rollbackListenerMock)).afterRollback();
        ((RollbackListener)Mockito.verify((Object)rollbackListenerMock, (VerificationMode)Mockito.never())).beforeRollback((Savepoint)ArgumentMatchers.any());
        ((RollbackListener)Mockito.verify((Object)rollbackListenerMock, (VerificationMode)Mockito.never())).afterRollback((Savepoint)ArgumentMatchers.any());
    }

    @Test
    void rollbackSavepointIsCalled_rollbackSavepointMethodsAreInvoked() throws SQLException {
        Connection connection = (Connection)Mockito.mock(Connection.class);
        TransactionAwareConnectionProvider testInstance = new TransactionAwareConnectionProvider((ConnectionProvider)new SimpleConnectionProvider(connection));
        RollbackListener rollbackListenerMock = (RollbackListener)Mockito.mock(RollbackListener.class);
        testInstance.addRollbackListener(rollbackListenerMock);
        Savepoint savepoint = testInstance.giveConnection().setSavepoint();
        testInstance.giveConnection().rollback(savepoint);
        ((RollbackListener)Mockito.verify((Object)rollbackListenerMock)).beforeRollback(savepoint);
        ((RollbackListener)Mockito.verify((Object)rollbackListenerMock)).afterRollback(savepoint);
        ((RollbackListener)Mockito.verify((Object)rollbackListenerMock, (VerificationMode)Mockito.never())).beforeRollback();
        ((RollbackListener)Mockito.verify((Object)rollbackListenerMock, (VerificationMode)Mockito.never())).afterRollback();
    }
}

