/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.model;

import java.util.Collection;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.query.model.Query;
import org.codefilarete.stalactite.query.model.QueryStatement;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.query.model.Union;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Test;

class UnionTest {
    UnionTest() {
    }

    @Test
    void registerColumn_basicUseCase() {
        Union testInstance = new Union(new Query[0]);
        QueryStatement.PseudoColumn createdColumn = testInstance.registerColumn("count(*)", Integer.TYPE);
        Assertions.assertThat((String)createdColumn.getExpression()).isEqualTo("count(*)");
        Assertions.assertThat((Class)createdColumn.getJavaType()).isEqualTo(Integer.TYPE);
    }

    @Test
    void registerColumn_columnAlreadyExists_doesntRegisterColumn() {
        Union testInstance = new Union(new Query[0]);
        QueryStatement.PseudoColumn createdColumn = testInstance.registerColumn("count(*)", Integer.TYPE);
        QueryStatement.PseudoColumn createdColumn2 = testInstance.registerColumn("count(*)", Integer.TYPE);
        Assertions.assertThat((Object)createdColumn2).isSameAs((Object)createdColumn);
        Assertions.assertThat((Collection)testInstance.getColumns()).hasSize(1);
    }

    @Test
    void registerColumn_columnAlreadyExistsButHasAlias_doesntRegisterColumn() {
        Union testInstance = new Union(new Query[0]);
        QueryStatement.PseudoColumn createdColumn = testInstance.registerColumn("count(*)", Integer.TYPE, "count");
        QueryStatement.PseudoColumn createdColumn2 = testInstance.registerColumn("count(*)", Integer.TYPE);
        Assertions.assertThat((Object)createdColumn2).isSameAs((Object)createdColumn);
        Assertions.assertThat((Collection)testInstance.getColumns()).hasSize(1);
    }

    @Test
    void registerColumn_columnAlreadyExistsButRegisteredOnHasAlias_doesntRegisterColumn() {
        Union testInstance = new Union(new Query[0]);
        QueryStatement.PseudoColumn createdColumn = testInstance.registerColumn("count(*)", Integer.TYPE);
        QueryStatement.PseudoColumn createdColumn2 = testInstance.registerColumn("count(*)", Integer.TYPE, "count");
        Assertions.assertThat((Object)createdColumn2).isNotSameAs((Object)createdColumn);
        Assertions.assertThat((Collection)testInstance.getColumns()).hasSize(2);
    }

    @Test
    void registerColumn_columnAlreadyExistsWithDifferentType_throwsException() {
        Union testInstance = new Union(new Query[0]);
        testInstance.registerColumn("count(*)", Integer.TYPE);
        Assertions.assertThatThrownBy(() -> testInstance.registerColumn("count(*)", Integer.class)).hasMessage("Trying to add a column 'count(*)' that already exists with a different type : int vs j.l.Integer");
    }

    @Test
    void registerColumn_columnAlreadyExistsWithDifferentTypeButWithDifferentAlias_doesNotThrowsException() {
        Union testInstance = new Union(new Query[0]);
        QueryStatement.PseudoColumn createdColumn = testInstance.registerColumn("count(*)", Integer.TYPE, "a");
        QueryStatement.PseudoColumn createdColumn2 = testInstance.registerColumn("count(*)", Integer.TYPE, "b");
        Assertions.assertThat((Object)createdColumn2).isNotSameAs((Object)createdColumn);
        Assertions.assertThat((Collection)testInstance.getColumns()).hasSize(2);
    }

    @Test
    void mapsColumnOnName() {
        Union testInstance = new Union(new Query[0]);
        QueryStatement.PseudoColumn column1 = testInstance.registerColumn("count(*)", Integer.TYPE);
        QueryStatement.PseudoColumn column2 = testInstance.registerColumn("name", String.class);
        QueryStatement.PseudoColumn column3 = testInstance.registerColumn("FIRST_NAME", String.class, "firstName");
        Map columnPerName = testInstance.mapColumnsOnName();
        Assertions.assertThat((Map)columnPerName).isEqualTo((Object)Maps.forHashMap(String.class, Selectable.class).add((Object)"count(*)", (Object)column1).add((Object)"name", (Object)column2).add((Object)"FIRST_NAME", (Object)column3));
    }
}

