/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql;

import java.sql.Savepoint;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.CommitListener;
import org.codefilarete.stalactite.sql.RollbackListener;
import org.codefilarete.stalactite.sql.TransactionListenerCollection;
import org.codefilarete.tool.trace.MutableInt;
import org.junit.jupiter.api.Test;

public class TransactionListenerCollectionTest {
    @Test
    public void testAfterCommit_temporaryListenersShouldNotBeCalledTwice() {
        TransactionListenerCollection testInstance = new TransactionListenerCollection();
        final MutableBoolean isTemporary = new MutableBoolean();
        final MutableInt modifiableInt = new MutableInt();
        CommitListener temporaryCommitListener = new CommitListener(){

            public void beforeCommit() {
            }

            public void afterCommit() {
                modifiableInt.increment();
            }

            public boolean isTemporary() {
                return isTemporary.booleanValue();
            }
        };
        testInstance.addCommitListener(temporaryCommitListener);
        isTemporary.setFalse();
        testInstance.afterCommit();
        Assertions.assertThat((int)modifiableInt.getValue()).isEqualTo(1);
        testInstance.afterCommit();
        Assertions.assertThat((int)modifiableInt.getValue()).isEqualTo(2);
        isTemporary.setTrue();
        testInstance.afterCommit();
        Assertions.assertThat((int)modifiableInt.getValue()).isEqualTo(3);
        testInstance.afterCommit();
        Assertions.assertThat((int)modifiableInt.getValue()).isEqualTo(3);
    }

    @Test
    public void testAfterRolback_temporaryListenersShouldNotBeCalledTwice() {
        TransactionListenerCollection testInstance = new TransactionListenerCollection();
        final MutableBoolean isTemporary = new MutableBoolean();
        final MutableInt modifiableInt = new MutableInt();
        RollbackListener temporaryRollbackListener = new RollbackListener(){

            public void beforeRollback() {
            }

            public void afterRollback() {
                modifiableInt.increment();
            }

            public void beforeRollback(Savepoint savepoint) {
            }

            public void afterRollback(Savepoint savepoint) {
            }

            public boolean isTemporary() {
                return isTemporary.booleanValue();
            }
        };
        testInstance.addRollbackListener(temporaryRollbackListener);
        isTemporary.setFalse();
        testInstance.afterRollback();
        Assertions.assertThat((int)modifiableInt.getValue()).isEqualTo(1);
        testInstance.afterRollback();
        Assertions.assertThat((int)modifiableInt.getValue()).isEqualTo(2);
        isTemporary.setTrue();
        testInstance.afterRollback();
        Assertions.assertThat((int)modifiableInt.getValue()).isEqualTo(3);
        testInstance.afterRollback();
        Assertions.assertThat((int)modifiableInt.getValue()).isEqualTo(3);
    }

    private static class MutableBoolean {
        private boolean value;

        private MutableBoolean() {
        }

        public boolean booleanValue() {
            return this.value;
        }

        public void setTrue() {
            this.value = true;
        }

        public void setFalse() {
            this.value = false;
        }
    }
}

