/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.result;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.ReadOnlyIterator;
import org.codefilarete.tool.exception.Exceptions;
import org.codefilarete.tool.function.ThrowingConverter;

public abstract class ResultSetIterator<T>
extends ReadOnlyIterator<T>
implements ThrowingConverter<ResultSet, T, SQLException> {
    @Nullable
    private ResultSet resultSet;
    private int rowNumber = 1;
    private boolean nextCalled = false;
    private boolean hasNext = false;

    public ResultSetIterator() {
    }

    public ResultSetIterator(ResultSet resultSet) {
        this();
        this.resultSet = resultSet;
    }

    public void setResultSet(ResultSet resultSet) {
        this.resultSet = resultSet;
        this.reset();
    }

    public ResultSet getResultSet() {
        return this.resultSet;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    private void reset() {
        this.nextCalled = false;
        this.hasNext = false;
        this.rowNumber = 1;
    }

    public boolean hasNext() {
        try {
            this.hasNext = !this.nextCalled && this.resultSet.next();
            boolean bl = this.hasNext;
            return bl;
        }
        catch (SQLException e) {
            throw Exceptions.asRuntimeException((Throwable)e);
        }
        finally {
            this.nextCalled = true;
        }
    }

    public T next() {
        if (!this.hasNext) {
            throw new NoSuchElementException();
        }
        try {
            ++this.rowNumber;
            T t = this.convert(this.resultSet);
            return t;
        }
        catch (SQLException e) {
            throw new RuntimeException("Error while reading ResultSet on row " + --this.rowNumber, e);
        }
        finally {
            this.nextCalled = false;
            this.hasNext = false;
        }
    }

    public List<T> convert() {
        return Iterables.collectToList(() -> this, Function.identity());
    }

    public abstract T convert(ResultSet var1) throws SQLException;
}

