/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query.bean;

import java.lang.reflect.Executable;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.codefilarete.reflection.MethodReferenceCapturer;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.ExecutableQuery;
import org.codefilarete.stalactite.query.model.Limit;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.spring.repository.query.BeanQuery;
import org.codefilarete.stalactite.spring.repository.query.StalactiteQueryMethod;
import org.codefilarete.stalactite.spring.repository.query.execution.AbstractQueryExecutor;
import org.codefilarete.stalactite.spring.repository.query.execution.AbstractRepositoryQuery;
import org.codefilarete.stalactite.spring.repository.query.execution.StalactiteQueryMethodInvocationParameters;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.result.Accumulator;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.function.Hanger;
import org.codefilarete.tool.trace.MutableLong;

public class QueryRepositoryQuery<O, R>
extends AbstractRepositoryQuery<O, R> {
    private final ExecutableQuery<O> entityQuery;
    @Nullable
    private final EntityPersister.ExecutableProjectionQuery<O, ?> countQuery;
    private final Dialect dialect;

    public QueryRepositoryQuery(StalactiteQueryMethod queryMethod, ExecutableQuery entityQuery, @Nullable EntityPersister.ExecutableProjectionQuery<O, ?> countQuery, Dialect dialect) {
        super(queryMethod);
        this.entityQuery = entityQuery;
        this.countQuery = countQuery;
        this.dialect = dialect;
    }

    @Override
    protected AbstractQueryExecutor<List<Object>, Object> buildQueryExecutor(StalactiteQueryMethodInvocationParameters invocationParameters) {
        return new AbstractQueryExecutor<List<Object>, Object>(this.getQueryMethod()){

            @Override
            public Supplier<List<Object>> buildQueryExecutor(StalactiteQueryMethodInvocationParameters invocationParameters) {
                return () -> {
                    Limit limit = invocationParameters.getLimit();
                    if (limit != null) {
                        // empty if block
                    }
                    HashMap<String, Object> values = new HashMap<String, Object>();
                    values.putAll(invocationParameters.getNamedValues());
                    return (List)QueryRepositoryQuery.this.entityQuery.execute(Accumulators.toList());
                };
            }
        };
    }

    @Override
    protected LongSupplier buildCountSupplier(StalactiteQueryMethodInvocationParameters invocationParameters) {
        if (this.countQuery == null) {
            MethodReferenceCapturer methodReferenceCapturer = new MethodReferenceCapturer();
            Executable countQueryAccessor = methodReferenceCapturer.findExecutable(BeanQuery::counterBean);
            throw new IllegalStateException("Count query is mandatory for paged queries, please provide one through " + Reflections.toString((Executable)countQueryAccessor));
        }
        return () -> {
            final Hanger.Holder countSelectable = new Hanger.Holder();
            this.countQuery.selectInspector(select -> countSelectable.set((Object)((Selectable)Iterables.first((Iterable)select))));
            invocationParameters.getNamedValues().forEach((arg_0, arg_1) -> this.countQuery.set(arg_0, arg_1));
            return (Long)this.countQuery.execute((Accumulator)new Accumulator<Function<Selectable<Long>, Long>, MutableLong, Long>(){

                public Supplier<MutableLong> supplier() {
                    return MutableLong::new;
                }

                public BiConsumer<MutableLong, Function<Selectable<Long>, Long>> aggregator() {
                    return (modifiableInt, selectableObjectFunction) -> {
                        Long apply = (Long)selectableObjectFunction.apply(countSelectable.get());
                        modifiableInt.reset(apply.longValue());
                    };
                }

                public Function<MutableLong, Long> finisher() {
                    return MutableLong::getValue;
                }
            });
        };
    }
}

