/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.onetoone;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.stalactite.engine.cascade.BeforeDeleteByIdSupport;
import org.codefilarete.stalactite.engine.cascade.BeforeDeleteSupport;
import org.codefilarete.stalactite.engine.listener.DeleteListener;
import org.codefilarete.stalactite.engine.listener.InsertListener;
import org.codefilarete.stalactite.engine.listener.UpdateListener;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.engine.runtime.onetoone.AbstractOneToOneEngine;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.IdMapping;
import org.codefilarete.stalactite.mapping.Mapping;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.PreparedUpdate;
import org.codefilarete.stalactite.sql.statement.SQLStatement;
import org.codefilarete.stalactite.sql.statement.WriteOperation;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.collection.Collections;
import org.codefilarete.tool.collection.IdentityMap;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.function.Predicates;

public class OneToOneOwnedByTargetEngine<SRC, TRGT, SRCID, TRGTID, LEFTTABLE extends Table<LEFTTABLE>, RIGHTTABLE extends Table<RIGHTTABLE>>
extends AbstractOneToOneEngine<SRC, TRGT, SRCID, TRGTID, LEFTTABLE, RIGHTTABLE> {
    private final ThreadLocal<TargetToSourceRelationStorage> currentTargetToSourceRelationStorage = new ThreadLocal();

    public OneToOneOwnedByTargetEngine(ConfiguredPersister<SRC, SRCID> sourcePersister, ConfiguredPersister<TRGT, TRGTID> targetPersister, Accessor<SRC, TRGT> targetAccessor, Map<Column<LEFTTABLE, ?>, Column<RIGHTTABLE, ?>> keyColumnsMapping) {
        super(sourcePersister, targetPersister, targetAccessor, keyColumnsMapping);
    }

    protected void ensureRelationStorageContext() {
        if (this.giveRelationStorageContext() == null) {
            this.currentTargetToSourceRelationStorage.set(new TargetToSourceRelationStorage());
        }
    }

    protected TargetToSourceRelationStorage giveRelationStorageContext() {
        return this.currentTargetToSourceRelationStorage.get();
    }

    protected void clearRelationStorageContext() {
        this.currentTargetToSourceRelationStorage.remove();
    }

    @Override
    public void addInsertCascade() {
        Collector identitySetProvider = Collectors.toCollection(Collections::newIdentitySet);
        final Consumer<Iterable> persistTargetCascader = entities -> this.targetPersister.persist((Iterable)Iterables.stream((Iterable)entities).map(arg_0 -> ((Accessor)this.targetAccessor).get(arg_0)).filter(Objects::nonNull).collect(identitySetProvider));
        this.sourcePersister.addInsertListener(new InsertListener<SRC>(){

            public void afterInsert(Iterable<? extends SRC> entities) {
                OneToOneOwnedByTargetEngine.this.ensureRelationStorageContext();
                for (Object sourceEntity : entities) {
                    OneToOneOwnedByTargetEngine.this.giveRelationStorageContext().add(OneToOneOwnedByTargetEngine.this.targetAccessor.get(sourceEntity), sourceEntity);
                }
                persistTargetCascader.accept(entities);
                OneToOneOwnedByTargetEngine.this.clearRelationStorageContext();
            }

            public void onInsertError(Iterable<? extends SRC> entities, RuntimeException runtimeException) {
                OneToOneOwnedByTargetEngine.this.clearRelationStorageContext();
            }
        });
        this.targetPersister.getMapping().addShadowColumnInsert(new Mapping.ShadowColumnValueProvider<TRGT, RIGHTTABLE>(){

            public Set<Column<RIGHTTABLE, ?>> getColumns() {
                return new HashSet(OneToOneOwnedByTargetEngine.this.keyColumnsMapping.values());
            }

            public Map<Column<RIGHTTABLE, ?>, ?> giveValue(TRGT bean) {
                OneToOneOwnedByTargetEngine.this.ensureRelationStorageContext();
                Object srcid = OneToOneOwnedByTargetEngine.this.giveRelationStorageContext().giveSourceId(bean);
                Map columnValues = OneToOneOwnedByTargetEngine.this.sourcePersister.getMapping().getIdMapping().getIdentifierAssembler().getColumnValues(srcid);
                return Maps.innerJoin((Map)OneToOneOwnedByTargetEngine.this.keyColumnsMapping, (Map)columnValues);
            }
        });
    }

    @Override
    public void addUpdateCascade(final boolean orphanRemoval) {
        super.addUpdateCascade(orphanRemoval);
        this.targetPersister.getMapping().addShadowColumnUpdate(new Mapping.ShadowColumnValueProvider<TRGT, RIGHTTABLE>(){

            public Set<Column<RIGHTTABLE, ?>> getColumns() {
                return new HashSet(OneToOneOwnedByTargetEngine.this.keyColumnsMapping.values());
            }

            public Map<Column<RIGHTTABLE, ?>, ?> giveValue(TRGT bean) {
                OneToOneOwnedByTargetEngine.this.ensureRelationStorageContext();
                Object srcid = OneToOneOwnedByTargetEngine.this.giveRelationStorageContext().giveSourceId(bean);
                Map columnValues = OneToOneOwnedByTargetEngine.this.sourcePersister.getMapping().getIdMapping().getIdentifierAssembler().getColumnValues(srcid);
                return Maps.innerJoin((Map)OneToOneOwnedByTargetEngine.this.keyColumnsMapping, (Map)columnValues);
            }
        });
        this.sourcePersister.addUpdateListener(new UpdateListener<SRC>(){

            public void afterUpdate(Iterable<? extends Duo<SRC, SRC>> payloads, boolean allColumnsStatement) {
                OneToOneOwnedByTargetEngine.this.ensureRelationStorageContext();
                final ArrayList newObjects = new ArrayList();
                final ArrayList existingEntities = new ArrayList();
                ArrayList nullifiedRelations = new ArrayList();
                class PersisterHelper {
                    PersisterHelper() {
                    }

                    void markToPersist(TRGT targetOfModified, SRC modifiedSource) {
                        if (OneToOneOwnedByTargetEngine.this.targetPersister.getMapping().isNew(targetOfModified)) {
                            newObjects.add(targetOfModified);
                        } else {
                            existingEntities.add(new Duo(targetOfModified, null));
                        }
                        OneToOneOwnedByTargetEngine.this.giveRelationStorageContext().add(targetOfModified, modifiedSource);
                    }
                }
                PersisterHelper persisterHelper = new PersisterHelper();
                for (Duo payload : payloads) {
                    Object targetOfModified = this.getTarget(payload.getLeft());
                    Object targetOfUnmodified = this.getTarget(payload.getRight());
                    if (targetOfModified == null && targetOfUnmodified != null) {
                        nullifiedRelations.add(targetOfUnmodified);
                        continue;
                    }
                    if (targetOfModified != null && targetOfUnmodified == null) {
                        persisterHelper.markToPersist(targetOfModified, payload.getLeft());
                        continue;
                    }
                    if (targetOfModified == null) continue;
                    persisterHelper.markToPersist(targetOfModified, payload.getLeft());
                    if (OneToOneOwnedByTargetEngine.this.targetPersister.getMapping().getId(targetOfUnmodified).equals(OneToOneOwnedByTargetEngine.this.targetPersister.getMapping().getId(targetOfModified))) continue;
                    nullifiedRelations.add(targetOfUnmodified);
                }
                OneToOneOwnedByTargetEngine.this.targetPersister.insert(newObjects);
                OneToOneOwnedByTargetEngine.this.targetPersister.update(existingEntities, allColumnsStatement);
                if (!orphanRemoval) {
                    OneToOneOwnedByTargetEngine.this.targetPersister.updateById(nullifiedRelations);
                }
                OneToOneOwnedByTargetEngine.this.clearRelationStorageContext();
            }

            private TRGT getTarget(SRC src) {
                return src == null ? null : OneToOneOwnedByTargetEngine.this.targetAccessor.get(src);
            }

            public void onUpdateError(Iterable<? extends SRC> entities, RuntimeException runtimeException) {
                OneToOneOwnedByTargetEngine.this.clearRelationStorageContext();
            }
        });
    }

    @Override
    public void addDeleteCascade(boolean orphanRemoval) {
        if (orphanRemoval) {
            Predicate<Object> deletionPredicate = ((Predicate<Object>)Objects::nonNull).and(Predicates.not(arg_0 -> ((IdMapping)this.targetPersister.getMapping().getIdMapping()).isNew(arg_0)));
            this.sourcePersister.addDeleteListener(new BeforeDeleteSupport<Object, Object>(arg_0 -> ((ConfiguredPersister)this.targetPersister).delete(arg_0), arg_0 -> ((Accessor)this.targetAccessor).get(arg_0), deletionPredicate));
            this.sourcePersister.addDeleteByIdListener(new BeforeDeleteByIdSupport<Object, Object>(arg_0 -> ((ConfiguredPersister)this.targetPersister).delete(arg_0), arg_0 -> ((Accessor)this.targetAccessor).get(arg_0), deletionPredicate));
        } else {
            this.sourcePersister.addDeleteListener((DeleteListener)new NullifyRelationColumnBeforeDelete(this.targetAccessor, this.targetPersister));
        }
    }

    public void addForeignKeyMaintainer(Dialect dialect, ConnectionConfiguration connectionConfiguration, Key<RIGHTTABLE, SRCID> rightKey) {
        final ForeignKeyUpdateOrderProvider foreignKeyUpdateOrderProvider = new ForeignKeyUpdateOrderProvider(dialect, connectionConfiguration, rightKey);
        this.sourcePersister.getPersisterListener().addInsertListener(new InsertListener<SRC>(){

            public void afterInsert(Iterable<? extends SRC> entities) {
                WriteOperation upwhereColumnWriteOperation = foreignKeyUpdateOrderProvider.getOperation();
                foreignKeyUpdateOrderProvider.addValuesToUpdateBatch(entities, arg_0 -> ((ConfiguredPersister)OneToOneOwnedByTargetEngine.this.sourcePersister).getId(arg_0), OneToOneOwnedByTargetEngine.this.sourcePersister.getMapping().getIdMapping().getIdentifierAssembler(), Function.identity(), upwhereColumnWriteOperation);
                upwhereColumnWriteOperation.executeBatch();
            }
        });
        this.sourcePersister.getPersisterListener().addUpdateListener(new UpdateListener<SRC>(){

            public void afterUpdate(Iterable<? extends Duo<SRC, SRC>> entities, boolean allColumnsStatement) {
                WriteOperation upwhereColumnWriteOperation = foreignKeyUpdateOrderProvider.getOperation();
                foreignKeyUpdateOrderProvider.addValuesToUpdateBatch(entities, duo -> OneToOneOwnedByTargetEngine.this.sourcePersister.getId(duo.getLeft()), OneToOneOwnedByTargetEngine.this.sourcePersister.getMapping().getIdMapping().getIdentifierAssembler(), Duo::getLeft, upwhereColumnWriteOperation);
                foreignKeyUpdateOrderProvider.addValuesToUpdateBatch(entities, duo -> null, OneToOneOwnedByTargetEngine.this.sourcePersister.getMapping().getIdMapping().getIdentifierAssembler(), Duo::getRight, upwhereColumnWriteOperation);
                upwhereColumnWriteOperation.executeBatch();
            }
        });
        this.sourcePersister.getPersisterListener().addDeleteListener(new DeleteListener<SRC>(){

            public void beforeDelete(Iterable<? extends SRC> entities) {
                WriteOperation upwhereColumnWriteOperation = foreignKeyUpdateOrderProvider.getOperation();
                foreignKeyUpdateOrderProvider.addValuesToUpdateBatch(entities, duo -> null, OneToOneOwnedByTargetEngine.this.sourcePersister.getMapping().getIdMapping().getIdentifierAssembler(), Function.identity(), upwhereColumnWriteOperation);
                upwhereColumnWriteOperation.executeBatch();
            }
        });
    }

    private class ForeignKeyUpdateOrderProvider {
        private final WriteOperation<Mapping.UpwhereColumn<RIGHTTABLE>> foreignKeyUpdateOperation;

        public ForeignKeyUpdateOrderProvider(Dialect dialect, ConnectionConfiguration connectionConfiguration, Key<RIGHTTABLE, SRCID> rightKey) {
            PreparedUpdate tablePreparedUpdate = dialect.getDmlGenerator().buildUpdate((Iterable)rightKey.getColumns(), OneToOneOwnedByTargetEngine.this.targetPersister.getMapping().getVersionedKeys());
            this.foreignKeyUpdateOperation = dialect.getWriteOperationFactory().createInstance((SQLStatement)tablePreparedUpdate, connectionConfiguration.getConnectionProvider());
        }

        private WriteOperation<Mapping.UpwhereColumn<RIGHTTABLE>> getOperation() {
            return this.foreignKeyUpdateOperation;
        }

        private <C> void addValuesToUpdateBatch(Iterable<? extends C> entities, Function<C, SRCID> idProvider, IdentifierAssembler<SRCID, LEFTTABLE> identifierAssembler, Function<C, SRC> sourceProvider, WriteOperation<Mapping.UpwhereColumn<RIGHTTABLE>> updateOrder) {
            HashMap values = new HashMap();
            entities.forEach(e -> {
                Map columnValues = Maps.innerJoin((Map)OneToOneOwnedByTargetEngine.this.keyColumnsMapping, (Map)identifierAssembler.getColumnValues(idProvider.apply(e)));
                columnValues.forEach((key, value) -> values.put(new Mapping.UpwhereColumn(key, true), value));
                OneToOneOwnedByTargetEngine.this.targetPersister.getMapping().getVersionedKeyValues(OneToOneOwnedByTargetEngine.this.targetAccessor.get(sourceProvider.apply(e))).forEach((c, o) -> values.put(new Mapping.UpwhereColumn(c, false), o));
                updateOrder.addBatch(values);
                values.clear();
            });
        }
    }

    private class NullifyRelationColumnBeforeDelete
    implements DeleteListener<SRC> {
        private final ConfiguredPersister<TRGT, TRGTID> targetPersister;
        private final Accessor<SRC, TRGT> targetEntityProvider;

        private NullifyRelationColumnBeforeDelete(Accessor<SRC, TRGT> targetEntityProvider, ConfiguredPersister<TRGT, TRGTID> targetPersister) {
            this.targetPersister = targetPersister;
            this.targetEntityProvider = targetEntityProvider;
        }

        public void beforeDelete(Iterable<? extends SRC> entities) {
            OneToOneOwnedByTargetEngine.this.ensureRelationStorageContext();
            List targetEntities = Iterables.stream(entities).map(this::getTarget).filter(Objects::nonNull).peek(trgt -> OneToOneOwnedByTargetEngine.this.giveRelationStorageContext().add(trgt, null)).collect(Collectors.toList());
            this.targetPersister.updateById(targetEntities);
            OneToOneOwnedByTargetEngine.this.clearRelationStorageContext();
        }

        private TRGT getTarget(SRC src) {
            Object target = this.targetEntityProvider.get(src);
            return target != null && !this.targetPersister.getMapping().getIdMapping().isNew(target) ? target : null;
        }
    }

    private class TargetToSourceRelationStorage {
        private final IdentityMap<TRGT, SRC> store = new IdentityMap();

        TargetToSourceRelationStorage() {
        }

        private void add(TRGT target, SRC source) {
            this.store.put(target, source);
        }

        private SRC get(TRGT target) {
            return this.store.get(target);
        }

        private SRCID giveSourceId(TRGT trgt) {
            return Nullable.nullable(this.get(trgt)).map(arg_0 -> ((EntityMapping)OneToOneOwnedByTargetEngine.this.sourcePersister.getMapping()).getId(arg_0)).get();
        }
    }
}

