/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.sql.statement.ExpandableSQL;
import org.codefilarete.stalactite.sql.statement.SQLParameterParser;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class ExpandableSQLTest {
    private static SQLParameterParser.Parameter paramB = new SQLParameterParser.Parameter("B");
    private static SQLParameterParser.Parameter paramC = new SQLParameterParser.Parameter("C");

    public static Object[][] testExpandableParameters_data() {
        return new Object[][]{{Arrays.asList((Object[])new Object[]{"select a from Toto where b = ", paramB, " and c = ", paramC}), Maps.asMap((Object)"B", (Object)18).add((Object)"C", (Object)23), "select a from Toto where b = ? and c = ?", Maps.asMap((Object)"B", (Object)Arrays.asList((Object[])new Integer[]{1})).add((Object)"C", (Object)Arrays.asList((Object[])new Integer[]{2}))}, {Arrays.asList((Object[])new Object[]{"select a from Toto where b = ", paramB, " and c = ", paramC}), Maps.asMap((Object)"B", (Object)Arrays.asList((Object[])new Integer[]{20, 30, 40})).add((Object)"C", (Object)23), "select a from Toto where b = ?, ?, ? and c = ?", Maps.asMap((Object)"B", (Object)Arrays.asList((Object[])new Integer[]{1, 2, 3})).add((Object)"C", (Object)Arrays.asList((Object[])new Integer[]{4}))}, {Arrays.asList((Object[])new Object[]{"select a from Toto where b = ", paramB, " and c = ", paramC, " and b = ", paramB}), Maps.asMap((Object)"B", (Object)Arrays.asList((Object[])new Integer[]{20, 30, 40})).add((Object)"C", (Object)17), "select a from Toto where b = ?, ?, ? and c = ? and b = ?, ?, ?", Maps.asMap((Object)"B", (Object)Arrays.asList((Object[])new Integer[]{1, 2, 3, 5, 6, 7})).add((Object)"C", (Object)Arrays.asList((Object[])new Integer[]{4}))}, {Arrays.asList((Object[])new Object[]{"select a from Toto where b = ", paramB, " and c = ", paramC, " and b = ", paramB, " and c = ", paramC}), Maps.asMap((Object)"B", (Object)Arrays.asList((Object[])new Integer[]{20, 30, 40})).add((Object)"C", (Object)Arrays.asList((Object[])new Integer[]{17, 23})), "select a from Toto where b = ?, ?, ? and c = ?, ? and b = ?, ?, ? and c = ?, ?", Maps.asMap((Object)"B", (Object)Arrays.asList((Object[])new Integer[]{1, 2, 3, 6, 7, 8})).add((Object)"C", (Object)Arrays.asList((Object[])new Integer[]{4, 5, 9, 10}))}, {Arrays.asList((Object[])new Object[]{"select a from Toto where b = ", paramB, " and b = ", paramB, " and c = ", paramC}), Maps.asMap((Object)"B", (Object)Arrays.asList((Object[])new Integer[]{20, 30, 40})).add((Object)"C", (Object)Arrays.asList((Object[])new Integer[]{17, 23})), "select a from Toto where b = ?, ?, ? and b = ?, ?, ? and c = ?, ?", Maps.asMap((Object)"B", (Object)Arrays.asList((Object[])new Integer[]{1, 2, 3, 4, 5, 6})).add((Object)"C", (Object)Arrays.asList((Object[])new Integer[]{7, 8}))}, {Arrays.asList((Object[])new Object[]{"select a from Toto where c = ", paramC, " and b = ", paramB, " and b = ", paramB}), Maps.asMap((Object)"B", (Object)Arrays.asList((Object[])new Integer[]{20, 30, 40})).add((Object)"C", (Object)Arrays.asList((Object[])new Integer[]{17, 23})), "select a from Toto where c = ?, ? and b = ?, ?, ? and b = ?, ?, ?", Maps.asMap((Object)"B", (Object)Arrays.asList((Object[])new Integer[]{3, 4, 5, 6, 7, 8})).add((Object)"C", (Object)Arrays.asList((Object[])new Integer[]{1, 2}))}};
    }

    @ParameterizedTest
    @MethodSource(value={"testExpandableParameters_data"})
    public void testExpandableParameters(List<Object> sqlSnippets, Map<String, Object> values, String expectedPreparedSql, Map<String, Iterable<Integer>> expectedIndexedValues) {
        HashMap<String, SQLParameterParser.Parameter> params = new HashMap<String, SQLParameterParser.Parameter>();
        for (Object sqlSnippet : sqlSnippets) {
            if (!(sqlSnippet instanceof SQLParameterParser.Parameter)) continue;
            params.put(((SQLParameterParser.Parameter)sqlSnippet).getName(), (SQLParameterParser.Parameter)sqlSnippet);
        }
        SQLParameterParser.ParsedSQL parsedSQL = new SQLParameterParser.ParsedSQL(sqlSnippets, params);
        ExpandableSQL testInstance = new ExpandableSQL(parsedSQL, ExpandableSQL.sizes(values));
        Assertions.assertThat((String)testInstance.getPreparedSQL()).isEqualTo(expectedPreparedSql);
        List expectedParams = Arrays.asList((Object[])new SQLParameterParser.Parameter[]{paramB, paramC});
        for (SQLParameterParser.Parameter expectedParam : expectedParams) {
            ExpandableSQL.ExpandableParameter expandableParameter = (ExpandableSQL.ExpandableParameter)testInstance.getExpandableParameters().get(expectedParam.getName());
            int i = 0;
            for (Integer expectedIndex : expectedIndexedValues.get(expectedParam.getName())) {
                Assertions.assertThat((int)expandableParameter.getMarkIndexes()[i++]).isEqualTo(expectedIndex.intValue());
            }
        }
    }
}

