/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.dsl.MappingEase;
import org.codefilarete.stalactite.dsl.embeddable.EmbeddableMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.embeddable.FluentEmbeddableMappingBuilder;
import org.codefilarete.stalactite.dsl.embeddable.FluentEmbeddableMappingBuilderOneToManyOptions;
import org.codefilarete.stalactite.dsl.embeddable.FluentEmbeddableMappingBuilderOneToOneOptions;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.entity.FluentEntityMappingBuilder;
import org.codefilarete.stalactite.dsl.property.CascadeOptions;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.JdbcForeignKey;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.model.City;
import org.codefilarete.stalactite.engine.model.Country;
import org.codefilarete.stalactite.engine.model.device.Address;
import org.codefilarete.stalactite.engine.model.device.Device;
import org.codefilarete.stalactite.engine.model.device.Location;
import org.codefilarete.stalactite.engine.model.device.Review;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialectBuilder;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class FluentEmbeddableWithRelationMappingConfigurationSupportTest {
    private final Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
    private final DataSource dataSource = new HSQLDBInMemoryDataSource();
    private PersistenceContext persistenceContext;

    @BeforeEach
    public void initTest() {
        this.dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        this.dialect.getSqlTypeRegistry().put(Identifier.class, "int");
        this.persistenceContext = new PersistenceContext(this.dataSource, this.dialect);
    }

    @Nested
    class OneToMany_Embedded {
        OneToMany_Embedded() {
        }

        @Test
        void foreignKeyIsCreated() {
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions reviewConfiguration = MappingEase.entityBuilder(Review.class, Identifier.LONG_TYPE).mapKey(Review::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Review::getRanking).mandatory();
            FluentEmbeddableMappingBuilderOneToManyOptions locationMappingBuilder = MappingEase.embeddableBuilder(Location.class).mapOneToMany(Location::getReviews, (EntityMappingConfigurationProvider)reviewConfiguration);
            EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).embed(Device::setLocation, (EmbeddableMappingConfigurationProvider)locationMappingBuilder).build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            Map tablePerName = Iterables.map((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext), Table::getName);
            JdbcForeignKey expectedForeignKey1 = new JdbcForeignKey("FK_Device_location_reviews_location_reviews_id_Review_id", "Device_location_reviews", "location_reviews_id", "Review", "id");
            JdbcForeignKey expectedForeignKey2 = new JdbcForeignKey("FK_Device_location_reviews_device_id_Device_id", "Device_location_reviews", "device_id", "Device", "id");
            Comparator<JdbcForeignKey> comparing = Comparator.comparing(JdbcForeignKey::getSignature, Comparator.naturalOrder());
            Assertions.assertThat((Collection)((Table)tablePerName.get("Device_location_reviews")).getForeignKeys()).extracting(JdbcForeignKey::new).usingElementComparator(comparing).containsExactlyInAnyOrder((Object[])new JdbcForeignKey[]{expectedForeignKey1, expectedForeignKey2});
        }

        @Test
        void foreignKeyIsCreated_mappedBy() {
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions reviewConfiguration = MappingEase.entityBuilder(Review.class, Identifier.LONG_TYPE).mapKey(Review::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Review::getRanking).mandatory();
            FluentEmbeddableMappingBuilderOneToManyOptions locationMappingBuilder = MappingEase.embeddableBuilder(Location.class).mapOneToMany(Location::getReviews, (EntityMappingConfigurationProvider)reviewConfiguration).mappedBy(Review::getLocation);
            EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).embed(Device::setLocation, (EmbeddableMappingConfigurationProvider)locationMappingBuilder).build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            Map tablePerName = Iterables.map((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext), Table::getName);
            Comparator<JdbcForeignKey> comparing = Comparator.comparing(JdbcForeignKey::getSignature, Comparator.naturalOrder());
            Assertions.assertThat((Collection)((Table)tablePerName.get("Device")).getForeignKeys()).isEmpty();
            JdbcForeignKey expectedForeignKey1 = new JdbcForeignKey("FK_Review_location_locationId_Device_id", "Review", "location_locationId", "Device", "id");
            Assertions.assertThat((Collection)((Table)tablePerName.get("Review")).getForeignKeys()).extracting(JdbcForeignKey::new).usingElementComparator(comparing).containsExactlyInAnyOrder((Object[])new JdbcForeignKey[]{expectedForeignKey1});
        }

        @Test
        void mappedByGetter_crud() {
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions reviewConfiguration = MappingEase.entityBuilder(Review.class, Identifier.LONG_TYPE).mapKey(Review::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Review::getRanking).mandatory();
            FluentEmbeddableMappingBuilder locationMappingBuilder = MappingEase.embeddableBuilder(Address.class).map(Address::getStreet).mapSuperClass((EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Location.class).mapOneToMany(Location::getReviews, (EntityMappingConfigurationProvider)reviewConfiguration).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).mappedBy(Review::getLocation));
            EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).embed(Device::setLocation, (EmbeddableMappingConfigurationProvider)locationMappingBuilder).build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            EntityPersister reviewPersister = reviewConfiguration.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            Device dummyDevice = new Device(13L);
            dummyDevice.setName("UPS");
            Address address = new Address();
            address.setStreet("221B Baker Street");
            address.setReviews(Arrays.asHashSet((Object[])new Review[]{new Review(1L), new Review(2L), new Review(3L)}));
            dummyDevice.setLocation(address);
            devicePersister.insert((Object)dummyDevice);
            Device loadedDevice = (Device)devicePersister.select(dummyDevice.getId());
            Assertions.assertThat((Object)loadedDevice).usingRecursiveComparison().ignoringFields(new String[]{"location.reviews.location"}).isEqualTo((Object)dummyDevice);
            Assertions.assertThat((Collection)loadedDevice.getLocation().getReviews().stream().map(Review::getLocation).collect(Collectors.toSet())).containsOnly((Object[])new Location[]{loadedDevice.getLocation()});
            address.getReviews().add(new Review(4L));
            devicePersister.update((Object)dummyDevice);
            loadedDevice = (Device)devicePersister.select(dummyDevice.getId());
            Assertions.assertThat((Object)loadedDevice).usingRecursiveComparison().ignoringFields(new String[]{"location.reviews.location"}).isEqualTo((Object)dummyDevice);
            Assertions.assertThat((Collection)loadedDevice.getLocation().getReviews().stream().map(Review::getLocation).collect(Collectors.toSet())).containsOnly((Object[])new Location[]{loadedDevice.getLocation()});
            devicePersister.delete((Object)dummyDevice);
            Assertions.assertThat((Object)devicePersister.select(dummyDevice.getId())).isNull();
            Assertions.assertThat((Collection)reviewPersister.select((Iterable)address.getReviews().stream().map(Review::getId).collect(Collectors.toSet()))).isEmpty();
        }

        @Test
        void mappedBySetter_crud() {
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions reviewConfiguration = MappingEase.entityBuilder(Review.class, Identifier.LONG_TYPE).mapKey(Review::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Review::getRanking).mandatory();
            FluentEmbeddableMappingBuilderOneToManyOptions locationMappingBuilder = MappingEase.embeddableBuilder(Address.class).map(Address::getStreet).mapOneToMany(Location::getReviews, (EntityMappingConfigurationProvider)reviewConfiguration).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).mappedBy(Review::setLocation);
            EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).embed(Device::setLocation, (EmbeddableMappingConfigurationProvider)locationMappingBuilder).build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            EntityPersister reviewPersister = reviewConfiguration.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            Device dummyDevice = new Device(13L);
            dummyDevice.setName("UPS");
            Address address = new Address();
            address.setStreet("221B Baker Street");
            address.setReviews(Arrays.asHashSet((Object[])new Review[]{new Review(1L), new Review(2L), new Review(3L)}));
            dummyDevice.setLocation(address);
            devicePersister.insert((Object)dummyDevice);
            Device loadedDevice = (Device)devicePersister.select(dummyDevice.getId());
            Assertions.assertThat((Object)loadedDevice).usingRecursiveComparison().ignoringFields(new String[]{"location.reviews.location"}).isEqualTo((Object)dummyDevice);
            Assertions.assertThat((Collection)loadedDevice.getLocation().getReviews().stream().map(Review::getLocation).collect(Collectors.toSet())).containsOnly((Object[])new Location[]{loadedDevice.getLocation()});
            address.getReviews().add(new Review(4L));
            devicePersister.update((Object)dummyDevice);
            loadedDevice = (Device)devicePersister.select(dummyDevice.getId());
            Assertions.assertThat((Object)loadedDevice).usingRecursiveComparison().ignoringFields(new String[]{"location.reviews.location"}).isEqualTo((Object)dummyDevice);
            Assertions.assertThat((Collection)loadedDevice.getLocation().getReviews().stream().map(Review::getLocation).collect(Collectors.toSet())).containsOnly((Object[])new Location[]{loadedDevice.getLocation()});
            devicePersister.delete((Object)dummyDevice);
            Assertions.assertThat((Object)devicePersister.select(dummyDevice.getId())).isNull();
            Assertions.assertThat((Collection)reviewPersister.select((Iterable)address.getReviews().stream().map(Review::getId).collect(Collectors.toSet()))).isEmpty();
        }
    }

    @Nested
    class OneToMany_MappedSuperClass {
        OneToMany_MappedSuperClass() {
        }

        @Test
        void foreignKeyIsCreated() {
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions reviewConfiguration = MappingEase.entityBuilder(Review.class, Identifier.LONG_TYPE).mapKey(Review::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Review::getRanking).mandatory();
            FluentEmbeddableMappingBuilderOneToManyOptions locationMappingBuilder = MappingEase.embeddableBuilder(Location.class).mapOneToMany(Location::getReviews, (EntityMappingConfigurationProvider)reviewConfiguration).mappedBy(Review::getLocation);
            FluentEntityMappingBuilder addressMappingBuilder = MappingEase.entityBuilder(Address.class, Identifier.LONG_TYPE).mapKey(Location::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Address::getStreet).mandatory().mapOneToOne(Address::getCity, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName).mandatory()).mapSuperClass((EmbeddableMappingConfigurationProvider)locationMappingBuilder);
            addressMappingBuilder.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            Map tablePerName = Iterables.map((Iterable)DDLDeployer.collectTables((PersistenceContext)FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext), Table::getName);
            JdbcForeignKey expectedForeignKey1 = new JdbcForeignKey("FK_Address_cityId_City_id", "Address", "cityId", "City", "id");
            Comparator<JdbcForeignKey> comparing = Comparator.comparing(JdbcForeignKey::getSignature, Comparator.naturalOrder());
            Assertions.assertThat((Collection)((Table)tablePerName.get("Address")).getForeignKeys()).extracting(JdbcForeignKey::new).usingElementComparator(comparing).containsExactlyInAnyOrder((Object[])new JdbcForeignKey[]{expectedForeignKey1});
            JdbcForeignKey expectedForeignKey2 = new JdbcForeignKey("FK_Review_locationId_Address_id", "Review", "locationId", "Address", "id");
            Assertions.assertThat((Collection)((Table)tablePerName.get("Review")).getForeignKeys()).extracting(JdbcForeignKey::new).usingElementComparator(comparing).containsExactlyInAnyOrder((Object[])new JdbcForeignKey[]{expectedForeignKey2});
        }

        @Test
        void crud() {
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions reviewConfiguration = MappingEase.entityBuilder(Review.class, Identifier.LONG_TYPE).mapKey(Review::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Review::getRanking).mandatory();
            FluentEmbeddableMappingBuilderOneToManyOptions locationMappingBuilder = MappingEase.embeddableBuilder(Location.class).mapOneToMany(Location::getReviews, (EntityMappingConfigurationProvider)reviewConfiguration).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).mappedBy(Review::getLocation);
            FluentEntityMappingBuilder addressMappingBuilder = MappingEase.entityBuilder(Address.class, Identifier.LONG_TYPE).mapKey(Location::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Address::getStreet).mandatory().mapOneToOne(Address::getCity, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName).mandatory()).mapSuperClass((EmbeddableMappingConfigurationProvider)locationMappingBuilder);
            EntityPersister addressPersister = addressMappingBuilder.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            ConfiguredPersister reviewPersister = (ConfiguredPersister)reviewConfiguration.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            Address address = new Address(42L);
            address.setStreet("221B Baker Street");
            City city = new City(111L);
            city.setName("Grenoble");
            address.setCity(city);
            address.setReviews(Arrays.asHashSet((Object[])new Review[]{new Review(1L), new Review(2L), new Review(3L)}));
            addressPersister.insert((Object)address);
            Address loadedAddress = (Address)addressPersister.select(address.getId());
            Assertions.assertThat((Object)loadedAddress).usingRecursiveComparison().ignoringFields(new String[]{"reviews.location"}).isEqualTo((Object)address);
            Assertions.assertThat((Collection)loadedAddress.getReviews().stream().map(Review::getLocation).collect(Collectors.toSet())).containsOnly((Object[])new Location[]{loadedAddress});
            address.getReviews().add(new Review(4L));
            addressPersister.update((Object)address);
            loadedAddress = (Address)addressPersister.select(address.getId());
            Assertions.assertThat((Object)loadedAddress).usingRecursiveComparison().ignoringFields(new String[]{"reviews.location"}).isEqualTo((Object)address);
            Assertions.assertThat((Collection)loadedAddress.getReviews().stream().map(Review::getLocation).collect(Collectors.toSet())).containsOnly((Object[])new Location[]{loadedAddress});
            addressPersister.delete((Object)address);
            Assertions.assertThat((Collection)reviewPersister.select((Iterable)address.getReviews().stream().map(Review::getId).collect(Collectors.toSet()))).isEmpty();
        }
    }

    @Nested
    class OneToOne_Embedded {
        OneToOne_Embedded() {
        }

        @Test
        void foreignKeyIsCreated() {
            FluentEmbeddableMappingBuilderOneToOneOptions addressMappingBuilder = MappingEase.embeddableBuilder(Address.class).map(Address::getStreet).mapOneToOne(Address::getCity, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName).mandatory());
            EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).embed(Device::setLocation, (EmbeddableMappingConfigurationProvider)addressMappingBuilder).build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            ConfiguredPersister addressPersister = (ConfiguredPersister)devicePersister;
            JdbcForeignKey expectedForeignKey1 = new JdbcForeignKey("FK_Device_location_cityId_City_id", "Device", "location_cityId", "City", "id");
            Comparator<JdbcForeignKey> comparing = Comparator.comparing(JdbcForeignKey::getSignature, Comparator.naturalOrder());
            Assertions.assertThat((Collection)addressPersister.getMapping().getTargetTable().getForeignKeys()).extracting(JdbcForeignKey::new).usingElementComparator(comparing).containsExactlyInAnyOrder((Object[])new JdbcForeignKey[]{expectedForeignKey1});
        }

        @Test
        void crud() {
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions cityConfiguration = MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName).mandatory();
            EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).embed(Device::setLocation, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Address.class).map(Address::getStreet).mapOneToOne(Address::getCity, (EntityMappingConfigurationProvider)cityConfiguration).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL)).build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            EntityPersister cityPersister = cityConfiguration.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Device dummyDevice = new Device(13L);
            dummyDevice.setName("UPS");
            Address address = new Address();
            address.setStreet("221B Baker Street");
            City city = new City(111L);
            city.setName("France");
            address.setCity(city);
            dummyDevice.setLocation(address);
            devicePersister.insert((Object)dummyDevice);
            Device loadedDevice = (Device)devicePersister.select(dummyDevice.getId());
            Assertions.assertThat((Object)loadedDevice).usingRecursiveComparison().isEqualTo((Object)dummyDevice);
            City city1 = new City(22L);
            city1.setName("Spain");
            address.setCity(city1);
            devicePersister.update((Object)dummyDevice);
            loadedDevice = (Device)devicePersister.select(dummyDevice.getId());
            Assertions.assertThat((Object)loadedDevice).usingRecursiveComparison().isEqualTo((Object)dummyDevice);
            devicePersister.delete((Object)dummyDevice);
            Assertions.assertThat((Object)devicePersister.select(dummyDevice.getId())).isNull();
            Assertions.assertThat((Object)cityPersister.select(city1.getId())).isNull();
        }
    }

    @Nested
    class OneToOne_MappedSuperClass {
        OneToOne_MappedSuperClass() {
        }

        @Test
        void foreignKeyIsCreated() {
            FluentEmbeddableMappingBuilderOneToOneOptions locationMappingBuilder = MappingEase.embeddableBuilder(Location.class).mapOneToOne(Location::getCountry, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).mandatory());
            FluentEntityMappingBuilder addressMappingBuilder = MappingEase.entityBuilder(Address.class, Identifier.LONG_TYPE).mapKey(Location::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Address::getStreet).mandatory().mapOneToOne(Address::getCity, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName).mandatory()).mapSuperClass((EmbeddableMappingConfigurationProvider)locationMappingBuilder);
            ConfiguredPersister addressPersister = (ConfiguredPersister)addressMappingBuilder.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            JdbcForeignKey expectedForeignKey1 = new JdbcForeignKey("FK_Address_cityId_City_id", "Address", "cityId", "City", "id");
            JdbcForeignKey expectedForeignKey2 = new JdbcForeignKey("FK_Address_countryId_Country_id", "Address", "countryId", "Country", "id");
            Comparator<JdbcForeignKey> comparing = Comparator.comparing(JdbcForeignKey::getSignature, Comparator.naturalOrder());
            Assertions.assertThat((Collection)addressPersister.getMapping().getTargetTable().getForeignKeys()).extracting(JdbcForeignKey::new).usingElementComparator(comparing).containsExactlyInAnyOrder((Object[])new JdbcForeignKey[]{expectedForeignKey1, expectedForeignKey2});
        }

        @Test
        void crud() {
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions countryConfiguration = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).mandatory();
            FluentEmbeddableMappingBuilderOneToOneOptions locationMappingBuilder = MappingEase.embeddableBuilder(Location.class).mapOneToOne(Location::getCountry, (EntityMappingConfigurationProvider)countryConfiguration).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL);
            FluentEntityMappingBuilder addressMappingBuilder = MappingEase.entityBuilder(Address.class, Identifier.LONG_TYPE).mapKey(Location::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Address::getStreet).mandatory().mapOneToOne(Address::getCity, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName).mandatory()).mapSuperClass((EmbeddableMappingConfigurationProvider)locationMappingBuilder);
            EntityPersister countryPersister = countryConfiguration.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            ConfiguredPersister addressPersister = (ConfiguredPersister)addressMappingBuilder.build(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEmbeddableWithRelationMappingConfigurationSupportTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Address address = new Address(42L);
            address.setStreet("221B Baker Street");
            Country country = new Country(11L);
            country.setName("France");
            address.setCountry(country);
            City city = new City(111L);
            city.setName("Grenoble");
            address.setCity(city);
            addressPersister.insert((Object)address);
            Address loadedAddress = (Address)addressPersister.select(address.getId());
            Assertions.assertThat((Object)loadedAddress).usingRecursiveComparison().isEqualTo((Object)address);
            Country country1 = new Country(22L);
            country1.setName("France");
            address.setCountry(country1);
            addressPersister.update((Object)address);
            loadedAddress = (Address)addressPersister.select(address.getId());
            Assertions.assertThat((Object)loadedAddress).usingRecursiveComparison().isEqualTo((Object)address);
            addressPersister.delete((Object)address);
            Assertions.assertThat((Object)addressPersister.select(address.getId())).isNull();
            Assertions.assertThat((Object)countryPersister.select(country1.getId())).isNull();
        }
    }
}

