/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.idprovider;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.CurrentThreadTransactionalConnectionProvider;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.SeparateTransactionExecutor;
import org.codefilarete.stalactite.engine.idprovider.PooledSequenceIdentifierProvider;
import org.codefilarete.stalactite.mapping.id.sequence.hilo.PooledHiLoSequence;
import org.codefilarete.stalactite.mapping.id.sequence.hilo.PooledHiLoSequenceOptions;
import org.codefilarete.stalactite.mapping.id.sequence.hilo.PooledHiLoSequencePersister;
import org.codefilarete.stalactite.mapping.id.sequence.hilo.PooledHiLoSequenceStorageOptions;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.HSQLDBDialectBuilder;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.tool.collection.Arrays;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PooledSequenceIdentifierProviderTest {
    private PersistenceContext persistenceContext;

    @BeforeEach
    public void setUp() {
        this.persistenceContext = new PersistenceContext((ConnectionProvider)new CurrentThreadTransactionalConnectionProvider((DataSource)new HSQLDBInMemoryDataSource()), HSQLDBDialectBuilder.defaultHSQLDBDialect());
    }

    @Test
    public void giveNewIdentifier() {
        PooledHiLoSequence sequenceIdentifierGenerator = new PooledHiLoSequence(new PooledHiLoSequenceOptions(10, "Toto", PooledHiLoSequenceStorageOptions.DEFAULT), this.persistenceContext.getDialect(), (SeparateTransactionExecutor)this.persistenceContext.getConnectionProvider(), this.persistenceContext.getJDBCBatchSize());
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.getDdlGenerator().setTables((Set)Arrays.asSet((Object[])new PooledHiLoSequencePersister.SequenceTable[]{(PooledHiLoSequencePersister.SequenceTable)sequenceIdentifierGenerator.getPersister().getMapping().getTargetTable()}));
        ddlDeployer.deployDDL();
        List starterKit = Arrays.asList((Object[])new Long[0]);
        ExecutorService backgroundLoader = Executors.newSingleThreadExecutor();
        PooledSequenceIdentifierProvider testInstance = new PooledSequenceIdentifierProvider((Collection)starterKit, 2, (Executor)backgroundLoader, Duration.ofSeconds(2L), sequenceIdentifierGenerator);
        ArrayList<Long> generated = new ArrayList<Long>();
        ArrayList<Long> expectedGeneration = new ArrayList<Long>();
        for (int i = 1; i < 15; ++i) {
            long persistableIdentifier = (Long)testInstance.giveNewIdentifier();
            generated.add(persistableIdentifier);
            expectedGeneration.add(Long.valueOf(i));
        }
        Assertions.assertThat(generated).isEqualTo(expectedGeneration);
    }
}

