/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.assertj.core.api.Assertions;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByMethodReference;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.MutatorByMethodReference;
import org.codefilarete.reflection.PropertyAccessor;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.dsl.embeddable.EmbeddableMappingConfiguration;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfiguration;
import org.codefilarete.stalactite.dsl.idpolicy.IdentifierPolicy;
import org.codefilarete.stalactite.dsl.naming.ColumnNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.JoinColumnNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.TableNamingStrategy;
import org.codefilarete.stalactite.engine.PersisterRegistry;
import org.codefilarete.stalactite.engine.configurer.EntityMappingConfigurationWithTable;
import org.codefilarete.stalactite.engine.configurer.FluentEmbeddableMappingConfigurationSupport;
import org.codefilarete.stalactite.engine.configurer.builder.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.configurer.onetoone.OneToOneRelation;
import org.codefilarete.stalactite.engine.configurer.onetoone.OneToOneRelationConfigurer;
import org.codefilarete.stalactite.engine.model.City;
import org.codefilarete.stalactite.engine.model.Country;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.SimpleRelationalEntityPersister;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.PersistableIdentifier;
import org.codefilarete.stalactite.id.PersistedIdentifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.mapping.DefaultEntityMapping;
import org.codefilarete.stalactite.mapping.id.manager.AlreadyAssignedIdentifierManager;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.ForeignKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.test.DefaultDialect;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class OneToOneRelationConfigurerTest {
    OneToOneRelationConfigurerTest() {
    }

    @BeforeEach
    void initEntityCandidates() {
        PersisterBuilderContext.CURRENT.set(new PersisterBuilderContext((PersisterRegistry)Mockito.mock(PersisterRegistry.class)));
    }

    @AfterEach
    void removeEntityCandidates() {
        PersisterBuilderContext.CURRENT.remove();
    }

    @Test
    <T extends Table<T>> void tableStructure_associationTable() throws SQLException {
        Table countryTable = new Table("country");
        Column countryTableIdColumn = countryTable.addColumn("id", Long.TYPE).primaryKey();
        Column countryTableNameColumn = countryTable.addColumn("name", String.class);
        Column countryTableCapitalColumn = countryTable.addColumn("capitalId", Identifier.LONG_TYPE);
        Maps.ChainingMap countryMapping = Maps.asMap((Object)new PropertyAccessor((Accessor)new AccessorByMethodReference(Country::getId), (Mutator)Accessors.mutatorByField(Country.class, (String)"id")), (Object)countryTableIdColumn).add((Object)new PropertyAccessor((Accessor)new AccessorByMethodReference(Country::getName), (Mutator)new MutatorByMethodReference(Country::setName)), (Object)countryTableNameColumn).add((Object)new PropertyAccessor((Accessor)new AccessorByMethodReference(Country::getCapital), (Mutator)new MutatorByMethodReference(Country::setCapital)), (Object)countryTableCapitalColumn);
        PropertyAccessor countryIdentifierAccessorByMethodReference = new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Country::getId), (Mutator)Accessors.mutatorByField(Country.class, (String)"id"));
        DefaultEntityMapping countryEntityMappingStrategy = new DefaultEntityMapping(Country.class, countryTable, (Map)countryMapping, (ReversibleAccessor)countryIdentifierAccessorByMethodReference, (IdentifierInsertionManager)new AlreadyAssignedIdentifierManager(Identifier.class, c -> {}, c -> false));
        FluentEmbeddableMappingConfigurationSupport.LinkageSupport identifierLinkage = new FluentEmbeddableMappingConfigurationSupport.LinkageSupport(City::getId);
        identifierLinkage.setField(Reflections.findField(City.class, (String)"id"));
        identifierLinkage.setColumnOptions((FluentEmbeddableMappingConfigurationSupport.LocalColumnLinkageOptions)new FluentEmbeddableMappingConfigurationSupport.ColumnLinkageOptionsSupport("id"));
        FluentEmbeddableMappingConfigurationSupport.LinkageSupport nameLinkage = new FluentEmbeddableMappingConfigurationSupport.LinkageSupport(City::getName);
        nameLinkage.setField(Reflections.findField(City.class, (String)"name"));
        nameLinkage.setColumnOptions((FluentEmbeddableMappingConfigurationSupport.LocalColumnLinkageOptions)new FluentEmbeddableMappingConfigurationSupport.ColumnLinkageOptionsSupport("name"));
        Table cityTable = new Table("city");
        Column cityTableIdColumn = cityTable.addColumn("id", Identifier.class).primaryKey();
        PropertyAccessor cityIdentifierAccessorByMethodReference = new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(City::getId), (Mutator)Accessors.mutatorByField(City.class, (String)"id"));
        EmbeddableMappingConfiguration cityPropertiesMapping = (EmbeddableMappingConfiguration)Mockito.mock(EmbeddableMappingConfiguration.class);
        Mockito.when((Object)cityPropertiesMapping.getBeanType()).thenReturn(City.class);
        Mockito.when((Object)cityPropertiesMapping.getPropertiesMapping()).thenReturn((Object)Arrays.asList((Object[])new EmbeddableMappingConfiguration.Linkage[]{identifierLinkage, nameLinkage}));
        Mockito.when((Object)cityPropertiesMapping.getInsets()).thenReturn(Collections.emptyList());
        Mockito.when((Object)cityPropertiesMapping.getColumnNamingStrategy()).thenReturn((Object)ColumnNamingStrategy.DEFAULT);
        EntityMappingConfiguration cityMappingConfiguration = (EntityMappingConfiguration)Mockito.mock(EntityMappingConfiguration.class);
        Mockito.when((Object)cityMappingConfiguration.getEntityType()).thenReturn(City.class);
        Mockito.when((Object)cityMappingConfiguration.getPropertiesMapping()).thenReturn((Object)cityPropertiesMapping);
        Mockito.when((Object)cityMappingConfiguration.getTableNamingStrategy()).thenReturn((Object)TableNamingStrategy.DEFAULT);
        Mockito.when((Object)cityMappingConfiguration.getKeyMapping()).thenReturn((Object)new EntityMappingConfiguration.SingleKeyMapping<City, Identifier<Long>>((ReversibleAccessor)cityIdentifierAccessorByMethodReference){
            final /* synthetic */ ReversibleAccessor val$cityIdentifierAccessorByMethodReference;
            {
                this.val$cityIdentifierAccessorByMethodReference = reversibleAccessor;
            }

            public IdentifierPolicy<Identifier<Long>> getIdentifierPolicy() {
                return StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED;
            }

            public ReversibleAccessor<City, Identifier<Long>> getAccessor() {
                return this.val$cityIdentifierAccessorByMethodReference;
            }

            @Nullable
            public EntityMappingConfiguration.ColumnLinkageOptions getColumnOptions() {
                return null;
            }

            public boolean isSetByConstructor() {
                return false;
            }
        });
        Mockito.when((Object)cityMappingConfiguration.getOneToOnes()).thenReturn(Collections.emptyList());
        Mockito.when((Object)cityMappingConfiguration.getOneToManys()).thenReturn(Collections.emptyList());
        Mockito.when((Object)cityMappingConfiguration.getManyToManys()).thenReturn(Collections.emptyList());
        Mockito.when((Object)cityMappingConfiguration.inheritanceIterable()).thenAnswer(Mockito.CALLS_REAL_METHODS);
        PropertyAccessor capitalAccessPoint = new PropertyAccessor((Accessor)new AccessorByMethodReference(Country::getCapital), (Mutator)new MutatorByMethodReference(Country::setCapital));
        OneToOneRelation countryCapitalRelation = new OneToOneRelation((ReversibleAccessor)capitalAccessPoint, () -> true, () -> new EntityMappingConfigurationWithTable(cityMappingConfiguration, cityTable));
        DefaultDialect dialect = new DefaultDialect();
        dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        dialect.getSqlTypeRegistry().put(Identifier.class, "int");
        ConnectionConfiguration.ConnectionConfigurationSupport connectionConfiguration = new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)Mockito.mock(ConnectionProvider.class), 10);
        SimpleRelationalEntityPersister countryPersister = new SimpleRelationalEntityPersister(countryEntityMappingStrategy, (Dialect)dialect, (ConnectionConfiguration)connectionConfiguration);
        OneToOneRelationConfigurer testInstance = new OneToOneRelationConfigurer((Dialect)dialect, (ConnectionConfiguration)connectionConfiguration, (ConfiguredRelationalPersister)countryPersister, TableNamingStrategy.DEFAULT, JoinColumnNamingStrategy.JOIN_DEFAULT, ForeignKeyNamingStrategy.DEFAULT, (PersisterBuilderContext)PersisterBuilderContext.CURRENT.get());
        testInstance.configure(countryCapitalRelation);
        Assertions.assertThat(countryTable.mapColumnsOnName().keySet()).isEqualTo((Object)Arrays.asSet((Object[])new String[]{"id", "capitalId", "name"}));
        Assertions.assertThat((Collection)countryTable.getForeignKeys()).extracting(ForeignKey::getName).containsExactlyInAnyOrder((Object[])new String[]{"FK_country_capitalId_city_id"});
        Assertions.assertThat((Object)Iterables.first((Iterable)((ForeignKey)Iterables.first((Iterable)countryTable.getForeignKeys())).getColumns())).isEqualTo((Object)countryTableCapitalColumn);
        Assertions.assertThat((Object)Iterables.first((Iterable)((ForeignKey)Iterables.first((Iterable)countryTable.getForeignKeys())).getTargetColumns())).isEqualTo((Object)cityTableIdColumn);
        Assertions.assertThat(cityTable.mapColumnsOnName().keySet()).isEqualTo((Object)Arrays.asSet((Object[])new String[]{"id", "name"}));
        Assertions.assertThat((Collection)cityTable.getForeignKeys()).extracting(ForeignKey::getName).isEmpty();
        ParameterBinder cityParameterBinder = dialect.getColumnBinderRegistry().getBinder((Object)countryTableCapitalColumn);
        Assertions.assertThat((Object)cityParameterBinder).isNotNull();
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        cityParameterBinder.set(preparedStatementMock, 1, new PersistableIdentifier<Long>(4L));
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).setLong(ArgumentMatchers.eq((int)1), ArgumentMatchers.eq((long)4L));
        ResultSet resultSetMock = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)resultSetMock.getObject(ArgumentMatchers.anyString())).thenReturn(new Object());
        Mockito.when((Object)resultSetMock.getLong(ArgumentMatchers.anyString())).thenReturn((Object)42L);
        Assertions.assertThat((Object)cityParameterBinder.get(resultSetMock, "whateverColumn")).isEqualTo(new PersistedIdentifier<Long>(42L));
    }

    @Test
    <T extends Table<T>> void tableStructure_relationMappedByReverseSide() {
        Table countryTable = new Table("country");
        Column countryTableIdColumn = countryTable.addColumn("id", Long.TYPE).primaryKey();
        Column countryTableNameColumn = countryTable.addColumn("name", String.class);
        Maps.ChainingMap countryMapping = Maps.asMap((Object)new PropertyAccessor((Accessor)new AccessorByMethodReference(Country::getId), (Mutator)Accessors.mutatorByField(Country.class, (String)"id")), (Object)countryTableIdColumn).add((Object)new PropertyAccessor((Accessor)new AccessorByMethodReference(Country::getName), (Mutator)new MutatorByMethodReference(Country::setName)), (Object)countryTableNameColumn);
        PropertyAccessor countryIdentifierAccessorByMethodReference = new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(Country::getId), (Mutator)Accessors.mutatorByField(Country.class, (String)"id"));
        DefaultEntityMapping countryEntityMappingStrategy = new DefaultEntityMapping(Country.class, countryTable, (Map)countryMapping, (ReversibleAccessor)countryIdentifierAccessorByMethodReference, (IdentifierInsertionManager)new AlreadyAssignedIdentifierManager(Identifier.class, c -> {}, c -> false));
        Table cityTable = new Table("city");
        Column cityTableCountryColumn = cityTable.addColumn("countryId", Long.TYPE);
        PropertyAccessor cityIdentifierAccessorByMethodReference = new PropertyAccessor((Accessor)Accessors.accessorByMethodReference(City::getId), (Mutator)Accessors.mutatorByField(City.class, (String)"id"));
        FluentEmbeddableMappingConfigurationSupport.LinkageSupport identifierLinkage = new FluentEmbeddableMappingConfigurationSupport.LinkageSupport(City::getId);
        identifierLinkage.setField(Reflections.findField(City.class, (String)"id"));
        identifierLinkage.setColumnOptions((FluentEmbeddableMappingConfigurationSupport.LocalColumnLinkageOptions)new FluentEmbeddableMappingConfigurationSupport.ColumnLinkageOptionsSupport("id"));
        FluentEmbeddableMappingConfigurationSupport.LinkageSupport nameLinkage = new FluentEmbeddableMappingConfigurationSupport.LinkageSupport(City::getName);
        nameLinkage.setField(Reflections.findField(City.class, (String)"name"));
        nameLinkage.setColumnOptions((FluentEmbeddableMappingConfigurationSupport.LocalColumnLinkageOptions)new FluentEmbeddableMappingConfigurationSupport.ColumnLinkageOptionsSupport("name"));
        EmbeddableMappingConfiguration cityPropertiesMapping = (EmbeddableMappingConfiguration)Mockito.mock(EmbeddableMappingConfiguration.class);
        Mockito.when((Object)cityPropertiesMapping.getPropertiesMapping()).thenReturn((Object)Arrays.asList((Object[])new EmbeddableMappingConfiguration.Linkage[]{identifierLinkage, nameLinkage}));
        Mockito.when((Object)cityPropertiesMapping.getInsets()).thenReturn(Collections.emptyList());
        Mockito.when((Object)cityPropertiesMapping.getColumnNamingStrategy()).thenReturn((Object)ColumnNamingStrategy.DEFAULT);
        EntityMappingConfiguration cityMappingConfiguration = (EntityMappingConfiguration)Mockito.mock(EntityMappingConfiguration.class);
        Mockito.when((Object)cityMappingConfiguration.getEntityType()).thenReturn(City.class);
        Mockito.when((Object)cityMappingConfiguration.getPropertiesMapping()).thenReturn((Object)cityPropertiesMapping);
        Mockito.when((Object)cityMappingConfiguration.getTableNamingStrategy()).thenReturn((Object)TableNamingStrategy.DEFAULT);
        Mockito.when((Object)cityMappingConfiguration.getKeyMapping()).thenReturn((Object)new EntityMappingConfiguration.SingleKeyMapping<City, Identifier<Long>>((ReversibleAccessor)cityIdentifierAccessorByMethodReference){
            final /* synthetic */ ReversibleAccessor val$cityIdentifierAccessorByMethodReference;
            {
                this.val$cityIdentifierAccessorByMethodReference = reversibleAccessor;
            }

            public IdentifierPolicy<Identifier<Long>> getIdentifierPolicy() {
                return StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED;
            }

            public ReversibleAccessor<City, Identifier<Long>> getAccessor() {
                return this.val$cityIdentifierAccessorByMethodReference;
            }

            @Nullable
            public EntityMappingConfiguration.ColumnLinkageOptions getColumnOptions() {
                return null;
            }

            public boolean isSetByConstructor() {
                return false;
            }
        });
        Mockito.when((Object)cityMappingConfiguration.getOneToOnes()).thenReturn(Collections.emptyList());
        Mockito.when((Object)cityMappingConfiguration.getOneToManys()).thenReturn(Collections.emptyList());
        Mockito.when((Object)cityMappingConfiguration.getManyToManys()).thenReturn(Collections.emptyList());
        Mockito.when((Object)cityMappingConfiguration.inheritanceIterable()).thenAnswer(Mockito.CALLS_REAL_METHODS);
        PropertyAccessor capitalAccessPoint = new PropertyAccessor((Accessor)new AccessorByMethodReference(Country::getCapital), (Mutator)new MutatorByMethodReference(Country::setCapital));
        OneToOneRelation countryCapitalRelation = new OneToOneRelation((ReversibleAccessor)capitalAccessPoint, () -> true, () -> new EntityMappingConfigurationWithTable(cityMappingConfiguration, cityTable));
        countryCapitalRelation.setReverseColumn(cityTableCountryColumn);
        DefaultDialect dialect = new DefaultDialect();
        dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        dialect.getSqlTypeRegistry().put(Identifier.class, "int");
        ConnectionConfiguration.ConnectionConfigurationSupport connectionConfiguration = new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)Mockito.mock(ConnectionProvider.class), 10);
        SimpleRelationalEntityPersister countryPersister = new SimpleRelationalEntityPersister(countryEntityMappingStrategy, (Dialect)dialect, (ConnectionConfiguration)connectionConfiguration);
        OneToOneRelationConfigurer testInstance = new OneToOneRelationConfigurer((Dialect)dialect, (ConnectionConfiguration)connectionConfiguration, (ConfiguredRelationalPersister)countryPersister, TableNamingStrategy.DEFAULT, JoinColumnNamingStrategy.JOIN_DEFAULT, ForeignKeyNamingStrategy.DEFAULT, (PersisterBuilderContext)PersisterBuilderContext.CURRENT.get());
        testInstance.configure(countryCapitalRelation);
        Assertions.assertThat(cityTable.mapColumnsOnName().keySet()).isEqualTo((Object)Arrays.asSet((Object[])new String[]{"id", "countryId", "name"}));
        Assertions.assertThat((Collection)cityTable.getForeignKeys()).extracting(ForeignKey::getName).containsExactlyInAnyOrder((Object[])new String[]{"FK_city_countryId_country_id"});
        Assertions.assertThat((Object)Iterables.first((Iterable)((ForeignKey)Iterables.first((Iterable)cityTable.getForeignKeys())).getColumns())).isEqualTo((Object)cityTableCountryColumn);
        Assertions.assertThat((Object)Iterables.first((Iterable)((ForeignKey)Iterables.first((Iterable)cityTable.getForeignKeys())).getTargetColumns())).isEqualTo((Object)countryTableIdColumn);
        Assertions.assertThat(countryTable.mapColumnsOnName().keySet()).isEqualTo((Object)Arrays.asSet((Object[])new String[]{"id", "name"}));
        Assertions.assertThat((Collection)countryTable.getForeignKeys()).extracting(ForeignKey::getName).isEmpty();
    }
}

