/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.onetoone;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.stalactite.dsl.MappingConfigurationException;
import org.codefilarete.stalactite.dsl.RuntimeMappingException;
import org.codefilarete.stalactite.dsl.property.CascadeOptions;
import org.codefilarete.stalactite.engine.configurer.CascadeConfigurationResult;
import org.codefilarete.stalactite.engine.configurer.onetoone.FirstPhaseCycleLoadListener;
import org.codefilarete.stalactite.engine.configurer.onetoone.OneToOneRelation;
import org.codefilarete.stalactite.engine.listener.InsertListener;
import org.codefilarete.stalactite.engine.listener.SelectListener;
import org.codefilarete.stalactite.engine.listener.SelectListenerCollection;
import org.codefilarete.stalactite.engine.listener.UpdateListener;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Iterables;

public abstract class OneToOneConfigurerTemplate<SRC, TRGT, SRCID, TRGTID, LEFTTABLE extends Table<LEFTTABLE>, RIGHTTABLE extends Table<RIGHTTABLE>, JOINID> {
    protected final ConfiguredRelationalPersister<SRC, SRCID> sourcePersister;
    protected final OneToOneRelation<SRC, TRGT, TRGTID> oneToOneRelation;

    protected OneToOneConfigurerTemplate(ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, OneToOneRelation<SRC, TRGT, TRGTID> oneToOneRelation) {
        this.sourcePersister = sourcePersister;
        this.oneToOneRelation = oneToOneRelation;
    }

    public String configure(@Nullable String tableAlias, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister, boolean loadSeparately) {
        this.assertConfigurationIsSupported();
        EntityMapping targetMappingStrategy = targetPersister.getMapping();
        Duo<Key<LEFTTABLE, JOINID>, Key<RIGHTTABLE, JOINID>> foreignKeyColumns = this.determineForeignKeyColumns(this.sourcePersister.getMapping(), targetMappingStrategy);
        BeanRelationFixer<SRC, TRGT> beanRelationFixer = this.determineRelationFixer();
        String relationJoinNodeName = this.addSelectJoin(tableAlias, targetPersister, (Key)foreignKeyColumns.getLeft(), (Key)foreignKeyColumns.getRight(), beanRelationFixer, loadSeparately);
        this.addWriteCascades(targetPersister);
        return relationJoinNodeName;
    }

    public CascadeConfigurationResult<SRC, TRGT> configureWithSelectIn2Phases(String tableAlias, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister, FirstPhaseCycleLoadListener<SRC, TRGTID> firstPhaseCycleLoadListener) {
        this.assertConfigurationIsSupported();
        EntityMapping targetMappingStrategy = targetPersister.getMapping();
        Duo<Key<LEFTTABLE, JOINID>, Key<RIGHTTABLE, JOINID>> foreignKeyColumns = this.determineForeignKeyColumns(this.sourcePersister.getMapping(), targetMappingStrategy);
        BeanRelationFixer<SRC, TRGT> beanRelationFixer = this.determineRelationFixer();
        this.addSelectIn2Phases(tableAlias, targetPersister, (Key)foreignKeyColumns.getLeft(), (Key)foreignKeyColumns.getRight(), firstPhaseCycleLoadListener);
        this.addWriteCascades(targetPersister);
        return new CascadeConfigurationResult<SRC, TRGT>(beanRelationFixer, this.sourcePersister);
    }

    private void assertConfigurationIsSupported() {
        CascadeOptions.RelationMode maintenanceMode = this.oneToOneRelation.getRelationMode();
        if (maintenanceMode == CascadeOptions.RelationMode.ASSOCIATION_ONLY) {
            throw new MappingConfigurationException((Object)((Object)CascadeOptions.RelationMode.ASSOCIATION_ONLY) + " is only relevant for one-to-many association");
        }
    }

    protected abstract Duo<Key<LEFTTABLE, JOINID>, Key<RIGHTTABLE, JOINID>> determineForeignKeyColumns(EntityMapping<SRC, SRCID, LEFTTABLE> var1, EntityMapping<TRGT, TRGTID, RIGHTTABLE> var2);

    protected abstract BeanRelationFixer<SRC, TRGT> determineRelationFixer();

    protected void addWriteCascades(ConfiguredPersister<TRGT, TRGTID> targetPersister) {
        boolean writeAuthorized;
        boolean orphanRemoval = this.oneToOneRelation.getRelationMode() == CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL;
        boolean bl = writeAuthorized = this.oneToOneRelation.getRelationMode() != CascadeOptions.RelationMode.READ_ONLY;
        if (writeAuthorized) {
            this.addInsertCascade(targetPersister);
            this.addUpdateCascade(targetPersister, orphanRemoval);
            this.addDeleteCascade(targetPersister, orphanRemoval);
        }
    }

    protected void addInsertCascade(ConfiguredPersister<TRGT, TRGTID> targetPersister) {
        if (!this.oneToOneRelation.isNullable()) {
            this.sourcePersister.addInsertListener(new MandatoryRelationAssertBeforeInsertListener<SRC>(this.oneToOneRelation.getTargetProvider()));
        }
    }

    protected void addUpdateCascade(ConfiguredPersister<TRGT, TRGTID> targetPersister, boolean orphanRemoval) {
        if (!this.oneToOneRelation.isNullable()) {
            this.sourcePersister.addUpdateListener(new MandatoryRelationAssertBeforeUpdateListener<SRC>(this.oneToOneRelation.getTargetProvider()));
        }
    }

    protected abstract void addDeleteCascade(ConfiguredPersister<TRGT, TRGTID> var1, boolean var2);

    protected String addSelectJoin(@Nullable String tableAlias, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister, Key<LEFTTABLE, JOINID> leftKey, Key<RIGHTTABLE, JOINID> rightKey, BeanRelationFixer<SRC, TRGT> beanRelationFixer, boolean loadSeparately) {
        String joinNodeName = targetPersister.joinAsOne(this.sourcePersister, (Accessor)this.oneToOneRelation.getTargetProvider(), (Key)leftKey, (Key)rightKey, tableAlias, (BeanRelationFixer)beanRelationFixer, this.oneToOneRelation.isNullable(), loadSeparately);
        SelectListenerCollection targetSelectListener = targetPersister.getPersisterListener().getSelectListener();
        this.sourcePersister.addSelectListener(new SelectListener<SRC, SRCID>((SelectListener)targetSelectListener){
            final /* synthetic */ SelectListener val$targetSelectListener;
            {
                this.val$targetSelectListener = selectListener;
            }

            public void beforeSelect(Iterable<SRCID> ids) {
                this.val$targetSelectListener.beforeSelect(Collections.emptyList());
            }

            public void afterSelect(Set<? extends SRC> result) {
                Set collect = (Set)Iterables.collect(result, arg_0 -> OneToOneConfigurerTemplate.this.oneToOneRelation.getTargetProvider().get(arg_0), HashSet::new);
                collect.removeIf(Objects::isNull);
                this.val$targetSelectListener.afterSelect(collect);
            }

            public void onSelectError(Iterable<SRCID> ids, RuntimeException exception) {
                this.val$targetSelectListener.onSelectError(Collections.emptyList(), exception);
            }
        });
        return joinNodeName;
    }

    protected abstract void addSelectIn2Phases(String var1, ConfiguredRelationalPersister<TRGT, TRGTID> var2, Key<LEFTTABLE, JOINID> var3, Key<RIGHTTABLE, JOINID> var4, FirstPhaseCycleLoadListener<SRC, TRGTID> var5);

    public static RuntimeMappingException newRuntimeMappingException(Object pawn, ValueAccessPoint<?> accessor) {
        return new RuntimeMappingException("Non null value expected for relation " + AccessorDefinition.toString(accessor) + " on object " + pawn);
    }

    public static class MandatoryRelationAssertBeforeUpdateListener<C>
    implements UpdateListener<C> {
        private final Accessor<C, ?> targetAccessor;

        public MandatoryRelationAssertBeforeUpdateListener(Accessor<C, ?> targetAccessor) {
            this.targetAccessor = targetAccessor;
        }

        public void beforeUpdate(Iterable<? extends Duo<C, C>> payloads, boolean allColumnsStatement) {
            for (Duo<C, C> payload : payloads) {
                Object modifiedEntity = payload.getLeft();
                Object modifiedTarget = this.targetAccessor.get(modifiedEntity);
                if (modifiedTarget != null) continue;
                throw OneToOneConfigurerTemplate.newRuntimeMappingException(modifiedEntity, this.targetAccessor);
            }
        }
    }

    public static class MandatoryRelationAssertBeforeInsertListener<C>
    implements InsertListener<C> {
        private final Accessor<C, ?> targetAccessor;

        public MandatoryRelationAssertBeforeInsertListener(Accessor<C, ?> targetAccessor) {
            this.targetAccessor = targetAccessor;
        }

        public void beforeInsert(Iterable<? extends C> entities) {
            for (C pawn : entities) {
                Object modifiedTarget = this.targetAccessor.get(pawn);
                if (modifiedTarget != null) continue;
                throw OneToOneConfigurerTemplate.newRuntimeMappingException(pawn, this.targetAccessor);
            }
        }
    }
}

