/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.mapping;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.mapping.ColumnedCollectionMapping;
import org.codefilarete.stalactite.mapping.Mapping;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.stalactite.sql.result.MapBasedColumnedRow;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class ColumnedCollectionMappingTest {
    private static Table targetTable;
    private static Column col1;
    private static Column col2;
    private static Column col3;
    private static Column col4;
    private static Column col5;
    private ColumnedCollectionMapping<List<String>, String, ?> testInstance;

    ColumnedCollectionMappingTest() {
    }

    @BeforeAll
    static void setUpClass() {
        targetTable = new Table(null, "Toto");
        int nbCol = 5;
        for (int i = 1; i <= nbCol; ++i) {
            String columnName = "col_" + i;
            targetTable.addColumn(columnName, String.class);
        }
        Map namedColumns = targetTable.mapColumnsOnName();
        col1 = (Column)namedColumns.get("col_1");
        col1.setPrimaryKey(true);
        col2 = (Column)namedColumns.get("col_2");
        col3 = (Column)namedColumns.get("col_3");
        col4 = (Column)namedColumns.get("col_4");
        col5 = (Column)namedColumns.get("col_5");
    }

    @BeforeEach
    <T extends Table<T>> void setUp() {
        this.testInstance = new ColumnedCollectionMapping<List<String>, String, T>(targetTable, targetTable.getColumns(), ArrayList.class){

            protected String toCollectionValue(Object object) {
                return object == null ? null : object.toString();
            }
        };
    }

    static Object[][] getInsertValues() {
        ColumnedCollectionMappingTest.setUpClass();
        return new Object[][]{{Arrays.asList((Object[])new String[]{"a", "b", "c"}), Maps.asMap((Object)col1, (Object)"a").add((Object)col2, (Object)"b").add((Object)col3, (Object)"c").add((Object)col4, null).add((Object)col5, null)}, {Arrays.asList((Object[])new String[]{"a", "b", null}), Maps.asMap((Object)col1, (Object)"a").add((Object)col2, (Object)"b").add((Object)col3, null).add((Object)col4, null).add((Object)col5, null)}, {null, Maps.asMap((Object)col1, null).add((Object)col2, null).add((Object)col3, null).add((Object)col4, null).add((Object)col5, null)}};
    }

    @ParameterizedTest
    @MethodSource(value={"getInsertValues"})
    void getInsertValues(List<String> toInsert, Maps.ChainingMap<Column, String> expected) {
        Map insertValues = this.testInstance.getInsertValues(toInsert);
        Assertions.assertThat(expected).isEqualTo((Object)insertValues);
    }

    static Object[][] getUpdateValues_diffOnly() {
        ColumnedCollectionMappingTest.setUpClass();
        return new Object[][]{{Arrays.asList((Object[])new String[]{"a", "b", "c"}), Arrays.asList((Object[])new String[]{"x", "y", "x"}), Maps.asMap((Object)col1, (Object)"a").add((Object)col2, (Object)"b").add((Object)col3, (Object)"c")}, {Arrays.asList((Object[])new String[]{"a", "b"}), Arrays.asList((Object[])new String[]{"x", "y", "x"}), Maps.asMap((Object)col1, (Object)"a").add((Object)col2, (Object)"b").add((Object)col3, null)}, {Arrays.asList((Object[])new String[]{"a", "b", "c"}), Arrays.asList((Object[])new String[]{"x", "y"}), Maps.asMap((Object)col1, (Object)"a").add((Object)col2, (Object)"b").add((Object)col3, (Object)"c")}, {Arrays.asList((Object[])new String[]{"x", "b"}), Arrays.asList((Object[])new String[]{"x", "y"}), Maps.asMap((Object)col2, (Object)"b")}, {Arrays.asList((Object[])new String[]{"x", "b", null}), Arrays.asList((Object[])new String[]{"x", "y", "z"}), Maps.asMap((Object)col2, (Object)"b").add((Object)col3, null)}, {Arrays.asList((Object[])new String[]{"x", "b", null}), null, Maps.asMap((Object)col1, (Object)"x").add((Object)col2, (Object)"b")}};
    }

    @ParameterizedTest
    @MethodSource(value={"getUpdateValues_diffOnly"})
    void testGetUpdateValues_diffOnly(List<String> modified, List<String> unmodified, Map<Column, String> expected) {
        Map updateValues = this.testInstance.getUpdateValues(modified, unmodified, false);
        HashMap expectationWithUpwhereColumn = new HashMap();
        expected.forEach((c, s) -> expectationWithUpwhereColumn.put(new Mapping.UpwhereColumn(c, true), s));
        Assertions.assertThat((Map)updateValues).isEqualTo(expectationWithUpwhereColumn);
    }

    static Object[][] getUpdateValues_allColumns() {
        ColumnedCollectionMappingTest.setUpClass();
        return new Object[][]{{Arrays.asList((Object[])new String[]{"a", "b", "c"}), Arrays.asList((Object[])new String[]{"x", "y", "x"}), Maps.asMap((Object)col1, (Object)"a").add((Object)col2, (Object)"b").add((Object)col3, (Object)"c").add((Object)col4, null).add((Object)col5, null)}, {Arrays.asList((Object[])new String[]{"a", "b"}), Arrays.asList((Object[])new String[]{"x", "y", "x"}), Maps.asMap((Object)col1, (Object)"a").add((Object)col2, (Object)"b").add((Object)col3, null).add((Object)col4, null).add((Object)col5, null)}, {Arrays.asList((Object[])new String[]{"a", "b", "c"}), Arrays.asList((Object[])new String[]{"x", "y"}), Maps.asMap((Object)col1, (Object)"a").add((Object)col2, (Object)"b").add((Object)col3, (Object)"c").add((Object)col4, null).add((Object)col5, null)}, {Arrays.asList((Object[])new String[]{"x", "b"}), Arrays.asList((Object[])new String[]{"x", "y"}), Maps.asMap((Object)col1, (Object)"x").add((Object)col2, (Object)"b").add((Object)col3, null).add((Object)col4, null).add((Object)col5, null)}, {Arrays.asList((Object[])new String[]{"x", "b", null}), Arrays.asList((Object[])new String[]{"x", "y", "z"}), Maps.asMap((Object)col1, (Object)"x").add((Object)col2, (Object)"b").add((Object)col3, null).add((Object)col4, null).add((Object)col5, null)}, {Arrays.asList((Object[])new String[]{"x", "b", null}), null, Maps.asMap((Object)col1, (Object)"x").add((Object)col2, (Object)"b").add((Object)col3, null).add((Object)col4, null).add((Object)col5, null)}, {Arrays.asList((Object[])new String[]{"a", "b", "c"}), Arrays.asList((Object[])new String[]{"a", "b", "c"}), new HashMap()}};
    }

    @ParameterizedTest
    @MethodSource(value={"getUpdateValues_allColumns"})
    void getUpdateValues_allColumns(List<String> modified, List<String> unmodified, Map<Column, String> expected) {
        Map updateValues = this.testInstance.getUpdateValues(modified, unmodified, true);
        HashMap expectationWithUpwhereColumn = new HashMap();
        expected.forEach((c, s) -> expectationWithUpwhereColumn.put(new Mapping.UpwhereColumn(c, true), s));
        Assertions.assertThat((Map)updateValues).isEqualTo(expectationWithUpwhereColumn);
    }

    @Test
    void transform() {
        MapBasedColumnedRow row = new MapBasedColumnedRow();
        row.put((Selectable)col1, (Object)"a");
        row.put((Selectable)col2, (Object)"b");
        row.put((Selectable)col3, (Object)"c");
        List toto = (List)this.testInstance.transform((ColumnedRow)row);
        Assertions.assertThat((String)((String)toto.get(0))).isEqualTo("a");
        Assertions.assertThat((String)((String)toto.get(1))).isEqualTo("b");
        Assertions.assertThat((String)((String)toto.get(2))).isEqualTo("c");
        Assertions.assertThat((String)((String)toto.get(3))).isNull();
        Assertions.assertThat((String)((String)toto.get(4))).isNull();
        Assertions.assertThat((int)toto.size()).isEqualTo(5);
    }
}

