/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.sql.DataSource;
import org.apache.commons.lang3.builder.MultilineRecursiveToStringStyle;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.presentation.Representation;
import org.assertj.core.presentation.StandardRepresentation;
import org.codefilarete.stalactite.dsl.MappingConfigurationException;
import org.codefilarete.stalactite.dsl.MappingEase;
import org.codefilarete.stalactite.dsl.RuntimeMappingException;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.entity.FluentEntityMappingBuilder;
import org.codefilarete.stalactite.dsl.entity.FluentMappingBuilderManyToOneOptions;
import org.codefilarete.stalactite.dsl.naming.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.dsl.property.CascadeOptions;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.JdbcForeignKey;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.idprovider.LongProvider;
import org.codefilarete.stalactite.engine.model.device.Address;
import org.codefilarete.stalactite.engine.model.device.Company;
import org.codefilarete.stalactite.engine.model.device.Device;
import org.codefilarete.stalactite.engine.model.device.Location;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.PersistableIdentifier;
import org.codefilarete.stalactite.id.PersistedIdentifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialectBuilder;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.result.ResultSetIterator;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.exception.Exceptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;

public class FluentEntityMappingConfigurationSupportManyToOneTest {
    private final Dialect dialect = HSQLDBDialectBuilder.defaultHSQLDBDialect();
    private final DataSource dataSource = new HSQLDBInMemoryDataSource();
    private FluentEntityMappingBuilder<Company, Identifier<Long>> companyConfiguration;
    private FluentEntityMappingBuilder<Address, Identifier<Long>> addressConfiguration;
    private PersistenceContext persistenceContext;

    @BeforeEach
    public void initTest() {
        FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions addressMappingBuilder;
        FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions companyMappingBuilder;
        this.dialect.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        this.dialect.getSqlTypeRegistry().put(Identifier.class, "int");
        this.persistenceContext = new PersistenceContext(this.dataSource, this.dialect);
        this.companyConfiguration = companyMappingBuilder = MappingEase.entityBuilder(Company.class, Identifier.LONG_TYPE).mapKey(Company::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Company::getName);
        this.addressConfiguration = addressMappingBuilder = MappingEase.entityBuilder(Address.class, Identifier.LONG_TYPE).mapKey(Location::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Address::getStreet);
    }

    @Test
    void multiple_manyToOne() throws SQLException {
        EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).mapManyToOne(Device::setManufacturer, this.companyConfiguration).cascading(CascadeOptions.RelationMode.ALL).mapManyToOne(Device::setLocation, this.addressConfiguration).cascading(CascadeOptions.RelationMode.ALL).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        LongProvider deviceIdProvider = new LongProvider();
        Device dummyDevice = new Device((Long)deviceIdProvider.giveNewIdentifier());
        dummyDevice.setName("UPS");
        Company company = new Company((Long)new LongProvider().giveNewIdentifier());
        company.setName("World Company");
        dummyDevice.setManufacturer(company);
        Address somewhere = new Address((Long)new LongProvider().giveNewIdentifier());
        somewhere.setStreet("somewhere");
        dummyDevice.setLocation(somewhere);
        devicePersister.insert((Object)dummyDevice);
        Device persistedDevice = (Device)devicePersister.select(dummyDevice.getId());
        Assertions.assertThat(persistedDevice.getId()).isEqualTo(new PersistedIdentifier<Long>(0L));
        Assertions.assertThat((String)persistedDevice.getManufacturer().getName()).isEqualTo("World Company");
        Assertions.assertThat((String)((Address)persistedDevice.getLocation()).getStreet()).isEqualTo("somewhere");
        Assertions.assertThat((boolean)persistedDevice.getManufacturer().getId().isPersisted()).isTrue();
        Assertions.assertThat((boolean)persistedDevice.getLocation().getId().isPersisted()).isTrue();
        Device dummyDevice2 = new Device((Long)deviceIdProvider.giveNewIdentifier());
        dummyDevice2.setName("France 2");
        dummyDevice2.setManufacturer(company);
        dummyDevice2.setLocation(somewhere);
        devicePersister.insert((Object)dummyDevice2);
        Device persistedDevice2 = (Device)devicePersister.select(dummyDevice2.getId());
        Assertions.assertThat(persistedDevice2.getId()).isEqualTo(new PersistedIdentifier<Long>(1L));
        Assertions.assertThat((String)persistedDevice2.getManufacturer().getName()).isEqualTo("World Company");
        Assertions.assertThat((Long)((Long)persistedDevice2.getManufacturer().getId().getDelegate())).isEqualTo(persistedDevice.getManufacturer().getId().getDelegate());
        Assertions.assertThat((Long)((Long)persistedDevice2.getLocation().getId().getDelegate())).isEqualTo(persistedDevice.getLocation().getId().getDelegate());
        Assertions.assertThat((Object)persistedDevice2.getManufacturer()).isNotSameAs((Object)persistedDevice.getManufacturer());
        Assertions.assertThat((Object)persistedDevice2.getLocation()).isNotSameAs((Object)persistedDevice.getLocation());
        persistedDevice2.getManufacturer().setName("World Company renamed");
        ((Address)persistedDevice2.getLocation()).setStreet("somewhere renamed");
        devicePersister.update((Object)persistedDevice2, (Object)dummyDevice2, true);
        ResultSet resultSet = this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select name from Company");
        resultSet.next();
        Assertions.assertThat((String)resultSet.getString("name")).isEqualTo("World Company renamed");
        Assertions.assertThat((boolean)resultSet.next()).isFalse();
        resultSet = this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select street from Address");
        resultSet.next();
        Assertions.assertThat((String)resultSet.getString("street")).isEqualTo("somewhere renamed");
        Assertions.assertThat((boolean)resultSet.next()).isFalse();
        Assertions.assertThat((int)this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("update Device set manufacturerId = null, locationId = null where id = " + dummyDevice2.getId().getDelegate())).isEqualTo(1);
        devicePersister.delete((Object)persistedDevice);
        resultSet = this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Device where id = " + persistedDevice.getId().getDelegate());
        Assertions.assertThat((boolean)resultSet.next()).isFalse();
        resultSet = this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Company where id = " + persistedDevice.getManufacturer().getId().getDelegate());
        Assertions.assertThat((boolean)resultSet.next()).isTrue();
        resultSet = this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Address where id = " + persistedDevice.getLocation().getId().getDelegate());
        Assertions.assertThat((boolean)resultSet.next()).isTrue();
    }

    @Test
    void multiple_manyToOne_partialOrphanRemoval() throws SQLException {
        EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).mapManyToOne(Device::setManufacturer, this.companyConfiguration).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).mapManyToOne(Device::setLocation, this.addressConfiguration).cascading(CascadeOptions.RelationMode.ALL).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        LongProvider deviceIdProvider = new LongProvider();
        Device dummyDevice = new Device((Long)deviceIdProvider.giveNewIdentifier());
        dummyDevice.setName("UPS");
        Company company = new Company((Long)new LongProvider().giveNewIdentifier());
        company.setName("World Company");
        dummyDevice.setManufacturer(company);
        Address somewhere = new Address((Long)new LongProvider().giveNewIdentifier());
        somewhere.setStreet("somewhere");
        dummyDevice.setLocation(somewhere);
        devicePersister.insert((Object)dummyDevice);
        Device persistedDevice = (Device)devicePersister.select(dummyDevice.getId());
        Assertions.assertThat(persistedDevice.getId()).isEqualTo(new PersistedIdentifier<Long>(0L));
        Assertions.assertThat((String)persistedDevice.getManufacturer().getName()).isEqualTo("World Company");
        Assertions.assertThat((String)((Address)persistedDevice.getLocation()).getStreet()).isEqualTo("somewhere");
        Assertions.assertThat((boolean)persistedDevice.getManufacturer().getId().isPersisted()).isTrue();
        Assertions.assertThat((boolean)persistedDevice.getLocation().getId().isPersisted()).isTrue();
        Device dummyDevice2 = new Device((Long)deviceIdProvider.giveNewIdentifier());
        dummyDevice2.setName("UPS 2");
        dummyDevice2.setManufacturer(company);
        dummyDevice2.setLocation(somewhere);
        devicePersister.insert((Object)dummyDevice2);
        Device persistedDevice2 = (Device)devicePersister.select(dummyDevice2.getId());
        Assertions.assertThat(persistedDevice2.getId()).isEqualTo(new PersistedIdentifier<Long>(1L));
        Assertions.assertThat((String)persistedDevice2.getManufacturer().getName()).isEqualTo("World Company");
        Assertions.assertThat((Long)((Long)persistedDevice2.getManufacturer().getId().getDelegate())).isEqualTo(persistedDevice.getManufacturer().getId().getDelegate());
        Assertions.assertThat((Long)((Long)persistedDevice2.getLocation().getId().getDelegate())).isEqualTo(persistedDevice.getLocation().getId().getDelegate());
        Assertions.assertThat((Object)persistedDevice2.getManufacturer()).isNotSameAs((Object)persistedDevice.getManufacturer());
        Assertions.assertThat((Object)persistedDevice2.getLocation()).isNotSameAs((Object)persistedDevice.getLocation());
        Assertions.assertThat((int)this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("update Device set manufacturerId = null, locationId = null where id = " + dummyDevice.getId().getDelegate())).isEqualTo(1);
        persistedDevice2.setManufacturer(null);
        ((Address)persistedDevice2.getLocation()).setStreet("somewhere renamed");
        devicePersister.update((Object)persistedDevice2, (Object)dummyDevice2, true);
        ResultSet resultSet = this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select name from Company");
        Assertions.assertThat((boolean)resultSet.next()).isFalse();
        resultSet = this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select street from Address");
        resultSet.next();
        Assertions.assertThat((String)resultSet.getString("street")).isEqualTo("somewhere renamed");
        Assertions.assertThat((boolean)resultSet.next()).isFalse();
        devicePersister.delete((Object)persistedDevice2);
        resultSet = this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Device where id = " + persistedDevice2.getId().getDelegate());
        Assertions.assertThat((boolean)resultSet.next()).isFalse();
        resultSet = this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Company where id = " + dummyDevice2.getManufacturer().getId().getDelegate());
        Assertions.assertThat((boolean)resultSet.next()).isFalse();
        resultSet = this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Address where id = " + persistedDevice2.getLocation().getId().getDelegate());
        Assertions.assertThat((boolean)resultSet.next()).isTrue();
    }

    @Test
    void mandatory_withNullTarget_throwsException() {
        EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).mapManyToOne(Device::getManufacturer, this.companyConfiguration).cascading(CascadeOptions.RelationMode.ALL).mandatory().build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Device dummyDevice = new Device(new PersistableIdentifier<Long>(42L));
        dummyDevice.setManufacturer(null);
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> devicePersister.insert((Object)dummyDevice)).isInstanceOf(RuntimeMappingException.class)).hasMessage("Non null value expected for relation Device::getManufacturer on object o.c.s.e.m.d.Device@42");
        Company company = new Company(new PersistableIdentifier<Long>(1L));
        dummyDevice.setManufacturer(company);
        devicePersister.insert((Object)dummyDevice);
        dummyDevice.setManufacturer(null);
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> devicePersister.update((Object)dummyDevice)).isInstanceOf(RuntimeMappingException.class)).hasMessage("Non null value expected for relation Device::getManufacturer on object o.c.s.e.m.d.Device@42");
    }

    @Test
    void fetchSeparately() {
        EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).mapManyToOne(Device::getManufacturer, this.companyConfiguration).cascading(CascadeOptions.RelationMode.ALL).fetchSeparately().build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Device dummyDevice = new Device(new PersistableIdentifier<Long>(42L));
        dummyDevice.setName("UPS");
        Company company = new Company(new PersistableIdentifier<Long>(1L));
        company.setName("World Company");
        dummyDevice.setManufacturer(company);
        devicePersister.insert((Object)dummyDevice);
        Device loadedDevice = (Device)devicePersister.select(dummyDevice.getId());
        Assertions.assertThat((Object)loadedDevice.getManufacturer()).isNotNull();
        Assertions.assertThat((String)loadedDevice.getManufacturer().getName()).isEqualTo("World Company");
    }

    public static class LiteCompany {
        private final String name;

        public LiteCompany(String name) {
            this.name = name;
        }
    }

    @Nested
    class BiDirectionality {
        BiDirectionality() {
        }

        @Test
        void reverseCollection() {
            EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).mapManyToOne(Device::setManufacturer, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportManyToOneTest.this.companyConfiguration).cascading(CascadeOptions.RelationMode.ALL).reverseCollection(Company::getDevices).build(FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            LongProvider deviceIdProvider = new LongProvider();
            Device device1 = new Device((Long)deviceIdProvider.giveNewIdentifier());
            device1.setName("device 1");
            Device device2 = new Device((Long)deviceIdProvider.giveNewIdentifier());
            device2.setName("device 2");
            Company company = new Company((Long)new LongProvider().giveNewIdentifier());
            company.setName("World Company");
            device1.setManufacturer(company);
            company.addDevice(device1);
            device2.setManufacturer(company);
            company.addDevice(device2);
            devicePersister.insert((Object)device1);
            devicePersister.insert((Object)device2);
            Set select = devicePersister.select((Iterable)Arrays.asSet((Object[])new Identifier[]{device1.getId(), device2.getId()}));
            Device loadedDevice1 = (Device)Iterables.find((Iterable)select, Device::getName, "device 1"::equals).getLeft();
            Device loadedDevice2 = (Device)Iterables.find((Iterable)select, Device::getName, "device 2"::equals).getLeft();
            Assertions.assertThat(loadedDevice1.getManufacturer().getDevices()).containsExactlyInAnyOrder((Object[])new Device[]{loadedDevice1, loadedDevice2});
        }

        @Test
        void reverselySetBy() {
            EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).mapManyToOne(Device::setManufacturer, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportManyToOneTest.this.companyConfiguration).cascading(CascadeOptions.RelationMode.ALL).reverselySetBy(Company::addDevice).build(FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            LongProvider deviceIdProvider = new LongProvider();
            Device device1 = new Device((Long)deviceIdProvider.giveNewIdentifier());
            device1.setName("device 1");
            Device device2 = new Device((Long)deviceIdProvider.giveNewIdentifier());
            device2.setName("device 2");
            Company company = new Company((Long)new LongProvider().giveNewIdentifier());
            company.setName("World Company");
            device1.setManufacturer(company);
            company.addDevice(device1);
            device2.setManufacturer(company);
            company.addDevice(device2);
            devicePersister.insert((Object)device1);
            devicePersister.insert((Object)device2);
            Set select = devicePersister.select((Iterable)Arrays.asSet((Object[])new Identifier[]{device1.getId(), device2.getId()}));
            Device loadedDevice1 = (Device)Iterables.find((Iterable)select, Device::getName, "device 1"::equals).getLeft();
            Device loadedDevice2 = (Device)Iterables.find((Iterable)select, Device::getName, "device 2"::equals).getLeft();
            Assertions.assertThat(loadedDevice1.getManufacturer().getDevices()).containsExactlyInAnyOrder((Object[])new Device[]{loadedDevice1, loadedDevice2});
        }

        @Test
        void reverselyInitializeWith() {
            EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).mapManyToOne(Device::setManufacturer, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportManyToOneTest.this.companyConfiguration).cascading(CascadeOptions.RelationMode.ALL).reverseCollection(Company::getDevices).reverselyInitializeWith(LinkedHashSet::new).build(FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            LongProvider deviceIdProvider = new LongProvider();
            Device device1 = new Device((Long)deviceIdProvider.giveNewIdentifier());
            device1.setName("device 1");
            Device device2 = new Device((Long)deviceIdProvider.giveNewIdentifier());
            device2.setName("device 2");
            Company company = new Company((Long)new LongProvider().giveNewIdentifier());
            company.setName("World Company");
            device1.setManufacturer(company);
            company.addDevice(device1);
            device2.setManufacturer(company);
            company.addDevice(device2);
            devicePersister.insert((Object)device1);
            devicePersister.insert((Object)device2);
            Set select = devicePersister.select((Iterable)Arrays.asSet((Object[])new Identifier[]{device1.getId(), device2.getId()}));
            Device loadedDevice1 = (Device)Iterables.find((Iterable)select, Device::getName, "device 1"::equals).getLeft();
            Device loadedDevice2 = (Device)Iterables.find((Iterable)select, Device::getName, "device 2"::equals).getLeft();
            Assertions.assertThat(loadedDevice1.getManufacturer().getDevices()).containsExactlyInAnyOrder((Object[])new Device[]{loadedDevice1, loadedDevice2});
            Assertions.assertThat(loadedDevice1.getManufacturer().getDevices()).isInstanceOf(LinkedHashSet.class);
        }
    }

    @Nested
    class ForeignKeyCreation {
        ForeignKeyCreation() {
        }

        @Test
        void defaultBehavior() throws SQLException {
            MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).withForeignKeyNaming(ForeignKeyNamingStrategy.DEFAULT).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).mapManyToOne(Device::getLocation, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportManyToOneTest.this.addressConfiguration).mandatory().build(FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Connection currentConnection = FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext.getConnectionProvider().giveConnection();
            ResultSetIterator<JdbcForeignKey> fkPersonIterator = new ResultSetIterator<JdbcForeignKey>(currentConnection.getMetaData().getExportedKeys(null, null, "ADDRESS")){

                public JdbcForeignKey convert(ResultSet rs) throws SQLException {
                    return new JdbcForeignKey(rs.getString("FK_NAME"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"));
                }
            };
            JdbcForeignKey foundForeignKey = (JdbcForeignKey)Iterables.first((Iterator)fkPersonIterator);
            JdbcForeignKey expectedForeignKey = new JdbcForeignKey("FK_DEVICE_LOCATIONID_ADDRESS_ID", "DEVICE", "LOCATIONID", "ADDRESS", "ID");
            Assertions.assertThat((String)foundForeignKey.getSignature()).isEqualTo(expectedForeignKey.getSignature());
            ResultSetIterator<Column> columnIterator = new ResultSetIterator<Column>(currentConnection.getMetaData().getColumns(null, null, "DEVICE", "%")){

                public Column convert(ResultSet rs) throws SQLException {
                    class Column {
                        private final String tableName;
                        private final String name;
                        private final boolean nullable;

                        Column(String tableName, String name, boolean nullable) {
                            this.tableName = tableName;
                            this.name = name;
                            this.nullable = nullable;
                        }
                    }
                    return new Column(rs.getString("TABLE_NAME"), rs.getString("COLUMN_NAME"), rs.getBoolean("NULLABLE"));
                }
            };
            ((ListAssert)((ListAssert)Assertions.assertThat((List)Iterables.collectToList(() -> ForeignKeyCreation.lambda$defaultBehavior$0((ResultSetIterator)columnIterator), Function.identity())).usingRecursiveFieldByFieldElementComparator()).withRepresentation((Representation)new StandardRepresentation(){

                protected String fallbackToStringOf(Object object) {
                    return ToStringBuilder.reflectionToString((Object)object, (ToStringStyle)new MultilineRecursiveToStringStyle());
                }
            })).containsExactlyInAnyOrder((Object[])new Column[]{new Column("DEVICE", "ID", false), new Column("DEVICE", "NAME", true), new Column("DEVICE", "LOCATIONID", false)});
        }

        @Test
        void defaultBehavior_2Relations() throws SQLException {
            MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).withForeignKeyNaming(ForeignKeyNamingStrategy.DEFAULT).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).mapManyToOne(Device::getLocation, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Address.class, Identifier.LONG_TYPE).mapKey(Location::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Address::getStreet)).mapManyToOne(Device::getManufacturer, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Company.class, Identifier.LONG_TYPE).mapKey(Company::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Company::getName)).build(FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Connection currentConnection = FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext.getConnectionProvider().giveConnection();
            ResultSetIterator<JdbcForeignKey> fkPersonIterator = new ResultSetIterator<JdbcForeignKey>(currentConnection.getMetaData().getExportedKeys(null, null, "ADDRESS")){

                public JdbcForeignKey convert(ResultSet rs) throws SQLException {
                    return new JdbcForeignKey(rs.getString("FK_NAME"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"));
                }
            };
            JdbcForeignKey foundForeignKey = (JdbcForeignKey)Iterables.first((Iterator)fkPersonIterator);
            JdbcForeignKey expectedForeignKey = new JdbcForeignKey("FK_DEVICE_LOCATIONID_ADDRESS_ID", "DEVICE", "LOCATIONID", "ADDRESS", "ID");
            Assertions.assertThat((String)foundForeignKey.getSignature()).isEqualTo(expectedForeignKey.getSignature());
            ResultSetIterator<JdbcForeignKey> fkLocationIterator = new ResultSetIterator<JdbcForeignKey>(currentConnection.getMetaData().getExportedKeys(null, null, "COMPANY")){

                public JdbcForeignKey convert(ResultSet rs) throws SQLException {
                    return new JdbcForeignKey(rs.getString("FK_NAME"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"));
                }
            };
            foundForeignKey = (JdbcForeignKey)Iterables.first((Iterator)fkLocationIterator);
            expectedForeignKey = new JdbcForeignKey("FK_DEVICE_MANUFACTURERID_COMPANY_ID", "DEVICE", "MANUFACTURERID", "COMPANY", "ID");
            Assertions.assertThat((String)foundForeignKey.getSignature()).isEqualTo(expectedForeignKey.getSignature());
        }

        @Test
        void withTargetTable_targetTableIsUsed() throws SQLException {
            MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).withForeignKeyNaming(ForeignKeyNamingStrategy.DEFAULT).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).mapManyToOne(Device::getLocation, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Address.class, Identifier.LONG_TYPE).mapKey(Location::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Address::getStreet).onTable(new Table("Township"))).build(FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Connection currentConnection = FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext.getConnectionProvider().giveConnection();
            ResultSetIterator<Table> tableIterator = new ResultSetIterator<Table>(currentConnection.getMetaData().getTables(null, currentConnection.getSchema(), null, null)){

                public Table convert(ResultSet rs) throws SQLException {
                    return new Table(rs.getString("TABLE_NAME"));
                }
            };
            Set foundTables = (Set)Iterables.collect(() -> ForeignKeyCreation.lambda$withTargetTable_targetTableIsUsed$1((ResultSetIterator)tableIterator), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)foundTables).containsExactlyInAnyOrder((Object[])new String[]{"DEVICE", "TOWNSHIP"});
            ResultSetIterator<JdbcForeignKey> fkPersonIterator = new ResultSetIterator<JdbcForeignKey>(currentConnection.getMetaData().getExportedKeys(null, null, "TOWNSHIP")){

                public JdbcForeignKey convert(ResultSet rs) throws SQLException {
                    return new JdbcForeignKey(rs.getString("FK_NAME"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"));
                }
            };
            JdbcForeignKey foundForeignKey = (JdbcForeignKey)Iterables.first((Iterator)fkPersonIterator);
            JdbcForeignKey expectedForeignKey = new JdbcForeignKey("FK_DEVICE_LOCATIONID_TOWNSHIP_ID", "DEVICE", "LOCATIONID", "TOWNSHIP", "ID");
            Assertions.assertThat((String)foundForeignKey.getSignature()).isEqualTo(expectedForeignKey.getSignature());
        }

        @Test
        void withTargetTableSetByTargetEntity_tableSetByTargetEntityIsUSed() throws SQLException {
            MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).withForeignKeyNaming(ForeignKeyNamingStrategy.DEFAULT).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).mapManyToOne(Device::getLocation, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(Address.class, Identifier.LONG_TYPE).onTable(new Table("Town")).mapKey(Location::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Address::getStreet)).build(FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Connection currentConnection = FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext.getConnectionProvider().giveConnection();
            ResultSetIterator<Table> tableIterator = new ResultSetIterator<Table>(currentConnection.getMetaData().getTables(null, currentConnection.getSchema(), null, null)){

                public Table convert(ResultSet rs) throws SQLException {
                    return new Table(rs.getString("TABLE_NAME"));
                }
            };
            Set foundTables = (Set)Iterables.collect(() -> ForeignKeyCreation.lambda$withTargetTableSetByTargetEntity_tableSetByTargetEntityIsUSed$2((ResultSetIterator)tableIterator), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)foundTables).containsExactlyInAnyOrder((Object[])new String[]{"DEVICE", "TOWN"});
            ResultSetIterator<JdbcForeignKey> fkPersonIterator = new ResultSetIterator<JdbcForeignKey>(currentConnection.getMetaData().getExportedKeys(null, null, "TOWN")){

                public JdbcForeignKey convert(ResultSet rs) throws SQLException {
                    return new JdbcForeignKey(rs.getString("FK_NAME"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"));
                }
            };
            JdbcForeignKey foundForeignKey = (JdbcForeignKey)Iterables.first((Iterator)fkPersonIterator);
            JdbcForeignKey expectedForeignKey = new JdbcForeignKey("FK_DEVICE_LOCATIONID_TOWN_ID", "DEVICE", "LOCATIONID", "TOWN", "ID");
            Assertions.assertThat((String)foundForeignKey.getSignature()).isEqualTo(expectedForeignKey.getSignature());
        }

        private static /* synthetic */ Iterator lambda$withTargetTableSetByTargetEntity_tableSetByTargetEntityIsUSed$2(ResultSetIterator tableIterator) {
            return tableIterator;
        }

        private static /* synthetic */ Iterator lambda$withTargetTable_targetTableIsUsed$1(ResultSetIterator tableIterator) {
            return tableIterator;
        }

        private static /* synthetic */ Iterator lambda$defaultBehavior$0(ResultSetIterator columnIterator) {
            return columnIterator;
        }
    }

    @Nested
    class CascadeDeclaration {
        CascadeDeclaration() {
        }

        @Test
        void associationOnly_throwsException() {
            FluentMappingBuilderManyToOneOptions mappingBuilder = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).mapManyToOne(Device::getLocation, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportManyToOneTest.this.addressConfiguration).cascading(CascadeOptions.RelationMode.ASSOCIATION_ONLY);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$associationOnly_throwsException$0((FluentEntityMappingBuilder)mappingBuilder)).extracting(t -> (MappingConfigurationException)Exceptions.findExceptionInCauses((Throwable)t, MappingConfigurationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage(CascadeOptions.RelationMode.ASSOCIATION_ONLY + " is only relevant for one-to-many association");
        }

        @Test
        void notDefined_defaultIsAll_getter() {
            EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).mapManyToOne(Device::getManufacturer, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportManyToOneTest.this.companyConfiguration).build(FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Device device = new Device(new PersistableIdentifier<Long>(42L));
            device.setManufacturer(new Company(new PersistableIdentifier<Long>(666L)));
            devicePersister.insert((Object)device);
            Device selectedDevice = (Device)devicePersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat((Long)((Long)selectedDevice.getId().getDelegate())).isEqualTo(42L);
            Assertions.assertThat((Long)((Long)selectedDevice.getManufacturer().getId().getDelegate())).isEqualTo(666L);
            devicePersister.delete((Object)selectedDevice);
            Assertions.assertThat((Object)devicePersister.select(new PersistedIdentifier<Long>(42L))).isEqualTo(null);
            EntityPersister personPersister = FluentEntityMappingConfigurationSupportManyToOneTest.this.companyConfiguration.build(FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext);
            Assertions.assertThat((Long)((Long)((Company)personPersister.select(new PersistedIdentifier<Long>(666L))).getId().getDelegate())).isEqualTo(666L);
        }

        @Test
        void readOnly_getter() throws SQLException {
            EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).mapManyToOne(Device::getManufacturer, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportManyToOneTest.this.companyConfiguration).cascading(CascadeOptions.RelationMode.READ_ONLY).build(FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext);
            this.assert_cascade_readOnly((EntityPersister<Device, Identifier<Long>>)devicePersister);
        }

        @Test
        void readOnly_setter() throws SQLException {
            EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).withForeignKeyNaming(ForeignKeyNamingStrategy.DEFAULT).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).mapManyToOne(Device::setManufacturer, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportManyToOneTest.this.companyConfiguration).cascading(CascadeOptions.RelationMode.READ_ONLY).build(FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext);
            this.assert_cascade_readOnly((EntityPersister<Device, Identifier<Long>>)devicePersister);
        }

        private void assert_cascade_readOnly(EntityPersister<Device, Identifier<Long>> devicePersister) throws SQLException {
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Device dummyDevice = new Device(new PersistableIdentifier<Long>(42L));
            dummyDevice.setName("UPS");
            Company company = new Company(new PersistableIdentifier<Long>(1L));
            company.setName("World company");
            dummyDevice.setManufacturer(company);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> devicePersister.insert((Object)dummyDevice)).extracting(t -> (BatchUpdateException)Exceptions.findExceptionInCauses((Throwable)t, BatchUpdateException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("integrity constraint violation: foreign key no parent ; FK_DEVICE_MANUFACTURERID_COMPANY_ID table: DEVICE value: 1");
            FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext.getConnectionProvider().giveConnection().prepareStatement("insert into Company(id, name) values (1, 'World company')").execute();
            FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext.getConnectionProvider().giveConnection().prepareStatement("insert into Device(id, name, manufacturerId) values (42, 'UPS', 1)").execute();
            Device loadedDevice = (Device)devicePersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat((String)loadedDevice.getName()).isEqualTo("UPS");
            Assertions.assertThat((String)loadedDevice.getManufacturer().getName()).isEqualTo("World company");
            loadedDevice.setName("touched UPS");
            loadedDevice.getManufacturer().setName("touched World Company");
            devicePersister.update((Object)loadedDevice, (Object)dummyDevice, false);
            Assertions.assertThat((String)((String)FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext.newQuery((CharSequence)"select name from Company where id = 1", String.class).mapKey("name", String.class).execute(Accumulators.getFirst()))).isEqualTo("World company");
            devicePersister.delete((Object)loadedDevice);
            PersistenceContext.ExecutableBeanPropertyQueryMapper stringExecutableQuery = FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext.newQuery((CharSequence)"select name from Device", String.class).mapKey("name", String.class);
            Assertions.assertThat((boolean)((Set)stringExecutableQuery.execute(Accumulators.toSet())).isEmpty()).isTrue();
            Assertions.assertThat((String)((String)FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext.newQuery((CharSequence)"select name from Company where id = 1", String.class).mapKey("name", String.class).execute(Accumulators.getFirst()))).isEqualTo("World company");
        }

        @Test
        void cascade_deleteWithOrphanRemoval() throws SQLException {
            EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).mapManyToOne(Device::setManufacturer, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportManyToOneTest.this.companyConfiguration).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).build(FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Company(id) values (42), (666)");
            FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Device(id, manufacturerId) values (100, 42), (200, 666)");
            Device persistedDevice = (Device)devicePersister.select(new PersistedIdentifier<Long>(100L));
            devicePersister.delete((Object)persistedDevice);
            ResultSet resultSet = FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Device where id = 100");
            Assertions.assertThat((boolean)resultSet.next()).isFalse();
            resultSet = FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Company where id = 42");
            Assertions.assertThat((boolean)resultSet.next()).isFalse();
            resultSet = FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Device where id = 200");
            Assertions.assertThat((boolean)resultSet.next()).isTrue();
            resultSet = FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Company where id = 666");
            Assertions.assertThat((boolean)resultSet.next()).isTrue();
        }

        @Test
        void all() {
            EntityPersister devicePersister = MappingEase.entityBuilder(Device.class, Identifier.LONG_TYPE).mapKey(Device::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Device::getName).mapManyToOne(Device::setManufacturer, (EntityMappingConfigurationProvider)FluentEntityMappingConfigurationSupportManyToOneTest.this.companyConfiguration).cascading(CascadeOptions.RelationMode.ALL).build(FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            LongProvider deviceIdProvider = new LongProvider(42L);
            Device dummyDevice = new Device((Long)deviceIdProvider.giveNewIdentifier());
            dummyDevice.setName("UPS");
            LongProvider companyIdProvider = new LongProvider();
            Company company = new Company((Long)companyIdProvider.giveNewIdentifier());
            company.setName("World Company");
            dummyDevice.setManufacturer(company);
            devicePersister.insert((Object)dummyDevice);
            Device persistedDevice = (Device)devicePersister.select(dummyDevice.getId());
            Assertions.assertThat(persistedDevice.getId()).isEqualTo(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat((String)persistedDevice.getManufacturer().getName()).isEqualTo("World Company");
            Assertions.assertThat((boolean)persistedDevice.getManufacturer().getId().isPersisted()).isTrue();
            Device modifiedDevice = persistedDevice;
            Device referentDevice = dummyDevice;
            modifiedDevice.setManufacturer(null);
            devicePersister.update((Object)modifiedDevice, (Object)referentDevice, false);
            modifiedDevice = (Device)devicePersister.select(referentDevice.getId());
            Assertions.assertThat((Object)modifiedDevice.getManufacturer()).isNull();
            PersistenceContext.ExecutableBeanPropertyQueryMapper companySelector = FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext.newQuery((CharSequence)"select name from Company where id = :id", LiteCompany.class).mapKey(LiteCompany::new, "name", String.class);
            LiteCompany liteCompany = (LiteCompany)companySelector.set("id", company.getId()).execute(Accumulators.getFirstUnique());
            Assertions.assertThat((Object)liteCompany).usingRecursiveComparison().isEqualTo((Object)new LiteCompany("World Company"));
            referentDevice = (Device)devicePersister.select(referentDevice.getId());
            Company stalactiteCorp = new Company((Long)companyIdProvider.giveNewIdentifier());
            stalactiteCorp.setName("Stalactite Corp");
            modifiedDevice.setManufacturer(stalactiteCorp);
            devicePersister.update((Object)modifiedDevice, (Object)referentDevice, false);
            modifiedDevice = (Device)devicePersister.select(referentDevice.getId());
            Assertions.assertThat((Object)modifiedDevice.getManufacturer()).usingRecursiveComparison().isEqualTo((Object)stalactiteCorp);
            Assertions.assertThat((Object)companySelector.set("id", stalactiteCorp.getId()).execute(Accumulators.getFirstUnique())).usingRecursiveComparison().isEqualTo((Object)new LiteCompany("Stalactite Corp"));
            referentDevice = (Device)devicePersister.select(referentDevice.getId());
            modifiedDevice.getManufacturer().setName("Skynet");
            devicePersister.update((Object)modifiedDevice, (Object)referentDevice, false);
            modifiedDevice = (Device)devicePersister.select(referentDevice.getId());
            Assertions.assertThat((Object)companySelector.set("id", stalactiteCorp.getId()).execute(Accumulators.getFirstUnique())).usingRecursiveComparison().isEqualTo((Object)new LiteCompany("Skynet"));
            devicePersister.delete((Object)modifiedDevice);
            Assertions.assertThat((Object)companySelector.set("id", stalactiteCorp.getId()).execute(Accumulators.getFirstUnique())).usingRecursiveComparison().isEqualTo((Object)new LiteCompany("Skynet"));
        }

        private /* synthetic */ void lambda$associationOnly_throwsException$0(FluentEntityMappingBuilder mappingBuilder) throws Throwable {
            mappingBuilder.build(FluentEntityMappingConfigurationSupportManyToOneTest.this.persistenceContext);
        }
    }
}

