/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.builder;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPointMap;
import org.codefilarete.reflection.ValueAccessPointSet;
import org.codefilarete.stalactite.dsl.MappingConfigurationException;
import org.codefilarete.stalactite.dsl.embeddable.EmbeddableMappingConfiguration;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfiguration;
import org.codefilarete.stalactite.engine.configurer.AbstractIdentification;
import org.codefilarete.stalactite.engine.configurer.DefaultComposedIdentifierAssembler;
import org.codefilarete.stalactite.engine.configurer.NamingConfiguration;
import org.codefilarete.stalactite.engine.configurer.builder.ExtraTableConfigurer;
import org.codefilarete.stalactite.engine.configurer.builder.InheritanceMappingStep;
import org.codefilarete.stalactite.engine.runtime.SimpleRelationalEntityPersister;
import org.codefilarete.stalactite.mapping.ComposedIdMapping;
import org.codefilarete.stalactite.mapping.DefaultEntityMapping;
import org.codefilarete.stalactite.mapping.IdMapping;
import org.codefilarete.stalactite.mapping.SimpleIdMapping;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.mapping.id.assembly.SingleIdentifierAssembler;
import org.codefilarete.stalactite.mapping.id.manager.AlreadyAssignedIdentifierManager;
import org.codefilarete.stalactite.mapping.id.manager.IdentifierInsertionManager;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.function.Converter;

public class MainPersisterStep<C, I> {
    public static <E, I, T extends Table<T>> DefaultEntityMapping<E, I, T> createEntityMapping(boolean isIdentifyingConfiguration, T targetTable, Map<? extends ReversibleAccessor<E, Object>, ? extends Column<T, Object>> mapping, Map<? extends ReversibleAccessor<E, Object>, ? extends Column<T, Object>> readOnlyMapping, ValueAccessPointMap<E, ? extends Converter<Object, Object>> readConverters, ValueAccessPointMap<E, ? extends Converter<Object, Object>> writeConverters, ValueAccessPointSet<E> propertiesSetByConstructor, AbstractIdentification<E, I> identification, Class<E> beanType, @Nullable EntityMappingConfiguration.EntityFactoryProvider<E, T> entityFactoryProvider) {
        Function<ColumnedRow, Object> beanFactory;
        SimpleIdMapping idMappingStrategy;
        IdentifierInsertionManager<E, I> identifierInsertionManager;
        PrimaryKey primaryKey = targetTable.getPrimaryKey();
        ReversibleAccessor<E, I> idAccessor = identification.getIdAccessor();
        AccessorDefinition idDefinition = AccessorDefinition.giveDefinition(idAccessor);
        Object object = identifierInsertionManager = isIdentifyingConfiguration ? identification.getInsertionManager() : identification.getFallbackInsertionManager();
        if (identification instanceof AbstractIdentification.CompositeKeyIdentification) {
            Map composedKeyMapping = Iterables.map(((AbstractIdentification.CompositeKeyIdentification)identification).getCompositeKeyMapping().entrySet(), Map.Entry::getKey, entry -> targetTable.getColumn(((Column)entry.getValue()).getName()));
            DefaultComposedIdentifierAssembler composedIdentifierAssembler = new DefaultComposedIdentifierAssembler(targetTable, idDefinition.getMemberType(), composedKeyMapping);
            idMappingStrategy = new ComposedIdMapping(idAccessor, (AlreadyAssignedIdentifierManager)identifierInsertionManager, composedIdentifierAssembler);
        } else {
            idMappingStrategy = new SimpleIdMapping(idAccessor, identifierInsertionManager, new SingleIdentifierAssembler((Column)Iterables.first((Iterable)primaryKey.getColumns())));
        }
        boolean identifierSetByBeanFactory = true;
        if (entityFactoryProvider == null) {
            Constructor constructorById = Reflections.findConstructor(beanType, (Class[])new Class[]{idDefinition.getMemberType()});
            if (constructorById == null) {
                Constructor defaultConstructor = Reflections.findConstructor(beanType, (Class[])new Class[0]);
                if (defaultConstructor == null) {
                    beanFactory = columnValueProvider -> {
                        throw new MappingConfigurationException("Entity class " + Reflections.toString((Class)beanType) + " doesn't have a compatible accessible constructor, please implement a no-arg constructor or " + Reflections.toString((Class)idDefinition.getMemberType()) + "-arg constructor");
                    };
                } else {
                    beanFactory = columnValueProvider -> Reflections.newInstance((Constructor)defaultConstructor, (Object[])new Object[0]);
                    identifierSetByBeanFactory = false;
                }
            } else {
                IdentifierAssembler identifierAssembler = idMappingStrategy.getIdentifierAssembler();
                beanFactory = columnValueProvider -> Reflections.newInstance((Constructor)constructorById, (Object[])new Object[]{identifierAssembler.assemble(columnValueProvider)});
            }
        } else {
            beanFactory = entityFactoryProvider.giveEntityFactory(targetTable);
            identifierSetByBeanFactory = entityFactoryProvider.isIdentifierSetByFactory();
        }
        DefaultEntityMapping result = new DefaultEntityMapping(beanType, targetTable, mapping, readOnlyMapping, (IdMapping)idMappingStrategy, beanFactory, identifierSetByBeanFactory);
        result.getMainMapping().setReadConverters(readConverters);
        result.getMainMapping().setWriteConverters(writeConverters);
        propertiesSetByConstructor.forEach(arg_0 -> ((DefaultEntityMapping)result).addPropertySetByConstructor(arg_0));
        return result;
    }

    <T extends Table<T>> SimpleRelationalEntityPersister<C, I, T> buildMainPersister(EntityMappingConfiguration<C, I> entityMappingConfiguration, AbstractIdentification<C, I> identification, InheritanceMappingStep.MappingPerTable<C> inheritanceMappingPerTable, NamingConfiguration namingConfiguration, Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        InheritanceMappingStep.Mapping mainMapping = (InheritanceMappingStep.Mapping)Iterables.first(inheritanceMappingPerTable.getMappings());
        SimpleRelationalEntityPersister<C, I, T> mainPersister = this.buildMainPersister(entityMappingConfiguration, identification, mainMapping, dialect, connectionConfiguration);
        this.applyExtraTableConfigurations(entityMappingConfiguration, identification, mainPersister, namingConfiguration, dialect, connectionConfiguration);
        return mainPersister;
    }

    private <T extends Table<T>> SimpleRelationalEntityPersister<C, I, T> buildMainPersister(EntityMappingConfiguration<C, I> entityMappingConfiguration, AbstractIdentification<C, I> identification, InheritanceMappingStep.Mapping<C, T> mapping, Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        EntityMappingConfiguration mappingConfiguration = (EntityMappingConfiguration)mapping.getMappingConfiguration();
        boolean isIdentifyingConfiguration = entityMappingConfiguration.getInheritanceConfiguration() == null || !entityMappingConfiguration.getInheritanceConfiguration().isJoinTable();
        DefaultEntityMapping<C, I, Table> mappingStrategy = MainPersisterStep.createEntityMapping(isIdentifyingConfiguration, mapping.getTargetTable(), mapping.getMapping(), mapping.getReadonlyMapping(), mapping.getReadConverters(), mapping.getWriteConverters(), mapping.getPropertiesSetByConstructor(), identification, mappingConfiguration.getEntityType(), mappingConfiguration.getEntityFactoryProvider());
        return new SimpleRelationalEntityPersister<C, I, Table>(mappingStrategy, dialect, connectionConfiguration);
    }

    private <T extends Table<T>> void applyExtraTableConfigurations(EntityMappingConfiguration<C, I> entityMappingConfiguration, AbstractIdentification<C, I> identification, SimpleRelationalEntityPersister<C, I, T> mainPersister, NamingConfiguration namingConfiguration, Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        HashMap<String, Set<EmbeddableMappingConfiguration.Linkage>> extraTableLinkages = new HashMap<String, Set<EmbeddableMappingConfiguration.Linkage>>();
        entityMappingConfiguration.inheritanceIterable().forEach(entityMappingConfiguration1 -> {
            EntityMappingConfiguration mappingConfiguration = entityMappingConfiguration1;
            List<EmbeddableMappingConfiguration.Linkage> propertiesMapping = mappingConfiguration.getPropertiesMapping().getPropertiesMapping();
            for (EmbeddableMappingConfiguration.Linkage linkage : propertiesMapping) {
                if (linkage.getExtraTableName() == null) continue;
                extraTableLinkages.computeIfAbsent(linkage.getExtraTableName(), extraTableName -> new HashSet()).add(linkage);
            }
        });
        if (!extraTableLinkages.isEmpty()) {
            ExtraTableConfigurer extraTableConfigurer = new ExtraTableConfigurer(identification, mainPersister, extraTableLinkages, dialect.getColumnBinderRegistry(), namingConfiguration);
            extraTableConfigurer.configure(dialect, connectionConfiguration);
        }
    }
}

