/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.stalactite.engine.DeleteExecutor;
import org.codefilarete.stalactite.engine.ExecutableProjection;
import org.codefilarete.stalactite.engine.ExecutableQuery;
import org.codefilarete.stalactite.engine.InsertExecutor;
import org.codefilarete.stalactite.engine.PersistExecutor;
import org.codefilarete.stalactite.engine.SelectExecutor;
import org.codefilarete.stalactite.engine.UpdateExecutor;
import org.codefilarete.stalactite.engine.listener.PersisterListener;
import org.codefilarete.stalactite.query.model.ConditionalOperator;
import org.codefilarete.stalactite.query.model.Select;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Experimental;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.KeepOrderMap;
import org.codefilarete.tool.collection.KeepOrderSet;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.collection.PairIterator;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;

public interface EntityPersister<C, I>
extends PersistExecutor<C>,
InsertExecutor<C>,
UpdateExecutor<C>,
SelectExecutor<C, I>,
DeleteExecutor<C, I>,
PersisterListener<C, I> {
    default public void persist(C entity) {
        this.persist((Iterable<? extends C>)Collections.singleton(entity));
    }

    @Override
    default public void persist(Iterable<? extends C> entities) {
        PersistExecutor.persist(entities, this::isNew, this, this, this, this::getId);
    }

    default public void insert(C entity) {
        this.insert((C)Collections.singletonList(entity));
    }

    default public void update(C modified, C unmodified, boolean allColumnsStatement) {
        this.update((C)Collections.singletonList(new Duo(modified, unmodified)), allColumnsStatement);
    }

    default public void update(C entity) {
        this.update(entity, true);
    }

    default public void update(C entity, boolean allColumnsStatement) {
        this.update(entity, this.select(this.getId(entity)), allColumnsStatement);
    }

    default public void update(Iterable<C> entities) {
        Set ids = (Set)Iterables.collect(entities, this::getId, KeepOrderSet::new);
        C entitiesFromDb = this.select((I)ids);
        Map idPerEntity = Iterables.map(entities, Function.identity(), this::getId, KeepOrderMap::new);
        Map entityFromDbPerId = Iterables.map(entitiesFromDb, this::getId, Function.identity());
        Map modifiedVsUnmodifiedEntities = Maps.innerJoinOnValuesAndKeys((Map)idPerEntity, (Map)entityFromDbPerId, KeepOrderMap::new);
        this.update((C)((Iterable)() -> new PairIterator(modifiedVsUnmodifiedEntities.keySet(), modifiedVsUnmodifiedEntities.values())), true);
    }

    @Experimental
    default public void update(I id, Consumer<C> entityConsumer) {
        this.update((Iterable<I>)Collections.singleton(id), entityConsumer);
    }

    @Experimental
    default public void update(Iterable<I> ids, Consumer<C> entityConsumer) {
        Object unmodified = this.select((I)ids);
        Object modified = this.select((I)ids);
        modified.forEach(entityConsumer);
        this.update((C)((Iterable)() -> new PairIterator((Iterable)modified, (Iterable)unmodified)), true);
    }

    default public void delete(C entity) {
        this.delete((C)Collections.singletonList(entity));
    }

    default public void deleteById(C entity) {
        this.deleteById((C)Collections.singletonList(entity));
    }

    default public C select(I id) {
        return (C)Iterables.first(this.select((I)Collections.singleton(id)));
    }

    default public <O> ExecutableEntityQuery<C> selectWhere(SerializableFunction<C, O> getter, ConditionalOperator<O, ?> operator) {
        return this.selectWhere().and((SerializableFunction)getter, (ConditionalOperator)operator);
    }

    default public <O> ExecutableEntityQuery<C> selectWhere(SerializableBiConsumer<C, O> setter, ConditionalOperator<O, ?> operator) {
        return this.selectWhere().and((SerializableBiConsumer)setter, (ConditionalOperator)operator);
    }

    default public <O, A> ExecutableEntityQuery<C> selectWhere(SerializableFunction<C, A> getter1, SerializableFunction<A, O> getter2, ConditionalOperator<O, ?> operator) {
        return this.selectWhere(AccessorChain.chain(getter1, getter2), operator);
    }

    default public <O> ExecutableEntityQuery<C> selectWhere(AccessorChain<C, O> accessorChain, ConditionalOperator<O, ?> operator) {
        return this.selectWhere().and((AccessorChain)accessorChain, (ConditionalOperator)operator);
    }

    public ExecutableEntityQuery<C> selectWhere();

    default public <O> ExecutableProjectionQuery<C> selectProjectionWhere(Consumer<Select> selectAdapter, SerializableFunction<C, O> getter, ConditionalOperator<O, ?> operator) {
        return this.selectProjectionWhere(selectAdapter).and((SerializableFunction)getter, (ConditionalOperator)operator);
    }

    default public <O> ExecutableProjectionQuery<C> selectProjectionWhere(Consumer<Select> selectAdapter, SerializableBiConsumer<C, O> setter, ConditionalOperator<O, ?> operator) {
        return this.selectProjectionWhere(selectAdapter).and((SerializableBiConsumer)setter, (ConditionalOperator)operator);
    }

    default public <O, A> ExecutableProjectionQuery<C> selectProjectionWhere(Consumer<Select> selectAdapter, SerializableFunction<C, A> getter1, SerializableFunction<A, O> getter2, ConditionalOperator<O, ?> operator) {
        return this.selectProjectionWhere(selectAdapter, AccessorChain.chain(getter1, getter2), operator);
    }

    default public <O> ExecutableProjectionQuery<C> selectProjectionWhere(Consumer<Select> selectAdapter, AccessorChain<C, O> accessorChain, ConditionalOperator<O, ?> operator) {
        return this.selectProjectionWhere(selectAdapter).and((AccessorChain)accessorChain, (ConditionalOperator)operator);
    }

    public ExecutableProjectionQuery<C> selectProjectionWhere(Consumer<Select> var1);

    public Set<C> selectAll();

    public boolean isNew(C var1);

    public I getId(C var1);

    public Class<C> getClassToPersist();

    public static interface EntityCriteria<C> {
        public <O> EntityCriteria<C> and(SerializableFunction<C, O> var1, ConditionalOperator<O, ?> var2);

        public <O> EntityCriteria<C> and(SerializableBiConsumer<C, O> var1, ConditionalOperator<O, ?> var2);

        public <O> EntityCriteria<C> or(SerializableFunction<C, O> var1, ConditionalOperator<O, ?> var2);

        public <O> EntityCriteria<C> or(SerializableBiConsumer<C, O> var1, ConditionalOperator<O, ?> var2);

        public <A, B> EntityCriteria<C> and(SerializableFunction<C, A> var1, SerializableFunction<A, B> var2, ConditionalOperator<B, ?> var3);

        public <O> EntityCriteria<C> and(AccessorChain<C, O> var1, ConditionalOperator<O, ?> var2);
    }

    public static interface ExecutableProjectionQuery<C>
    extends EntityCriteria<C>,
    ExecutableProjection {
        @Override
        public <O> ExecutableProjectionQuery<C> and(SerializableFunction<C, O> var1, ConditionalOperator<O, ?> var2);

        @Override
        public <O> ExecutableProjectionQuery<C> and(SerializableBiConsumer<C, O> var1, ConditionalOperator<O, ?> var2);

        @Override
        public <O> ExecutableProjectionQuery<C> or(SerializableFunction<C, O> var1, ConditionalOperator<O, ?> var2);

        @Override
        public <O> ExecutableProjectionQuery<C> or(SerializableBiConsumer<C, O> var1, ConditionalOperator<O, ?> var2);

        @Override
        public <A, B> ExecutableProjectionQuery<C> and(SerializableFunction<C, A> var1, SerializableFunction<A, B> var2, ConditionalOperator<B, ?> var3);

        @Override
        public <O> ExecutableProjectionQuery<C> and(AccessorChain<C, O> var1, ConditionalOperator<O, ?> var2);
    }

    public static interface ExecutableEntityQuery<C>
    extends EntityCriteria<C>,
    ExecutableQuery<C> {
        @Override
        public <O> ExecutableEntityQuery<C> and(SerializableFunction<C, O> var1, ConditionalOperator<O, ?> var2);

        @Override
        public <O> ExecutableEntityQuery<C> and(SerializableBiConsumer<C, O> var1, ConditionalOperator<O, ?> var2);

        @Override
        public <O> ExecutableEntityQuery<C> or(SerializableFunction<C, O> var1, ConditionalOperator<O, ?> var2);

        @Override
        public <O> ExecutableEntityQuery<C> or(SerializableBiConsumer<C, O> var1, ConditionalOperator<O, ?> var2);

        @Override
        public <A, B> ExecutableEntityQuery<C> and(SerializableFunction<C, A> var1, SerializableFunction<A, B> var2, ConditionalOperator<B, ?> var3);

        @Override
        public <O> ExecutableEntityQuery<C> and(AccessorChain<C, O> var1, ConditionalOperator<O, ?> var2);
    }
}

