/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.onetomany;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.codefilarete.stalactite.engine.runtime.onetomany.ManyRelationDescriptor;
import org.codefilarete.stalactite.engine.runtime.onetomany.MappedManyRelationDescriptor;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.BeanRelationFixer;
import org.codefilarete.tool.bean.Objects;

public class IndexedMappedManyRelationDescriptor<SRC, TRGT, C extends Collection<TRGT>, SRCID>
extends MappedManyRelationDescriptor<SRC, TRGT, C, SRCID> {
    private final Column<Table, Integer> indexingColumn;

    public IndexedMappedManyRelationDescriptor(Function<SRC, C> collectionGetter, BiConsumer<SRC, C> collectionSetter, Supplier<C> collectionFactory, BiConsumer<TRGT, SRC> reverseSetter, Key<?, SRCID> reverseColumn, Column<? extends Table, Integer> indexingColumn, Function<SRC, SRCID> idProvider) {
        super(collectionGetter, collectionSetter, collectionFactory, reverseSetter, reverseColumn);
        this.indexingColumn = indexingColumn;
        this.relationFixer = new InMemoryRelationHolder(idProvider);
    }

    public Column<Table, Integer> getIndexingColumn() {
        return this.indexingColumn;
    }

    public class InMemoryRelationHolder
    implements BeanRelationFixer<SRC, TRGT> {
        private final ThreadLocal<Map<SRCID, C>> relationCollectionPerEntity = new ThreadLocal();
        private final Function<SRC, SRCID> idProvider;

        public InMemoryRelationHolder(Function<SRC, SRCID> idProvider) {
            this.idProvider = idProvider;
        }

        public void apply(SRC source, TRGT input) {
            Map srcidcMap = this.relationCollectionPerEntity.get();
            Collection collection = srcidcMap.computeIfAbsent(this.idProvider.apply(source), id -> (Collection)IndexedMappedManyRelationDescriptor.this.getCollectionFactory().get());
            collection.add(input);
            ((BiConsumer)Objects.preventNull(IndexedMappedManyRelationDescriptor.this.getReverseSetter(), (Object)ManyRelationDescriptor.NOOP_REVERSE_SETTER)).accept(input, source);
        }

        public C get(SRC src) {
            Map currentMap = this.relationCollectionPerEntity.get();
            return currentMap == null ? null : (Collection)currentMap.get(this.idProvider.apply(src));
        }

        public void init() {
            this.relationCollectionPerEntity.set(new HashMap());
        }

        public void clear() {
            this.relationCollectionPerEntity.remove();
        }
    }
}

