/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer;

import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfiguration;
import org.codefilarete.stalactite.engine.PersisterRegistry;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderContext;
import org.codefilarete.tool.trace.MutableInt;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class PersisterBuilderContextTest {
    PersisterBuilderContextTest() {
    }

    @Test
    void cycling() {
        PersisterBuilderContext testInstance = new PersisterBuilderContext((PersisterRegistry)Mockito.mock(PersisterRegistry.class));
        EntityMappingConfiguration entityMappingConfigurationMock = (EntityMappingConfiguration)Mockito.mock(EntityMappingConfiguration.class);
        Mockito.when((Object)entityMappingConfigurationMock.getEntityType()).thenReturn(Integer.class);
        MutableInt invocationSafeGuard = new MutableInt();
        testInstance.runInContext(entityMappingConfigurationMock, () -> {
            invocationSafeGuard.increment();
            Assertions.assertThat((boolean)testInstance.isCycling(entityMappingConfigurationMock)).isTrue();
            EntityMappingConfiguration dummyConfiguration = (EntityMappingConfiguration)Mockito.mock(EntityMappingConfiguration.class);
            Mockito.when((Object)dummyConfiguration.getEntityType()).thenReturn(String.class);
            testInstance.runInContext(dummyConfiguration, () -> {
                invocationSafeGuard.increment();
                Assertions.assertThat((boolean)testInstance.isCycling(entityMappingConfigurationMock)).isTrue();
                testInstance.runInContext(dummyConfiguration, () -> {
                    invocationSafeGuard.increment();
                    Assertions.assertThat((boolean)testInstance.isCycling(entityMappingConfigurationMock)).isTrue();
                    Assertions.assertThat((boolean)testInstance.isCycling((EntityMappingConfiguration)Mockito.mock(EntityMappingConfiguration.class))).isFalse();
                });
            });
            testInstance.runInContext(dummyConfiguration, () -> {
                invocationSafeGuard.increment();
                Assertions.assertThat((boolean)testInstance.isCycling(entityMappingConfigurationMock)).isTrue();
                Assertions.assertThat((boolean)testInstance.isCycling((EntityMappingConfiguration)Mockito.mock(EntityMappingConfiguration.class))).isFalse();
            });
        });
        Assertions.assertThat((int)4).isEqualTo(invocationSafeGuard.getValue());
    }
}

