/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.result;

import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.codefilarete.stalactite.sql.result.Accumulators;

public interface Accumulator<T, S, R> {
    public Supplier<S> supplier();

    public BiConsumer<S, T> aggregator();

    public Function<S, R> finisher();

    default public <RR> Accumulator<T, S, RR> andThen(Function<R, RR> nextFunction) {
        return new Accumulators.AccumulatorSupport<T, S, RR>(this.supplier(), this.aggregator(), this.finisher().andThen(nextFunction));
    }

    default public R collect(Iterable<T> input) {
        Object seed = this.supplier().get();
        BiConsumer aggregator = this.aggregator();
        input.forEach(c -> aggregator.accept(seed, c));
        Function<S, R> finisher = this.finisher();
        return finisher.apply(seed);
    }
}

