/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.polymorphism;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPoint;
import org.codefilarete.reflection.ValueAccessPointMap;
import org.codefilarete.reflection.ValueAccessPointSet;
import org.codefilarete.stalactite.dsl.PolymorphismPolicy;
import org.codefilarete.stalactite.dsl.idpolicy.GeneratedKeysPolicy;
import org.codefilarete.stalactite.dsl.subentity.SubEntityMappingConfiguration;
import org.codefilarete.stalactite.engine.configurer.AbstractIdentification;
import org.codefilarete.stalactite.engine.configurer.BeanMappingBuilder;
import org.codefilarete.stalactite.engine.configurer.NamingConfiguration;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderImpl;
import org.codefilarete.stalactite.engine.configurer.polymorphism.AbstractPolymorphicPersisterBuilder;
import org.codefilarete.stalactite.engine.runtime.AbstractPolymorphismPersister;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.SimpleRelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.tableperclass.TablePerClassPolymorphismPersister;
import org.codefilarete.stalactite.mapping.DefaultEntityMapping;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.exception.NotImplementedException;
import org.codefilarete.tool.function.Converter;

class TablePerClassPolymorphismBuilder<C, I, T extends Table<T>>
extends AbstractPolymorphicPersisterBuilder<C, I, T> {
    private final Map<ReversibleAccessor<C, Object>, Column<T, Object>> mainMapping;
    private final Map<ReversibleAccessor<C, Object>, Column<T, Object>> mainReadonlyMapping;
    private final ValueAccessPointMap<C, Converter<Object, Object>> mainReadConverters;
    private final ValueAccessPointMap<C, Converter<Object, Object>> mainWriteConverters;

    public static <C, T extends Table<T>, A extends ValueAccessPoint<C>> Map<A, Column<T, Object>> projectColumns(Map<? extends A, ? extends Column<?, Object>> propertyToColumn, T targetTable, BiFunction<? super A, Column<?, Object>, String> columnNameSupplier) {
        HashMap localResult = new HashMap();
        propertyToColumn.forEach((accessor, column) -> {
            Column projectedColumn = targetTable.addColumn((String)columnNameSupplier.apply((Object)accessor, (Column<?, Object>)column), column.getJavaType());
            projectedColumn.setAutoGenerated(column.isAutoGenerated());
            projectedColumn.setNullable(column.isNullable());
            localResult.put(accessor, projectedColumn);
        });
        return localResult;
    }

    TablePerClassPolymorphismBuilder(PolymorphismPolicy.TablePerClassPolymorphism<C> polymorphismPolicy, AbstractIdentification<C, I> identification, ConfiguredRelationalPersister<C, I> mainPersister, Map<? extends ReversibleAccessor<C, Object>, Column<T, Object>> mainMapping, Map<? extends ReversibleAccessor<C, Object>, ? extends Column<T, Object>> mainReadonlyMapping, ValueAccessPointMap<C, ? extends Converter<Object, Object>> mainReadConverters, ValueAccessPointMap<C, ? extends Converter<Object, Object>> mainWriteConverters, ColumnBinderRegistry columnBinderRegistry, NamingConfiguration namingConfiguration) {
        super(polymorphismPolicy, identification, mainPersister, columnBinderRegistry, namingConfiguration);
        this.mainMapping = mainMapping;
        this.mainReadonlyMapping = mainReadonlyMapping;
        this.mainReadConverters = mainReadConverters;
        this.mainWriteConverters = mainWriteConverters;
    }

    @Override
    public AbstractPolymorphismPersister<C, I> build(Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        if (this.identification instanceof AbstractIdentification.SingleColumnIdentification && ((AbstractIdentification.SingleColumnIdentification)this.identification).getIdentifierPolicy() instanceof GeneratedKeysPolicy) {
            throw new UnsupportedOperationException("Table-per-class polymorphism is not compatible with auto-incremented primary key");
        }
        Map persisterPerSubclass = this.collectSubClassPersister(dialect, connectionConfiguration);
        this.registerSubEntitiesRelations(persisterPerSubclass, dialect, connectionConfiguration);
        TablePerClassPolymorphismPersister result = new TablePerClassPolymorphismPersister(this.mainPersister, persisterPerSubclass, connectionConfiguration.getConnectionProvider(), dialect);
        ((DefaultEntityMapping)this.mainPersister.getMapping()).getShadowColumnsForInsert().forEach(columnProvider -> result.getMapping().addShadowColumnInsert(columnProvider));
        ((DefaultEntityMapping)this.mainPersister.getMapping()).getShadowColumnsForUpdate().forEach(columnProvider -> result.getMapping().addShadowColumnUpdate(columnProvider));
        return result;
    }

    private <D extends C> Map<Class<D>, ConfiguredRelationalPersister<D, I>> collectSubClassPersister(Dialect dialect, ConnectionConfiguration connectionConfiguration) {
        HashMap<Class<D>, ConfiguredRelationalPersister<D, I>> persisterPerSubclass = new HashMap<Class<D>, ConfiguredRelationalPersister<D, I>>();
        for (SubEntityMappingConfiguration subConfiguration : this.polymorphismPolicy.getSubClasses()) {
            SimpleRelationalEntityPersister subclassPersister = this.buildSubclassPersister(dialect, connectionConfiguration, subConfiguration);
            persisterPerSubclass.put(subConfiguration.getEntityType(), subclassPersister);
        }
        return persisterPerSubclass;
    }

    private <D extends C, SUBTABLE extends Table<SUBTABLE>> SimpleRelationalEntityPersister<D, I, SUBTABLE> buildSubclassPersister(Dialect dialect, ConnectionConfiguration connectionConfiguration, SubEntityMappingConfiguration<D> subConfiguration) {
        Table tableDefinedByInheritanceConfiguration = ((PolymorphismPolicy.TablePerClassPolymorphism)this.polymorphismPolicy).giveTable(subConfiguration);
        Table tableDefinedByColumnOverride = BeanMappingBuilder.giveTargetTable(subConfiguration.getPropertiesMapping(), tableDefinedByInheritanceConfiguration);
        Table subTable = (Table)Nullable.nullable((Object)tableDefinedByColumnOverride).elseSet((Object)tableDefinedByInheritanceConfiguration).getOr(() -> new Table(this.namingConfiguration.getTableNamingStrategy().giveName(subConfiguration.getEntityType())));
        BeanMappingBuilder<D, Table> beanMappingBuilder = new BeanMappingBuilder<D, Table>(subConfiguration.getPropertiesMapping(), subTable, this.columnBinderRegistry, this.namingConfiguration.getColumnNamingStrategy());
        BeanMappingBuilder.BeanMapping<D, Table> beanMapping = beanMappingBuilder.build();
        Map<ReversibleAccessor<D, Object>, Column<Table, Object>> subEntityPropertiesMapping = beanMapping.getMapping();
        Map<ReversibleAccessor<D, Object>, Column<Table, Object>> subEntityReadonlyPropertiesMapping = beanMapping.getReadonlyMapping();
        ValueAccessPointMap<D, Converter<Object, Object>> subEntityPropertiesReadConverters = beanMapping.getReadConverters();
        ValueAccessPointMap<D, Converter<Object, Object>> subEntityPropertiesWriteConverters = beanMapping.getWriteConverters();
        this.addPrimaryKey(subTable);
        Map<ReversibleAccessor, Column<Table, Object>> projectedMainMapping = TablePerClassPolymorphismBuilder.projectColumns(this.mainMapping, subTable, (accessor, c) -> c.getName());
        subEntityPropertiesMapping.putAll(projectedMainMapping);
        Map<ReversibleAccessor, Column<Table, Object>> projectedMainReadonlyMapping = TablePerClassPolymorphismBuilder.projectColumns(this.mainReadonlyMapping, subTable, (accessor, c) -> c.getName());
        subEntityReadonlyPropertiesMapping.putAll(projectedMainReadonlyMapping);
        subEntityPropertiesReadConverters.putAll(this.mainReadConverters);
        subEntityPropertiesWriteConverters.putAll(this.mainWriteConverters);
        PersisterBuilderImpl.MappingPerTable.Mapping<D, Table> subEntityMapping = new PersisterBuilderImpl.MappingPerTable.Mapping<D, Table>(subConfiguration, subTable, subEntityPropertiesMapping, subEntityReadonlyPropertiesMapping, subEntityPropertiesReadConverters, subEntityPropertiesWriteConverters, false);
        this.addIdentificationToMapping(this.identification, subEntityMapping);
        DefaultEntityMapping entityMapping = PersisterBuilderImpl.createEntityMapping(true, subTable, subEntityPropertiesMapping, subEntityReadonlyPropertiesMapping, subEntityPropertiesReadConverters, subEntityPropertiesWriteConverters, new ValueAccessPointSet(), this.identification, subConfiguration.getPropertiesMapping().getBeanType(), null);
        ((DefaultEntityMapping)this.mainPersister.getMapping()).getShadowColumnsForInsert().forEach(columnProvider -> columnProvider.getColumns().forEach(c -> {
            Column column = subTable.addColumn(c.getName(), c.getJavaType(), c.getSize());
            column.setNullable(c.isNullable());
        }));
        ((DefaultEntityMapping)this.mainPersister.getMapping()).getShadowColumnsForUpdate().forEach(columnProvider -> columnProvider.getColumns().forEach(c -> {
            Column column = subTable.addColumn(c.getName(), c.getJavaType(), c.getSize());
            column.setNullable(c.isNullable());
        }));
        return new SimpleRelationalEntityPersister(entityMapping, dialect, connectionConfiguration);
    }

    private void addPrimaryKey(Table table) {
        PersisterBuilderImpl.propagatePrimaryKey(this.mainPersister.getMapping().getTargetTable().getPrimaryKey(), Arrays.asSet((Object[])new Table[]{table}));
    }

    private void addIdentificationToMapping(AbstractIdentification<C, I> identification, PersisterBuilderImpl.MappingPerTable.Mapping mapping) {
        PersisterBuilderImpl.addIdentificationToMapping(identification, Arrays.asSet((Object[])new PersisterBuilderImpl.MappingPerTable.Mapping[]{mapping}));
    }

    @Override
    void assertSubPolymorphismIsSupported(PolymorphismPolicy<? extends C> subPolymorphismPolicy) {
        if (subPolymorphismPolicy instanceof PolymorphismPolicy.TablePerClassPolymorphism) {
            throw new NotImplementedException("Combining table-per-class polymorphism policy with " + Reflections.toString(subPolymorphismPolicy.getClass()));
        }
    }
}

