/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.onetomany;

import java.util.Collection;
import java.util.HashSet;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.stalactite.dsl.MappingConfigurationException;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfiguration;
import org.codefilarete.stalactite.dsl.naming.AssociationTableNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.ColumnNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.dsl.naming.JoinColumnNamingStrategy;
import org.codefilarete.stalactite.dsl.property.CascadeOptions;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderContext;
import org.codefilarete.stalactite.engine.configurer.PersisterBuilderImpl;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyAssociationConfiguration;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyConfigurerTemplate;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyCycleConfigurer;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyRelation;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyWithAssociationTableConfigurer;
import org.codefilarete.stalactite.engine.configurer.onetomany.OneToManyWithMappedAssociationConfigurer;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.StringAppender;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;

public class OneToManyRelationConfigurer<SRC, TRGT, SRCID, TRGTID> {
    private final ConfiguredRelationalPersister<SRC, SRCID> sourcePersister;
    private final Dialect dialect;
    private final ConnectionConfiguration connectionConfiguration;
    private final ForeignKeyNamingStrategy foreignKeyNamingStrategy;
    private final JoinColumnNamingStrategy joinColumnNamingStrategy;
    private final AssociationTableNamingStrategy associationTableNamingStrategy;
    private final ColumnNamingStrategy indexColumnNamingStrategy;
    private final PrimaryKey<?, SRCID> leftPrimaryKey;

    public OneToManyRelationConfigurer(ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, Dialect dialect, ConnectionConfiguration connectionConfiguration, ForeignKeyNamingStrategy foreignKeyNamingStrategy, JoinColumnNamingStrategy joinColumnNamingStrategy, AssociationTableNamingStrategy associationTableNamingStrategy, ColumnNamingStrategy indexColumnNamingStrategy) {
        this.sourcePersister = sourcePersister;
        this.dialect = dialect;
        this.connectionConfiguration = connectionConfiguration;
        this.foreignKeyNamingStrategy = foreignKeyNamingStrategy;
        this.joinColumnNamingStrategy = joinColumnNamingStrategy;
        this.associationTableNamingStrategy = associationTableNamingStrategy;
        this.indexColumnNamingStrategy = indexColumnNamingStrategy;
        this.leftPrimaryKey = sourcePersister.getMapping().getTargetTable().getPrimaryKey();
    }

    public void configure(OneToManyRelation<SRC, TRGT, TRGTID, ? extends Collection<TRGT>> oneToManyRelation) {
        OneToManyConfigurerTemplate configurer;
        CascadeOptions.RelationMode maintenanceMode = oneToManyRelation.getRelationMode();
        boolean orphanRemoval = maintenanceMode == CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL;
        boolean writeAuthorized = maintenanceMode != CascadeOptions.RelationMode.READ_ONLY;
        String columnName = oneToManyRelation.getIndexingColumnName();
        OneToManyAssociationConfiguration associationConfiguration = new OneToManyAssociationConfiguration(oneToManyRelation, this.sourcePersister, this.leftPrimaryKey, this.foreignKeyNamingStrategy, this.joinColumnNamingStrategy, this.indexColumnNamingStrategy, columnName, orphanRemoval, writeAuthorized);
        if (oneToManyRelation.isOwnedByReverseSide()) {
            if (maintenanceMode == CascadeOptions.RelationMode.ASSOCIATION_ONLY) {
                throw new MappingConfigurationException((Object)((Object)CascadeOptions.RelationMode.ASSOCIATION_ONLY) + " is only relevant with an association table");
            }
            configurer = new OneToManyWithMappedAssociationConfigurer(associationConfiguration, oneToManyRelation.isFetchSeparately());
        } else {
            configurer = new OneToManyWithAssociationTableConfigurer(associationConfiguration, oneToManyRelation.isFetchSeparately(), this.associationTableNamingStrategy, maintenanceMode == CascadeOptions.RelationMode.ASSOCIATION_ONLY, this.dialect, this.connectionConfiguration);
        }
        PersisterBuilderContext currentBuilderContext = PersisterBuilderContext.CURRENT.get();
        EntityMappingConfiguration<TRGT, TRGTID> targetMappingConfiguration = oneToManyRelation.getTargetMappingConfiguration();
        if (currentBuilderContext.isCycling(targetMappingConfiguration)) {
            Class targetEntityType = targetMappingConfiguration.getEntityType();
            OneToManyCycleConfigurer cycleSolver = (OneToManyCycleConfigurer)Iterables.find(currentBuilderContext.getBuildLifeCycleListeners(), p -> p instanceof OneToManyCycleConfigurer && ((OneToManyCycleConfigurer)p).getEntityType() == targetEntityType);
            if (cycleSolver == null) {
                cycleSolver = new OneToManyCycleConfigurer(targetEntityType);
                currentBuilderContext.addBuildLifeCycleListener(cycleSolver);
            }
            String relationName = AccessorDefinition.giveDefinition(oneToManyRelation.getCollectionProvider()).getName();
            cycleSolver.addCycleSolver(relationName, configurer);
        } else {
            Table targetTable = this.determineTargetTable(oneToManyRelation);
            ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister = new PersisterBuilderImpl<TRGT, TRGTID>(targetMappingConfiguration).build(this.dialect, this.connectionConfiguration, targetTable);
            configurer.configure(targetPersister);
        }
    }

    private Table determineTargetTable(OneToManyRelation<SRC, TRGT, TRGTID, ?> oneToManyRelation) {
        Table reverseTable = (Table)Nullable.nullable(oneToManyRelation.getReverseColumn()).map(Column::getTable).get();
        Table indexingTable = (Table)Nullable.nullable(oneToManyRelation.getIndexingColumn()).map(Column::getTable).get();
        HashSet availableTables = Arrays.asHashSet((Object[])new Table[]{oneToManyRelation.getTargetTable(), reverseTable, indexingTable});
        availableTables.remove(null);
        if (availableTables.size() > 1) {
            class TableAppender
            extends StringAppender {
                TableAppender() {
                }

                public StringAppender cat(Object o) {
                    if (o instanceof Table) {
                        return super.cat((Object)((Table)o).getName());
                    }
                    return super.cat(o);
                }
            }
            throw new MappingConfigurationException("Different tables used for configuring mapping : " + new TableAppender().ccat(availableTables, ", "));
        }
        return (Table)Nullable.nullable((Object)oneToManyRelation.getTargetTable()).elseSet((Object)reverseTable).elseSet((Object)indexingTable).get();
    }
}

