/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.map;

import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.codefilarete.reflection.AccessorByMethodReference;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.reflection.MutatorByMethodReference;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.reflection.ValueAccessPointMap;
import org.codefilarete.stalactite.dsl.embeddable.EmbeddableMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.entity.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.dsl.property.CascadeOptions;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;

public class MapRelation<SRC, K, V, M extends Map<K, V>> {
    private final ReversibleAccessor<SRC, M> mapProvider;
    private final Class<K> keyType;
    private final Class<V> valueType;
    private Supplier<M> mapFactory;
    private Table targetTable;
    private String targetTableName;
    private Column<Table, ?> reverseColumn;
    private String reverseColumnName;
    private String keyColumnName;
    private String valueColumnName;
    private final ValueAccessPointMap<SRC, String> overriddenKeyColumnNames = new ValueAccessPointMap();
    private final ValueAccessPointMap<SRC, String> overriddenValueColumnNames = new ValueAccessPointMap();
    @Nullable
    private EntityMappingConfigurationProvider<K, ?> keyEntityConfigurationProvider;
    @Nullable
    private EmbeddableMappingConfigurationProvider<K> keyEmbeddableConfigurationProvider;
    @Nullable
    private EntityMappingConfigurationProvider<V, ?> valueEntityConfigurationProvider;
    @Nullable
    private EmbeddableMappingConfigurationProvider<V> valueEmbeddableConfigurationProvider;
    private CascadeOptions.RelationMode keyEntityRelationMode = CascadeOptions.RelationMode.ALL;
    private CascadeOptions.RelationMode valueEntityRelationMode = CascadeOptions.RelationMode.ALL;
    private boolean fetchSeparately;

    public MapRelation(SerializableBiConsumer<SRC, M> setter, Class<K> keyType, Class<V> valueType) {
        this((ReversibleAccessor<SRC, M>)Accessors.mutator(setter), keyType, valueType);
    }

    public MapRelation(SerializableFunction<SRC, M> getter, Class<K> keyType, Class<V> valueType) {
        this((ReversibleAccessor<SRC, M>)Accessors.accessor(getter), keyType, valueType);
    }

    public MapRelation(ReversibleAccessor<SRC, M> mapProvider, Class<K> keyType, Class<V> valueType) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.mapProvider = mapProvider;
    }

    public ReversibleAccessor<SRC, M> getMapProvider() {
        return this.mapProvider;
    }

    public Class<K> getKeyType() {
        return this.keyType;
    }

    public Class<V> getValueType() {
        return this.valueType;
    }

    public Supplier<M> getMapFactory() {
        return this.mapFactory;
    }

    public void setMapFactory(Supplier<M> mapFactory) {
        this.mapFactory = mapFactory;
    }

    public Table getTargetTable() {
        return this.targetTable;
    }

    public void setTargetTable(Table targetTable) {
        this.targetTable = targetTable;
    }

    public String getTargetTableName() {
        return this.targetTableName;
    }

    public void setTargetTableName(String targetTableName) {
        this.targetTableName = targetTableName;
    }

    public <I> Column<Table, I> getReverseColumn() {
        return this.reverseColumn;
    }

    public void setReverseColumn(Column<Table, ?> reverseColumn) {
        this.reverseColumn = reverseColumn;
    }

    public String getReverseColumnName() {
        return this.reverseColumnName;
    }

    public void setReverseColumnName(String reverseColumnName) {
        this.reverseColumnName = reverseColumnName;
    }

    public void setKeyConfigurationProvider(@Nullable EntityMappingConfigurationProvider<K, ?> keyConfigurationProvider) {
        this.keyEntityConfigurationProvider = keyConfigurationProvider;
    }

    @Nullable
    public EmbeddableMappingConfigurationProvider<K> getKeyEmbeddableConfigurationProvider() {
        return this.keyEmbeddableConfigurationProvider;
    }

    public void setKeyConfigurationProvider(@Nullable EmbeddableMappingConfigurationProvider<K> keyConfigurationProvider) {
        this.keyEmbeddableConfigurationProvider = keyConfigurationProvider;
    }

    @Nullable
    public EntityMappingConfigurationProvider<K, ?> getKeyEntityConfigurationProvider() {
        return this.keyEntityConfigurationProvider;
    }

    public void setValueConfigurationProvider(@Nullable EntityMappingConfigurationProvider<V, ?> valueConfigurationProvider) {
        this.valueEntityConfigurationProvider = valueConfigurationProvider;
    }

    @Nullable
    public EntityMappingConfigurationProvider<V, ?> getValueEntityConfigurationProvider() {
        return this.valueEntityConfigurationProvider;
    }

    public void setValueConfigurationProvider(@Nullable EmbeddableMappingConfigurationProvider<V> valueConfigurationProvider) {
        this.valueEmbeddableConfigurationProvider = valueConfigurationProvider;
    }

    @Nullable
    public EmbeddableMappingConfigurationProvider<V> getValueEmbeddableConfigurationProvider() {
        return this.valueEmbeddableConfigurationProvider;
    }

    public void setKeyColumnName(String keyColumnName) {
        this.keyColumnName = keyColumnName;
    }

    public String getKeyColumnName() {
        return this.keyColumnName;
    }

    public void setValueColumnName(String valueColumnName) {
        this.valueColumnName = valueColumnName;
    }

    public String getValueColumnName() {
        return this.valueColumnName;
    }

    public ValueAccessPointMap<SRC, String> getOverriddenKeyColumnNames() {
        return this.overriddenKeyColumnNames;
    }

    public void overrideKeyName(SerializableFunction methodRef, String columnName) {
        this.overriddenKeyColumnNames.put((Object)new AccessorByMethodReference(methodRef), (Object)columnName);
    }

    public void overrideKeyName(SerializableBiConsumer methodRef, String columnName) {
        this.overriddenKeyColumnNames.put((Object)new MutatorByMethodReference(methodRef), (Object)columnName);
    }

    public ValueAccessPointMap<SRC, String> getOverriddenValueColumnNames() {
        return this.overriddenValueColumnNames;
    }

    public void overrideValueName(SerializableFunction methodRef, String columnName) {
        this.overriddenValueColumnNames.put((Object)new AccessorByMethodReference(methodRef), (Object)columnName);
    }

    public void overrideValueName(SerializableBiConsumer methodRef, String columnName) {
        this.overriddenValueColumnNames.put((Object)new MutatorByMethodReference(methodRef), (Object)columnName);
    }

    public CascadeOptions.RelationMode getKeyEntityRelationMode() {
        return this.keyEntityRelationMode;
    }

    public void setKeyEntityRelationMode(CascadeOptions.RelationMode keyEntityRelationMode) {
        this.keyEntityRelationMode = keyEntityRelationMode;
    }

    public CascadeOptions.RelationMode getValueEntityRelationMode() {
        return this.valueEntityRelationMode;
    }

    public void setValueEntityRelationMode(CascadeOptions.RelationMode valueEntityRelationMode) {
        this.valueEntityRelationMode = valueEntityRelationMode;
    }

    public boolean isFetchSeparately() {
        return this.fetchSeparately;
    }

    public void fetchSeparately() {
        this.fetchSeparately = true;
    }
}

