/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement.binder;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;

public class LocalTimeBinder
implements ParameterBinder<LocalTime> {
    public static final LocalDate DEFAULT_TIMESTAMP_REFERENCE_DATE = LocalDate.of(2000, Month.JANUARY, 1);
    private final LocalDate timestampReferenceDate;

    public LocalTimeBinder() {
        this(DEFAULT_TIMESTAMP_REFERENCE_DATE);
    }

    public LocalTimeBinder(LocalDate timestampReferenceDate) {
        this.timestampReferenceDate = timestampReferenceDate;
    }

    @Override
    public Class<LocalTime> getType() {
        return LocalTime.class;
    }

    @Override
    public LocalTime doGet(ResultSet resultSet, String columnName) throws SQLException {
        return resultSet.getTimestamp(columnName).toLocalDateTime().toLocalTime();
    }

    @Override
    public void set(PreparedStatement statement, int valueIndex, LocalTime value) throws SQLException {
        statement.setTimestamp(valueIndex, Timestamp.valueOf(value.atDate(this.timestampReferenceDate)));
    }
}

