/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query.execution.reduce;

import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.codefilarete.stalactite.spring.repository.query.StalactiteRepositoryQuery;
import org.codefilarete.stalactite.spring.repository.query.execution.StalactiteQueryMethodInvocationParameters;
import org.codefilarete.stalactite.spring.repository.query.execution.reduce.LimitHandler;
import org.codefilarete.stalactite.spring.repository.query.execution.reduce.QueryResultReducer;
import org.codefilarete.stalactite.spring.repository.query.execution.reduce.QueryResultWindower;
import org.springframework.data.domain.Pageable;

public class QueryResultStreamer<C, R, I>
implements QueryResultReducer<Stream<R>, I> {
    private final StalactiteRepositoryQuery<C, ?> delegate;
    private final LimitHandler limitHandler;

    public QueryResultStreamer(StalactiteRepositoryQuery<C, ?> delegate, LimitHandler limitHandler) {
        this.delegate = delegate;
        this.limitHandler = limitHandler;
    }

    @Override
    public Function<Object[], Stream<R>> adapt(Supplier<List<I>> resultSupplier) {
        return new StreamResultWindower(this.delegate, this.limitHandler, resultSupplier)::adaptExecution;
    }

    private static class StreamResultWindower<C, R, P>
    extends QueryResultWindower<C, R, P> {
        public StreamResultWindower(StalactiteRepositoryQuery<C, ?> delegate, LimitHandler limitHandler, Supplier<List<P>> resultSupplier) {
            super(delegate, limitHandler, (accessor, result) -> {
                int pageSize = 0;
                Pageable pageable = accessor.getPageable();
                if (pageable.isPaged()) {
                    pageSize = pageable.getPageSize();
                }
                boolean hasNext = pageable.isPaged() && result.size() > pageSize;
                result = hasNext ? result.subList(0, pageSize) : result;
                return result.stream();
            }, resultSupplier);
        }

        @Override
        protected void adaptLimit(StalactiteQueryMethodInvocationParameters invocationParameters) {
            Pageable pageable = invocationParameters.getPageable();
            if (!pageable.isUnpaged()) {
                if (pageable.getPageNumber() == 0) {
                    this.limitHandler.limit(pageable.getPageSize() + 1);
                } else {
                    this.limitHandler.limit(pageable.getPageSize(), (int)pageable.getOffset());
                }
            }
        }
    }
}

