/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer.onetoone;

import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.engine.CascadeOptions;
import org.codefilarete.stalactite.engine.EntityMappingConfiguration;
import org.codefilarete.stalactite.engine.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.PolymorphismPolicy;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.danekja.java.util.function.serializable.SerializableBiConsumer;
import org.danekja.java.util.function.serializable.SerializableFunction;

public class OneToOneRelation<SRC, TRGT, TRGTID> {
    private final ReversibleAccessor<SRC, TRGT> targetProvider;
    private final EntityMappingConfigurationProvider<TRGT, TRGTID> targetMappingConfiguration;
    private final BooleanSupplier sourceTablePerClassPolymorphic;
    @Nullable
    private final Table<?> targetTable;
    private boolean nullable = true;
    @Nullable
    private SerializableFunction<TRGT, SRC> reverseGetter;
    @Nullable
    private SerializableBiConsumer<TRGT, SRC> reverseSetter;
    @Nullable
    private Column<Table, SRC> reverseColumn;
    @Nullable
    private String reverseColumnName;
    private CascadeOptions.RelationMode relationMode = CascadeOptions.RelationMode.ALL;
    private boolean fetchSeparately;

    public OneToOneRelation(ReversibleAccessor<SRC, TRGT> targetProvider, boolean sourceTablePerClassPolymorphic, EntityMappingConfiguration<TRGT, TRGTID> targetMappingConfiguration, Table<?> table) {
        this(targetProvider, () -> sourceTablePerClassPolymorphic, () -> targetMappingConfiguration, table);
    }

    public OneToOneRelation(ReversibleAccessor<SRC, TRGT> targetProvider, BooleanSupplier sourceTablePerClassPolymorphic, EntityMappingConfigurationProvider<? extends TRGT, TRGTID> targetMappingConfiguration, Table<?> table) {
        this.sourceTablePerClassPolymorphic = sourceTablePerClassPolymorphic;
        this.targetMappingConfiguration = targetMappingConfiguration;
        this.targetProvider = targetProvider;
        this.targetTable = table;
    }

    public ReversibleAccessor<SRC, TRGT> getTargetProvider() {
        return this.targetProvider;
    }

    public boolean isSourceTablePerClassPolymorphic() {
        return this.sourceTablePerClassPolymorphic.getAsBoolean();
    }

    public EntityMappingConfiguration<TRGT, TRGTID> getTargetMappingConfiguration() {
        return this.targetMappingConfiguration.getConfiguration();
    }

    public boolean isTargetTablePerClassPolymorphic() {
        return this.getTargetMappingConfiguration().getPolymorphismPolicy() instanceof PolymorphismPolicy.TablePerClassPolymorphism;
    }

    @Nullable
    public Table getTargetTable() {
        return this.targetTable;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    @Nullable
    public SerializableFunction<TRGT, SRC> getReverseGetter() {
        return this.reverseGetter;
    }

    public void setReverseGetter(@Nullable SerializableFunction<? super TRGT, SRC> reverseGetter) {
        this.reverseGetter = reverseGetter;
    }

    @Nullable
    public SerializableBiConsumer<TRGT, SRC> getReverseSetter() {
        return this.reverseSetter;
    }

    public void setReverseSetter(@Nullable SerializableBiConsumer<? super TRGT, SRC> reverseSetter) {
        this.reverseSetter = reverseSetter;
    }

    @Nullable
    public <T extends Table, O> Column<T, O> getReverseColumn() {
        return this.reverseColumn;
    }

    public void setReverseColumn(Column reverseSide) {
        this.reverseColumn = reverseSide;
    }

    @Nullable
    public String getReverseColumnName() {
        return this.reverseColumnName;
    }

    public void setReverseColumn(@Nullable String reverseColumnName) {
        this.reverseColumnName = reverseColumnName;
    }

    public CascadeOptions.RelationMode getRelationMode() {
        return this.relationMode;
    }

    public void setRelationMode(CascadeOptions.RelationMode relationMode) {
        this.relationMode = relationMode;
    }

    public boolean isRelationOwnedByTarget() {
        return this.getReverseSetter() != null || this.getReverseGetter() != null || this.getReverseColumn() != null || this.getReverseColumnName() != null;
    }

    public boolean isFetchSeparately() {
        return this.fetchSeparately;
    }

    public void setFetchSeparately(boolean fetchSeparately) {
        this.fetchSeparately = fetchSeparately;
    }

    public void fetchSeparately() {
        this.setFetchSeparately(true);
    }
}

