/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.Mutator;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.engine.MappingConfigurationException;
import org.codefilarete.stalactite.mapping.id.assembly.ComposedIdentifierAssembler;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.ColumnedRow;
import org.codefilarete.tool.Reflections;
import org.codefilarete.tool.collection.Iterables;

public class DefaultComposedIdentifierAssembler<I, T extends Table<T>>
extends ComposedIdentifierAssembler<I, T> {
    private final Function<ColumnedRow, I> keyFactory;
    private final Map<ReversibleAccessor<I, ?>, Column<T, ?>> mapping;
    private final Map<Accessor<I, ?>, Column<T, ?>> compositeKeyReaders;
    private final Map<Mutator<I, ?>, Column<T, ?>> compositeKeyWriters;
    private final Constructor<I> defaultConstructor;

    public DefaultComposedIdentifierAssembler(T targetTable, Class<I> keyType, Map<? extends ReversibleAccessor<I, ?>, ? extends Column<T, ?>> mapping) {
        super(targetTable);
        this.mapping = mapping;
        this.defaultConstructor = Reflections.findConstructor(keyType, (Class[])new Class[0]);
        this.keyFactory = this.defaultConstructor == null ? keyValueProvider -> {
            throw new MappingConfigurationException("Key class " + Reflections.toString((Class)keyType) + " doesn't have a compatible accessible constructor, please implement a no-arg constructor");
        } : keyValueProvider -> Reflections.newInstance(this.defaultConstructor, (Object[])new Object[0]);
        this.compositeKeyReaders = Iterables.map(mapping.entrySet(), Map.Entry::getKey, Map.Entry::getValue);
        this.compositeKeyWriters = Iterables.map(mapping.entrySet(), entry -> ((ReversibleAccessor)entry.getKey()).toMutator(), Map.Entry::getValue);
    }

    public Map<ReversibleAccessor<I, ?>, Column<T, ?>> getMapping() {
        return this.mapping;
    }

    public Constructor<I> getDefaultConstructor() {
        return this.defaultConstructor;
    }

    public Map<Accessor<I, ?>, Column<T, ?>> getCompositeKeyReaders() {
        return this.compositeKeyReaders;
    }

    public Map<Mutator<I, ?>, Column<T, ?>> getCompositeKeyWriters() {
        return this.compositeKeyWriters;
    }

    public Map<Column<T, ?>, Object> getColumnValues(I id) {
        HashMap result = new HashMap();
        this.compositeKeyReaders.forEach((propertyAccessor, column) -> result.put((Column)column, id == null ? null : propertyAccessor.get(id)));
        return result;
    }

    @Nullable
    public I assemble(ColumnedRow columnValueProvider) {
        boolean hasAnyNullValue = this.getColumns().stream().anyMatch(column -> {
            Object partialKeyValue = columnValueProvider.get((Selectable)column);
            return partialKeyValue == null || Reflections.PRIMITIVE_DEFAULT_VALUES.containsValue(partialKeyValue);
        });
        if (hasAnyNullValue) {
            return null;
        }
        Object result = this.keyFactory.apply(columnValueProvider);
        this.mapping.forEach((setter, col) -> setter.toMutator().set(result, columnValueProvider.get((Selectable)col)));
        return result;
    }
}

