/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.sql.DataSource;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.codefilarete.stalactite.engine.CascadeOptions;
import org.codefilarete.stalactite.engine.EntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.FluentEntityMappingBuilder;
import org.codefilarete.stalactite.engine.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.engine.JdbcForeignKey;
import org.codefilarete.stalactite.engine.MappingConfigurationException;
import org.codefilarete.stalactite.engine.MappingEase;
import org.codefilarete.stalactite.engine.PersistenceContext;
import org.codefilarete.stalactite.engine.PolymorphismPolicy;
import org.codefilarete.stalactite.engine.SubEntityMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.idprovider.LongProvider;
import org.codefilarete.stalactite.engine.model.City;
import org.codefilarete.stalactite.engine.model.Country;
import org.codefilarete.stalactite.engine.model.State;
import org.codefilarete.stalactite.engine.model.Town;
import org.codefilarete.stalactite.engine.runtime.ConfiguredPersister;
import org.codefilarete.stalactite.engine.runtime.OptimizedUpdatePersister;
import org.codefilarete.stalactite.id.Identifier;
import org.codefilarete.stalactite.id.PersistableIdentifier;
import org.codefilarete.stalactite.id.PersistedIdentifier;
import org.codefilarete.stalactite.id.StatefulIdentifierAlreadyAssignedIdentifierPolicy;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.CurrentThreadConnectionProvider;
import org.codefilarete.stalactite.sql.Dialect;
import org.codefilarete.stalactite.sql.HSQLDBDialectBuilder;
import org.codefilarete.stalactite.sql.ddl.DDLDeployer;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.codefilarete.stalactite.sql.result.ResultSetIterator;
import org.codefilarete.stalactite.sql.result.RowIterator;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.test.HSQLDBInMemoryDataSource;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.Maps;
import org.codefilarete.tool.exception.Exceptions;
import org.codefilarete.tool.function.ThrowingSupplier;
import org.danekja.java.util.function.serializable.SerializableFunction;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class FluentEntityMappingConfigurationSupportOneToManySetTest {
    private static final Dialect DIALECT = HSQLDBDialectBuilder.defaultHSQLDBDialect();
    private static FluentEntityMappingBuilder<City, Identifier<Long>> CITY_MAPPING_CONFIGURATION;
    private final DataSource dataSource = new HSQLDBInMemoryDataSource();
    private final ConnectionProvider connectionProvider = new CurrentThreadConnectionProvider(this.dataSource);
    private PersistenceContext persistenceContext;

    FluentEntityMappingConfigurationSupportOneToManySetTest() {
    }

    @BeforeAll
    static void initBinders() {
        DIALECT.getColumnBinderRegistry().register(Identifier.class, Identifier.identifierBinder(DefaultParameterBinders.LONG_PRIMITIVE_BINDER));
        DIALECT.getSqlTypeRegistry().put(Identifier.class, "int");
    }

    @BeforeEach
    void beforeTest() {
        this.persistenceContext = new PersistenceContext(this.connectionProvider, DIALECT);
        CITY_MAPPING_CONFIGURATION = MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName);
    }

    @Test
    void mappedBy_set_crud() {
        FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions cityConfiguration = MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName);
        EntityPersister persister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)cityConfiguration).mappedBy(City::getCountry).cascading(CascadeOptions.RelationMode.ALL).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Country country = new Country(new PersistableIdentifier<Long>(1L));
        City grenoble = new City(new PersistableIdentifier<Long>(13L));
        grenoble.setName("Grenoble");
        country.addCity(grenoble);
        City lyon = new City(new PersistableIdentifier<Long>(17L));
        lyon.setName("Lyon");
        country.addCity(lyon);
        persister.insert((Object)country);
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery2 = this.persistenceContext.newQuery((CharSequence)"select countryId from city", Long.class).mapKey((SerializableFunction & Serializable)i -> i, "countryId", Long.class);
        Set cityCountryIds = (Set)longExecutableQuery2.execute(Accumulators.toSet());
        Assertions.assertThat(new HashSet(cityCountryIds)).isEqualTo((Object)Arrays.asSet((Object[])new Long[]{(Long)country.getId().getDelegate()}));
        Country loadedCountry = (Country)persister.select(country.getId());
        Assertions.assertThat(loadedCountry.getCities()).extracting(City::getName).containsExactlyInAnyOrder((Object[])new String[]{"Grenoble", "Lyon"});
        Assertions.assertThat((Object)((City)Iterables.first(loadedCountry.getCities())).getCountry()).isEqualTo((Object)loadedCountry);
        Country modifiedCountry = new Country(country.getId());
        modifiedCountry.addCity((City)Iterables.first(country.getCities()));
        persister.update((Object)modifiedCountry, (Object)country, false);
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = this.persistenceContext.newQuery((CharSequence)"select countryId from city", Long.class).mapKey((SerializableFunction & Serializable)i -> i, "countryId", Long.class);
        cityCountryIds = (Set)longExecutableQuery1.execute(Accumulators.toSet());
        Assertions.assertThat(new HashSet(cityCountryIds)).isEqualTo((Object)Arrays.asSet((Object[])new Long[]{(Long)country.getId().getDelegate(), null}));
        persister.delete((Object)modifiedCountry);
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = this.persistenceContext.newQuery((CharSequence)"select countryId from city", Long.class).mapKey((SerializableFunction & Serializable)i -> i, "countryId", Long.class);
        cityCountryIds = (Set)longExecutableQuery.execute(Accumulators.toSet());
        Assertions.assertThat(new HashSet(cityCountryIds)).isEqualTo((Object)Arrays.asSet((Object[])new Long[]{null}));
    }

    @Test
    void fetchSeparately() throws SQLException {
        EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).mapOneToMany(Country::getCities, CITY_MAPPING_CONFIGURATION).mappedBy(City::setCountry).fetchSeparately().build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        this.persistenceContext.getConnectionProvider().giveConnection().prepareStatement("insert into Country(id, name) values (42, 'France')").execute();
        this.persistenceContext.getConnectionProvider().giveConnection().prepareStatement("insert into City(id, name, countryId) values (1, 'Paris', 42)").execute();
        this.persistenceContext.getConnectionProvider().giveConnection().prepareStatement("insert into City(id, name, countryId) values (2, 'Lyon', 42)").execute();
        Country loadedCountry = (Country)countryPersister.select(new PersistedIdentifier<Long>(42L));
        Assertions.assertThat(loadedCountry.getCities()).extracting(City::getName).containsExactlyInAnyOrder((Object[])new String[]{"Paris", "Lyon"});
    }

    @Test
    void withPolymorphicTarget_crud() {
        FluentEntityMappingBuilder cityConfiguration = MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName).mapPolymorphism((PolymorphismPolicy)PolymorphismPolicy.joinTable().addSubClass((SubEntityMappingConfigurationProvider)MappingEase.subentityBuilder(Town.class, Identifier.LONG_TYPE)));
        EntityPersister persister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToMany(Country::getTowns, (EntityMappingConfigurationProvider)cityConfiguration).mappedBy(City::getCountry).cascading(CascadeOptions.RelationMode.ALL).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Country country = new Country(new PersistableIdentifier<Long>(1L));
        Town grenoble = new Town(new PersistableIdentifier<Long>(13L));
        grenoble.setName("Grenoble");
        country.addTown(grenoble);
        Town lyon = new Town(new PersistableIdentifier<Long>(17L));
        lyon.setName("Lyon");
        country.addTown(lyon);
        persister.insert((Object)country);
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery2 = this.persistenceContext.newQuery((CharSequence)"select countryId from city", Long.class).mapKey((SerializableFunction & Serializable)i -> i, "countryId", Long.class);
        Set cityCountryIds = (Set)longExecutableQuery2.execute(Accumulators.toSet());
        Assertions.assertThat(new HashSet(cityCountryIds)).isEqualTo((Object)Arrays.asSet((Object[])new Long[]{(Long)country.getId().getDelegate()}));
        Country loadedCountry = (Country)persister.select(country.getId());
        Assertions.assertThat(loadedCountry.getTowns()).extracting(City::getName).containsExactlyInAnyOrder((Object[])new String[]{"Grenoble", "Lyon"});
        Assertions.assertThat((Object)((Town)Iterables.first(loadedCountry.getTowns())).getCountry()).isEqualTo((Object)loadedCountry);
        Country modifiedCountry = new Country(country.getId());
        modifiedCountry.addTown((Town)Iterables.first(country.getTowns()));
        persister.update((Object)modifiedCountry, (Object)country, false);
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = this.persistenceContext.newQuery((CharSequence)"select countryId from city", Long.class).mapKey((SerializableFunction & Serializable)i -> i, "countryId", Long.class);
        cityCountryIds = (Set)longExecutableQuery1.execute(Accumulators.toSet());
        Assertions.assertThat(new HashSet(cityCountryIds)).isEqualTo((Object)Arrays.asSet((Object[])new Long[]{(Long)country.getId().getDelegate(), null}));
        persister.delete((Object)modifiedCountry);
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = this.persistenceContext.newQuery((CharSequence)"select countryId from city", Long.class).mapKey((SerializableFunction & Serializable)i -> i, "countryId", Long.class);
        cityCountryIds = (Set)longExecutableQuery.execute(Accumulators.toSet());
        Assertions.assertThat(new HashSet(cityCountryIds)).isEqualTo((Object)Arrays.asSet((Object[])new Long[]{null}));
    }

    private static Duo<String, Integer> pair(String name, Integer idx) {
        return new Duo((Object)name, (Object)idx);
    }

    @Test
    void mappedBy_set_ordered_crud() {
        FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions cityConfiguration = MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName);
        EntityPersister persister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)cityConfiguration).mappedBy(City::getCountry).indexedBy("myIdx").initializeWith(LinkedHashSet::new).cascading(CascadeOptions.RelationMode.ALL).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Country country = new Country(new PersistableIdentifier<Long>(1L));
        City grenoble = new City(new PersistableIdentifier<Long>(13L));
        grenoble.setName("Grenoble");
        City lyon = new City(new PersistableIdentifier<Long>(17L));
        lyon.setName("Lyon");
        City paris = new City(new PersistableIdentifier<Long>(23L));
        paris.setName("Paris");
        country.addCity(paris);
        country.addCity(grenoble);
        country.addCity(lyon);
        persister.insert((Object)country);
        PersistenceContext.ExecutableBeanPropertyQueryMapper duoExecutableQuery1 = this.persistenceContext.newQuery((CharSequence)"select name, myIdx from city", Duo.class).mapKey(FluentEntityMappingConfigurationSupportOneToManySetTest::pair, "name", "myIdx");
        Set cityCountryIds = (Set)duoExecutableQuery1.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)cityCountryIds).containsExactlyInAnyOrder((Object[])new Duo[]{new Duo((Object)"Paris", (Object)1), new Duo((Object)"Grenoble", (Object)2), new Duo((Object)"Lyon", (Object)3)});
        Country loadedCountry = (Country)persister.select(country.getId());
        Assertions.assertThat(loadedCountry.getCities()).extracting(City::getName).containsExactly((Object[])new String[]{"Paris", "Grenoble", "Lyon"});
        Assertions.assertThat((Object)((City)Iterables.first(loadedCountry.getCities())).getCountry()).isEqualTo((Object)loadedCountry);
        Country modifiedCountry = loadedCountry;
        modifiedCountry.getCities().removeIf(city -> city.getName().equals("Grenoble"));
        persister.update((Object)modifiedCountry, (Object)country, false);
        PersistenceContext.ExecutableBeanPropertyQueryMapper duoExecutableQuery = this.persistenceContext.newQuery((CharSequence)"select name, myIdx from city", Duo.class).mapKey(FluentEntityMappingConfigurationSupportOneToManySetTest::pair, "name", "myIdx");
        cityCountryIds = (Set)duoExecutableQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)cityCountryIds).containsExactlyInAnyOrder((Object[])new Duo[]{new Duo((Object)"Paris", (Object)1), new Duo((Object)"Lyon", (Object)2), new Duo((Object)"Grenoble", null)});
    }

    @Test
    void associationTable_set_crud() {
        FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions cityConfiguration = MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName);
        EntityPersister persister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)cityConfiguration).reverselySetBy(City::setCountry).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Country country = new Country(new PersistableIdentifier<Long>(1L));
        City grenoble = new City(new PersistableIdentifier<Long>(13L));
        grenoble.setName("Grenoble");
        country.addCity(grenoble);
        City lyon = new City(new PersistableIdentifier<Long>(17L));
        lyon.setName("Lyon");
        country.addCity(lyon);
        persister.insert((Object)country);
        PersistenceContext.ExecutableBeanPropertyQueryMapper duoExecutableQuery = this.persistenceContext.newQuery((CharSequence)"select Country_id, cities_id from Country_cities", Duo.class).mapKey(Duo::new, "Country_id", Long.class, "cities_id", Long.class);
        Set associatedIds = (Set)duoExecutableQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)associatedIds).containsExactlyInAnyOrder((Object[])new Duo[]{new Duo(country.getId().getDelegate(), grenoble.getId().getDelegate()), new Duo(country.getId().getDelegate(), lyon.getId().getDelegate())});
        Country loadedCountry = (Country)persister.select(country.getId());
        Assertions.assertThat(loadedCountry.getCities()).extracting(City::getName).containsExactlyInAnyOrder((Object[])new String[]{"Grenoble", "Lyon"});
        Assertions.assertThat((Object)((City)Iterables.first(loadedCountry.getCities())).getCountry()).isEqualTo((Object)loadedCountry);
        Country modifiedCountry = new Country(country.getId());
        modifiedCountry.addCity((City)Iterables.first(country.getCities()));
        persister.update((Object)modifiedCountry, (Object)country, false);
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery1 = this.persistenceContext.newQuery((CharSequence)"select Country_id from Country_cities", Long.class).mapKey((SerializableFunction & Serializable)i -> i, "Country_id", Long.class);
        Set cityCountryIds = (Set)longExecutableQuery1.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)cityCountryIds).containsExactlyInAnyOrder((Object[])new Long[]{(Long)country.getId().getDelegate()});
        persister.delete((Object)modifiedCountry);
        PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = this.persistenceContext.newQuery((CharSequence)"select id from city", Long.class).mapKey((SerializableFunction & Serializable)i -> i, "id", Long.class);
        Set cityIds = (Set)longExecutableQuery.execute(Accumulators.toSet());
        Assertions.assertThat((Collection)cityIds).containsExactlyInAnyOrder((Object[])new Long[]{(Long)grenoble.getId().getDelegate(), (Long)lyon.getId().getDelegate()});
    }

    @Test
    void mappedBy_noCascade_defaultCascadeIsAll() throws SQLException {
        EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToMany(Country::getCities, CITY_MAPPING_CONFIGURATION).mappedBy(City::setCountry).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        Country dummyCountry = new Country(new PersistableIdentifier<Long>(42L));
        dummyCountry.setName("France");
        dummyCountry.setDescription("Smelly cheese !");
        City city = new City((Long)new LongProvider().giveNewIdentifier());
        city.setName("Paris");
        dummyCountry.addCity(city);
        countryPersister.insert((Object)dummyCountry);
        ResultSet resultSet = this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Country where id = 42");
        Assertions.assertThat((boolean)resultSet.next()).isTrue();
        resultSet = this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from City");
        Assertions.assertThat((boolean)resultSet.next()).isTrue();
        this.persistenceContext.getConnectionProvider().giveConnection().prepareStatement("insert into City(id, name, countryId) values (1, 'Paris', 42)").execute();
        Country loadedCountry = (Country)countryPersister.select(new PersistedIdentifier<Long>(42L));
        Assertions.assertThat((String)loadedCountry.getName()).isEqualTo("France");
        Assertions.assertThat((String)((City)Iterables.first(loadedCountry.getCities())).getName()).isEqualTo("Paris");
        loadedCountry.setName("touched France");
        ((City)Iterables.first(loadedCountry.getCities())).setName("touched Paris");
        countryPersister.update((Object)loadedCountry, (Object)dummyCountry, false);
        Assertions.assertThat((String)((String)this.persistenceContext.newQuery((CharSequence)"select name from City where id = 1", String.class).mapKey("name", String.class).execute(Accumulators.getFirst()))).isEqualTo("Paris");
        Assertions.assertThat((String)((String)this.persistenceContext.newQuery((CharSequence)"select name from Country where id = 42", String.class).mapKey("name", String.class).execute(Accumulators.getFirst()))).isEqualTo("touched France");
        countryPersister.delete((Object)loadedCountry);
        PersistenceContext.ExecutableBeanPropertyQueryMapper stringExecutableQuery = this.persistenceContext.newQuery((CharSequence)"select name from Country where id = 42", String.class).mapKey("name", String.class);
        Assertions.assertThat((Collection)((Collection)stringExecutableQuery.execute(Accumulators.toSet()))).isEmpty();
        Assertions.assertThat((String)((String)this.persistenceContext.newQuery((CharSequence)"select name from City where id = 1", String.class).mapKey("name", String.class).execute(Accumulators.getFirst()))).isEqualTo("Paris");
    }

    @Test
    void mappedBy_entitiesAreLoaded() throws SQLException {
        EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).mapOneToMany(Country::getCities, CITY_MAPPING_CONFIGURATION).mappedBy(City::setCountry).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        this.persistenceContext.getConnectionProvider().giveConnection().prepareStatement("insert into Country(id, name) values (42, 'France')").execute();
        this.persistenceContext.getConnectionProvider().giveConnection().prepareStatement("insert into City(id, name, countryId) values (1, 'Paris', 42)").execute();
        this.persistenceContext.getConnectionProvider().giveConnection().prepareStatement("insert into City(id, name, countryId) values (2, 'Lyon', 42)").execute();
        Country loadedCountry = (Country)countryPersister.select(new PersistedIdentifier<Long>(42L));
        Assertions.assertThat(loadedCountry.getCities()).extracting(City::getName).containsExactlyInAnyOrder((Object[])new String[]{"Paris", "Lyon"});
    }

    @Test
    void mappedBy_collectionFactory() throws SQLException {
        EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).mapOneToMany(Country::getCities, CITY_MAPPING_CONFIGURATION).mappedBy(City::setCountry).initializeWith(() -> new TreeSet<City>(Comparator.comparing(City::getName))).build(this.persistenceContext);
        DDLDeployer ddlDeployer = new DDLDeployer(this.persistenceContext);
        ddlDeployer.deployDDL();
        this.persistenceContext.getConnectionProvider().giveConnection().prepareStatement("insert into Country(id, name) values (42, 'France')").execute();
        this.persistenceContext.getConnectionProvider().giveConnection().prepareStatement("insert into City(id, name, countryId) values (1, 'Paris', 42)").execute();
        this.persistenceContext.getConnectionProvider().giveConnection().prepareStatement("insert into City(id, name, countryId) values (2, 'Lyon', 42)").execute();
        Country loadedCountry = (Country)countryPersister.select(new PersistedIdentifier<Long>(42L));
        Assertions.assertThat(loadedCountry.getCities().getClass()).isEqualTo(TreeSet.class);
        Assertions.assertThat(loadedCountry.getCities()).extracting(City::getName).containsExactly((Object[])new String[]{"Lyon", "Paris"});
    }

    static Object[][] mappedBy_differentWays_data() {
        return new Object[][]{{() -> {
            PersistenceContext persistenceContext = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToMany(Country::getCities, CITY_MAPPING_CONFIGURATION).mappedBy(City::setCountry).cascading(CascadeOptions.RelationMode.ALL).build(persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
            ddlDeployer.deployDDL();
            return countryPersister;
        }, true}, {() -> {
            PersistenceContext persistenceContext = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToMany(Country::getCities, CITY_MAPPING_CONFIGURATION).mappedBy(City::getCountry).cascading(CascadeOptions.RelationMode.ALL).build(persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
            ddlDeployer.deployDDL();
            return countryPersister;
        }, true}, {() -> {
            PersistenceContext persistenceContext = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
            Table cityTable = new Table("city");
            Column countryId = cityTable.addColumn("country_id", Identifier.LONG_TYPE);
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToMany(Country::getCities, CITY_MAPPING_CONFIGURATION).mappedBy(countryId).cascading(CascadeOptions.RelationMode.ALL).build(persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
            ddlDeployer.deployDDL();
            return countryPersister;
        }, false}, {() -> {
            PersistenceContext persistenceContext = new PersistenceContext((DataSource)new HSQLDBInMemoryDataSource(), DIALECT);
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToMany(Country::getCities, CITY_MAPPING_CONFIGURATION).mappedBy("country_id").cascading(CascadeOptions.RelationMode.ALL).build(persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(persistenceContext);
            ddlDeployer.deployDDL();
            return countryPersister;
        }, false}};
    }

    @ParameterizedTest
    @MethodSource(value={"mappedBy_differentWays_data"})
    void mappedBy_differentWays(ThrowingSupplier<EntityPersister<Country, Identifier<Long>>, SQLException> persisterSupplier, boolean mappedByFunction) throws SQLException {
        EntityPersister countryPersister = (EntityPersister)persisterSupplier.get();
        LongProvider countryIdProvider = new LongProvider();
        Country dummyCountry = new Country((Long)countryIdProvider.giveNewIdentifier());
        dummyCountry.setName("France");
        dummyCountry.setDescription("Smelly cheese !");
        LongProvider cityIdProvider = new LongProvider();
        City paris = new City((Long)cityIdProvider.giveNewIdentifier());
        paris.setName("Paris");
        dummyCountry.addCity(paris);
        City lyon = new City((Long)cityIdProvider.giveNewIdentifier());
        lyon.setName("Lyon");
        dummyCountry.addCity(lyon);
        countryPersister.insert((Object)dummyCountry);
        Country persistedCountry = (Country)countryPersister.select(dummyCountry.getId());
        Assertions.assertThat(persistedCountry.getId()).isEqualTo(new PersistedIdentifier<Long>(0L));
        Assertions.assertThat((String)persistedCountry.getDescription()).isEqualTo("Smelly cheese !");
        Assertions.assertThat((int)persistedCountry.getCities().size()).isEqualTo(2);
        Assertions.assertThat(persistedCountry.getCities()).extracting(City::getName).containsExactlyInAnyOrder((Object[])new String[]{"Paris", "Lyon"});
        if (mappedByFunction) {
            Assertions.assertThat(persistedCountry.getCities()).extracting(City::getCountry).containsExactlyInAnyOrder((Object[])new Country[]{persistedCountry, persistedCountry});
        }
        Country dummyCountry2 = new Country((Long)countryIdProvider.giveNewIdentifier());
        dummyCountry2.setName("France 2");
        dummyCountry2.addCity(paris);
        dummyCountry2.addCity(lyon);
        countryPersister.insert((Object)dummyCountry2);
        Country persistedCountry2 = (Country)countryPersister.select(dummyCountry2.getId());
        Assertions.assertThat(persistedCountry2.getId()).isEqualTo(new PersistedIdentifier<Long>(1L));
        Assertions.assertThat(persistedCountry2.getCities()).extracting(City::getName).containsExactlyInAnyOrder((Object[])new String[]{"Paris", "Lyon"});
        if (mappedByFunction) {
            Assertions.assertThat(persistedCountry2.getCities()).extracting(City::getCountry).containsExactlyInAnyOrder((Object[])new Country[]{persistedCountry2, persistedCountry2});
        }
    }

    @Nested
    class SelectWithEmptyRelationMustReturnEmptyCollection {
        SelectWithEmptyRelationMustReturnEmptyCollection() {
        }

        @Test
        void noAssociationTable() throws SQLException {
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)CITY_MAPPING_CONFIGURATION).mappedBy(City::setCountry).cascading(CascadeOptions.RelationMode.READ_ONLY).build(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            Assertions.assertThat((Object)((OptimizedUpdatePersister)countryPersister).getDelegate().getEntityJoinTree().getJoin("Country_Citys0")).isNull();
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Country(id) values (42)");
            Country loadedCountry = (Country)countryPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat(loadedCountry.getCities()).isEqualTo(null);
        }

        @Test
        void withAssociationTable() throws SQLException {
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)CITY_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.READ_ONLY).build(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Country(id) values (42)");
            Country loadedCountry = (Country)countryPersister.select(new PersistedIdentifier<Long>(42L));
            Assertions.assertThat(loadedCountry.getCities()).isEqualTo(null);
        }
    }

    @Nested
    class CascadeAssociationOnly {
        CascadeAssociationOnly() {
        }

        @Test
        void withoutAssociationTable_throwsException() {
            FluentEntityMappingBuilder.FluentMappingBuilderOneToManyOptions mappingBuilder = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)CITY_MAPPING_CONFIGURATION).mappedBy(City::setCountry).cascading(CascadeOptions.RelationMode.ASSOCIATION_ONLY);
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.lambda$withoutAssociationTable_throwsException$0((FluentEntityMappingBuilder)mappingBuilder)).extracting(t -> (MappingConfigurationException)Exceptions.findExceptionInCauses((Throwable)t, MappingConfigurationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage(CascadeOptions.RelationMode.ASSOCIATION_ONLY + " is only relevant with an association table");
        }

        @Test
        void insert_withAssociationTable_associationRecordsMustBeInserted_butNotTargetEntities() throws SQLException {
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)CITY_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.ASSOCIATION_ONLY).build(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into City(id) values (100), (200), (300)");
            Country country1 = new Country(new PersistableIdentifier<Long>(42L));
            City city1 = new City(new PersistableIdentifier<Long>(100L));
            City city2 = new City(new PersistableIdentifier<Long>(200L));
            country1.addCity(city1);
            country1.addCity(city2);
            Country country2 = new Country(new PersistableIdentifier<Long>(666L));
            City city3 = new City(new PersistableIdentifier<Long>(300L));
            country2.addCity(city3);
            countryPersister.insert((Iterable)Arrays.asList((Object[])new Country[]{country1, country2}));
            ResultSet resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Country where id = 42");
            Assertions.assertThat((boolean)resultSet.next()).isTrue();
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Country where id = 666");
            Assertions.assertThat((boolean)resultSet.next()).isTrue();
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select * from Country_cities where country_Id = 42");
            Assertions.assertThat((boolean)resultSet.next()).isTrue();
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select * from Country_cities where country_Id = 666");
            Assertions.assertThat((boolean)resultSet.next()).isTrue();
        }

        @Test
        void update_withAssociationTable_associationRecordsMustBeUpdated_butNotTargetEntities() throws SQLException {
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)CITY_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.ASSOCIATION_ONLY).build(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into City(id) values (100), (200)");
            Country country1 = new Country(new PersistableIdentifier<Long>(42L));
            City city1 = new City(new PersistableIdentifier<Long>(100L));
            City city2 = new City(new PersistableIdentifier<Long>(200L));
            country1.addCity(city1);
            country1.addCity(city2);
            countryPersister.insert((Object)country1);
            country1.setName("France");
            city1.setName("Grenoble");
            countryPersister.update((Object)country1, countryPersister.select(country1.getId()), true);
            ResultSet resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select name from Country where id = 42");
            RowIterator countryIterator = new RowIterator(resultSet, (Map)Maps.asMap((Object)"name", (Object)DefaultParameterBinders.STRING_BINDER));
            Assertions.assertThat((List)Iterables.collectToList(() -> CascadeAssociationOnly.lambda$update_withAssociationTable_associationRecordsMustBeUpdated_butNotTargetEntities$2((ResultSetIterator)countryIterator), row -> row.get((Object)"name"))).isEqualTo((Object)Arrays.asList((Object[])new String[]{"France"}));
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select name from City where id = 100");
            RowIterator cityIterator = new RowIterator(resultSet, (Map)Maps.asMap((Object)"name", (Object)DefaultParameterBinders.STRING_BINDER));
            Assertions.assertThat((List)Iterables.collectToList(() -> CascadeAssociationOnly.lambda$update_withAssociationTable_associationRecordsMustBeUpdated_butNotTargetEntities$4((ResultSetIterator)cityIterator), row -> row.get((Object)"name"))).isEqualTo((Object)Arrays.asList((Object[])new Object[]{null}));
            Assertions.assertThat((int)country1.getCities().size()).isEqualTo(2);
            country1.getCities().remove(city1);
            Assertions.assertThat((int)country1.getCities().size()).isEqualTo(1);
            countryPersister.update((Object)country1, countryPersister.select(country1.getId()), true);
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select name from City where id = 100");
            RowIterator cityIterator2 = new RowIterator(resultSet, (Map)Maps.asMap((Object)"name", (Object)DefaultParameterBinders.STRING_BINDER));
            Assertions.assertThat((List)Iterables.collectToList(() -> CascadeAssociationOnly.lambda$update_withAssociationTable_associationRecordsMustBeUpdated_butNotTargetEntities$6((ResultSetIterator)cityIterator2), row -> row.get((Object)"name"))).isEqualTo((Object)Arrays.asList((Object[])new Object[]{null}));
        }

        @Test
        void delete_withAssociationTable_associationRecordsMustBeDeleted_butNotTargetEntities() throws SQLException {
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)CITY_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.ASSOCIATION_ONLY).build(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Country(id) values (42, 666)");
            FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into City(id) values (100), (200), (300)");
            FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Country_cities(country_Id, cities_Id) values (42, 100), (42, 200), (666, 300)");
            Country country1 = new Country(new PersistedIdentifier<Long>(42L));
            City city1 = new City(new PersistedIdentifier<Long>(100L));
            City city2 = new City(new PersistedIdentifier<Long>(200L));
            country1.addCity(city1);
            country1.addCity(city2);
            Country country2 = new Country(new PersistedIdentifier<Long>(666L));
            City city3 = new City(new PersistedIdentifier<Long>(300L));
            country2.addCity(city3);
            countryPersister.delete((Object)country1);
            ResultSet resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Country where id = 42");
            Assertions.assertThat((boolean)resultSet.next()).isFalse();
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select * from Country_cities where country_Id = 42");
            Assertions.assertThat((boolean)resultSet.next()).isFalse();
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from City where id in (100, 200)");
            Assertions.assertThat((boolean)resultSet.next()).isTrue();
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Country where id = 666");
            Assertions.assertThat((boolean)resultSet.next()).isTrue();
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from City where id = 300");
            Assertions.assertThat((boolean)resultSet.next()).isTrue();
            countryPersister.delete((Object)country2);
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Country where id = 666");
            Assertions.assertThat((boolean)resultSet.next()).isFalse();
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select * from Country_cities where country_Id = 666");
            Assertions.assertThat((boolean)resultSet.next()).isFalse();
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from City where id = 300");
            Assertions.assertThat((boolean)resultSet.next()).isTrue();
        }

        private static /* synthetic */ Iterator lambda$update_withAssociationTable_associationRecordsMustBeUpdated_butNotTargetEntities$6(ResultSetIterator cityIterator2) {
            return cityIterator2;
        }

        private static /* synthetic */ Iterator lambda$update_withAssociationTable_associationRecordsMustBeUpdated_butNotTargetEntities$4(ResultSetIterator cityIterator) {
            return cityIterator;
        }

        private static /* synthetic */ Iterator lambda$update_withAssociationTable_associationRecordsMustBeUpdated_butNotTargetEntities$2(ResultSetIterator countryIterator) {
            return countryIterator;
        }

        private /* synthetic */ void lambda$withoutAssociationTable_throwsException$0(FluentEntityMappingBuilder mappingBuilder) throws Throwable {
            mappingBuilder.build(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
        }
    }

    @Nested
    class CascadeAllOrphanRemoval {
        CascadeAllOrphanRemoval() {
        }

        @Test
        void update_mappedBy_removedElementsAreDeleted() {
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)CITY_MAPPING_CONFIGURATION).mappedBy(City::setCountry).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).build(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            LongProvider countryIdProvider = new LongProvider();
            Country dummyCountry = new Country((Long)countryIdProvider.giveNewIdentifier());
            dummyCountry.setName("France");
            dummyCountry.setDescription("Smelly cheese !");
            LongProvider cityIdProvider = new LongProvider();
            City paris = new City((Long)cityIdProvider.giveNewIdentifier());
            paris.setName("Paris");
            dummyCountry.addCity(paris);
            City lyon = new City((Long)cityIdProvider.giveNewIdentifier());
            lyon.setName("Lyon");
            dummyCountry.addCity(lyon);
            countryPersister.insert((Object)dummyCountry);
            Country persistedCountry = (Country)countryPersister.select(dummyCountry.getId());
            persistedCountry.getCities().remove(paris);
            City grenoble = new City((Long)cityIdProvider.giveNewIdentifier());
            grenoble.setName("Grenoble");
            persistedCountry.addCity(grenoble);
            ((City)Iterables.first(persistedCountry.getCities())).setName("changed");
            countryPersister.update((Object)persistedCountry, (Object)dummyCountry, true);
            Country persistedCountry2 = (Country)countryPersister.select(dummyCountry.getId());
            Assertions.assertThat(persistedCountry2.getCities()).isEqualTo((Object)Arrays.asHashSet((Object[])new City[]{lyon, grenoble}));
            Assertions.assertThat(persistedCountry2.getCities()).extracting(City::getName).containsExactlyInAnyOrder((Object[])new String[]{"changed", "Grenoble"});
        }

        @Test
        void update_associationTable_removedElementsAreDeleted() {
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)CITY_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).build(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            LongProvider countryIdProvider = new LongProvider();
            Country dummyCountry = new Country((Long)countryIdProvider.giveNewIdentifier());
            dummyCountry.setName("France");
            dummyCountry.setDescription("Smelly cheese !");
            LongProvider cityIdProvider = new LongProvider();
            City paris = new City((Long)cityIdProvider.giveNewIdentifier());
            paris.setName("Paris");
            dummyCountry.addCity(paris);
            City lyon = new City((Long)cityIdProvider.giveNewIdentifier());
            lyon.setName("Lyon");
            dummyCountry.addCity(lyon);
            countryPersister.insert((Object)dummyCountry);
            Country persistedCountry = (Country)countryPersister.select(dummyCountry.getId());
            persistedCountry.getCities().remove(paris);
            City grenoble = new City((Long)cityIdProvider.giveNewIdentifier());
            grenoble.setName("Grenoble");
            persistedCountry.addCity(grenoble);
            ((City)Iterables.first(persistedCountry.getCities())).setName("changed");
            countryPersister.update((Object)persistedCountry, (Object)dummyCountry, true);
            Country persistedCountry2 = (Country)countryPersister.select(dummyCountry.getId());
            Assertions.assertThat(persistedCountry2.getCities()).isEqualTo((Object)Arrays.asHashSet((Object[])new City[]{lyon, grenoble}));
            Assertions.assertThat(persistedCountry2.getCities()).extracting(City::getName).containsExactlyInAnyOrder((Object[])new String[]{"changed", "Grenoble"});
        }

        @Test
        void delete_mappedBy() throws SQLException {
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)CITY_MAPPING_CONFIGURATION).mappedBy(City::setCountry).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).build(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Country(id) values (42, 666)");
            FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into City(id, countryId) values (100, 42), (200, 42), (300, 666)");
            Country persistedCountry = (Country)countryPersister.select(new PersistedIdentifier<Long>(42L));
            countryPersister.delete((Object)persistedCountry);
            ResultSet resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Country where id = 42");
            Assertions.assertThat((boolean)resultSet.next()).isFalse();
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from City where id in (100, 200)");
            Assertions.assertThat((boolean)resultSet.next()).isFalse();
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Country where id = 666");
            Assertions.assertThat((boolean)resultSet.next()).isTrue();
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from City where id = 300");
            Assertions.assertThat((boolean)resultSet.next()).isTrue();
        }

        @Test
        void delete_withAssociationTable_associationRecordsMustBeDeleted() throws SQLException {
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)CITY_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).build(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Country(id) values (42, 666)");
            FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into City(id) values (100), (200), (300)");
            FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Country_cities(country_Id, cities_Id) values (42, 100), (42, 200), (666, 300)");
            Country country1 = new Country(new PersistedIdentifier<Long>(42L));
            City city1 = new City(new PersistedIdentifier<Long>(100L));
            City city2 = new City(new PersistedIdentifier<Long>(200L));
            country1.addCity(city1);
            country1.addCity(city2);
            Country country2 = new Country(new PersistedIdentifier<Long>(666L));
            City city3 = new City(new PersistedIdentifier<Long>(300L));
            country2.addCity(city3);
            countryPersister.delete((Object)country1);
            ResultSet resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Country where id = 42");
            Assertions.assertThat((boolean)resultSet.next()).isFalse();
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select * from Country_cities where country_Id = 42");
            Assertions.assertThat((boolean)resultSet.next()).isFalse();
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from City where id in (100, 200)");
            Assertions.assertThat((boolean)resultSet.next()).isFalse();
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Country where id = 666");
            Assertions.assertThat((boolean)resultSet.next()).isTrue();
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from City where id = 300");
            Assertions.assertThat((boolean)resultSet.next()).isTrue();
            countryPersister.delete((Object)country2);
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Country where id = 666");
            Assertions.assertThat((boolean)resultSet.next()).isFalse();
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select * from Country_cities where country_Id = 666");
            Assertions.assertThat((boolean)resultSet.next()).isFalse();
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from City where id = 300");
            Assertions.assertThat((boolean)resultSet.next()).isFalse();
        }
    }

    @Nested
    class CascadeAll {
        CascadeAll() {
        }

        @Test
        void update_mappedBy() {
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)CITY_MAPPING_CONFIGURATION).mappedBy(City::setCountry).cascading(CascadeOptions.RelationMode.ALL).build(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            LongProvider countryIdProvider = new LongProvider();
            Country dummyCountry = new Country((Long)countryIdProvider.giveNewIdentifier());
            dummyCountry.setName("France");
            dummyCountry.setDescription("Smelly cheese !");
            LongProvider cityIdProvider = new LongProvider();
            City paris = new City((Long)cityIdProvider.giveNewIdentifier());
            paris.setName("Paris");
            dummyCountry.addCity(paris);
            City lyon = new City((Long)cityIdProvider.giveNewIdentifier());
            lyon.setName("Lyon");
            dummyCountry.addCity(lyon);
            countryPersister.insert((Object)dummyCountry);
            Country persistedCountry = (Country)countryPersister.select(dummyCountry.getId());
            persistedCountry.getCities().remove(paris);
            City grenoble = new City((Long)cityIdProvider.giveNewIdentifier());
            grenoble.setName("Grenoble");
            persistedCountry.addCity(grenoble);
            ((City)Iterables.first(persistedCountry.getCities())).setName("changed");
            countryPersister.update((Object)persistedCountry, (Object)dummyCountry, true);
            Country persistedCountry2 = (Country)countryPersister.select(dummyCountry.getId());
            Assertions.assertThat(persistedCountry2.getCities()).extracting(City::getName).containsExactlyInAnyOrder((Object[])new String[]{"changed", "Grenoble"});
            Assertions.assertThat(persistedCountry2.getCities()).extracting(City::getCountry).containsExactly((Object[])new Country[]{persistedCountry2, persistedCountry2});
        }

        @Test
        void update_noMappedBy_associationTableIsMaintained() {
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)CITY_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.ALL).build(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            LongProvider countryIdProvider = new LongProvider();
            Country dummyCountry = new Country((Long)countryIdProvider.giveNewIdentifier());
            dummyCountry.setName("France");
            dummyCountry.setDescription("Smelly cheese !");
            LongProvider cityIdProvider = new LongProvider();
            City paris = new City((Long)cityIdProvider.giveNewIdentifier());
            paris.setName("Paris");
            dummyCountry.addCity(paris);
            City lyon = new City((Long)cityIdProvider.giveNewIdentifier());
            lyon.setName("Lyon");
            dummyCountry.addCity(lyon);
            countryPersister.insert((Object)dummyCountry);
            Country persistedCountry = (Country)countryPersister.select(dummyCountry.getId());
            persistedCountry.getCities().remove(paris);
            City grenoble = new City((Long)cityIdProvider.giveNewIdentifier());
            grenoble.setName("Grenoble");
            persistedCountry.addCity(grenoble);
            ((City)Iterables.first(persistedCountry.getCities())).setName("changed");
            countryPersister.update((Object)persistedCountry, (Object)dummyCountry, true);
            Country persistedCountry2 = (Country)countryPersister.select(dummyCountry.getId());
            Assertions.assertThat(persistedCountry2.getCities()).extracting(City::getName).containsExactlyInAnyOrder((Object[])new String[]{"changed", "Grenoble"});
            Assertions.assertThat(persistedCountry2.getCities()).extracting(City::getCountry).containsExactly((Object[])new Country[]{null, null});
        }

        @Test
        void update_associationTable() {
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)CITY_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.ALL).build(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            LongProvider countryIdProvider = new LongProvider();
            Country dummyCountry = new Country((Long)countryIdProvider.giveNewIdentifier());
            dummyCountry.setName("France");
            dummyCountry.setDescription("Smelly cheese !");
            LongProvider cityIdProvider = new LongProvider();
            City paris = new City((Long)cityIdProvider.giveNewIdentifier());
            paris.setName("Paris");
            dummyCountry.addCity(paris);
            City lyon = new City((Long)cityIdProvider.giveNewIdentifier());
            lyon.setName("Lyon");
            dummyCountry.addCity(lyon);
            countryPersister.insert((Object)dummyCountry);
            Country persistedCountry = (Country)countryPersister.select(dummyCountry.getId());
            persistedCountry.getCities().remove(paris);
            City grenoble = new City((Long)cityIdProvider.giveNewIdentifier());
            grenoble.setName("Grenoble");
            persistedCountry.addCity(grenoble);
            ((City)Iterables.first(persistedCountry.getCities())).setName("changed");
            countryPersister.update((Object)persistedCountry, (Object)dummyCountry, true);
            Country persistedCountry2 = (Country)countryPersister.select(dummyCountry.getId());
            Assertions.assertThat(persistedCountry2.getCities()).containsExactlyInAnyOrder((Object[])new City[]{lyon, grenoble});
            Assertions.assertThat(persistedCountry2.getCities()).extracting(City::getName).containsExactlyInAnyOrder((Object[])new String[]{"changed", "Grenoble"});
        }

        @Test
        void update_multipleTimes() {
            FluentEntityMappingBuilder.FluentMappingBuilderPropertyOptions stateMappingBuilder = MappingEase.entityBuilder(State.class, Identifier.LONG_TYPE).mapKey(State::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(State::getName);
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)CITY_MAPPING_CONFIGURATION).mappedBy(City::setCountry).cascading(CascadeOptions.RelationMode.ALL_ORPHAN_REMOVAL).mapOneToMany(Country::getStates, (EntityMappingConfigurationProvider)stateMappingBuilder).mappedBy(State::setCountry).cascading(CascadeOptions.RelationMode.ALL).build(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            LongProvider countryIdProvider = new LongProvider();
            Country dummyCountry = new Country((Long)countryIdProvider.giveNewIdentifier());
            dummyCountry.setName("France");
            dummyCountry.setDescription("Smelly cheese !");
            LongProvider cityIdProvider = new LongProvider();
            City paris = new City((Long)cityIdProvider.giveNewIdentifier());
            paris.setName("Paris");
            dummyCountry.addCity(paris);
            City lyon = new City((Long)cityIdProvider.giveNewIdentifier());
            lyon.setName("Lyon");
            dummyCountry.addCity(lyon);
            LongProvider stateIdProvider = new LongProvider();
            State isere = new State(new PersistableIdentifier<Object>(stateIdProvider.giveNewIdentifier()));
            isere.setName("Isere");
            dummyCountry.addState(isere);
            State ain = new State(new PersistableIdentifier<Object>(stateIdProvider.giveNewIdentifier()));
            ain.setName("ain");
            dummyCountry.addState(ain);
            countryPersister.insert((Object)dummyCountry);
            Country persistedCountry = (Country)countryPersister.select(dummyCountry.getId());
            persistedCountry.getCities().remove(paris);
            City grenoble = new City((Long)cityIdProvider.giveNewIdentifier());
            grenoble.setName("Grenoble");
            persistedCountry.addCity(grenoble);
            ((City)Iterables.first(persistedCountry.getCities())).setName("changed");
            persistedCountry.getStates().remove(ain);
            State ardeche = new State(new PersistableIdentifier<Object>(stateIdProvider.giveNewIdentifier()));
            ardeche.setName("ardeche");
            persistedCountry.addState(ardeche);
            ((State)Iterables.first(persistedCountry.getStates())).setName("changed");
            countryPersister.update((Object)persistedCountry, (Object)dummyCountry, true);
            Country persistedCountry2 = (Country)countryPersister.select(dummyCountry.getId());
            Assertions.assertThat(persistedCountry2.getCities()).isEqualTo((Object)Arrays.asHashSet((Object[])new City[]{lyon, grenoble}));
            Assertions.assertThat(persistedCountry2.getStates()).isEqualTo((Object)Arrays.asHashSet((Object[])new State[]{ardeche, isere}));
            Assertions.assertThat(persistedCountry2.getCities()).extracting(City::getName).containsExactlyInAnyOrder((Object[])new String[]{"changed", "Grenoble"});
            Assertions.assertThat(persistedCountry2.getStates()).extracting(State::getName).containsExactlyInAnyOrder((Object[])new String[]{"changed", "ardeche"});
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.newQuery((CharSequence)("select id from State where id = " + ain.getId().getDelegate()), Long.class).mapKey(Long::new, "id", Long.TYPE);
            Set loadedAin = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Long)((Long)Iterables.first((Iterable)loadedAin))).isNotNull();
        }

        @Test
        void delete_mappedRelation() throws SQLException {
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)CITY_MAPPING_CONFIGURATION).mappedBy(City::setCountry).cascading(CascadeOptions.RelationMode.ALL).build(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Country(id) values (42, 666)");
            FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into City(id, countryId) values (100, 42), (200, 42), (300, 666)");
            Country persistedCountry = (Country)countryPersister.select(new PersistedIdentifier<Long>(42L));
            countryPersister.delete((Object)persistedCountry);
            ResultSet resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Country where id = 42");
            Assertions.assertThat((boolean)resultSet.next()).isFalse();
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select countryId from City where id in (100, 200)");
            Assertions.assertThat((List)Iterables.copy((Iterator)new ResultSetIterator<Object>(resultSet){

                public Object convert(ResultSet resultSet) throws SQLException {
                    return resultSet.getObject(1);
                }
            })).isEqualTo((Object)Arrays.asList((Object[])new Object[]{null, null}));
            Assertions.assertThat((List)Iterables.collectToList(persistedCountry.getCities(), City::getCountry)).isEqualTo((Object)Arrays.asList((Object[])new Object[]{null, null}));
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Country where id = 666");
            Assertions.assertThat((boolean)resultSet.next()).isTrue();
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from City where id = 300");
            Assertions.assertThat((boolean)resultSet.next()).isTrue();
        }

        @Test
        void delete_withAssociationTable_associationRecordsMustBeDeleted() throws SQLException {
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)CITY_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.ALL).build(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Country(id) values (42, 666)");
            FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into City(id) values (100), (200), (300)");
            FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeUpdate("insert into Country_cities(country_Id, cities_Id) values (42, 100), (42, 200), (666, 300)");
            Country country1 = new Country(new PersistedIdentifier<Long>(42L));
            City city1 = new City(new PersistedIdentifier<Long>(100L));
            City city2 = new City(new PersistedIdentifier<Long>(200L));
            country1.addCity(city1);
            country1.addCity(city2);
            Country country2 = new Country(new PersistedIdentifier<Long>(666L));
            City city3 = new City(new PersistedIdentifier<Long>(300L));
            country2.addCity(city3);
            countryPersister.delete((Object)country1);
            ResultSet resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Country where id = 42");
            Assertions.assertThat((boolean)resultSet.next()).isFalse();
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select * from Country_cities where country_Id = 42");
            Assertions.assertThat((boolean)resultSet.next()).isFalse();
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from City where id in (100, 200)");
            Assertions.assertThat((List)Iterables.copy((Iterator)new ResultSetIterator<Object>(resultSet){

                public Object convert(ResultSet resultSet) throws SQLException {
                    return resultSet.getObject(1);
                }
            })).isEqualTo((Object)Arrays.asList((Object[])new Integer[]{100, 200}));
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Country where id = 666");
            Assertions.assertThat((boolean)resultSet.next()).isTrue();
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from City where id = 300");
            Assertions.assertThat((boolean)resultSet.next()).isTrue();
            countryPersister.delete((Object)country2);
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from Country where id = 666");
            Assertions.assertThat((boolean)resultSet.next()).isFalse();
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select * from Country_cities where country_Id = 666");
            Assertions.assertThat((boolean)resultSet.next()).isFalse();
            resultSet = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection().createStatement().executeQuery("select id from City where id = 300");
            Assertions.assertThat((List)Iterables.copy((Iterator)new ResultSetIterator<Object>(resultSet){

                public Object convert(ResultSet resultSet) throws SQLException {
                    return resultSet.getObject(1);
                }
            })).isEqualTo((Object)Arrays.asList((Object[])new Integer[]{300}));
        }
    }

    @Nested
    class CascadeReadOnly {
        CascadeReadOnly() {
        }

        @Test
        void insert_onlySourceEntitiesArePersisted() {
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)CITY_MAPPING_CONFIGURATION).cascading(CascadeOptions.RelationMode.READ_ONLY).build(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            LongProvider countryIdProvider = new LongProvider(1L);
            Country dummyCountry = new Country((Long)countryIdProvider.giveNewIdentifier());
            dummyCountry.setName("France");
            LongProvider cityIdProvider = new LongProvider(10L);
            City city = new City((Long)cityIdProvider.giveNewIdentifier());
            city.setName("French president");
            countryPersister.insert((Object)dummyCountry);
            PersistenceContext.ExecutableBeanPropertyQueryMapper longExecutableQuery = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.newQuery((CharSequence)"select id from country", Long.class).mapKey("id", Long.class);
            Set countryIds = (Set)longExecutableQuery.execute(Accumulators.toSet());
            Assertions.assertThat((Collection)countryIds).containsExactlyInAnyOrder((Object[])new Long[]{(Long)dummyCountry.getId().getDelegate()});
            Long relationCount = (Long)FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as relationCount from country_cities", Long.class).mapKey("relationCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)relationCount).isEqualTo(0L);
            Long cityCount = (Long)FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.newQuery((CharSequence)"select count(*) as cityCount from city", Long.class).mapKey("cityCount", Long.class).execute(Accumulators.getFirst());
            Assertions.assertThat((Long)cityCount).isEqualTo(0L);
        }
    }

    @Nested
    class SchemaCreation {
        SchemaCreation() {
        }

        @Test
        void mappedBy_foreignKeyIsCreated() throws SQLException {
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).withForeignKeyNaming(ForeignKeyNamingStrategy.DEFAULT).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)CITY_MAPPING_CONFIGURATION).mappedBy(City::setCountry).cascading(CascadeOptions.RelationMode.READ_ONLY).build(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Connection currentConnection = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection();
            ResultSetIterator<JdbcForeignKey> fkCityIterator = new ResultSetIterator<JdbcForeignKey>(currentConnection.getMetaData().getExportedKeys(null, null, ((ConfiguredPersister)countryPersister).getMapping().getTargetTable().getName().toUpperCase())){

                public JdbcForeignKey convert(ResultSet rs) throws SQLException {
                    return new JdbcForeignKey(rs.getString("FK_NAME"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"));
                }
            };
            Set foundForeignKey = (Set)Iterables.collect(() -> SchemaCreation.lambda$mappedBy_foreignKeyIsCreated$0((ResultSetIterator)fkCityIterator), JdbcForeignKey::getSignature, HashSet::new);
            JdbcForeignKey expectedForeignKey = new JdbcForeignKey("FK_CITY_COUNTRYID_COUNTRY_ID", "CITY", "COUNTRYID", "COUNTRY", "ID");
            Assertions.assertThat((Collection)foundForeignKey).isEqualTo((Object)Arrays.asHashSet((Object[])new String[]{expectedForeignKey.getSignature()}));
        }

        @Test
        void withTargetTable_targetTableIsUsed() throws SQLException {
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).withForeignKeyNaming(ForeignKeyNamingStrategy.DEFAULT).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName), new Table("Town")).mappedBy(City::setCountry).cascading(CascadeOptions.RelationMode.READ_ONLY).build(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Connection currentConnection = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection();
            ResultSetIterator<Table> tableIterator = new ResultSetIterator<Table>(currentConnection.getMetaData().getTables(null, currentConnection.getSchema(), null, null)){

                public Table convert(ResultSet rs) throws SQLException {
                    return new Table(rs.getString("TABLE_NAME"));
                }
            };
            Set foundTables = (Set)Iterables.collect(() -> SchemaCreation.lambda$withTargetTable_targetTableIsUsed$1((ResultSetIterator)tableIterator), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)foundTables).containsExactlyInAnyOrder((Object[])new String[]{"COUNTRY", "TOWN"});
            ResultSetIterator<JdbcForeignKey> fkCityIterator = new ResultSetIterator<JdbcForeignKey>(currentConnection.getMetaData().getExportedKeys(null, null, ((ConfiguredPersister)countryPersister).getMapping().getTargetTable().getName().toUpperCase())){

                public JdbcForeignKey convert(ResultSet rs) throws SQLException {
                    return new JdbcForeignKey(rs.getString("FK_NAME"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"));
                }
            };
            Set foundForeignKey = (Set)Iterables.collect(() -> SchemaCreation.lambda$withTargetTable_targetTableIsUsed$2((ResultSetIterator)fkCityIterator), JdbcForeignKey::getSignature, HashSet::new);
            JdbcForeignKey expectedForeignKey = new JdbcForeignKey("FK_TOWN_COUNTRYID_COUNTRY_ID", "TOWN", "COUNTRYID", "COUNTRY", "ID");
            Assertions.assertThat((Collection)foundForeignKey).isEqualTo((Object)Arrays.asHashSet((Object[])new String[]{expectedForeignKey.getSignature()}));
        }

        @Test
        void withTargetTableSetByTargetEntity_tableSetByTargetEntityIsUSed() throws SQLException {
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).withForeignKeyNaming(ForeignKeyNamingStrategy.DEFAULT).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE, (Table)new Table("Town")).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName)).mappedBy(City::setCountry).cascading(CascadeOptions.RelationMode.READ_ONLY).build(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Connection currentConnection = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection();
            ResultSetIterator<Table> tableIterator = new ResultSetIterator<Table>(currentConnection.getMetaData().getTables(null, currentConnection.getSchema(), null, null)){

                public Table convert(ResultSet rs) throws SQLException {
                    return new Table(rs.getString("TABLE_NAME"));
                }
            };
            Set foundTables = (Set)Iterables.collect(() -> SchemaCreation.lambda$withTargetTableSetByTargetEntity_tableSetByTargetEntityIsUSed$3((ResultSetIterator)tableIterator), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)foundTables).containsExactlyInAnyOrder((Object[])new String[]{"COUNTRY", "TOWN"});
            ResultSetIterator<JdbcForeignKey> fkCityIterator = new ResultSetIterator<JdbcForeignKey>(currentConnection.getMetaData().getExportedKeys(null, null, ((ConfiguredPersister)countryPersister).getMapping().getTargetTable().getName().toUpperCase())){

                public JdbcForeignKey convert(ResultSet rs) throws SQLException {
                    return new JdbcForeignKey(rs.getString("FK_NAME"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"));
                }
            };
            Set foundForeignKey = (Set)Iterables.collect(() -> SchemaCreation.lambda$withTargetTableSetByTargetEntity_tableSetByTargetEntityIsUSed$4((ResultSetIterator)fkCityIterator), JdbcForeignKey::getSignature, HashSet::new);
            JdbcForeignKey expectedForeignKey = new JdbcForeignKey("FK_TOWN_COUNTRYID_COUNTRY_ID", "TOWN", "COUNTRYID", "COUNTRY", "ID");
            Assertions.assertThat((Collection)foundForeignKey).isEqualTo((Object)Arrays.asHashSet((Object[])new String[]{expectedForeignKey.getSignature()}));
        }

        @Test
        void withTargetTableAndTableSetByTargetEntity_targetTableIsUsed() throws SQLException {
            EntityPersister countryPersister = MappingEase.entityBuilder(Country.class, Identifier.LONG_TYPE).withForeignKeyNaming(ForeignKeyNamingStrategy.DEFAULT).mapKey(Country::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(Country::getName).map(Country::getDescription).mapOneToMany(Country::getCities, (EntityMappingConfigurationProvider)MappingEase.entityBuilder(City.class, Identifier.LONG_TYPE, (Table)new Table("Town")).mapKey(City::getId, StatefulIdentifierAlreadyAssignedIdentifierPolicy.ALREADY_ASSIGNED).map(City::getName), new Table("Township")).mappedBy(City::setCountry).cascading(CascadeOptions.RelationMode.READ_ONLY).build(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            DDLDeployer ddlDeployer = new DDLDeployer(FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext);
            ddlDeployer.deployDDL();
            Connection currentConnection = FluentEntityMappingConfigurationSupportOneToManySetTest.this.persistenceContext.getConnectionProvider().giveConnection();
            ResultSetIterator<Table> tableIterator = new ResultSetIterator<Table>(currentConnection.getMetaData().getTables(null, currentConnection.getSchema(), null, null)){

                public Table convert(ResultSet rs) throws SQLException {
                    return new Table(rs.getString("TABLE_NAME"));
                }
            };
            Set foundTables = (Set)Iterables.collect(() -> SchemaCreation.lambda$withTargetTableAndTableSetByTargetEntity_targetTableIsUsed$5((ResultSetIterator)tableIterator), Table::getName, HashSet::new);
            Assertions.assertThat((Collection)foundTables).containsExactlyInAnyOrder((Object[])new String[]{"COUNTRY", "TOWNSHIP"});
            ResultSetIterator<JdbcForeignKey> fkCityIterator = new ResultSetIterator<JdbcForeignKey>(currentConnection.getMetaData().getExportedKeys(null, null, ((ConfiguredPersister)countryPersister).getMapping().getTargetTable().getName().toUpperCase())){

                public JdbcForeignKey convert(ResultSet rs) throws SQLException {
                    return new JdbcForeignKey(rs.getString("FK_NAME"), rs.getString("FKTABLE_NAME"), rs.getString("FKCOLUMN_NAME"), rs.getString("PKTABLE_NAME"), rs.getString("PKCOLUMN_NAME"));
                }
            };
            Set foundForeignKey = (Set)Iterables.collect(() -> SchemaCreation.lambda$withTargetTableAndTableSetByTargetEntity_targetTableIsUsed$6((ResultSetIterator)fkCityIterator), JdbcForeignKey::getSignature, HashSet::new);
            JdbcForeignKey expectedForeignKey = new JdbcForeignKey("FK_TOWNSHIP_COUNTRYID_COUNTRY_ID", "TOWNSHIP", "COUNTRYID", "COUNTRY", "ID");
            Assertions.assertThat((Collection)foundForeignKey).isEqualTo((Object)Arrays.asHashSet((Object[])new String[]{expectedForeignKey.getSignature()}));
        }

        private static /* synthetic */ Iterator lambda$withTargetTableAndTableSetByTargetEntity_targetTableIsUsed$6(ResultSetIterator fkCityIterator) {
            return fkCityIterator;
        }

        private static /* synthetic */ Iterator lambda$withTargetTableAndTableSetByTargetEntity_targetTableIsUsed$5(ResultSetIterator tableIterator) {
            return tableIterator;
        }

        private static /* synthetic */ Iterator lambda$withTargetTableSetByTargetEntity_tableSetByTargetEntityIsUSed$4(ResultSetIterator fkCityIterator) {
            return fkCityIterator;
        }

        private static /* synthetic */ Iterator lambda$withTargetTableSetByTargetEntity_tableSetByTargetEntityIsUSed$3(ResultSetIterator tableIterator) {
            return tableIterator;
        }

        private static /* synthetic */ Iterator lambda$withTargetTable_targetTableIsUsed$2(ResultSetIterator fkCityIterator) {
            return fkCityIterator;
        }

        private static /* synthetic */ Iterator lambda$withTargetTable_targetTableIsUsed$1(ResultSetIterator tableIterator) {
            return tableIterator;
        }

        private static /* synthetic */ Iterator lambda$mappedBy_foreignKeyIsCreated$0(ResultSetIterator fkCityIterator) {
            return fkCityIterator;
        }
    }
}

