/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.configurer;

import java.util.Date;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.stalactite.engine.ColumnNamingStrategy;
import org.codefilarete.stalactite.engine.EmbeddableMappingConfiguration;
import org.codefilarete.stalactite.engine.EmbeddableMappingConfigurationProvider;
import org.codefilarete.stalactite.engine.MappingConfigurationException;
import org.codefilarete.stalactite.engine.MappingEase;
import org.codefilarete.stalactite.engine.configurer.BeanMappingBuilder;
import org.codefilarete.stalactite.engine.configurer.FluentEmbeddableMappingConfigurationSupport;
import org.codefilarete.stalactite.engine.configurer.FluentEntityMappingConfigurationSupport;
import org.codefilarete.stalactite.engine.model.Color;
import org.codefilarete.stalactite.engine.model.Country;
import org.codefilarete.stalactite.engine.model.Person;
import org.codefilarete.stalactite.engine.model.Vehicle;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.stalactite.sql.statement.binder.ColumnBinderRegistry;
import org.codefilarete.stalactite.sql.statement.binder.DateBinder;
import org.codefilarete.tool.exception.Exceptions;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class BeanMappingBuilderTest {
    BeanMappingBuilderTest() {
    }

    @Test
    void giveTargetTable() {
        Table expectedResult = new Table("MyOverridingTable");
        Column colorTable = expectedResult.addColumn("myOverridingColumn", Integer.class);
        FluentEntityMappingConfigurationSupport vehicleObjectFluentEntityMappingConfigurationSupport = new FluentEntityMappingConfigurationSupport(Vehicle.class);
        vehicleObjectFluentEntityMappingConfigurationSupport.embed(Vehicle::getColor, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Color.class).map(Color::getRgb)).override(Color::getRgb, colorTable);
        Table result = BeanMappingBuilder.giveTargetTable((EmbeddableMappingConfiguration)vehicleObjectFluentEntityMappingConfigurationSupport.getPropertiesMapping());
        Assertions.assertThat((Object)result).isSameAs((Object)expectedResult);
    }

    @Test
    void giveTargetTable_multipleTableFound_throwsException() {
        Table firstTable = new Table("MyOverridingTable");
        Column nameColumn = firstTable.addColumn("myOverridingColumn", String.class);
        Table secondTable = new Table("MyOverridingTable2");
        Column versionColumn = secondTable.addColumn("myOverridingColumn", Integer.class);
        FluentEntityMappingConfigurationSupport vehicleObjectFluentEntityMappingConfigurationSupport = new FluentEntityMappingConfigurationSupport(Vehicle.class);
        vehicleObjectFluentEntityMappingConfigurationSupport.embed(Vehicle::getOwner, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Person.class).map(Person::getName).map(Person::getVersion)).override(Person::getName, nameColumn).override(Person::getVersion, versionColumn);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> BeanMappingBuilder.giveTargetTable((EmbeddableMappingConfiguration)vehicleObjectFluentEntityMappingConfigurationSupport.getPropertiesMapping())).extracting(t -> (MappingConfigurationException)Exceptions.findExceptionInCauses((Throwable)t, MappingConfigurationException.class), InstanceOfAssertFactories.THROWABLE)).hasMessage("Property o.c.s.e.m.Person::getName overrides column with MyOverridingTable.myOverridingColumn but it is not part of main table MyOverridingTable2");
    }

    @Test
    void giveTargetTable_withImportedConfiguration() {
        Table expectedResult = new Table("MyOverridingTable");
        Column nameColumn = expectedResult.addColumn("myOverridingColumn", String.class);
        FluentEntityMappingConfigurationSupport vehicleObjectFluentEntityMappingConfigurationSupport = new FluentEntityMappingConfigurationSupport(Vehicle.class);
        vehicleObjectFluentEntityMappingConfigurationSupport.embed(Vehicle::getOwner, (EmbeddableMappingConfigurationProvider)MappingEase.embeddableBuilder(Person.class).map(Person::getName)).override(Person::getName, nameColumn);
        Table result = BeanMappingBuilder.giveTargetTable((EmbeddableMappingConfiguration)vehicleObjectFluentEntityMappingConfigurationSupport.getPropertiesMapping());
        Assertions.assertThat((Object)result).isSameAs((Object)expectedResult);
    }

    @Test
    void ensureColumnBindingInRegistry() {
        BeanMappingBuilder testInstance;
        Table countryTable = new Table("Country");
        Column dummyColumn = countryTable.addColumn("dummyColumn", Set.class);
        BeanMappingBuilder beanMappingBuilder = testInstance = new BeanMappingBuilder((EmbeddableMappingConfiguration)new FluentEmbeddableMappingConfigurationSupport(Country.class), countryTable, new ColumnBinderRegistry(), new BeanMappingBuilder.ColumnNameProvider(ColumnNamingStrategy.DEFAULT));
        beanMappingBuilder.getClass();
        BeanMappingBuilder.InternalProcessor internalProcessor = new BeanMappingBuilder.InternalProcessor(beanMappingBuilder, false);
        BeanMappingBuilder.BeanMappingConfiguration.Linkage linkageMock = (BeanMappingBuilder.BeanMappingConfiguration.Linkage)Mockito.mock(BeanMappingBuilder.BeanMappingConfiguration.Linkage.class);
        Mockito.when((Object)linkageMock.getAccessor()).thenReturn((Object)Accessors.accessor(Country::getCities));
        Mockito.when((Object)linkageMock.getColumnType()).thenReturn(Set.class);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> internalProcessor.ensureColumnBindingInRegistry(linkageMock, dummyColumn)).isInstanceOf(Exception.class)).hasMessage("No binder found for property Country::getCities : neither its column nor its type are registered (Country.dummyColumn, type j.u.Set)");
    }

    @Nested
    class InternalProcessor {
        InternalProcessor() {
        }

        @Test
        void addColumnToTable_existingColumnDoesntMatchLinkageType_linkageAsParameterBinder_doesntThrowException() {
            BeanMappingBuilder testInstanceBuilder;
            Table countryTable = new Table("Country");
            Column dummyColumn = countryTable.addColumn("dummyColumnName", String.class);
            BeanMappingBuilder beanMappingBuilder = testInstanceBuilder = new BeanMappingBuilder((EmbeddableMappingConfiguration)new FluentEmbeddableMappingConfigurationSupport(Country.class), countryTable, new ColumnBinderRegistry(), new BeanMappingBuilder.ColumnNameProvider(ColumnNamingStrategy.DEFAULT));
            beanMappingBuilder.getClass();
            BeanMappingBuilder.InternalProcessor testInstance = new BeanMappingBuilder.InternalProcessor(beanMappingBuilder, false);
            BeanMappingBuilder.BeanMappingConfiguration.Linkage linkageMock = (BeanMappingBuilder.BeanMappingConfiguration.Linkage)Mockito.mock(BeanMappingBuilder.BeanMappingConfiguration.Linkage.class);
            Mockito.when((Object)linkageMock.getColumnType()).thenReturn(Date.class);
            Mockito.when((Object)linkageMock.getParameterBinder()).thenReturn((Object)new DateBinder(){

                public <O> Class<O> getColumnType() {
                    return String.class;
                }
            });
            Assertions.assertThatCode(() -> testInstance.addColumnToTable(linkageMock, dummyColumn.getName())).doesNotThrowAnyException();
        }
    }
}

