/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Savepoint;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.codefilarete.stalactite.dsl.NotYetSupportedOperationException;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.PersisterWrapper;
import org.codefilarete.stalactite.sql.CommitListener;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.RollbackListener;
import org.codefilarete.stalactite.sql.TransactionAwareConnectionProvider;
import org.codefilarete.stalactite.sql.result.InMemoryResultSet;
import org.codefilarete.stalactite.sql.result.NoopPreparedStatement;
import org.codefilarete.stalactite.sql.statement.SQLExecutionException;
import org.codefilarete.stalactite.sql.statement.SQLOperation;
import org.codefilarete.tool.Experimental;
import org.codefilarete.tool.ThreadLocals;
import org.codefilarete.tool.VisibleForTesting;
import org.codefilarete.tool.bean.ClassIterator;
import org.codefilarete.tool.bean.InterfaceIterator;
import org.codefilarete.tool.collection.Iterables;
import org.codefilarete.tool.collection.PairIterator;
import org.codefilarete.tool.function.Hanger;
import org.codefilarete.tool.function.ThrowingTriConsumer;
import org.codefilarete.tool.sql.ConnectionWrapper;
import org.codefilarete.tool.sql.ResultSetWrapper;

public class OptimizedUpdatePersister<C, I>
extends PersisterWrapper<C, I> {
    @VisibleForTesting
    static final ThreadLocal<Map<ResultSetCacheKey, ResultSet>> CURRENT_QUERY = new ThreadLocal();

    public static ConnectionConfiguration wrapWithQueryCache(ConnectionConfiguration connectionConfiguration) {
        ConnectionProvider delegate = connectionConfiguration.getConnectionProvider();
        CachingQueryConnectionProvider cachingQueryConnectionProvider = new CachingQueryConnectionProvider(delegate);
        HashSet interfaces = new HashSet(Iterables.copy((Iterator)new InterfaceIterator((Iterator)new ClassIterator(delegate.getClass(), null))));
        ConnectionProvider connectionProvider = (ConnectionProvider)Proxy.newProxyInstance(delegate.getClass().getClassLoader(), interfaces.toArray(new Class[0]), (proxy, method, args) -> {
            if (!method.getName().equals("giveConnection")) {
                return method.invoke((Object)delegate, args);
            }
            return cachingQueryConnectionProvider.giveConnection();
        });
        return new ConnectionConfiguration.ConnectionConfigurationSupport(connectionProvider, connectionConfiguration.getBatchSize());
    }

    public OptimizedUpdatePersister(ConfiguredRelationalPersister<C, I> delegate) {
        super(delegate);
    }

    @Override
    @Experimental
    public void update(I id, Consumer<C> entityConsumer) {
        this.update((Iterable<I>)Collections.singleton(id), entityConsumer);
    }

    @Override
    @Experimental
    public void update(Iterable<I> ids, Consumer<C> entityConsumer) {
        Hanger.Holder referenceEntity = new Hanger.Holder();
        Hanger.Holder entityToModify = new Hanger.Holder();
        ThreadLocals.doWithThreadLocal(CURRENT_QUERY, HashMap::new, () -> {
            referenceEntity.set(this.select(ids));
            entityToModify.set(this.select(ids));
        });
        ((Set)entityToModify.get()).forEach(entityConsumer);
        this.update(() -> new PairIterator((Iterable)entityToModify.get(), (Iterable)referenceEntity.get()), true);
    }

    private static class CachingQueryConnectionWrapper
    extends ConnectionWrapper {
        private CachingQueryConnectionWrapper(Connection delegate) {
            super(delegate);
        }

        public PreparedStatement prepareStatement(String sql) throws SQLException {
            if (CURRENT_QUERY.get() == null) {
                return super.prepareStatement(sql);
            }
            return new SpyingQueryPreparedStatement(sql);
        }

        private class SpyingQueryPreparedStatement
        extends NoopPreparedStatement {
            private final String sql;
            private final ResultSetCacheKey resultSetCacheKey;

            private SpyingQueryPreparedStatement(String sql) {
                this.sql = sql;
                this.resultSetCacheKey = new ResultSetCacheKey(sql);
            }

            public ResultSet executeQuery() throws SQLException {
                return this.executeQueryAndCacheResult(this.sql, this.resultSetCacheKey);
            }

            private ResultSet executeQueryAndCacheResult(String sql, ResultSetCacheKey resultSetCacheKey) throws SQLException {
                Map<ResultSetCacheKey, ResultSet> resultSetCache = CURRENT_QUERY.get();
                ResultSet previousResult = resultSetCache.get(resultSetCacheKey);
                if (previousResult != null) {
                    SQLOperation.LOGGER.debug("Result found in cache, statement will not be executed");
                    return previousResult;
                }
                PreparedStatement realStatement = CachingQueryConnectionWrapper.super.prepareStatement(sql);
                resultSetCacheKey.getValues().forEach((index, value) -> {
                    try {
                        resultSetCacheKey.getWriters().get(index).accept((Object)realStatement, index, value);
                    }
                    catch (SQLException throwable) {
                        throw new SQLExecutionException((Throwable)throwable);
                    }
                });
                return new CachingResultSet(realStatement.executeQuery(), resultSetCacheKey, resultSetCache);
            }

            public void setArray(int parameterIndex, Array value) throws SQLException {
                this.resultSetCacheKey.setValue(parameterIndex, value, PreparedStatement::setArray);
            }

            public void setBigDecimal(int parameterIndex, BigDecimal value) throws SQLException {
                this.resultSetCacheKey.setValue(parameterIndex, value, PreparedStatement::setBigDecimal);
            }

            public void setBoolean(int parameterIndex, boolean value) throws SQLException {
                this.resultSetCacheKey.setValue(parameterIndex, value, PreparedStatement::setBoolean);
            }

            public void setByte(int parameterIndex, byte value) throws SQLException {
                this.resultSetCacheKey.setValue(parameterIndex, value, PreparedStatement::setByte);
            }

            public void setBytes(int parameterIndex, byte[] value) throws SQLException {
                this.resultSetCacheKey.setValue(parameterIndex, value, PreparedStatement::setBytes);
            }

            public void setDate(int parameterIndex, Date value) throws SQLException {
                this.resultSetCacheKey.setValue(parameterIndex, value, (ps, index, x) -> ps.setDate((int)index, (Date)x));
            }

            public void setDate(int parameterIndex, Date value, Calendar cal) throws SQLException {
                this.resultSetCacheKey.setValue(parameterIndex, value, (ps, index, x) -> ps.setDate((int)index, (Date)x, cal));
            }

            public void setDouble(int parameterIndex, double value) throws SQLException {
                this.resultSetCacheKey.setValue(parameterIndex, value, PreparedStatement::setDouble);
            }

            public void setFloat(int parameterIndex, float value) throws SQLException {
                this.resultSetCacheKey.setValue(parameterIndex, Float.valueOf(value), PreparedStatement::setFloat);
            }

            public void setInt(int parameterIndex, int value) throws SQLException {
                this.resultSetCacheKey.setValue(parameterIndex, value, PreparedStatement::setInt);
            }

            public void setLong(int parameterIndex, long value) throws SQLException {
                this.resultSetCacheKey.setValue(parameterIndex, value, PreparedStatement::setLong);
            }

            public void setNull(int parameterIndex, int sqlType) throws SQLException {
                this.resultSetCacheKey.setValue(parameterIndex, null, (ps, index, x) -> ps.setNull((int)index, sqlType));
            }

            public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
                this.resultSetCacheKey.setValue(parameterIndex, null, (ps, index, x) -> ps.setNull((int)index, sqlType, typeName));
            }

            public void setObject(int parameterIndex, Object value) throws SQLException {
                this.resultSetCacheKey.setValue(parameterIndex, value, PreparedStatement::setObject);
            }

            public void setShort(int parameterIndex, short value) throws SQLException {
                this.resultSetCacheKey.setValue(parameterIndex, value, PreparedStatement::setShort);
            }

            public void setString(int parameterIndex, String value) throws SQLException {
                this.resultSetCacheKey.setValue(parameterIndex, value, PreparedStatement::setString);
            }

            public void setTime(int parameterIndex, Time value) throws SQLException {
                this.resultSetCacheKey.setValue(parameterIndex, value, (ps, index, x) -> ps.setTime((int)index, (Time)x));
            }

            public void setTime(int parameterIndex, Time value, Calendar cal) throws SQLException {
                this.resultSetCacheKey.setValue(parameterIndex, value, (ps, index, x) -> ps.setTime((int)index, (Time)x, cal));
            }

            public void setTimestamp(int parameterIndex, Timestamp value) throws SQLException {
                this.resultSetCacheKey.setValue(parameterIndex, value, (ps, index, x) -> ps.setTimestamp((int)index, (Timestamp)x));
            }

            public void setTimestamp(int parameterIndex, Timestamp value, Calendar cal) throws SQLException {
                this.resultSetCacheKey.setValue(parameterIndex, value, (ps, index, x) -> ps.setTimestamp((int)index, (Timestamp)x, cal));
            }

            public void setURL(int parameterIndex, URL value) throws SQLException {
                this.resultSetCacheKey.setValue(parameterIndex, value, PreparedStatement::setURL);
            }
        }

        private static class CachingResultSet
        extends ResultSetWrapper {
            private final List<Map<String, Object>> inMemoryValues = new ArrayList<Map<String, Object>>();
            private final ResultSetCacheKey resultSetCacheKey;
            private Map<String, Object> rowContent;
            private final Map<ResultSetCacheKey, ResultSet> cache;

            private CachingResultSet(ResultSet resultSet, ResultSetCacheKey resultSetCacheKey, Map<ResultSetCacheKey, ResultSet> cache) {
                super(resultSet);
                this.resultSetCacheKey = resultSetCacheKey;
                this.cache = cache;
            }

            public boolean next() throws SQLException {
                boolean next = super.next();
                if (next) {
                    this.rowContent = new TreeMap<String, Object>();
                    this.inMemoryValues.add(this.rowContent);
                } else {
                    this.cache.put(this.resultSetCacheKey, (ResultSet)new InMemoryResultSet(this.inMemoryValues));
                }
                return next;
            }

            public String getString(String columnLabel) throws SQLException {
                String value = this.delegate.getString(columnLabel);
                this.rowContent.put(columnLabel, value);
                return value;
            }

            public boolean getBoolean(String columnLabel) throws SQLException {
                boolean value = this.delegate.getBoolean(columnLabel);
                this.rowContent.put(columnLabel, value);
                return value;
            }

            public byte getByte(String columnLabel) throws SQLException {
                byte value = this.delegate.getByte(columnLabel);
                this.rowContent.put(columnLabel, value);
                return value;
            }

            public short getShort(String columnLabel) throws SQLException {
                short value = this.delegate.getShort(columnLabel);
                this.rowContent.put(columnLabel, value);
                return value;
            }

            public int getInt(String columnLabel) throws SQLException {
                int value = this.delegate.getInt(columnLabel);
                this.rowContent.put(columnLabel, value);
                return value;
            }

            public long getLong(String columnLabel) throws SQLException {
                long value = this.delegate.getLong(columnLabel);
                this.rowContent.put(columnLabel, value);
                return value;
            }

            public float getFloat(String columnLabel) throws SQLException {
                float value = this.delegate.getFloat(columnLabel);
                this.rowContent.put(columnLabel, Float.valueOf(value));
                return value;
            }

            public double getDouble(String columnLabel) throws SQLException {
                double value = this.delegate.getDouble(columnLabel);
                this.rowContent.put(columnLabel, value);
                return value;
            }

            public byte[] getBytes(String columnLabel) throws SQLException {
                byte[] value = this.delegate.getBytes(columnLabel);
                this.rowContent.put(columnLabel, value);
                return value;
            }

            public Date getDate(String columnLabel) throws SQLException {
                Date value = this.delegate.getDate(columnLabel);
                this.rowContent.put(columnLabel, value);
                return value;
            }

            public Time getTime(String columnLabel) throws SQLException {
                Time value = this.delegate.getTime(columnLabel);
                this.rowContent.put(columnLabel, value);
                return value;
            }

            public Timestamp getTimestamp(String columnLabel) throws SQLException {
                Timestamp value = this.delegate.getTimestamp(columnLabel);
                this.rowContent.put(columnLabel, value);
                return value;
            }

            public Object getObject(String columnLabel) throws SQLException {
                Object value = this.delegate.getObject(columnLabel);
                this.rowContent.put(columnLabel, value);
                return value;
            }

            public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
                BigDecimal value = this.delegate.getBigDecimal(columnLabel);
                this.rowContent.put(columnLabel, value);
                return value;
            }

            public URL getURL(String columnLabel) throws SQLException {
                URL value = this.delegate.getURL(columnLabel);
                this.rowContent.put(columnLabel, value);
                return value;
            }

            public Blob getBlob(String columnLabel) throws SQLException {
                throw new NotYetSupportedOperationException("Result will not be readable twice");
            }

            public Clob getClob(String columnLabel) throws SQLException {
                throw new NotYetSupportedOperationException("Result will not be readable twice");
            }

            public InputStream getBinaryStream(String columnLabel) throws SQLException {
                throw new NotYetSupportedOperationException("Result will not be readable twice");
            }

            public Reader getCharacterStream(String columnLabel) throws SQLException {
                throw new NotYetSupportedOperationException("Result will not be readable twice");
            }

            public InputStream getAsciiStream(String columnLabel) throws SQLException {
                throw new NotYetSupportedOperationException("Result will not be readable twice");
            }
        }
    }

    private static class CachingQueryConnectionProvider
    implements ConnectionProvider {
        private final ConnectionProvider delegate;
        private CachingQueryConnectionWrapper currentConnection;

        private CachingQueryConnectionProvider(ConnectionProvider delegate) {
            this.delegate = delegate;
        }

        public Connection giveConnection() {
            try {
                if (this.currentConnection == null || this.currentConnection.isClosed()) {
                    this.currentConnection = new CachingQueryConnectionWrapper(this.delegate.giveConnection());
                    if (this.delegate instanceof TransactionAwareConnectionProvider) {
                        ((TransactionAwareConnectionProvider)this.delegate).addCommitListener(new CommitListener(){

                            public void beforeCommit() {
                            }

                            public void afterCommit() {
                                this.releaseCurrentConnection();
                            }
                        });
                        ((TransactionAwareConnectionProvider)this.delegate).addRollbackListener(new RollbackListener(){

                            public void beforeRollback() {
                            }

                            public void afterRollback() {
                                this.releaseCurrentConnection();
                            }

                            public void beforeRollback(Savepoint savepoint) {
                            }

                            public void afterRollback(Savepoint savepoint) {
                                this.releaseCurrentConnection();
                            }
                        });
                    }
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            return this.currentConnection;
        }

        private void releaseCurrentConnection() {
            this.currentConnection = null;
        }
    }

    @VisibleForTesting
    static class ResultSetCacheKey {
        private final String sql;
        private final Map<Integer, Object> values = new HashMap<Integer, Object>();
        private final Map<Integer, ThrowingTriConsumer<PreparedStatement, Integer, Object, SQLException>> writers = new HashMap<Integer, ThrowingTriConsumer<PreparedStatement, Integer, Object, SQLException>>();

        @VisibleForTesting
        ResultSetCacheKey(String sql) {
            this.sql = sql;
        }

        private Map<Integer, Object> getValues() {
            return this.values;
        }

        private <T> void setValue(Integer index, Object value, ThrowingTriConsumer<PreparedStatement, Integer, T, SQLException> writer) {
            this.values.put(index, value);
            this.writers.put(index, writer);
        }

        public Map<Integer, ThrowingTriConsumer<PreparedStatement, Integer, Object, SQLException>> getWriters() {
            return this.writers;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ResultSetCacheKey)) {
                return false;
            }
            ResultSetCacheKey that = (ResultSetCacheKey)o;
            if (!this.sql.equals(that.sql)) {
                return false;
            }
            return this.values.equals(that.values);
        }

        public int hashCode() {
            int result = this.sql.hashCode();
            result = 31 * result + this.values.hashCode();
            return result;
        }
    }
}

