/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.spring.repository.query.domain;

import java.util.List;
import java.util.function.Supplier;
import org.codefilarete.reflection.Accessor;
import org.codefilarete.reflection.AccessorByMember;
import org.codefilarete.reflection.AccessorChain;
import org.codefilarete.reflection.Accessors;
import org.codefilarete.stalactite.engine.EntityCriteria;
import org.codefilarete.stalactite.engine.runtime.AdvancedEntityPersister;
import org.codefilarete.stalactite.engine.runtime.RelationalEntityPersister;
import org.codefilarete.stalactite.engine.runtime.query.EntityCriteriaSupport;
import org.codefilarete.stalactite.engine.runtime.query.EntityQueryCriteriaSupport;
import org.codefilarete.stalactite.query.model.Limit;
import org.codefilarete.stalactite.spring.repository.query.StalactiteQueryMethod;
import org.codefilarete.stalactite.spring.repository.query.derivation.ToCriteriaPartTreeTransformer;
import org.codefilarete.stalactite.spring.repository.query.execution.AbstractQueryExecutor;
import org.codefilarete.stalactite.spring.repository.query.execution.StalactiteQueryMethodInvocationParameters;
import org.codefilarete.stalactite.sql.result.Accumulators;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.parser.PartTree;

public class DomainEntityQueryExecutor<C>
extends AbstractQueryExecutor<List<C>, C> {
    private final AdvancedEntityPersister<C, ?> entityPersister;
    private final ToCriteriaPartTreeTransformer<C> criteriaAppender;

    public DomainEntityQueryExecutor(StalactiteQueryMethod method, AdvancedEntityPersister<C, ?> entityPersister, PartTree partTree) {
        super(method);
        this.entityPersister = entityPersister;
        this.criteriaAppender = new ToCriteriaPartTreeTransformer(partTree, entityPersister.getClassToPersist());
    }

    @Override
    public Supplier<List<C>> buildQueryExecutor(StalactiteQueryMethodInvocationParameters invocationParameters) {
        return () -> {
            EntityQueryCriteriaSupport executableEntityQuery = this.entityPersister.newCriteriaSupport();
            ToCriteriaPartTreeTransformer.Condition condition = this.criteriaAppender.applyTo((EntityCriteriaSupport<C>)executableEntityQuery.getEntityCriteriaSupport(), (EntityCriteria.OrderByChain<C, ?>)executableEntityQuery.getQueryPageSupport(), (EntityCriteria.LimitAware<?>)executableEntityQuery.getQueryPageSupport());
            condition.consume(invocationParameters.getValues());
            RelationalEntityPersister.ExecutableEntityQueryCriteria<C, ?> executableEntityQueryCriteria = this.handleDynamicParameters(invocationParameters, executableEntityQuery);
            List adaptation = (List)executableEntityQueryCriteria.execute(Accumulators.toList());
            return (List)this.method.getResultProcessor().processResult((Object)adaptation);
        };
    }

    private RelationalEntityPersister.ExecutableEntityQueryCriteria<C, ?> handleDynamicParameters(StalactiteQueryMethodInvocationParameters invocationParameters, EntityQueryCriteriaSupport<C, ?> defaultExecutableEntityQuery) {
        EntityQueryCriteriaSupport derivedQueryToUse;
        if (invocationParameters.getSort().isSorted()) {
            Class declaringClass = this.method.getEntityInformation().getJavaType();
            EntityQueryCriteriaSupport.EntityQueryPageSupport dynamicSortSupport = new EntityQueryCriteriaSupport.EntityQueryPageSupport();
            invocationParameters.getSort().stream().forEachOrdered(order -> {
                AccessorByMember accessor = Accessors.accessor((Class)declaringClass, (String)order.getProperty());
                dynamicSortSupport.orderBy(new AccessorChain(new Accessor[]{accessor}), order.getDirection() == Sort.Direction.ASC ? EntityCriteria.OrderByChain.Order.ASC : EntityCriteria.OrderByChain.Order.DESC, order.isIgnoreCase());
            });
            derivedQueryToUse = defaultExecutableEntityQuery.copyFor(dynamicSortSupport);
        } else {
            derivedQueryToUse = defaultExecutableEntityQuery;
        }
        RelationalEntityPersister.ExecutableEntityQueryCriteria result = derivedQueryToUse.wrapIntoExecutable();
        Limit limit = invocationParameters.getLimit();
        if (limit != null) {
            result.limit(limit.getCount().intValue(), limit.getOffset());
        }
        return result;
    }
}

