/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.engine.runtime.OptimizedUpdatePersister;
import org.codefilarete.stalactite.sql.ConnectionConfiguration;
import org.codefilarete.stalactite.sql.ConnectionProvider;
import org.codefilarete.stalactite.sql.CurrentThreadConnectionProvider;
import org.codefilarete.stalactite.sql.RollbackListener;
import org.codefilarete.stalactite.sql.RollbackObserver;
import org.codefilarete.stalactite.sql.TransactionAwareConnectionProvider;
import org.codefilarete.stalactite.sql.result.InMemoryResultSet;
import org.codefilarete.stalactite.sql.result.RowIterator;
import org.codefilarete.stalactite.sql.statement.binder.DefaultResultSetReaders;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.tool.collection.Arrays;
import org.codefilarete.tool.collection.Maps;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class OptimizedUpdatePersisterTest {
    OptimizedUpdatePersisterTest() {
    }

    @Test
    void cachingQueryConnectionProvider_implementsRollBackObserverWhenGivenOneDoes() {
        ConnectionProvider connectionProviderMock = (ConnectionProvider)Mockito.mock(ConnectionProvider.class);
        ConnectionProvider testInstance = OptimizedUpdatePersister.wrapWithQueryCache((ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)new TransactionAwareConnectionProvider(connectionProviderMock), 10)).getConnectionProvider();
        Assertions.assertThat((boolean)(testInstance instanceof RollbackObserver)).isTrue();
        testInstance = OptimizedUpdatePersister.wrapWithQueryCache((ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)new CurrentThreadConnectionProvider((DataSource)Mockito.mock(DataSource.class)), 10)).getConnectionProvider();
        Assertions.assertThat((boolean)(testInstance instanceof RollbackObserver)).isFalse();
    }

    @Test
    void cachingQueryConnectionProvider_notifiesRollbackObserverWhenGivenOneIsAwareOfTransaction() throws SQLException {
        ConnectionProvider connectionProviderMock = (ConnectionProvider)Mockito.mock(ConnectionProvider.class);
        Mockito.when((Object)connectionProviderMock.giveConnection()).thenReturn(Mockito.mock(Connection.class));
        ConnectionProvider testInstance = OptimizedUpdatePersister.wrapWithQueryCache((ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)new TransactionAwareConnectionProvider(connectionProviderMock), 10)).getConnectionProvider();
        RollbackListener rollbackListenerMock = (RollbackListener)Mockito.mock(RollbackListener.class);
        ((RollbackObserver)testInstance).addRollbackListener(rollbackListenerMock);
        testInstance.giveConnection().rollback();
        ((RollbackListener)Mockito.verify((Object)rollbackListenerMock)).beforeRollback();
    }

    @Test
    void cachingQueryConnectionProvider_releasesConnectionOnCommit() throws SQLException {
        ConnectionProvider connectionProviderMock = (ConnectionProvider)Mockito.mock(ConnectionProvider.class);
        Mockito.when((Object)connectionProviderMock.giveConnection()).thenReturn(Mockito.mock(Connection.class));
        ConnectionProvider testInstance = OptimizedUpdatePersister.wrapWithQueryCache((ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)new TransactionAwareConnectionProvider(connectionProviderMock), 10)).getConnectionProvider();
        Connection connection = testInstance.giveConnection();
        Assertions.assertThat((Object)connection).isSameAs((Object)testInstance.giveConnection());
        connection.commit();
        Assertions.assertThat((Object)connection).isNotSameAs((Object)testInstance.giveConnection());
    }

    @Test
    void cachingQueryConnectionProvider_releasesConnectionOnRollback() throws SQLException {
        ConnectionProvider connectionProviderMock = (ConnectionProvider)Mockito.mock(ConnectionProvider.class);
        Mockito.when((Object)connectionProviderMock.giveConnection()).thenReturn(Mockito.mock(Connection.class));
        ConnectionProvider testInstance = OptimizedUpdatePersister.wrapWithQueryCache((ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)new TransactionAwareConnectionProvider(connectionProviderMock), 10)).getConnectionProvider();
        Connection connection = testInstance.giveConnection();
        Assertions.assertThat((Object)connection).isSameAs((Object)testInstance.giveConnection());
        connection.rollback();
        Assertions.assertThat((Object)connection).isNotSameAs((Object)testInstance.giveConnection());
    }

    @Test
    void cachingQueryConnectionProvider_releasesConnectionOnClose() throws SQLException {
        ConnectionProvider connectionProviderMock = (ConnectionProvider)Mockito.mock(ConnectionProvider.class);
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        Mockito.when((Object)connectionProviderMock.giveConnection()).thenReturn((Object)connectionMock);
        ConnectionProvider testInstance = OptimizedUpdatePersister.wrapWithQueryCache((ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)new TransactionAwareConnectionProvider(connectionProviderMock), 10)).getConnectionProvider();
        Connection connection = testInstance.giveConnection();
        Assertions.assertThat((Object)connection).isSameAs((Object)testInstance.giveConnection());
        connection.close();
        Mockito.when((Object)connectionMock.isClosed()).thenReturn((Object)true);
        Assertions.assertThat((Object)connection).isNotSameAs((Object)testInstance.giveConnection());
    }

    @Test
    void cachingQueryConnectionProvider_cachesQuery() throws SQLException {
        DataSource dataSourceMock = (DataSource)Mockito.mock(DataSource.class);
        Connection connectionMock = (Connection)Mockito.mock(Connection.class);
        PreparedStatement preparedStatementMock = (PreparedStatement)Mockito.mock(PreparedStatement.class);
        Mockito.when((Object)dataSourceMock.getConnection()).thenReturn((Object)connectionMock);
        Mockito.when((Object)connectionMock.prepareStatement(ArgumentMatchers.anyString())).thenReturn((Object)preparedStatementMock);
        List data = Arrays.asList((Object[])new Maps.ChainingHashMap[]{Maps.forHashMap(String.class, String.class).add((Object)"a", (Object)"myValue").add((Object)"b", (Object)"my second value")});
        InMemoryResultSet dummyResultSet = new InMemoryResultSet((Iterable)data);
        Mockito.when((Object)preparedStatementMock.executeQuery()).thenReturn((Object)dummyResultSet);
        ConnectionProvider testInstance = OptimizedUpdatePersister.wrapWithQueryCache((ConnectionConfiguration)new ConnectionConfiguration.ConnectionConfigurationSupport((ConnectionProvider)new CurrentThreadConnectionProvider(dataSourceMock), 10)).getConnectionProvider();
        OptimizedUpdatePersister.CURRENT_QUERY.set(new HashMap());
        Connection currentConnection = testInstance.giveConnection();
        PreparedStatement preparedStatement1 = currentConnection.prepareStatement("Select * from WhateverYouWant");
        ResultSet effectiveResultSet = preparedStatement1.executeQuery();
        RowIterator rsReader = new RowIterator((Map)Maps.forHashMap(String.class, ResultSetReader.class).add((Object)"a", (Object)DefaultResultSetReaders.STRING_READER).add((Object)"b", (Object)DefaultResultSetReaders.STRING_READER));
        while (effectiveResultSet.next()) {
            rsReader.convert(effectiveResultSet);
        }
        PreparedStatement preparedStatement2 = currentConnection.prepareStatement("Select * from WhateverYouWant");
        ResultSet cachedResultSet = preparedStatement2.executeQuery();
        ArrayList<Map> cachedValues = new ArrayList<Map>();
        while (cachedResultSet.next()) {
            cachedValues.add(rsReader.convert(effectiveResultSet).getContent());
        }
        ((PreparedStatement)Mockito.verify((Object)preparedStatementMock)).executeQuery();
        OptimizedUpdatePersister.CURRENT_QUERY.remove();
        Assertions.assertThat((List)data).isEqualTo(cachedValues);
    }
}

