/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.query.model.operator;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.codefilarete.stalactite.query.model.ValuedVariable;
import org.codefilarete.stalactite.query.model.operator.TupleIn;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.collection.Arrays;
import org.junit.jupiter.api.Test;

class TupleInTest {
    TupleInTest() {
    }

    @Test
    void transformCompositeIdentifierColumnValuesToTupleInValues() {
        Table table = new Table("Toto");
        Column firstNameColumn = table.addColumn("firstName", String.class);
        Column lastNameColumn = table.addColumn("lastName", String.class);
        Column ageColumn = table.addColumn("age", Integer.TYPE);
        LinkedHashMap columnValues = new LinkedHashMap();
        Toto bean1 = new Toto("John", "Doe", 40);
        Toto bean2 = new Toto("Jane", "Doe", 41);
        Toto bean3 = new Toto("Paul", "Smith", 35);
        List beans = Arrays.asList((Object[])new Toto[]{bean1, bean2, bean3});
        beans.forEach(bean -> {
            columnValues.computeIfAbsent(firstNameColumn, k -> new ArrayList()).add(bean.getFirstName());
            columnValues.computeIfAbsent(lastNameColumn, k -> new ArrayList()).add(bean.getLastName());
            columnValues.computeIfAbsent(ageColumn, k -> new ArrayList()).add(bean.getAge());
        });
        TupleIn tupleIn = TupleIn.transformBeanColumnValuesToTupleInValues((int)3, columnValues);
        Assertions.assertThat((Object[])tupleIn.getColumns()).containsExactly((Object[])new Column[]{firstNameColumn, lastNameColumn, ageColumn});
        Assertions.assertThat((Object[])((Object[])((List)((ValuedVariable)tupleIn.getValue()).getValue()).get(0))).containsExactly(new Object[]{"John", "Doe", 40});
        Assertions.assertThat((Object[])((Object[])((List)((ValuedVariable)tupleIn.getValue()).getValue()).get(1))).containsExactly(new Object[]{"Jane", "Doe", 41});
        Assertions.assertThat((Object[])((Object[])((List)((ValuedVariable)tupleIn.getValue()).getValue()).get(2))).containsExactly(new Object[]{"Paul", "Smith", 35});
    }

    private static class Toto {
        private final String firstName;
        private final String lastName;
        private final int age;

        private Toto(String firstName, String lastName, int age) {
            this.firstName = firstName;
            this.lastName = lastName;
            this.age = age;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getLastName() {
            return this.lastName;
        }

        public int getAge() {
            return this.age;
        }
    }
}

