/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.sql.statement.binder;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import oracle.sql.BLOB;
import org.codefilarete.stalactite.sql.statement.binder.DefaultParameterBinders;
import org.codefilarete.stalactite.sql.statement.binder.JdbcTypePreparedStatementWriter;
import org.codefilarete.stalactite.sql.statement.binder.JdbcTypeResultSetReader;
import org.codefilarete.stalactite.sql.statement.binder.NullAwareParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.ParameterBinder;
import org.codefilarete.stalactite.sql.statement.binder.PreparedStatementWriter;
import org.codefilarete.stalactite.sql.statement.binder.ResultSetReader;
import org.codefilarete.tool.io.IOs;

public final class OracleParameterBinders {
    public static final ParameterBinder<Blob> BLOB_BINDER = new NullAwareParameterBinder((ResultSetReader)DefaultParameterBinders.BLOB_BINDER, (PreparedStatementWriter)new BlobWriter());
    public static final ParameterBinder<ZonedDateTime> ZONED_DATE_TIME_BINDER = new NullAwareParameterBinder(new JdbcTypeResultSetReader<ZonedDateTime>(ZonedDateTime.class), new JdbcTypePreparedStatementWriter<ZonedDateTime>(ZonedDateTime.class, JDBCType.TIMESTAMP_WITH_TIMEZONE));
    public static final ParameterBinder<OffsetDateTime> OFFSET_DATE_TIME_BINDER = new NullAwareParameterBinder(new JdbcTypeResultSetReader<OffsetDateTime>(OffsetDateTime.class), new JdbcTypePreparedStatementWriter<OffsetDateTime>(OffsetDateTime.class, JDBCType.TIMESTAMP_WITH_TIMEZONE));

    private OracleParameterBinders() {
    }

    private static class BlobWriter
    implements PreparedStatementWriter<Blob> {
        private BlobWriter() {
        }

        public Class<Blob> getType() {
            return Blob.class;
        }

        public void set(PreparedStatement preparedStatement, int valueIndex, Blob blob) throws SQLException {
            BLOB oracleBlob;
            if (blob instanceof BLOB) {
                oracleBlob = (BLOB)blob;
            } else {
                oracleBlob = (BLOB)preparedStatement.getConnection().createBlob();
                try {
                    oracleBlob.setBytes(1L, IOs.toByteArray((InputStream)blob.getBinaryStream()));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            preparedStatement.setBlob(valueIndex, (Blob)oracleBlob);
        }
    }
}

