/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime.onetomany;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.codefilarete.reflection.AccessorDefinition;
import org.codefilarete.reflection.ReversibleAccessor;
import org.codefilarete.stalactite.engine.EntityPersister;
import org.codefilarete.stalactite.engine.ForeignKeyNamingStrategy;
import org.codefilarete.stalactite.engine.cascade.AfterInsertCollectionCascader;
import org.codefilarete.stalactite.engine.cascade.BeforeDeleteByIdCollectionCascader;
import org.codefilarete.stalactite.engine.cascade.BeforeDeleteCollectionCascader;
import org.codefilarete.stalactite.engine.configurer.onetomany.FirstPhaseCycleLoadListener;
import org.codefilarete.stalactite.engine.listener.DeleteByIdListener;
import org.codefilarete.stalactite.engine.listener.DeleteListener;
import org.codefilarete.stalactite.engine.listener.SelectListener;
import org.codefilarete.stalactite.engine.listener.SelectListenerCollection;
import org.codefilarete.stalactite.engine.listener.UpdateListener;
import org.codefilarete.stalactite.engine.runtime.AbstractPolymorphismPersister;
import org.codefilarete.stalactite.engine.runtime.CollectionUpdater;
import org.codefilarete.stalactite.engine.runtime.ConfiguredRelationalPersister;
import org.codefilarete.stalactite.engine.runtime.load.EntityJoinTree;
import org.codefilarete.stalactite.engine.runtime.onetomany.MappedManyRelationDescriptor;
import org.codefilarete.stalactite.engine.runtime.tableperclass.TablePerClassPolymorphismPersister;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.stalactite.mapping.Mapping;
import org.codefilarete.stalactite.mapping.id.assembly.IdentifierAssembler;
import org.codefilarete.stalactite.query.model.Fromable;
import org.codefilarete.stalactite.query.model.JoinLink;
import org.codefilarete.stalactite.query.model.Selectable;
import org.codefilarete.stalactite.sql.ddl.structure.Column;
import org.codefilarete.stalactite.sql.ddl.structure.Key;
import org.codefilarete.stalactite.sql.ddl.structure.PrimaryKey;
import org.codefilarete.stalactite.sql.ddl.structure.Table;
import org.codefilarete.tool.Duo;
import org.codefilarete.tool.Nullable;
import org.codefilarete.tool.collection.IdentityMap;
import org.codefilarete.tool.collection.Iterables;

public class OneToManyWithMappedAssociationEngine<SRC, TRGT, SRCID, TRGTID, C extends Collection<TRGT>, RIGHTTABLE extends Table<RIGHTTABLE>> {
    protected final ConfiguredRelationalPersister<SRC, SRCID> sourcePersister;
    protected final ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister;
    protected final MappedManyRelationDescriptor<SRC, TRGT, C, SRCID> manyRelationDescriptor;
    private final ForeignKeyNamingStrategy foreignKeyNamingStrategy;
    protected final ThreadLocal<TargetToSourceRelationStorage> currentTargetToSourceRelationStorage = new ThreadLocal();
    protected final Mapping.ShadowColumnValueProvider<TRGT, RIGHTTABLE> foreignKeyValueProvider;

    public OneToManyWithMappedAssociationEngine(ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister, MappedManyRelationDescriptor<SRC, TRGT, C, SRCID> manyRelationDescriptor, ConfiguredRelationalPersister<SRC, SRCID> sourcePersister, final Set<Column<RIGHTTABLE, ?>> mappedReverseColumns, final Function<SRCID, Map<Column<RIGHTTABLE, ?>, ?>> reverseColumnsValueProvider, ForeignKeyNamingStrategy foreignKeyNamingStrategy) {
        this.targetPersister = targetPersister;
        this.manyRelationDescriptor = manyRelationDescriptor;
        this.sourcePersister = sourcePersister;
        this.foreignKeyNamingStrategy = foreignKeyNamingStrategy;
        this.foreignKeyValueProvider = new Mapping.ShadowColumnValueProvider<TRGT, RIGHTTABLE>(){

            public Set<Column<RIGHTTABLE, ?>> getColumns() {
                return mappedReverseColumns;
            }

            public Map<Column<RIGHTTABLE, ?>, ?> giveValue(TRGT trgt) {
                Map result;
                if (OneToManyWithMappedAssociationEngine.this.giveRelationStorageContext() == null) {
                    result = new HashMap();
                    this.getColumns().forEach(col -> result.put(col, null));
                } else {
                    Object srcid = OneToManyWithMappedAssociationEngine.this.giveRelationStorageContext().giveSourceId(trgt);
                    result = (Map)reverseColumnsValueProvider.apply(srcid);
                }
                return result;
            }
        };
        this.addForeignKeyManager();
    }

    protected TargetToSourceRelationStorage giveRelationStorageContext() {
        return this.currentTargetToSourceRelationStorage.get();
    }

    protected void clearRelationStorageContext() {
        this.currentTargetToSourceRelationStorage.remove();
    }

    protected void addForeignKeyManager() {
        this.targetPersister.getMapping().addShadowColumnInsert(this.foreignKeyValueProvider);
        this.targetPersister.getMapping().addShadowColumnUpdate(this.foreignKeyValueProvider);
    }

    public MappedManyRelationDescriptor<SRC, TRGT, C, SRCID> getManyRelationDescriptor() {
        return this.manyRelationDescriptor;
    }

    public <LEFTTABLE extends Table<LEFTTABLE>, JOINTYPE> void propagateMappedAssociationToSubTables(Key<LEFTTABLE, JOINTYPE> foreignKey) {
        AbstractPolymorphismPersister<TRGT, TRGT> targetPersisterAsPolymorphic = AbstractPolymorphismPersister.lookupForPolymorphicPersister(this.targetPersister);
        if (targetPersisterAsPolymorphic != null) {
            targetPersisterAsPolymorphic.propagateMappedAssociationToSubTables(foreignKey, this.sourcePersister.getMainTable().getPrimaryKey(), this.foreignKeyNamingStrategy::giveName);
        } else {
            AbstractPolymorphismPersister<SRC, SRC> sourcePersisterAsPolymorphic = AbstractPolymorphismPersister.lookupForPolymorphicPersister(this.sourcePersister);
            if (!(sourcePersisterAsPolymorphic instanceof TablePerClassPolymorphismPersister)) {
                this.sourcePersister.getMainTable().addForeignKey(this.foreignKeyNamingStrategy::giveName, foreignKey, (Key)this.sourcePersister.getMainTable().getPrimaryKey());
            }
        }
    }

    public <T1 extends Table<T1>, T2 extends Table<T2>> String addSelectCascade(Key<T1, SRCID> sourcePrimaryKey, boolean loadSeparately) {
        String relationJoinNodeName = this.targetPersister.joinAsMany("ROOT", this.sourcePersister, this.manyRelationDescriptor.getCollectionProvider(), sourcePrimaryKey, this.manyRelationDescriptor.getReverseColumn(), this.manyRelationDescriptor.getRelationFixer(), null, true, loadSeparately);
        SelectListenerCollection targetSelectListener = this.targetPersister.getPersisterListener().getSelectListener();
        this.sourcePersister.addSelectListener(new SelectListener<SRC, SRCID>((SelectListener)targetSelectListener){
            final /* synthetic */ SelectListener val$targetSelectListener;
            {
                this.val$targetSelectListener = selectListener;
            }

            public void beforeSelect(Iterable<SRCID> ids) {
                this.val$targetSelectListener.beforeSelect(Collections.emptyList());
            }

            public void afterSelect(Set<? extends SRC> result) {
                Set collect = Iterables.stream(result).flatMap(src -> (Stream)Nullable.nullable(OneToManyWithMappedAssociationEngine.this.manyRelationDescriptor.getCollectionGetter().apply(src)).map(Collection::stream).getOr(Stream.empty())).collect(Collectors.toSet());
                this.val$targetSelectListener.afterSelect(collect);
            }

            public void onSelectError(Iterable<SRCID> ids, RuntimeException exception) {
                this.val$targetSelectListener.onSelectError(Collections.emptyList(), exception);
            }
        });
        return relationJoinNodeName;
    }

    public void addInsertCascade(ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
        this.sourcePersister.addInsertListener(new TargetInstancesInsertCascader(targetPersister, this.manyRelationDescriptor.getCollectionGetter()));
    }

    public void addUpdateCascade(boolean shouldDeleteRemoved, ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
        this.sourcePersister.addUpdateListener(new UpdateListener<SRC>(){

            public void afterUpdate(Iterable<? extends Duo<SRC, SRC>> entities, boolean allColumnsStatement) {
                OneToManyWithMappedAssociationEngine.this.storeTargetToSourceRelation(Iterables.mappingIterator(entities, Duo::getLeft), false);
            }

            public String toString() {
                return "targetToSourceRelationStorer";
            }
        });
        this.addTargetInstancesUpdateCascader(shouldDeleteRemoved);
        this.sourcePersister.addUpdateListener(new UpdateListener<SRC>(){

            public void afterUpdate(Iterable<? extends Duo<SRC, SRC>> entities, boolean allColumnsStatement) {
                OneToManyWithMappedAssociationEngine.this.clearRelationStorageContext();
            }

            public String toString() {
                return "targetToSourceRelationStorageCleaner";
            }
        });
    }

    protected void addTargetInstancesUpdateCascader(boolean shouldDeleteRemoved) {
        CollectionUpdater collectionUpdater = new CollectionUpdater(this.manyRelationDescriptor.getCollectionGetter(), this.targetPersister, this.manyRelationDescriptor.getReverseSetter(), shouldDeleteRemoved);
        this.sourcePersister.addUpdateListener(new AfterUpdateTrigger(collectionUpdater));
    }

    public void addDeleteCascade(boolean shouldDeleteRemoved, final ConfiguredRelationalPersister<TRGT, TRGTID> targetPersister) {
        this.sourcePersister.addDeleteListener(new DeleteListener<SRC>(){

            public void beforeDelete(Iterable<? extends SRC> entities) {
                OneToManyWithMappedAssociationEngine.this.storeTargetToSourceRelation(entities, true);
            }
        });
        this.sourcePersister.addDeleteByIdListener(new DeleteByIdListener<SRC>(){

            public void beforeDeleteById(Iterable<? extends SRC> entities) {
                OneToManyWithMappedAssociationEngine.this.storeTargetToSourceRelation(entities, true);
            }
        });
        if (shouldDeleteRemoved) {
            this.sourcePersister.addDeleteListener(new DeleteTargetEntitiesBeforeDeleteCascader(targetPersister, this.manyRelationDescriptor.getCollectionGetter()));
            this.sourcePersister.addDeleteByIdListener(new DeleteByIdTargetEntitiesBeforeDeleteByIdCascader(targetPersister, this.manyRelationDescriptor.getCollectionGetter()));
        } else if (this.manyRelationDescriptor.getReverseSetter() != null) {
            this.sourcePersister.addDeleteListener(new BeforeDeleteCollectionCascader<SRC, TRGT>(targetPersister){

                @Override
                public void beforeDelete(Iterable<? extends SRC> entities) {
                    List<Object> targets = Iterables.stream(entities).flatMap(c -> this.getTargets((SRC)c).stream()).collect(Collectors.toList());
                    targets.forEach(e -> OneToManyWithMappedAssociationEngine.this.manyRelationDescriptor.getReverseSetter().accept(e, null));
                    targetPersister.updateById(targets);
                }

                @Override
                protected Collection<TRGT> getTargets(SRC src) {
                    return (Collection)Nullable.nullable(OneToManyWithMappedAssociationEngine.this.manyRelationDescriptor.getCollectionGetter().apply(src)).getOr(OneToManyWithMappedAssociationEngine.this.manyRelationDescriptor.getCollectionFactory());
                }
            });
        }
        this.sourcePersister.addDeleteListener(new DeleteListener<SRC>(){

            public void afterDelete(Iterable<? extends SRC> entities) {
                OneToManyWithMappedAssociationEngine.this.clearRelationStorageContext();
            }
        });
        this.sourcePersister.addDeleteByIdListener(new DeleteByIdListener<SRC>(){

            public void afterDeleteById(Iterable<? extends SRC> entities) {
                OneToManyWithMappedAssociationEngine.this.clearRelationStorageContext();
            }
        });
    }

    public <T extends Table<T>> void addSelectIn2Phases(PrimaryKey<T, SRCID> sourcePrimaryKey, Key<T, SRCID> relationOwner, ReversibleAccessor<SRC, C> collectionGetter, FirstPhaseCycleLoadListener<SRC, TRGTID> firstPhaseCycleLoadListener) {
        Table relationOwnerTable = sourcePrimaryKey.getTable();
        Table relationOwnerTableClone = new Table(relationOwnerTable.getName());
        Key.KeyBuilder relationOwnerPrimaryKeyBuilder = Key.from((Fromable)relationOwnerTableClone);
        relationOwnerTable.getPrimaryKey().getColumns().forEach(column -> relationOwnerPrimaryKeyBuilder.addColumn((JoinLink)relationOwnerTableClone.addColumn(column.getName(), column.getJavaType())));
        Key.KeyBuilder relationOwnerClone = Key.from((Fromable)relationOwnerTableClone);
        relationOwner.getColumns().forEach(column -> relationOwnerClone.addColumn((JoinLink)relationOwnerTableClone.addColumn(column.getExpression(), column.getJavaType())));
        IdentifierAssembler targetIdentifierAssembler = this.targetPersister.getMapping().getIdMapping().getIdentifierAssembler();
        Key rightKey = relationOwnerClone.build();
        Key rightPrimaryKey = relationOwnerPrimaryKeyBuilder.build();
        this.sourcePersister.getEntityJoinTree().addPassiveJoin("ROOT", sourcePrimaryKey, rightKey, relationOwnerTableClone.getName() + "_" + AccessorDefinition.giveDefinition(collectionGetter).getName(), EntityJoinTree.JoinType.OUTER, (Set<? extends Selectable<?>>)rightPrimaryKey.getColumns(), (src, columnValueProvider) -> firstPhaseCycleLoadListener.onFirstPhaseRowRead(src, targetIdentifierAssembler.assemble(columnValueProvider)), true);
    }

    private void storeTargetToSourceRelation(Iterable<? extends SRC> sourceEntities, boolean relationIsNullified) {
        if (this.giveRelationStorageContext() == null) {
            this.currentTargetToSourceRelationStorage.set(new TargetToSourceRelationStorage());
        }
        for (SRC sourceEntity : sourceEntities) {
            Collection collection = (Collection)this.manyRelationDescriptor.getCollectionGetter().apply(sourceEntity);
            ((Collection)Nullable.nullable((Object)collection).getOr(this.manyRelationDescriptor.getCollectionFactory())).forEach(trgt -> this.giveRelationStorageContext().add(trgt, relationIsNullified ? null : sourceEntity));
        }
    }

    public static class DeleteByIdTargetEntitiesBeforeDeleteByIdCascader<I, O>
    extends BeforeDeleteByIdCollectionCascader<I, O> {
        private final Function<I, ? extends Collection<O>> collectionGetter;

        public DeleteByIdTargetEntitiesBeforeDeleteByIdCascader(EntityPersister<O, ?> targetPersister, Function<I, ? extends Collection<O>> collectionGetter) {
            super(targetPersister);
            this.collectionGetter = collectionGetter;
        }

        @Override
        protected void postTargetDelete(Iterable<O> entities) {
        }

        @Override
        protected Collection<O> getTargets(I i) {
            return this.collectionGetter.apply(i);
        }
    }

    public static class DeleteTargetEntitiesBeforeDeleteCascader<I, O>
    extends BeforeDeleteCollectionCascader<I, O> {
        private final Function<I, ? extends Collection<O>> collectionGetter;

        public DeleteTargetEntitiesBeforeDeleteCascader(EntityPersister<O, ?> targetPersister, Function<I, ? extends Collection<O>> collectionGetter) {
            super(targetPersister);
            this.collectionGetter = collectionGetter;
        }

        @Override
        protected Collection<O> getTargets(I i) {
            return this.collectionGetter.apply(i);
        }
    }

    public static class AfterUpdateTrigger<I>
    implements UpdateListener<I> {
        private final BiConsumer<Duo<? extends I, ? extends I>, Boolean> afterUpdateListener;

        public AfterUpdateTrigger(BiConsumer<? extends Duo<? extends I, ? extends I>, Boolean> afterUpdateListener) {
            this.afterUpdateListener = afterUpdateListener;
        }

        public void afterUpdate(Iterable<? extends Duo<I, I>> entities, boolean allColumnsStatement) {
            entities.forEach(entry -> this.afterUpdateListener.accept((Duo<I, I>)entry, allColumnsStatement));
        }
    }

    public class TargetInstancesInsertCascader
    extends AfterInsertCollectionCascader<SRC, TRGT> {
        private final Function<SRC, ? extends Collection<TRGT>> collectionGetter;

        public TargetInstancesInsertCascader(EntityPersister<TRGT, TRGTID> targetPersister, Function<SRC, ? extends Collection<TRGT>> collectionGetter) {
            super(targetPersister);
            this.collectionGetter = collectionGetter;
        }

        @Override
        public void afterInsert(Iterable<? extends SRC> entities) {
            OneToManyWithMappedAssociationEngine.this.storeTargetToSourceRelation(entities, false);
            super.afterInsert(entities);
            OneToManyWithMappedAssociationEngine.this.clearRelationStorageContext();
        }

        @Override
        protected void postTargetInsert(Iterable<? extends TRGT> entities) {
        }

        @Override
        protected Collection<TRGT> getTargets(SRC source) {
            return this.collectionGetter.apply(source);
        }
    }

    protected class TargetToSourceRelationStorage {
        private final IdentityMap<TRGT, SRC> store = new IdentityMap();

        TargetToSourceRelationStorage() {
        }

        private void add(TRGT target, SRC source) {
            this.store.put(target, source);
        }

        protected SRC get(TRGT target) {
            return this.store.get(target);
        }

        private SRCID giveSourceId(TRGT trgt) {
            return Nullable.nullable(this.get(trgt)).map(arg_0 -> ((EntityMapping)OneToManyWithMappedAssociationEngine.this.sourcePersister.getMapping()).getId(arg_0)).get();
        }
    }
}

